/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.factory;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=ArtifactFactory.class)
public class DefaultArtifactFactory
implements ArtifactFactory {
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;

    @Override
    public Artifact createArtifact(String groupId, String artifactId, String version, String scope2, String type2) {
        return this.createArtifact(groupId, artifactId, version, scope2, type2, null, null);
    }

    @Override
    public Artifact createArtifactWithClassifier(String groupId, String artifactId, String version, String type2, String classifier2) {
        return this.createArtifact(groupId, artifactId, version, null, type2, classifier2, null);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type2, String classifier2, String scope2) {
        return this.createArtifact(groupId, artifactId, versionRange, type2, classifier2, scope2, null);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type2, String classifier2, String scope2, boolean optional) {
        return this.createArtifact(groupId, artifactId, versionRange, type2, classifier2, scope2, null, optional);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type2, String classifier2, String scope2, String inheritedScope) {
        return this.createArtifact(groupId, artifactId, versionRange, type2, classifier2, scope2, inheritedScope);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type2, String classifier2, String scope2, String inheritedScope, boolean optional) {
        return this.createArtifact(groupId, artifactId, versionRange, type2, classifier2, scope2, inheritedScope, optional);
    }

    @Override
    public Artifact createBuildArtifact(String groupId, String artifactId, String version, String packaging) {
        return this.createArtifact(groupId, artifactId, version, null, packaging, null, null);
    }

    @Override
    public Artifact createProjectArtifact(String groupId, String artifactId, String version) {
        return this.createProjectArtifact(groupId, artifactId, version, null);
    }

    @Override
    public Artifact createParentArtifact(String groupId, String artifactId, String version) {
        return this.createProjectArtifact(groupId, artifactId, version);
    }

    @Override
    public Artifact createPluginArtifact(String groupId, String artifactId, VersionRange versionRange) {
        return this.createArtifact(groupId, artifactId, versionRange, "maven-plugin", null, "runtime", null);
    }

    @Override
    public Artifact createProjectArtifact(String groupId, String artifactId, String version, String scope2) {
        return this.createArtifact(groupId, artifactId, version, scope2, "pom");
    }

    @Override
    public Artifact createExtensionArtifact(String groupId, String artifactId, VersionRange versionRange) {
        return this.createArtifact(groupId, artifactId, versionRange, "jar", null, "runtime", null);
    }

    private Artifact createArtifact(String groupId, String artifactId, String version, String scope2, String type2, String classifier2, String inheritedScope) {
        VersionRange versionRange = null;
        if (version != null) {
            versionRange = VersionRange.createFromVersion(version);
        }
        return this.createArtifact(groupId, artifactId, versionRange, type2, classifier2, scope2, inheritedScope);
    }

    private Artifact createArtifact(String groupId, String artifactId, VersionRange versionRange, String type2, String classifier2, String scope2, String inheritedScope) {
        return this.createArtifact(groupId, artifactId, versionRange, type2, classifier2, scope2, inheritedScope, false);
    }

    private Artifact createArtifact(String groupId, String artifactId, VersionRange versionRange, String type2, String classifier2, String scope2, String inheritedScope, boolean optional) {
        String desiredScope = "runtime";
        if (inheritedScope == null) {
            desiredScope = scope2;
        } else {
            if ("test".equals(scope2) || "provided".equals(scope2)) {
                return null;
            }
            if ("compile".equals(scope2) && "compile".equals(inheritedScope)) {
                desiredScope = "compile";
            }
        }
        if ("test".equals(inheritedScope)) {
            desiredScope = "test";
        }
        if ("provided".equals(inheritedScope)) {
            desiredScope = "provided";
        }
        if ("system".equals(scope2)) {
            desiredScope = "system";
        }
        ArtifactHandler handler2 = this.artifactHandlerManager.getArtifactHandler(type2);
        return new DefaultArtifact(groupId, artifactId, versionRange, desiredScope, type2, classifier2, handler2, optional);
    }
}

