/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.crypto;

import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.building.DefaultSettingsProblem;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionResult;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Named
@Singleton
public class DefaultSettingsDecrypter
implements SettingsDecrypter {
    private final SecDispatcher securityDispatcher;

    @Inject
    public DefaultSettingsDecrypter(@Named(value="maven") SecDispatcher securityDispatcher) {
        this.securityDispatcher = securityDispatcher;
    }

    @Override
    public SettingsDecryptionResult decrypt(SettingsDecryptionRequest request) {
        ArrayList<SettingsProblem> problems = new ArrayList<SettingsProblem>();
        ArrayList<Server> servers = new ArrayList<Server>();
        for (Server server : request.getServers()) {
            server = server.clone();
            servers.add(server);
            try {
                server.setPassword(this.decrypt(server.getPassword()));
            }
            catch (SecDispatcherException e) {
                problems.add(new DefaultSettingsProblem("Failed to decrypt password for server " + server.getId() + ": " + e.getMessage(), SettingsProblem.Severity.ERROR, "server: " + server.getId(), -1, -1, e));
            }
            try {
                server.setPassphrase(this.decrypt(server.getPassphrase()));
            }
            catch (SecDispatcherException e) {
                problems.add(new DefaultSettingsProblem("Failed to decrypt passphrase for server " + server.getId() + ": " + e.getMessage(), SettingsProblem.Severity.ERROR, "server: " + server.getId(), -1, -1, e));
            }
        }
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        for (Proxy proxy2 : request.getProxies()) {
            proxy2 = proxy2.clone();
            proxies.add(proxy2);
            try {
                proxy2.setPassword(this.decrypt(proxy2.getPassword()));
            }
            catch (SecDispatcherException e) {
                problems.add(new DefaultSettingsProblem("Failed to decrypt password for proxy " + proxy2.getId() + ": " + e.getMessage(), SettingsProblem.Severity.ERROR, "proxy: " + proxy2.getId(), -1, -1, e));
            }
        }
        return new DefaultSettingsDecryptionResult(servers, proxies, problems);
    }

    private String decrypt(String str) throws SecDispatcherException {
        return str == null ? null : this.securityDispatcher.decrypt(str);
    }
}

