/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.toolchain.RequirementMatcher;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.logging.Logger;

public abstract class DefaultToolchain
implements Toolchain,
ToolchainPrivate {
    private String type;
    private Map<String, RequirementMatcher> provides = new HashMap<String, RequirementMatcher>();
    public static final String KEY_TYPE = "type";
    private ToolchainModel model;
    private Logger logger;

    protected DefaultToolchain(ToolchainModel model, Logger logger) {
        this.model = model;
        this.logger = logger;
    }

    protected DefaultToolchain(ToolchainModel model, String type2, Logger logger) {
        this(model, logger);
        this.type = type2;
    }

    @Override
    public final String getType() {
        return this.type != null ? this.type : this.model.getType();
    }

    @Override
    public final ToolchainModel getModel() {
        return this.model;
    }

    public final void addProvideToken(String type2, RequirementMatcher matcher2) {
        this.provides.put(type2, matcher2);
    }

    @Override
    public boolean matchesRequirements(Map<String, String> requirements) {
        for (Map.Entry<String, String> requirement2 : requirements.entrySet()) {
            String key = requirement2.getKey();
            RequirementMatcher matcher2 = this.provides.get(key);
            if (matcher2 == null) {
                this.getLog().debug("Toolchain " + this + " is missing required property: " + key);
                return false;
            }
            if (matcher2.matches(requirement2.getValue())) continue;
            this.getLog().debug("Toolchain " + this + " doesn't match required property: " + key);
            return false;
        }
        return true;
    }

    protected Logger getLog() {
        return this.logger;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultToolchain)) {
            return false;
        }
        DefaultToolchain other = (DefaultToolchain)obj;
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        Properties thisProvides = this.getModel().getProvides();
        Properties otherProvides = other.getModel().getProvides();
        return Objects.equals(thisProvides, otherProvides);
    }

    public int hashCode() {
        int hashCode2;
        int n = hashCode2 = this.type == null ? 0 : this.type.hashCode();
        if (this.getModel().getProvides() != null) {
            hashCode2 = 31 * hashCode2 + this.getModel().getProvides().hashCode();
        }
        return hashCode2;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("type:").append(this.getType());
        builder2.append('{');
        Iterator<Map.Entry<String, RequirementMatcher>> providesIter = this.provides.entrySet().iterator();
        while (providesIter.hasNext()) {
            Map.Entry<String, RequirementMatcher> provideEntry = providesIter.next();
            builder2.append(provideEntry.getKey()).append(" = ").append(provideEntry.getValue());
            if (!providesIter.hasNext()) continue;
            builder2.append(';');
        }
        builder2.append('}');
        return builder2.toString();
    }
}

