/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.model.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.apache.maven.toolchain.model.TrackableBase;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class MavenToolchainsXpp3Writer {
    private static final String NAMESPACE = null;
    private String fileComment = null;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, PersistedToolchains persistedToolchains) throws IOException {
        MXSerializer serializer2 = new MXSerializer();
        serializer2.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  ");
        serializer2.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n");
        serializer2.setOutput(writer);
        serializer2.startDocument(persistedToolchains.getModelEncoding(), null);
        this.writePersistedToolchains(persistedToolchains, "toolchains", serializer2);
        serializer2.endDocument();
    }

    public void write(OutputStream stream, PersistedToolchains persistedToolchains) throws IOException {
        MXSerializer serializer2 = new MXSerializer();
        serializer2.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  ");
        serializer2.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n");
        serializer2.setOutput(stream, persistedToolchains.getModelEncoding());
        serializer2.startDocument(persistedToolchains.getModelEncoding(), null);
        this.writePersistedToolchains(persistedToolchains, "toolchains", serializer2);
        serializer2.endDocument();
    }

    private void writePersistedToolchains(PersistedToolchains persistedToolchains, String tagName, XmlSerializer serializer2) throws IOException {
        if (this.fileComment != null) {
            serializer2.comment(this.fileComment);
        }
        serializer2.setPrefix("", "http://maven.apache.org/TOOLCHAINS/1.1.0");
        serializer2.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        serializer2.startTag(NAMESPACE, tagName);
        serializer2.attribute("", "xsi:schemaLocation", "http://maven.apache.org/TOOLCHAINS/1.1.0 http://maven.apache.org/xsd/toolchains-1.1.0.xsd");
        if (persistedToolchains.getToolchains() != null && persistedToolchains.getToolchains().size() > 0) {
            for (ToolchainModel o : persistedToolchains.getToolchains()) {
                this.writeToolchainModel(o, "toolchain", serializer2);
            }
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeToolchainModel(ToolchainModel toolchainModel, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (toolchainModel.getType() != null) {
            serializer2.startTag(NAMESPACE, "type").text(toolchainModel.getType()).endTag(NAMESPACE, "type");
        }
        if (toolchainModel.getProvides() != null && toolchainModel.getProvides().size() > 0) {
            serializer2.startTag(NAMESPACE, "provides");
            for (String string2 : toolchainModel.getProvides().keySet()) {
                String value2 = (String)toolchainModel.getProvides().get(string2);
                serializer2.startTag(NAMESPACE, string2).text(value2).endTag(NAMESPACE, string2);
            }
            serializer2.endTag(NAMESPACE, "provides");
        }
        if (toolchainModel.getConfiguration() != null) {
            ((Xpp3Dom)toolchainModel.getConfiguration()).writeToSerializer(NAMESPACE, serializer2);
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeTrackableBase(TrackableBase trackableBase, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        serializer2.endTag(NAMESPACE, tagName);
    }
}

