/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.logging;

import org.codehaus.plexus.logging.Logger;

public abstract class AbstractLogger
implements Logger {
    private final String name;
    private int threshold;

    public AbstractLogger(int threshold, String name2) {
        this.name = name2;
        if (threshold < 0 || 5 < threshold) {
            throw new IllegalArgumentException("Threshold " + threshold + " is not valid");
        }
        this.threshold = threshold;
    }

    @Override
    public final void debug(String message2) {
        this.debug(message2, null);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.threshold <= 0;
    }

    @Override
    public final void info(String message2) {
        this.info(message2, null);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.threshold <= 1;
    }

    @Override
    public final void warn(String message2) {
        this.warn(message2, null);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.threshold <= 2;
    }

    @Override
    public final void error(String message2) {
        this.error(message2, null);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.threshold <= 3;
    }

    @Override
    public final void fatalError(String message2) {
        this.fatalError(message2, null);
    }

    @Override
    public boolean isFatalErrorEnabled() {
        return this.threshold <= 4;
    }

    @Override
    public final int getThreshold() {
        return this.threshold;
    }

    @Override
    public final void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public final String getName() {
        return this.name;
    }
}

