/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.logging;

import java.util.Map;
import org.codehaus.plexus.logging.AbstractLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.eclipse.sisu.inject.Weak;
import org.eclipse.sisu.plexus.Roles;

public abstract class BaseLoggerManager
extends AbstractLoggerManager
implements Initializable {
    private final Map<String, Logger> activeLoggers = Weak.values();
    String threshold = "INFO";
    private int currentThreshold;

    @Override
    public final void initialize() {
        this.currentThreshold = BaseLoggerManager.parseThreshold(this.threshold);
    }

    @Override
    public final synchronized Logger getLoggerForComponent(String role, String hint2) {
        String name2 = Roles.canonicalRoleHint(role, hint2);
        Logger logger = this.activeLoggers.get(name2);
        if (logger == null) {
            logger = this.createLogger(name2);
            logger.setThreshold(this.currentThreshold);
            this.activeLoggers.put(name2, logger);
        }
        return logger;
    }

    @Override
    public final synchronized void returnComponentLogger(String role, String hint2) {
        this.activeLoggers.remove(Roles.canonicalRoleHint(role, hint2));
    }

    @Override
    public final int getThreshold() {
        return this.currentThreshold;
    }

    @Override
    public final void setThreshold(int currentThreshold) {
        this.currentThreshold = currentThreshold;
    }

    @Override
    public final synchronized void setThresholds(int currentThreshold) {
        this.currentThreshold = currentThreshold;
        for (Logger logger : this.activeLoggers.values()) {
            logger.setThreshold(currentThreshold);
        }
    }

    public static final int parseThreshold(String text2) {
        if ("DEBUG".equalsIgnoreCase(text2)) {
            return 0;
        }
        if ("INFO".equalsIgnoreCase(text2)) {
            return 1;
        }
        if ("WARN".equalsIgnoreCase(text2)) {
            return 2;
        }
        if ("ERROR".equalsIgnoreCase(text2)) {
            return 3;
        }
        if ("FATAL".equalsIgnoreCase(text2)) {
            return 4;
        }
        if ("DISABLED".equalsIgnoreCase(text2)) {
            return 5;
        }
        return 0;
    }

    @Override
    public final synchronized int getActiveLoggerCount() {
        return this.activeLoggers.size();
    }

    protected abstract Logger createLogger(String var1);
}

