/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.metadata;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetadata
implements Metadata {
    private Metadata newInstance(Map<String, String> properties2, File file2) {
        return new DefaultMetadata(this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getType(), this.getNature(), file2, properties2);
    }

    @Override
    public Metadata setFile(File file2) {
        File current2 = this.getFile();
        if (current2 == null ? file2 == null : current2.equals(file2)) {
            return this;
        }
        return this.newInstance(this.getProperties(), file2);
    }

    @Override
    public Metadata setProperties(Map<String, String> properties2) {
        Map<String, String> current2 = this.getProperties();
        if (current2.equals(properties2) || properties2 == null && current2.isEmpty()) {
            return this;
        }
        return this.newInstance(AbstractMetadata.copyProperties(properties2), this.getFile());
    }

    @Override
    public String getProperty(String key, String defaultValue2) {
        String value2 = this.getProperties().get(key);
        return value2 != null ? value2 : defaultValue2;
    }

    protected static Map<String, String> copyProperties(Map<String, String> properties2) {
        if (properties2 != null && !properties2.isEmpty()) {
            return Collections.unmodifiableMap(new HashMap<String, String>(properties2));
        }
        return Collections.emptyMap();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        if (this.getGroupId().length() > 0) {
            buffer.append(this.getGroupId());
        }
        if (this.getArtifactId().length() > 0) {
            buffer.append(':').append(this.getArtifactId());
        }
        if (this.getVersion().length() > 0) {
            buffer.append(':').append(this.getVersion());
        }
        buffer.append('/').append(this.getType());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Metadata)) {
            return false;
        }
        Metadata that = (Metadata)obj;
        return this.getArtifactId().equals(that.getArtifactId()) && this.getGroupId().equals(that.getGroupId()) && this.getVersion().equals(that.getVersion()) && this.getType().equals(that.getType()) && this.getNature().equals((Object)that.getNature()) && AbstractMetadata.eq(this.getFile(), that.getFile()) && AbstractMetadata.eq(this.getProperties(), that.getProperties());
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.getGroupId().hashCode();
        hash = hash * 31 + this.getArtifactId().hashCode();
        hash = hash * 31 + this.getType().hashCode();
        hash = hash * 31 + this.getNature().hashCode();
        hash = hash * 31 + this.getVersion().hashCode();
        hash = hash * 31 + AbstractMetadata.hash(this.getFile());
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

