/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RepositoryPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoteRepository
implements ArtifactRepository {
    private static final Pattern URL_PATTERN = Pattern.compile("([^:/]+(:[^:/]{2,}+(?=://))?):(//([^@/]*@)?([^/:]+))?.*");
    private final String id;
    private final String type;
    private final String url;
    private final String host;
    private final String protocol;
    private final RepositoryPolicy releasePolicy;
    private final RepositoryPolicy snapshotPolicy;
    private final Proxy proxy;
    private final Authentication authentication;
    private final List<RemoteRepository> mirroredRepositories;
    private final boolean repositoryManager;

    RemoteRepository(Builder builder2) {
        if (builder2.prototype != null) {
            this.id = (builder2.delta & 1) != 0 ? builder2.id : builder2.prototype.id;
            this.type = (builder2.delta & 2) != 0 ? builder2.type : builder2.prototype.type;
            this.url = (builder2.delta & 4) != 0 ? builder2.url : builder2.prototype.url;
            this.releasePolicy = (builder2.delta & 8) != 0 ? builder2.releasePolicy : builder2.prototype.releasePolicy;
            this.snapshotPolicy = (builder2.delta & 0x10) != 0 ? builder2.snapshotPolicy : builder2.prototype.snapshotPolicy;
            this.proxy = (builder2.delta & 0x20) != 0 ? builder2.proxy : builder2.prototype.proxy;
            this.authentication = (builder2.delta & 0x40) != 0 ? builder2.authentication : builder2.prototype.authentication;
            this.repositoryManager = (builder2.delta & 0x100) != 0 ? builder2.repositoryManager : builder2.prototype.repositoryManager;
            this.mirroredRepositories = (builder2.delta & 0x80) != 0 ? RemoteRepository.copy(builder2.mirroredRepositories) : builder2.prototype.mirroredRepositories;
        } else {
            this.id = builder2.id;
            this.type = builder2.type;
            this.url = builder2.url;
            this.releasePolicy = builder2.releasePolicy;
            this.snapshotPolicy = builder2.snapshotPolicy;
            this.proxy = builder2.proxy;
            this.authentication = builder2.authentication;
            this.repositoryManager = builder2.repositoryManager;
            this.mirroredRepositories = RemoteRepository.copy(builder2.mirroredRepositories);
        }
        Matcher m = URL_PATTERN.matcher(this.url);
        if (m.matches()) {
            this.protocol = m.group(1);
            String host = m.group(5);
            this.host = host != null ? host : "";
        } else {
            this.host = "";
            this.protocol = "";
        }
    }

    private static List<RemoteRepository> copy(List<RemoteRepository> repos) {
        if (repos == null || repos.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(repos.toArray(new RemoteRepository[repos.size()])));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getContentType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public RepositoryPolicy getPolicy(boolean snapshot) {
        return snapshot ? this.snapshotPolicy : this.releasePolicy;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public List<RemoteRepository> getMirroredRepositories() {
        return this.mirroredRepositories;
    }

    public boolean isRepositoryManager() {
        return this.repositoryManager;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(this.getId());
        buffer.append(" (").append(this.getUrl());
        buffer.append(", ").append(this.getContentType());
        boolean r = this.getPolicy(false).isEnabled();
        boolean s = this.getPolicy(true).isEnabled();
        if (r && s) {
            buffer.append(", releases+snapshots");
        } else if (r) {
            buffer.append(", releases");
        } else if (s) {
            buffer.append(", snapshots");
        } else {
            buffer.append(", disabled");
        }
        if (this.isRepositoryManager()) {
            buffer.append(", managed");
        }
        buffer.append(")");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        RemoteRepository that = (RemoteRepository)obj;
        return RemoteRepository.eq(this.url, that.url) && RemoteRepository.eq(this.type, that.type) && RemoteRepository.eq(this.id, that.id) && RemoteRepository.eq(this.releasePolicy, that.releasePolicy) && RemoteRepository.eq(this.snapshotPolicy, that.snapshotPolicy) && RemoteRepository.eq(this.proxy, that.proxy) && RemoteRepository.eq(this.authentication, that.authentication) && RemoteRepository.eq(this.mirroredRepositories, that.mirroredRepositories) && this.repositoryManager == that.repositoryManager;
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + RemoteRepository.hash(this.url);
        hash = hash * 31 + RemoteRepository.hash(this.type);
        hash = hash * 31 + RemoteRepository.hash(this.id);
        hash = hash * 31 + RemoteRepository.hash(this.releasePolicy);
        hash = hash * 31 + RemoteRepository.hash(this.snapshotPolicy);
        hash = hash * 31 + RemoteRepository.hash(this.proxy);
        hash = hash * 31 + RemoteRepository.hash(this.authentication);
        hash = hash * 31 + RemoteRepository.hash(this.mirroredRepositories);
        hash = hash * 31 + (this.repositoryManager ? 1 : 0);
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        private static final RepositoryPolicy DEFAULT_POLICY = new RepositoryPolicy();
        static final int ID = 1;
        static final int TYPE = 2;
        static final int URL = 4;
        static final int RELEASES = 8;
        static final int SNAPSHOTS = 16;
        static final int PROXY = 32;
        static final int AUTH = 64;
        static final int MIRRORED = 128;
        static final int REPOMAN = 256;
        int delta;
        RemoteRepository prototype;
        String id;
        String type;
        String url;
        RepositoryPolicy releasePolicy = DEFAULT_POLICY;
        RepositoryPolicy snapshotPolicy = DEFAULT_POLICY;
        Proxy proxy;
        Authentication authentication;
        List<RemoteRepository> mirroredRepositories;
        boolean repositoryManager;

        public Builder(String id, String type2, String url) {
            this.id = id != null ? id : "";
            this.type = type2 != null ? type2 : "";
            this.url = url != null ? url : "";
        }

        public Builder(RemoteRepository prototype) {
            if (prototype == null) {
                throw new IllegalArgumentException("repository prototype missing");
            }
            this.prototype = prototype;
        }

        public RemoteRepository build() {
            if (this.prototype != null && this.delta == 0) {
                return this.prototype;
            }
            return new RemoteRepository(this);
        }

        private <T> void delta(int flag, T builder2, T prototype) {
            boolean equal;
            boolean bl = builder2 != null ? builder2.equals(prototype) : (equal = prototype == null);
            this.delta = equal ? (this.delta &= ~flag) : (this.delta |= flag);
        }

        public Builder setId(String id) {
            String string2 = this.id = id != null ? id : "";
            if (this.prototype != null) {
                this.delta(1, this.id, this.prototype.getId());
            }
            return this;
        }

        public Builder setContentType(String type2) {
            String string2 = this.type = type2 != null ? type2 : "";
            if (this.prototype != null) {
                this.delta(2, this.type, this.prototype.getContentType());
            }
            return this;
        }

        public Builder setUrl(String url) {
            String string2 = this.url = url != null ? url : "";
            if (this.prototype != null) {
                this.delta(4, this.url, this.prototype.getUrl());
            }
            return this;
        }

        public Builder setPolicy(RepositoryPolicy policy) {
            this.snapshotPolicy = policy != null ? policy : DEFAULT_POLICY;
            this.releasePolicy = this.snapshotPolicy;
            if (this.prototype != null) {
                this.delta(8, this.releasePolicy, this.prototype.getPolicy(false));
                this.delta(16, this.snapshotPolicy, this.prototype.getPolicy(true));
            }
            return this;
        }

        public Builder setReleasePolicy(RepositoryPolicy releasePolicy) {
            RepositoryPolicy repositoryPolicy = this.releasePolicy = releasePolicy != null ? releasePolicy : DEFAULT_POLICY;
            if (this.prototype != null) {
                this.delta(8, this.releasePolicy, this.prototype.getPolicy(false));
            }
            return this;
        }

        public Builder setSnapshotPolicy(RepositoryPolicy snapshotPolicy) {
            RepositoryPolicy repositoryPolicy = this.snapshotPolicy = snapshotPolicy != null ? snapshotPolicy : DEFAULT_POLICY;
            if (this.prototype != null) {
                this.delta(16, this.snapshotPolicy, this.prototype.getPolicy(true));
            }
            return this;
        }

        public Builder setProxy(Proxy proxy2) {
            this.proxy = proxy2;
            if (this.prototype != null) {
                this.delta(32, this.proxy, this.prototype.getProxy());
            }
            return this;
        }

        public Builder setAuthentication(Authentication authentication) {
            this.authentication = authentication;
            if (this.prototype != null) {
                this.delta(64, this.authentication, this.prototype.getAuthentication());
            }
            return this;
        }

        public Builder setMirroredRepositories(List<RemoteRepository> mirroredRepositories) {
            if (this.mirroredRepositories == null) {
                this.mirroredRepositories = new ArrayList<RemoteRepository>();
            } else {
                this.mirroredRepositories.clear();
            }
            if (mirroredRepositories != null) {
                this.mirroredRepositories.addAll(mirroredRepositories);
            }
            if (this.prototype != null) {
                this.delta(128, this.mirroredRepositories, this.prototype.getMirroredRepositories());
            }
            return this;
        }

        public Builder addMirroredRepository(RemoteRepository mirroredRepository) {
            if (mirroredRepository != null) {
                if (this.mirroredRepositories == null) {
                    this.mirroredRepositories = new ArrayList<RemoteRepository>();
                    if (this.prototype != null) {
                        this.mirroredRepositories.addAll(this.prototype.getMirroredRepositories());
                    }
                }
                this.mirroredRepositories.add(mirroredRepository);
                if (this.prototype != null) {
                    this.delta |= 0x80;
                }
            }
            return this;
        }

        public Builder setRepositoryManager(boolean repositoryManager) {
            this.repositoryManager = repositoryManager;
            if (this.prototype != null) {
                this.delta(256, this.repositoryManager, this.prototype.isRepositoryManager());
            }
            return this;
        }
    }
}

