/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.resolution;

import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.resolution.VersionResult;

public class VersionResolutionException
extends RepositoryException {
    private final transient VersionResult result;

    public VersionResolutionException(VersionResult result2) {
        super(VersionResolutionException.getMessage(result2), VersionResolutionException.getCause(result2));
        this.result = result2;
    }

    private static String getMessage(VersionResult result2) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("Failed to resolve version");
        if (result2 != null) {
            buffer.append(" for ").append(result2.getRequest().getArtifact());
            if (!result2.getExceptions().isEmpty()) {
                buffer.append(": ").append(result2.getExceptions().iterator().next().getMessage());
            }
        }
        return buffer.toString();
    }

    private static Throwable getCause(VersionResult result2) {
        Throwable cause = null;
        if (result2 != null && !result2.getExceptions().isEmpty()) {
            cause = result2.getExceptions().get(0);
        }
        return cause;
    }

    public VersionResolutionException(VersionResult result2, String message2) {
        super(message2, VersionResolutionException.getCause(result2));
        this.result = result2;
    }

    public VersionResolutionException(VersionResult result2, String message2, Throwable cause) {
        super(message2, cause);
        this.result = result2;
    }

    public VersionResult getResult() {
        return this.result;
    }
}

