/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transfer;

import java.nio.ByteBuffer;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.transfer.TransferResource;

public final class TransferEvent {
    private final EventType type;
    private final RequestType requestType;
    private final RepositorySystemSession session;
    private final TransferResource resource;
    private final ByteBuffer dataBuffer;
    private final long transferredBytes;
    private final Exception exception;

    TransferEvent(Builder builder2) {
        this.type = builder2.type;
        this.requestType = builder2.requestType;
        this.session = builder2.session;
        this.resource = builder2.resource;
        this.dataBuffer = builder2.dataBuffer;
        this.transferredBytes = builder2.transferredBytes;
        this.exception = builder2.exception;
    }

    public EventType getType() {
        return this.type;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public RepositorySystemSession getSession() {
        return this.session;
    }

    public TransferResource getResource() {
        return this.resource;
    }

    public long getTransferredBytes() {
        return this.transferredBytes;
    }

    public ByteBuffer getDataBuffer() {
        return this.dataBuffer != null ? this.dataBuffer.asReadOnlyBuffer() : null;
    }

    public int getDataLength() {
        return this.dataBuffer != null ? this.dataBuffer.remaining() : 0;
    }

    public Exception getException() {
        return this.exception;
    }

    public String toString() {
        return (Object)((Object)this.getRequestType()) + " " + (Object)((Object)this.getType()) + " " + this.getResource();
    }

    public static final class Builder {
        EventType type;
        RequestType requestType;
        RepositorySystemSession session;
        TransferResource resource;
        ByteBuffer dataBuffer;
        long transferredBytes;
        Exception exception;

        public Builder(RepositorySystemSession session2, TransferResource resource) {
            if (session2 == null) {
                throw new IllegalArgumentException("session not specified");
            }
            if (resource == null) {
                throw new IllegalArgumentException("transfer resource not specified");
            }
            this.session = session2;
            this.resource = resource;
            this.type = EventType.INITIATED;
            this.requestType = RequestType.GET;
        }

        private Builder(Builder prototype) {
            this.session = prototype.session;
            this.resource = prototype.resource;
            this.type = prototype.type;
            this.requestType = prototype.requestType;
            this.dataBuffer = prototype.dataBuffer;
            this.transferredBytes = prototype.transferredBytes;
            this.exception = prototype.exception;
        }

        public Builder copy() {
            return new Builder(this);
        }

        public Builder resetType(EventType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException("event type not specified");
            }
            this.type = type2;
            this.dataBuffer = null;
            this.exception = null;
            switch (type2) {
                case INITIATED: 
                case STARTED: {
                    this.transferredBytes = 0L;
                }
            }
            return this;
        }

        public Builder setType(EventType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException("event type not specified");
            }
            this.type = type2;
            return this;
        }

        public Builder setRequestType(RequestType requestType) {
            if (requestType == null) {
                throw new IllegalArgumentException("request type not specified");
            }
            this.requestType = requestType;
            return this;
        }

        public Builder setTransferredBytes(long transferredBytes) {
            if (transferredBytes < 0L) {
                throw new IllegalArgumentException("number of transferred bytes cannot be negative");
            }
            this.transferredBytes = transferredBytes;
            return this;
        }

        public Builder addTransferredBytes(long transferredBytes) {
            if (transferredBytes < 0L) {
                throw new IllegalArgumentException("number of transferred bytes cannot be negative");
            }
            this.transferredBytes += transferredBytes;
            return this;
        }

        public Builder setDataBuffer(byte[] buffer, int offset2, int length) {
            return this.setDataBuffer(buffer != null ? ByteBuffer.wrap(buffer, offset2, length) : null);
        }

        public Builder setDataBuffer(ByteBuffer dataBuffer) {
            this.dataBuffer = dataBuffer;
            return this;
        }

        public Builder setException(Exception exception) {
            this.exception = exception;
            return this;
        }

        public TransferEvent build() {
            return new TransferEvent(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestType {
        GET,
        GET_EXISTENCE,
        PUT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        INITIATED,
        STARTED,
        PROGRESSED,
        CORRUPTED,
        SUCCEEDED,
        FAILED;

    }
}

