/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.http;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.conn.ssl.X509HostnameVerifier;

final class X509HostnameVerifierAdapter
implements X509HostnameVerifier {
    private final HostnameVerifier verifier;

    public static X509HostnameVerifier adapt(HostnameVerifier verifier) {
        if (verifier instanceof X509HostnameVerifier) {
            return (X509HostnameVerifier)verifier;
        }
        return new X509HostnameVerifierAdapter(verifier);
    }

    private X509HostnameVerifierAdapter(HostnameVerifier verifier) {
        this.verifier = verifier;
    }

    public boolean verify(String hostname, SSLSession session2) {
        return this.verifier.verify(hostname, session2);
    }

    public void verify(String host, SSLSocket socket) throws IOException {
        if (!this.verify(host, socket.getSession())) {
            throw new SSLException("<" + host + "> does not pass hostname verification");
        }
    }

    public void verify(String host, X509Certificate cert) throws SSLException {
        throw new UnsupportedOperationException();
    }

    public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
        throw new UnsupportedOperationException();
    }
}

