/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.artifact;

import java.io.File;
import java.util.Map;
import org.eclipse.aether.artifact.AbstractArtifact;
import org.eclipse.aether.artifact.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubArtifact
extends AbstractArtifact {
    private final Artifact mainArtifact;
    private final String classifier;
    private final String extension;
    private final File file;
    private final Map<String, String> properties;

    public SubArtifact(Artifact mainArtifact, String classifier2, String extension) {
        this(mainArtifact, classifier2, extension, (File)null);
    }

    public SubArtifact(Artifact mainArtifact, String classifier2, String extension, File file2) {
        this(mainArtifact, classifier2, extension, null, file2);
    }

    public SubArtifact(Artifact mainArtifact, String classifier2, String extension, Map<String, String> properties2) {
        this(mainArtifact, classifier2, extension, properties2, null);
    }

    public SubArtifact(Artifact mainArtifact, String classifier2, String extension, Map<String, String> properties2, File file2) {
        if (mainArtifact == null) {
            throw new IllegalArgumentException("no artifact specified");
        }
        this.mainArtifact = mainArtifact;
        this.classifier = classifier2;
        this.extension = extension;
        this.file = file2;
        this.properties = SubArtifact.copyProperties(properties2);
    }

    private SubArtifact(Artifact mainArtifact, String classifier2, String extension, File file2, Map<String, String> properties2) {
        this.mainArtifact = mainArtifact;
        this.classifier = classifier2;
        this.extension = extension;
        this.file = file2;
        this.properties = properties2;
    }

    @Override
    public String getGroupId() {
        return this.mainArtifact.getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.mainArtifact.getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.mainArtifact.getVersion();
    }

    @Override
    public String getBaseVersion() {
        return this.mainArtifact.getBaseVersion();
    }

    @Override
    public boolean isSnapshot() {
        return this.mainArtifact.isSnapshot();
    }

    @Override
    public String getClassifier() {
        return SubArtifact.expand(this.classifier, this.mainArtifact.getClassifier());
    }

    @Override
    public String getExtension() {
        return SubArtifact.expand(this.extension, this.mainArtifact.getExtension());
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Artifact setFile(File file2) {
        if (this.file == null ? file2 == null : this.file.equals(file2)) {
            return this;
        }
        return new SubArtifact(this.mainArtifact, this.classifier, this.extension, file2, this.properties);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public Artifact setProperties(Map<String, String> properties2) {
        if (this.properties.equals(properties2) || properties2 == null && this.properties.isEmpty()) {
            return this;
        }
        return new SubArtifact(this.mainArtifact, this.classifier, this.extension, properties2, this.file);
    }

    private static String expand(String pattern, String replacement) {
        String result2 = "";
        if (pattern != null) {
            result2 = pattern.replace("*", replacement);
            if (replacement.length() <= 0) {
                char c;
                int i;
                if (pattern.startsWith("*")) {
                    for (i = 0; i < result2.length() && ((c = result2.charAt(i)) == '-' || c == '.'); ++i) {
                    }
                    result2 = result2.substring(i);
                }
                if (pattern.endsWith("*")) {
                    for (i = result2.length() - 1; i >= 0 && ((c = result2.charAt(i)) == '-' || c == '.'); --i) {
                    }
                    result2 = result2.substring(0, i + 1);
                }
            }
        }
        return result2;
    }
}

