/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencyManagement;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassicDependencyManager
implements DependencyManager {
    private final int depth;
    private final Map<Object, String> managedVersions;
    private final Map<Object, String> managedScopes;
    private final Map<Object, Boolean> managedOptionals;
    private final Map<Object, String> managedLocalPaths;
    private final Map<Object, Collection<Exclusion>> managedExclusions;
    private int hashCode;

    public ClassicDependencyManager() {
        this(0, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    private ClassicDependencyManager(int depth, Map<Object, String> managedVersions, Map<Object, String> managedScopes, Map<Object, Boolean> managedOptionals, Map<Object, String> managedLocalPaths, Map<Object, Collection<Exclusion>> managedExclusions) {
        this.depth = depth;
        this.managedVersions = managedVersions;
        this.managedScopes = managedScopes;
        this.managedOptionals = managedOptionals;
        this.managedLocalPaths = managedLocalPaths;
        this.managedExclusions = managedExclusions;
    }

    @Override
    public DependencyManager deriveChildManager(DependencyCollectionContext context2) {
        if (this.depth >= 2) {
            return this;
        }
        if (this.depth == 1) {
            return new ClassicDependencyManager(this.depth + 1, this.managedVersions, this.managedScopes, this.managedOptionals, this.managedLocalPaths, this.managedExclusions);
        }
        Map<Object, String> managedVersions = this.managedVersions;
        Map<Object, String> managedScopes = this.managedScopes;
        Map<Object, Boolean> managedOptionals = this.managedOptionals;
        Map<Object, String> managedLocalPaths = this.managedLocalPaths;
        Map<Object, Collection<Exclusion>> managedExclusions = this.managedExclusions;
        for (Dependency managedDependency : context2.getManagedDependencies()) {
            Collection<Exclusion> managed;
            Collection<Exclusion> exclusions;
            String localPath;
            Boolean optional;
            String scope2;
            Artifact artifact = managedDependency.getArtifact();
            Object key = this.getKey(artifact);
            String version = artifact.getVersion();
            if (version.length() > 0 && !managedVersions.containsKey(key)) {
                if (managedVersions == this.managedVersions) {
                    managedVersions = new HashMap<Object, String>(this.managedVersions);
                }
                managedVersions.put(key, version);
            }
            if ((scope2 = managedDependency.getScope()).length() > 0 && !managedScopes.containsKey(key)) {
                if (managedScopes == this.managedScopes) {
                    managedScopes = new HashMap<Object, String>(this.managedScopes);
                }
                managedScopes.put(key, scope2);
            }
            if ((optional = managedDependency.getOptional()) != null && !managedOptionals.containsKey(key)) {
                if (managedOptionals == this.managedOptionals) {
                    managedOptionals = new HashMap<Object, Boolean>(this.managedOptionals);
                }
                managedOptionals.put(key, optional);
            }
            if ((localPath = managedDependency.getArtifact().getProperty("localPath", null)) != null && !managedLocalPaths.containsKey(key)) {
                if (managedLocalPaths == this.managedLocalPaths) {
                    managedLocalPaths = new HashMap<Object, String>(this.managedLocalPaths);
                }
                managedLocalPaths.put(key, localPath);
            }
            if ((exclusions = managedDependency.getExclusions()).isEmpty()) continue;
            if (managedExclusions == this.managedExclusions) {
                managedExclusions = new HashMap<Object, Collection<Exclusion>>(this.managedExclusions);
            }
            if ((managed = managedExclusions.get(key)) == null) {
                managed = new LinkedHashSet<Exclusion>();
                managedExclusions.put(key, managed);
            }
            managed.addAll(exclusions);
        }
        return new ClassicDependencyManager(this.depth + 1, managedVersions, managedScopes, managedOptionals, managedLocalPaths, managedExclusions);
    }

    @Override
    public DependencyManagement manageDependency(Dependency dependency) {
        Collection<Exclusion> exclusions;
        DependencyManagement management = null;
        Object key = this.getKey(dependency.getArtifact());
        if (this.depth >= 2) {
            Boolean optional;
            String localPath;
            String scope2;
            String version = this.managedVersions.get(key);
            if (version != null) {
                if (management == null) {
                    management = new DependencyManagement();
                }
                management.setVersion(version);
            }
            if ((scope2 = this.managedScopes.get(key)) != null) {
                if (management == null) {
                    management = new DependencyManagement();
                }
                management.setScope(scope2);
                if (!"system".equals(scope2) && dependency.getArtifact().getProperty("localPath", null) != null) {
                    HashMap<String, String> properties2 = new HashMap<String, String>(dependency.getArtifact().getProperties());
                    properties2.remove("localPath");
                    management.setProperties(properties2);
                }
            }
            if ((scope2 != null && "system".equals(scope2) || scope2 == null && "system".equals(dependency.getScope())) && (localPath = this.managedLocalPaths.get(key)) != null) {
                if (management == null) {
                    management = new DependencyManagement();
                }
                HashMap<String, String> properties3 = new HashMap<String, String>(dependency.getArtifact().getProperties());
                properties3.put("localPath", localPath);
                management.setProperties(properties3);
            }
            if ((optional = this.managedOptionals.get(key)) != null) {
                if (management == null) {
                    management = new DependencyManagement();
                }
                management.setOptional(optional);
            }
        }
        if ((exclusions = this.managedExclusions.get(key)) != null) {
            if (management == null) {
                management = new DependencyManagement();
            }
            LinkedHashSet<Exclusion> result2 = new LinkedHashSet<Exclusion>(dependency.getExclusions());
            result2.addAll(exclusions);
            management.setExclusions(result2);
        }
        return management;
    }

    private Object getKey(Artifact a) {
        return new Key(a);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ClassicDependencyManager that = (ClassicDependencyManager)obj;
        return this.depth == that.depth && this.managedVersions.equals(that.managedVersions) && this.managedScopes.equals(that.managedScopes) && this.managedOptionals.equals(that.managedOptionals) && this.managedExclusions.equals(that.managedExclusions);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = 17;
            hash = hash * 31 + this.depth;
            hash = hash * 31 + this.managedVersions.hashCode();
            hash = hash * 31 + this.managedScopes.hashCode();
            hash = hash * 31 + this.managedOptionals.hashCode();
            this.hashCode = hash = hash * 31 + this.managedExclusions.hashCode();
        }
        return this.hashCode;
    }

    static class Key {
        private final Artifact artifact;
        private final int hashCode;

        public Key(Artifact artifact) {
            this.artifact = artifact;
            int hash = 17;
            hash = hash * 31 + artifact.getGroupId().hashCode();
            this.hashCode = hash = hash * 31 + artifact.getArtifactId().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key that = (Key)obj;
            return this.artifact.getArtifactId().equals(that.artifact.getArtifactId()) && this.artifact.getGroupId().equals(that.artifact.getGroupId()) && this.artifact.getExtension().equals(that.artifact.getExtension()) && this.artifact.getClassifier().equals(that.artifact.getClassifier());
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

