/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocator;
import org.jetbrains.kotlin.backend.jvm.lower.SuspendLambdaLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.SuspendLoweringUtils;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainerKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrMutableAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J*\u0010\u0012\u001a\u00020\u0013*\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J2\u0010\u001b\u001a\u00020\u0013*\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J$\u0010\u001e\u001a\u00020\u0013*\u00020\r2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\u0014\u0010 \u001a\u00020\u0013*\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J*\u0010!\u001a\u00020\u0013*\u00020\r2\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\r2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u001c\u0010%\u001a\u00020&*\u00020\r2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020)H\u0002J\u001c\u0010*\u001a\u00020+*\u00020,2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010-\u001a\u00020+H\u0002J*\u0010.\u001a\u00020+*\u00020,2\u0006\u0010/\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SuspendLambdaLowering;", "Lorg/jetbrains/kotlin/backend/jvm/lower/SuspendLoweringUtils;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "generateAnonymousObjectForLambda", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "generateContinuationClassForLambda", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "addCreate", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "createToOverride", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "fieldsForUnbound", "", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "addInvokeCallingConstructor", "invokeSuspend", "invokeToOverride", "addInvokeCallingCreate", "create", "addInvokeSuspendForInlineForLambda", "addInvokeSuspendForLambda", "irFunction", "suspendLambda", "fields", "addPrimaryConstructorForLambda", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "superClass", "arity", "", "callInvokeSuspend", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "lambda", "cloneLambda", "scope", "backend.jvm"})
final class SuspendLambdaLowering
extends SuspendLoweringUtils
implements FileLoweringPass {
    public SuspendLambdaLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        super(context2);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        Set<IrCallableReference<?>> inlineReferences = IrInlineReferenceLocator.Companion.scan(this.getContext(), irFile);
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoidWithContext(inlineReferences, this){
            final /* synthetic */ Set<IrCallableReference<?>> $inlineReferences;
            final /* synthetic */ SuspendLambdaLowering this$0;
            {
                this.$inlineReferences = $inlineReferences;
                this.this$0 = $receiver;
            }

            @NotNull
            public IrExpression visitBlock(@NotNull IrBlock expression2) {
                IrFunctionReference irFunctionReference;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrStatement irStatement = CollectionsKt.lastOrNull(expression2.getStatements());
                IrFunctionReference irFunctionReference2 = irFunctionReference = irStatement instanceof IrFunctionReference ? (IrFunctionReference)irStatement : null;
                if (irFunctionReference == null) {
                    return super.visitBlock(expression2);
                }
                IrFunctionReference reference = irFunctionReference;
                if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend(reference) && IrUtilsKt.isLambda(reference.getOrigin()) && !this.$inlineReferences.contains(reference)) {
                    boolean bl = expression2.getStatements().size() == 2 && expression2.getStatements().get(0) instanceof IrFunction;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl4 = false;
                        String string2 = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                    IrDeclarationParent irDeclarationParent = this.getCurrentDeclarationParent();
                    if (irDeclarationParent == null) {
                        String string3 = Intrinsics.stringPlus("No current declaration parent at ", DumpIrTreeKt.dump$default(reference, false, 1, null));
                        boolean bl5 = false;
                        throw (Throwable)new IllegalStateException(string3.toString());
                    }
                    IrDeclarationParent parent2 = irDeclarationParent;
                    return SuspendLambdaLowering.access$generateAnonymousObjectForLambda(this.this$0, reference, parent2);
                }
                return super.visitBlock(expression2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final IrContainerExpression generateAnonymousObjectForLambda(IrFunctionReference reference, IrDeclarationParent parent2) {
        void $this$generateAnonymousObjectForLambda_u24lambda_u2d2_u24lambda_u2d1;
        void this_$iv$iv;
        void startOffset$iv;
        void $this$irBlock_u24default$iv;
        IrBuilderWithScope irBuilderWithScope = LowerUtilsKt.createIrBuilder$default(this.getContext(), reference.getSymbol(), 0, 0, 6, null);
        int n = reference.getStartOffset();
        int endOffset$iv = reference.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateAnonymousObjectForLambda_u24lambda_u2d2 = this_$iv$iv;
        boolean bl = false;
        boolean bl2 = IrUtilsKt.getArgumentsWithIr(reference).isEmpty();
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string2 = Intrinsics.stringPlus("lambda with bound arguments: ", RenderIrElementKt.render(reference));
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        IrClass continuation2 = this.generateContinuationClassForLambda(reference, parent2);
        $this$generateAnonymousObjectForLambda_u24lambda_u2d2.unaryPlus(continuation2);
        IrConstructorCall irConstructorCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$generateAnonymousObjectForLambda_u24lambda_u2d2, (IrConstructorSymbol)SequencesKt.single(IrUtilsKt.getConstructors(continuation2)).getSymbol());
        boolean bl5 = false;
        boolean bl6 = false;
        IrConstructorCall irConstructorCall2 = irConstructorCall;
        void var18_22 = $this$generateAnonymousObjectForLambda_u24lambda_u2d2;
        boolean bl7 = false;
        $this$generateAnonymousObjectForLambda_u24lambda_u2d2_u24lambda_u2d1.putValueArgument(0, ExpressionHelpersKt.irNull((IrBuilderWithScope)$this$generateAnonymousObjectForLambda_u24lambda_u2d2));
        Unit unit = Unit.INSTANCE;
        var18_22.unaryPlus(irConstructorCall);
        return this_$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final IrClass generateContinuationClassForLambda(IrFunctionReference reference, IrDeclarationParent parent2) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        IrSimpleFunctionSymbol invokeToOverride;
        IrConstructor constructor2;
        List parametersFields;
        IrClass suspendLambda;
        IrFunction function2;
        IrClass $this$generateContinuationClassForLambda_u24lambda_u2d10;
        IrClass irClass2;
        block22: {
            Object item$iv$iv3;
            void $this$mapTo$iv$iv;
            Object object;
            void $this$mapTo$iv$iv2;
            Object $this$map$iv;
            IrConstructorCall it;
            Boolean bl;
            IrFactory $this$buildClass$iv = this.getContext().getIrFactory();
            boolean $i$f$buildClass = false;
            IrClassBuilder irClassBuilder = new IrClassBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            IrClassBuilder $this$buildClass_u24lambda_u2d2$iv = irClassBuilder;
            boolean $i$a$-run-DeclarationBuildersKt$buildClass$2$iv22 = false;
            List<IrConstructorCall> $this$generateContinuationClassForLambda_u24lambda_u2d3 = $this$buildClass_u24lambda_u2d2$iv;
            boolean bl4 = false;
            Object object2 = SpecialNames.NO_NAME_PROVIDED;
            Intrinsics.checkNotNullExpressionValue(object2, "NO_NAME_PROVIDED");
            ((IrDeclarationBuilder)((Object)$this$generateContinuationClassForLambda_u24lambda_u2d3)).setName((Name)object2);
            ((IrDeclarationBuilder)((Object)$this$generateContinuationClassForLambda_u24lambda_u2d3)).setOrigin(JvmLoweredDeclarationOrigin.SUSPEND_LAMBDA.INSTANCE);
            object2 = DescriptorVisibilities.LOCAL;
            Intrinsics.checkNotNullExpressionValue(object2, "LOCAL");
            ((IrDeclarationBuilder)((Object)$this$generateContinuationClassForLambda_u24lambda_u2d3)).setVisibility((DescriptorVisibility)object2);
            irClass2 = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u2d2$iv);
            boolean bl5 = false;
            boolean bl6 = false;
            $this$generateContinuationClassForLambda_u24lambda_u2d10 = irClass2;
            boolean bl7 = false;
            $this$generateContinuationClassForLambda_u24lambda_u2d10.setParent(parent2);
            org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor($this$generateContinuationClassForLambda_u24lambda_u2d10);
            IrAttributeContainerKt.copyAttributes((IrAttributeContainer)$this$generateContinuationClassForLambda_u24lambda_u2d10, reference);
            function2 = ((IrFunctionSymbol)reference.getSymbol()).getOwner();
            Object $i$a$-run-DeclarationBuildersKt$buildClass$2$iv22 = ((IrFunctionSymbol)reference.getSymbol()).getOwner().getExtensionReceiverParameter();
            List<IrConstructorCall> list2 = $this$generateContinuationClassForLambda_u24lambda_u2d3 = $i$a$-run-DeclarationBuildersKt$buildClass$2$iv22 == null ? null : ((IrValueDeclaration)$i$a$-run-DeclarationBuildersKt$buildClass$2$iv22).getType();
            IrMutableAnnotationContainer irMutableAnnotationContainer = $this$generateContinuationClassForLambda_u24lambda_u2d3 == null ? null : (bl4 = ($i$a$-run-DeclarationBuildersKt$buildClass$2$iv22 = IrTypesKt.getClassOrNull((IrType)((Object)$this$generateContinuationClassForLambda_u24lambda_u2d3))) == null ? null : (IrClass)$i$a$-run-DeclarationBuildersKt$buildClass$2$iv22.getOwner());
            if (bl4 == null) {
                bl = null;
            } else {
                $this$generateContinuationClassForLambda_u24lambda_u2d3 = bl4.getAnnotations();
                if ($this$generateContinuationClassForLambda_u24lambda_u2d3 == null) {
                    bl = null;
                } else {
                    boolean bl8;
                    block21: {
                        Iterable $this$any$iv = $this$generateContinuationClassForLambda_u24lambda_u2d3;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl8 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (IrConstructorCall)element$iv;
                                boolean bl9 = false;
                                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(it.getType());
                                if (!Intrinsics.areEqual(irClassSymbol == null ? null : irClassSymbol.getSignature(), new IdSignature.PublicSignature("kotlin.coroutines", "RestrictsSuspension", null, 0L))) continue;
                                bl8 = true;
                                break block21;
                            }
                            bl8 = false;
                        }
                    }
                    bl = bl8;
                }
            }
            boolean isRestricted = Intrinsics.areEqual(bl, true);
            suspendLambda = isRestricted ? (IrClass)this.getContext().getIr().getSymbols().getRestrictedSuspendLambdaClass().getOwner() : (IrClass)this.getContext().getIr().getSymbols().getSuspendLambdaClass().getOwner();
            int arity = ((IrSimpleType)reference.getType()).getArguments().size() - 1;
            IrClassSymbol functionNClass = this.getContext().getIr().getSymbols().getJvmFunctionClass(arity + 1);
            Iterable iterable = IrUtilsKt.getExplicitParameters(function2).subList(0, arity);
            Object object3 = functionNClass;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it2;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv2;
                object = destination$iv$iv;
                boolean bl10 = false;
                IrType irType = it2.getType();
                object.add(irType);
            }
            object = (List)destination$iv$iv;
            IrSimpleType functionNType = IrTypesKt.typeWith((IrClassifierSymbol)object3, CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)object, this.continuationType(function2)), this.getContext().getIrBuiltIns().getAnyNType()));
            $this$map$iv = new IrSimpleType[]{IrUtilsKt.getDefaultType(suspendLambda), functionNType};
            $this$generateContinuationClassForLambda_u24lambda_u2d10.setSuperTypes(CollectionsKt.listOf($this$map$iv));
            IrType irType = this.getContext().getIrBuiltIns().getIntType();
            $this$map$iv = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            Intrinsics.checkNotNullExpressionValue($this$map$iv, "PACKAGE_VISIBILITY");
            DeclarationBuildersKt.addField($this$generateContinuationClassForLambda_u24lambda_u2d10, "label", irType, (DescriptorVisibility)$this$map$iv);
            Iterable $this$map$iv2 = IrUtilsKt.getExplicitParameters(function2);
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                Object object4;
                Name name2;
                Object object5;
                void it3;
                IrValueParameter bl10 = (IrValueParameter)item$iv$iv3;
                object3 = destination$iv$iv2;
                boolean bl11 = false;
                IrClass $this$addField$iv = $this$generateContinuationClassForLambda_u24lambda_u2d10;
                boolean $i$f$addField = false;
                IrFactory $this$buildField$iv$iv = $this$addField$iv.getFactory();
                boolean $i$f$buildField = false;
                IrFieldBuilder irFieldBuilder = new IrFieldBuilder();
                boolean bl12 = false;
                boolean bl13 = false;
                IrFieldBuilder $this$buildField_u24lambda_u2d5$iv$iv = irFieldBuilder;
                boolean bl14 = false;
                IrFieldBuilder $this$generateContinuationClassForLambda_u24lambda_u2d10_u24lambda_u2d7_u24lambda_u2d6 = $this$buildField_u24lambda_u2d5$iv$iv;
                boolean bl15 = false;
                if (it3.getIndex() < 0) {
                    object5 = Name.identifier("p$");
                    Intrinsics.checkNotNullExpressionValue(object5, "identifier(\"p\\$\")");
                    name2 = object5;
                } else {
                    name2 = it3.getName();
                }
                $this$generateContinuationClassForLambda_u24lambda_u2d10_u24lambda_u2d7_u24lambda_u2d6.setName(name2);
                $this$generateContinuationClassForLambda_u24lambda_u2d10_u24lambda_u2d7_u24lambda_u2d6.setType(it3.getType());
                $this$generateContinuationClassForLambda_u24lambda_u2d10_u24lambda_u2d7_u24lambda_u2d6.setOrigin(LocalDeclarationsLowering.DECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE.INSTANCE);
                $this$generateContinuationClassForLambda_u24lambda_u2d10_u24lambda_u2d7_u24lambda_u2d6.setFinal(false);
                if (it3.getIndex() < 0) {
                    object5 = DescriptorVisibilities.PRIVATE;
                    Intrinsics.checkNotNullExpressionValue(object5, "PRIVATE");
                    object4 = object5;
                } else {
                    object5 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
                    Intrinsics.checkNotNullExpressionValue(object5, "PACKAGE_VISIBILITY");
                    object4 = object5;
                }
                $this$generateContinuationClassForLambda_u24lambda_u2d10_u24lambda_u2d7_u24lambda_u2d6.setVisibility((DescriptorVisibility)object4);
                IrField irField = DeclarationBuildersKt.buildField($this$buildField$iv$iv, $this$buildField_u24lambda_u2d5$iv$iv);
                boolean bl16 = false;
                boolean bl17 = false;
                IrField field$iv = irField;
                boolean bl18 = false;
                field$iv.setParent($this$addField$iv);
                $this$addField$iv.getDeclarations().add(field$iv);
                object = irField;
                object3.add(object);
            }
            parametersFields = (List)destination$iv$iv2;
            constructor2 = this.addPrimaryConstructorForLambda($this$generateContinuationClassForLambda_u24lambda_u2d10, suspendLambda, arity);
            Sequence<IrSimpleFunctionSymbol> $this$single$iv = IrUtilsKt.getFunctions(functionNClass);
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            item$iv$iv3 = $this$single$iv.iterator();
            while (item$iv$iv3.hasNext()) {
                Object element$iv = item$iv$iv3.next();
                IrSimpleFunctionSymbol it4 = (IrSimpleFunctionSymbol)element$iv;
                boolean bl19 = false;
                if (!(((IrSimpleFunction)it4.getOwner()).getValueParameters().size() == arity + 1 && Intrinsics.areEqual(((IrSimpleFunction)it4.getOwner()).getName().asString(), "invoke"))) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            invokeToOverride = single$iv;
            Sequence<IrSimpleFunctionSymbol> $this$singleOrNull$iv = IrUtilsKt.getFunctions((IrClassSymbol)suspendLambda.getSymbol());
            boolean $i$f$singleOrNull = false;
            IrSimpleFunctionSymbol single$iv2 = null;
            boolean found$iv2 = false;
            Iterator<IrSimpleFunctionSymbol> iterator2 = $this$singleOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                IrSimpleFunctionSymbol element$iv;
                IrSimpleFunctionSymbol it5 = element$iv = iterator2.next();
                boolean bl20 = false;
                if (!(((IrSimpleFunction)it5.getOwner()).getValueParameters().size() == arity + 1 && Intrinsics.areEqual(((IrSimpleFunction)it5.getOwner()).getName().asString(), "create"))) continue;
                if (found$iv2) {
                    irSimpleFunctionSymbol = null;
                    break block22;
                }
                single$iv2 = element$iv;
                found$iv2 = true;
            }
            irSimpleFunctionSymbol = !found$iv2 ? null : single$iv2;
        }
        IrSimpleFunctionSymbol createToOverride = irSimpleFunctionSymbol;
        IrSimpleFunction invokeSuspend = this.addInvokeSuspendForLambda($this$generateContinuationClassForLambda_u24lambda_u2d10, function2, suspendLambda, parametersFields);
        if (SuspendLambdaLoweringKt.access$capturesCrossinline(function2)) {
            this.addInvokeSuspendForInlineForLambda($this$generateContinuationClassForLambda_u24lambda_u2d10, invokeSuspend);
        }
        if (createToOverride != null) {
            this.addInvokeCallingCreate($this$generateContinuationClassForLambda_u24lambda_u2d10, this.addCreate($this$generateContinuationClassForLambda_u24lambda_u2d10, constructor2, createToOverride, parametersFields), invokeSuspend, invokeToOverride);
        } else {
            this.addInvokeCallingConstructor($this$generateContinuationClassForLambda_u24lambda_u2d10, constructor2, invokeSuspend, invokeToOverride, parametersFields);
        }
        $this$generateContinuationClassForLambda_u24lambda_u2d10.setMetadata(function2.getMetadata());
        Map<IrFunctionReference, IrFunction> map2 = this.getContext().getSuspendLambdaToOriginalFunctionMap();
        IrFunctionReference irFunctionReference = (IrFunctionReference)$this$generateContinuationClassForLambda_u24lambda_u2d10.getAttributeOwnerId();
        boolean bl = false;
        map2.put(irFunctionReference, function2);
        return irClass2;
    }

    private final IrSimpleFunction addInvokeSuspendForLambda(IrClass $this$addInvokeSuspendForLambda, IrFunction irFunction2, IrClass suspendLambda, List<? extends IrField> fields2) {
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(suspendLambda);
        boolean $i$f$single = false;
        IrSimpleFunction single$iv = null;
        boolean found$iv = false;
        Iterator<IrSimpleFunction> iterator2 = $this$single$iv.iterator();
        while (iterator2.hasNext()) {
            IrSimpleFunction element$iv;
            IrSimpleFunction it = element$iv = iterator2.next();
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual(it.getName().asString(), "invokeSuspend") && it.getValueParameters().size() == 1 && IrTypePredicatesKt.isKotlinResult(it.getValueParameters().get(0).getType());
            if (!bl2) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction superMethod = single$iv;
        IrSimpleFunction irSimpleFunction = this.addFunctionOverride($this$addInvokeSuspendForLambda, superMethod, irFunction2.getStartOffset(), irFunction2.getEndOffset());
        boolean bl = false;
        boolean bl3 = false;
        IrSimpleFunction $this$addInvokeSuspendForLambda_u24lambda_u2d12 = irSimpleFunction;
        boolean bl4 = false;
        boolean bl5 = false;
        IrBody irBody = IrInlineUtilsKt.moveBodyTo(irFunction2, $this$addInvokeSuspendForLambda_u24lambda_u2d12, MapsKt.emptyMap());
        $this$addInvokeSuspendForLambda_u24lambda_u2d12.setBody((IrBody)(irBody == null ? null : irBody.transform((IrElementTransformer)new IrElementTransformerVoid(fields2, irFunction2, $this$addInvokeSuspendForLambda_u24lambda_u2d12){
            final /* synthetic */ List<IrField> $fields;
            final /* synthetic */ IrFunction $irFunction;
            final /* synthetic */ IrSimpleFunction $this_anonymous;
            {
                this.$fields = $fields;
                this.$irFunction = $irFunction;
                this.$this_anonymous = $receiver;
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                IrValueParameter irValueParameter;
                IrValueDeclaration irValueDeclaration;
                IrValueParameter irValueParameter2;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrValueDeclaration irValueDeclaration2 = expression2.getSymbol().getOwner();
                IrValueParameter irValueParameter3 = irValueParameter2 = irValueDeclaration2 instanceof IrValueParameter ? (IrValueParameter)irValueDeclaration2 : null;
                if (irValueParameter2 == null) {
                    irValueDeclaration = null;
                } else {
                    irValueDeclaration2 = irValueParameter2;
                    IrFunction irFunction2 = this.$irFunction;
                    boolean bl = false;
                    boolean bl2 = false;
                    IrValueDeclaration it = irValueDeclaration2;
                    boolean bl3 = false;
                    irValueDeclaration = irValueParameter = Intrinsics.areEqual(it.getParent(), irFunction2) ? irValueDeclaration2 : null;
                }
                if (irValueParameter == null) {
                    return expression2;
                }
                IrValueParameter parameter = irValueParameter;
                IrField field = this.$fields.get(parameter.getIndex() + (this.$irFunction.getExtensionReceiverParameter() != null ? 1 : 0));
                irValueDeclaration2 = this.$this_anonymous.getDispatchReceiverParameter();
                Intrinsics.checkNotNull(irValueDeclaration2);
                IrGetValueImpl receiver = new IrGetValueImpl(-1, -1, irValueDeclaration2.getSymbol(), null, 8, null);
                return new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), (IrFieldSymbol)field.getSymbol(), field.getType(), receiver, null, null, 96, null);
            }
        }, (Object)null)));
        return irSimpleFunction;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction addInvokeSuspendForInlineForLambda(IrClass $this$addInvokeSuspendForInlineForLambda, IrSimpleFunction invokeSuspend) {
        Collection<IrValueParameter> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrSimpleFunction irSimpleFunction = DeclarationBuildersKt.addFunction$default($this$addInvokeSuspendForInlineForLambda, "invokeSuspend$$forInline", this.getContext().getIrBuiltIns().getAnyNType(), Modality.FINAL, null, false, false, false, JvmLoweredDeclarationOrigin.FOR_INLINE_STATE_MACHINE_TEMPLATE_CAPTURES_CROSSINLINE.INSTANCE, 0, 0, 888, null);
        boolean bl = false;
        boolean bl2 = false;
        IrSimpleFunction $this$addInvokeSuspendForInlineForLambda_u24lambda_u2d14 = irSimpleFunction;
        boolean bl3 = false;
        IrAttributeContainerKt.copyAttributes((IrAttributeContainer)$this$addInvokeSuspendForInlineForLambda_u24lambda_u2d14, invokeSuspend);
        this.generateErrorForInlineBody($this$addInvokeSuspendForInlineForLambda_u24lambda_u2d14);
        Iterable iterable = invokeSuspend.getValueParameters();
        IrSimpleFunction irSimpleFunction2 = $this$addInvokeSuspendForInlineForLambda_u24lambda_u2d14;
        boolean $i$f$map = false;
        void var11_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            IrValueParameter irValueParameter2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)it, $this$addInvokeSuspendForInlineForLambda_u24lambda_u2d14, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8190, null);
            collection.add(irValueParameter2);
        }
        collection = (List)destination$iv$iv;
        irSimpleFunction2.setValueParameters((List<? extends IrValueParameter>)collection);
        return irSimpleFunction;
    }

    private final IrSimpleFunction addInvokeCallingCreate(IrClass $this$addInvokeCallingCreate, IrFunction create2, IrSimpleFunction invokeSuspend, IrSimpleFunctionSymbol invokeToOverride) {
        return SuspendLoweringUtils.addFunctionOverride$default(this, $this$addInvokeCallingCreate, (IrSimpleFunction)invokeToOverride.getOwner(), 0, 0, new Function2<IrBlockBodyBuilder, IrFunction, Unit>(create2, this, invokeSuspend, $this$addInvokeCallingCreate){
            final /* synthetic */ IrFunction $create;
            final /* synthetic */ SuspendLambdaLowering this$0;
            final /* synthetic */ IrSimpleFunction $invokeSuspend;
            final /* synthetic */ IrClass $this_addInvokeCallingCreate;
            {
                this.$create = $create;
                this.this$0 = $receiver;
                this.$invokeSuspend = $invokeSuspend;
                this.$this_addInvokeCallingCreate = $receiver2;
                super(2);
            }

            public final void invoke(@NotNull IrBlockBodyBuilder irBlockBodyBuilder, @NotNull IrFunction function2) {
                Intrinsics.checkNotNullParameter(irBlockBodyBuilder, "<this>");
                Intrinsics.checkNotNullParameter(function2, "function");
                IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)irBlockBodyBuilder, this.$create);
                boolean bl = false;
                boolean bl2 = false;
                IrFunctionAccessExpression createCall = irFunctionAccessExpression;
                boolean bl3 = false;
                IrBuilderWithScope irBuilderWithScope = irBlockBodyBuilder;
                Object object = function2.getDispatchReceiverParameter();
                Intrinsics.checkNotNull(object);
                createCall.setDispatchReceiver(ExpressionHelpersKt.irGet(irBuilderWithScope, (IrValueDeclaration)object));
                object = function2.getValueParameters().iterator();
                int n = 0;
                while (object.hasNext()) {
                    int index2 = n++;
                    IrValueParameter param = (IrValueParameter)object.next();
                    createCall.putValueArgument(index2, ExpressionHelpersKt.irGet(irBlockBodyBuilder, param));
                }
                IrFunctionAccessExpression newlyCreatedObject = irFunctionAccessExpression;
                irBlockBodyBuilder.unaryPlus(ExpressionHelpersKt.irReturn(irBlockBodyBuilder, SuspendLambdaLowering.access$callInvokeSuspend(this.this$0, irBlockBodyBuilder, this.$invokeSuspend, ExpressionHelpersKt.irImplicitCast(irBlockBodyBuilder, newlyCreatedObject, IrUtilsKt.getDefaultType(this.$this_addInvokeCallingCreate)))));
            }
        }, 6, null);
    }

    private final IrSimpleFunction addInvokeCallingConstructor(IrClass $this$addInvokeCallingConstructor, IrFunction constructor2, IrSimpleFunction invokeSuspend, IrSimpleFunctionSymbol invokeToOverride, List<? extends IrField> fieldsForUnbound) {
        return SuspendLoweringUtils.addFunctionOverride$default(this, $this$addInvokeCallingConstructor, (IrSimpleFunction)invokeToOverride.getOwner(), 0, 0, new Function2<IrBlockBodyBuilder, IrFunction, Unit>(this, invokeSuspend, constructor2, fieldsForUnbound){
            final /* synthetic */ SuspendLambdaLowering this$0;
            final /* synthetic */ IrSimpleFunction $invokeSuspend;
            final /* synthetic */ IrFunction $constructor;
            final /* synthetic */ List<IrField> $fieldsForUnbound;
            {
                this.this$0 = $receiver;
                this.$invokeSuspend = $invokeSuspend;
                this.$constructor = $constructor;
                this.$fieldsForUnbound = $fieldsForUnbound;
                super(2);
            }

            public final void invoke(@NotNull IrBlockBodyBuilder irBlockBodyBuilder, @NotNull IrFunction function2) {
                Intrinsics.checkNotNullParameter(irBlockBodyBuilder, "<this>");
                Intrinsics.checkNotNullParameter(function2, "function");
                irBlockBodyBuilder.unaryPlus(ExpressionHelpersKt.irReturn(irBlockBodyBuilder, SuspendLambdaLowering.access$callInvokeSuspend(this.this$0, irBlockBodyBuilder, this.$invokeSuspend, SuspendLambdaLowering.access$cloneLambda(this.this$0, irBlockBodyBuilder, function2, this.$constructor, this.$fieldsForUnbound))));
            }
        }, 6, null);
    }

    private final IrSimpleFunction addCreate(IrClass $this$addCreate, IrFunction constructor2, IrSimpleFunctionSymbol createToOverride, List<? extends IrField> fieldsForUnbound) {
        return SuspendLoweringUtils.addFunctionOverride$default(this, $this$addCreate, (IrSimpleFunction)createToOverride.getOwner(), 0, 0, new Function2<IrBlockBodyBuilder, IrFunction, Unit>(this, constructor2, fieldsForUnbound){
            final /* synthetic */ SuspendLambdaLowering this$0;
            final /* synthetic */ IrFunction $constructor;
            final /* synthetic */ List<IrField> $fieldsForUnbound;
            {
                this.this$0 = $receiver;
                this.$constructor = $constructor;
                this.$fieldsForUnbound = $fieldsForUnbound;
                super(2);
            }

            public final void invoke(@NotNull IrBlockBodyBuilder irBlockBodyBuilder, @NotNull IrFunction function2) {
                Intrinsics.checkNotNullParameter(irBlockBodyBuilder, "<this>");
                Intrinsics.checkNotNullParameter(function2, "function");
                irBlockBodyBuilder.unaryPlus(ExpressionHelpersKt.irReturn(irBlockBodyBuilder, SuspendLambdaLowering.access$cloneLambda(this.this$0, irBlockBodyBuilder, function2, this.$constructor, this.$fieldsForUnbound)));
            }
        }, 6, null);
    }

    private final IrExpression cloneLambda(IrBlockBodyBuilder $this$cloneLambda, IrFunction scope2, IrFunction constructor2, List<? extends IrField> fieldsForUnbound) {
        IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$cloneLambda, constructor2);
        boolean bl = false;
        int n = 0;
        IrFunctionAccessExpression it = irFunctionAccessExpression;
        boolean bl2 = false;
        for (IrTypeParameter typeParameter : IrUtilsKt.getParentAsClass(constructor2).getTypeParameters()) {
            it.putTypeArgument(typeParameter.getIndex(), IrTypesKt.getDefaultType(typeParameter));
        }
        it.putValueArgument(0, ExpressionHelpersKt.irGet($this$cloneLambda, CollectionsKt.last(scope2.getValueParameters())));
        IrFunctionAccessExpression constructorCall = irFunctionAccessExpression;
        if (fieldsForUnbound.isEmpty()) {
            return constructorCall;
        }
        IrVariable result2 = ExpressionHelpersKt.irTemporary$default($this$cloneLambda, constructorCall, "result", null, false, 12, null);
        Iterator<? extends IrField> iterator2 = fieldsForUnbound.iterator();
        n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            IrField field = iterator2.next();
            $this$cloneLambda.unaryPlus(ExpressionHelpersKt.irSetField($this$cloneLambda, ExpressionHelpersKt.irGet($this$cloneLambda, result2), field, ExpressionHelpersKt.irGet($this$cloneLambda, scope2.getValueParameters().get(index2))));
        }
        return ExpressionHelpersKt.irGet($this$cloneLambda, result2);
    }

    private final IrExpression callInvokeSuspend(IrBlockBodyBuilder $this$callInvokeSuspend, IrSimpleFunction invokeSuspend, IrExpression lambda2) {
        return ExpressionHelpersKt.irCallOp$default($this$callInvokeSuspend, (IrSimpleFunctionSymbol)invokeSuspend.getSymbol(), invokeSuspend.getReturnType(), lambda2, ExpressionHelpersKt.irUnit($this$callInvokeSuspend), null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor addPrimaryConstructorForLambda(IrClass $this$addPrimaryConstructorForLambda, IrClass superClass2, int arity) {
        void it;
        void $this$addPrimaryConstructorForLambda_u24lambda_u2d20_u24lambda_u2d19;
        void this_$iv$iv;
        IrClass $this$addConstructor$iv = $this$addPrimaryConstructorForLambda;
        boolean $i$f$addConstructor = false;
        IrFactory $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2d22$iv$iv = irFunctionBuilder;
        boolean bl3 = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u2d23$iv = $this$buildConstructor_u24lambda_u2d22$iv$iv;
        boolean $i$a$-buildConstructor-DeclarationBuildersKt$addConstructor$2$iv22 = false;
        IrFunctionBuilder $this$addPrimaryConstructorForLambda_u24lambda_u2d16 = $this$addConstructor_u24lambda_u2d23$iv;
        boolean bl4 = false;
        $this$addPrimaryConstructorForLambda_u24lambda_u2d16.setOrigin(JvmLoweredDeclarationOrigin.SUSPEND_LAMBDA.INSTANCE);
        $this$addPrimaryConstructorForLambda_u24lambda_u2d16.setPrimary(true);
        $this$addPrimaryConstructorForLambda_u24lambda_u2d16.setReturnType(IrUtilsKt.getDefaultType($this$addPrimaryConstructorForLambda));
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "LOCAL");
        $this$addPrimaryConstructorForLambda_u24lambda_u2d16.setVisibility(descriptorVisibility);
        $this$addConstructor_u24lambda_u2d23$iv.setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv));
        IrConstructor irConstructor2 = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u2d22$iv$iv);
        $i$f$buildConstructor = false;
        boolean bl5 = false;
        IrConstructor constructor$iv = irConstructor2;
        boolean bl6 = false;
        $this$addConstructor$iv.getDeclarations().add(constructor$iv);
        constructor$iv.setParent($this$addConstructor$iv);
        IrConstructor irConstructor3 = irConstructor2;
        boolean bl7 = false;
        boolean bl8 = false;
        IrConstructor constructor2 = irConstructor3;
        boolean bl9 = false;
        IrValueParameter completionParameterSymbol = this.addCompletionValueParameter(constructor2);
        Sequence<IrConstructor> $this$single$iv = IrUtilsKt.getConstructors(superClass2);
        boolean $i$f$single = false;
        IrConstructor single$iv = null;
        boolean found$iv = false;
        Object $i$a$-buildConstructor-DeclarationBuildersKt$addConstructor$2$iv22 = $this$single$iv.iterator();
        while ($i$a$-buildConstructor-DeclarationBuildersKt$addConstructor$2$iv22.hasNext()) {
            IrConstructor element$iv;
            IrConstructor it2 = element$iv = $i$a$-buildConstructor-DeclarationBuildersKt$addConstructor$2$iv22.next();
            boolean bl10 = false;
            if (!(it2.getValueParameters().size() == 2 && IrTypePredicatesKt.isInt(it2.getValueParameters().get(0).getType()) && IrTypePredicatesKt.isNullableContinuation(it2.getValueParameters().get(1).getType()))) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrConstructor superClassConstructor = single$iv;
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), constructor2.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        $i$a$-buildConstructor-DeclarationBuildersKt$addConstructor$2$iv22 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void it2 = this_$iv$iv;
        IrConstructor irConstructor4 = constructor2;
        boolean bl11 = false;
        IrDelegatingConstructorCall irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$addPrimaryConstructorForLambda_u24lambda_u2d20_u24lambda_u2d19, superClassConstructor);
        boolean bl12 = false;
        boolean bl13 = false;
        IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall;
        void var24_39 = $this$addPrimaryConstructorForLambda_u24lambda_u2d20_u24lambda_u2d19;
        boolean bl14 = false;
        it.putValueArgument(0, ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$addPrimaryConstructorForLambda_u24lambda_u2d20_u24lambda_u2d19, arity + 1, null, 2, null));
        it.putValueArgument(1, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$addPrimaryConstructorForLambda_u24lambda_u2d20_u24lambda_u2d19, completionParameterSymbol));
        Unit unit = Unit.INSTANCE;
        var24_39.unaryPlus(irDelegatingConstructorCall);
        Unit unit2 = Unit.INSTANCE;
        irConstructor4.setBody(this_$iv$iv.doBuild());
        return irConstructor3;
    }

    public static final /* synthetic */ IrContainerExpression access$generateAnonymousObjectForLambda(SuspendLambdaLowering $this, IrFunctionReference reference, IrDeclarationParent parent2) {
        return $this.generateAnonymousObjectForLambda(reference, parent2);
    }

    public static final /* synthetic */ IrExpression access$callInvokeSuspend(SuspendLambdaLowering $this, IrBlockBodyBuilder $receiver, IrSimpleFunction invokeSuspend, IrExpression lambda2) {
        return $this.callInvokeSuspend($receiver, invokeSuspend, lambda2);
    }

    public static final /* synthetic */ IrExpression access$cloneLambda(SuspendLambdaLowering $this, IrBlockBodyBuilder $receiver, IrFunction scope2, IrFunction constructor2, List fieldsForUnbound) {
        return $this.cloneLambda($receiver, scope2, constructor2, fieldsForUnbound);
    }
}

