/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.ThreadDumper;
import org.jetbrains.kotlin.com.intellij.extapi.psi.ASTDelegatePsiElement;
import org.jetbrains.kotlin.com.intellij.lang.ASTFactory;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.FreeThreadedFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.AstBufferUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChangeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LazyParseableElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.ArrayFactory;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.kotlin.com.intellij.util.text.StringFactory;

public class CompositeElement
extends TreeElement {
    private static final Logger LOG = Logger.getInstance(CompositeElement.class);
    public static final CompositeElement[] EMPTY_ARRAY = new CompositeElement[0];
    private TreeElement firstChild;
    private TreeElement lastChild;
    private volatile int myCachedLength;
    private volatile int myHC;
    private volatile PsiElement myWrapper;
    private static final AtomicFieldUpdater<CompositeElement, PsiElement> ourPsiUpdater = AtomicFieldUpdater.forFieldOfType(CompositeElement.class, PsiElement.class);

    public CompositeElement(@NotNull IElementType type2) {
        if (type2 == null) {
            CompositeElement.$$$reportNull$$$0(0);
        }
        super(type2);
        this.myCachedLength = -1;
        this.myHC = -1;
    }

    @Override
    @NotNull
    public CompositeElement clone() {
        CompositeElement clone = (CompositeElement)super.clone();
        clone.firstChild = null;
        clone.lastChild = null;
        clone.myWrapper = null;
        for (ASTNode child = this.rawFirstChild(); child != null; child = child.getTreeNext()) {
            clone.rawAddChildrenWithoutNotifications((TreeElement)child.clone());
        }
        clone.clearCaches();
        CompositeElement compositeElement = clone;
        if (compositeElement == null) {
            CompositeElement.$$$reportNull$$$0(1);
        }
        return compositeElement;
    }

    public void subtreeChanged() {
        for (CompositeElement compositeElement = this; compositeElement != null; compositeElement = compositeElement.getTreeParent()) {
            compositeElement.clearCaches();
            if (compositeElement instanceof PsiElement) continue;
            PsiElement psi = compositeElement.myWrapper;
            if (psi instanceof ASTDelegatePsiElement) {
                ((ASTDelegatePsiElement)psi).subtreeChanged();
                continue;
            }
            if (!(psi instanceof PsiFile)) continue;
            ((PsiFile)psi).subtreeChanged();
            CompositeElement.assertThreading((PsiFile)psi);
        }
    }

    @Override
    public void clearCaches() {
        this.myCachedLength = -1;
        this.myHC = -1;
        CompositeElement.clearRelativeOffsets(this.rawFirstChild());
    }

    private static void assertThreading(@NotNull PsiFile file2) {
        boolean ok;
        if (file2 == null) {
            CompositeElement.$$$reportNull$$$0(2);
        }
        boolean bl = ok = ApplicationManager.getApplication().isWriteAccessAllowed() || CompositeElement.isNonPhysicalOrInjected(file2);
        if (!ok) {
            LOG.error("Threading assertion. " + CompositeElement.getThreadingDiagnostics(file2));
        }
    }

    private static String getThreadingDiagnostics(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CompositeElement.$$$reportNull$$$0(3);
        }
        return "psiFile: " + psiFile + "; psiFile.getViewProvider(): " + psiFile.getViewProvider() + "; psiFile.isPhysical(): " + psiFile.isPhysical() + "; nonPhysicalOrInjected: " + CompositeElement.isNonPhysicalOrInjected(psiFile);
    }

    private static boolean isNonPhysicalOrInjected(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CompositeElement.$$$reportNull$$$0(4);
        }
        return psiFile instanceof DummyHolder || psiFile.getViewProvider() instanceof FreeThreadedFileViewProvider || !psiFile.isPhysical();
    }

    @Override
    public void acceptTree(@NotNull TreeElementVisitor visitor2) {
        if (visitor2 == null) {
            CompositeElement.$$$reportNull$$$0(5);
        }
        visitor2.visitComposite(this);
    }

    @Override
    public LeafElement findLeafElementAt(int offset2) {
        TreeElement element = this;
        if (element.getTreeParent() == null && offset2 >= element.getTextLength()) {
            return null;
        }
        block0: while (true) {
            boolean fwd;
            TreeElement child = ((TreeElement)element).getFirstChildNode();
            TreeElement lastChild = ((TreeElement)element).getLastChildNode();
            int elementTextLength = element.getTextLength();
            boolean bl = fwd = lastChild == null || elementTextLength / 2 > offset2;
            if (!fwd) {
                child = lastChild;
                offset2 = elementTextLength - offset2;
            }
            while (child != null) {
                int textLength = child.getTextLength();
                if (textLength > offset2 || !fwd && textLength >= offset2) {
                    if (child instanceof LeafElement) {
                        if (child instanceof ForeignLeafPsiElement) {
                            child = fwd ? child.getTreeNext() : child.getTreePrev();
                            continue;
                        }
                        return (LeafElement)child;
                    }
                    offset2 = fwd ? offset2 : textLength - offset2;
                    element = child;
                    continue block0;
                }
                offset2 -= textLength;
                child = fwd ? child.getTreeNext() : child.getTreePrev();
            }
            break;
        }
        return null;
    }

    @Nullable
    public PsiElement findPsiChildByType(@NotNull IElementType type2) {
        ASTNode node;
        if (type2 == null) {
            CompositeElement.$$$reportNull$$$0(6);
        }
        return (node = this.findChildByType(type2)) == null ? null : node.getPsi();
    }

    @Nullable
    public PsiElement findPsiChildByType(@NotNull TokenSet types2) {
        ASTNode node;
        if (types2 == null) {
            CompositeElement.$$$reportNull$$$0(7);
        }
        return (node = this.findChildByType(types2)) == null ? null : node.getPsi();
    }

    @Override
    public ASTNode findChildByType(@NotNull IElementType type2) {
        if (type2 == null) {
            CompositeElement.$$$reportNull$$$0(8);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            this.assertReadAccessAllowed();
        }
        for (ASTNode element = this.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (element.getElementType() != type2) continue;
            return element;
        }
        return null;
    }

    public ASTNode findChildByType(@NotNull IElementType type2, ASTNode anchor2) {
        if (type2 == null) {
            CompositeElement.$$$reportNull$$$0(9);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            this.assertReadAccessAllowed();
        }
        return TreeUtil.findSibling(anchor2, type2);
    }

    @Override
    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet types2) {
        if (types2 == null) {
            CompositeElement.$$$reportNull$$$0(10);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            this.assertReadAccessAllowed();
        }
        for (ASTNode element = this.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (!types2.contains(element.getElementType())) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, ASTNode anchor2) {
        if (typesSet == null) {
            CompositeElement.$$$reportNull$$$0(11);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            this.assertReadAccessAllowed();
        }
        return TreeUtil.findSibling(anchor2, typesSet);
    }

    @Override
    @NotNull
    public String getText() {
        String string2 = StringFactory.createShared(this.textToCharArray());
        if (string2 == null) {
            CompositeElement.$$$reportNull$$$0(12);
        }
        return string2;
    }

    @Override
    @NotNull
    public CharSequence getChars() {
        String string2 = this.getText();
        if (string2 == null) {
            CompositeElement.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @Override
    public char @NotNull [] textToCharArray() {
        int endOffset;
        this.assertReadAccessAllowed();
        int len = this.getTextLength();
        char[] buffer = new char[len];
        try {
            endOffset = AstBufferUtil.toBuffer(this, buffer, 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String msg = "Underestimated text length: " + len;
            try {
                int length = AstBufferUtil.toBuffer(this, new char[len], 0);
                msg = msg + ";\n repetition gives success (" + length + ")";
            }
            catch (ArrayIndexOutOfBoundsException e1) {
                msg = msg + ";\n repetition fails as well";
            }
            throw new RuntimeException(msg, e);
        }
        if (endOffset != len) {
            String msg = "len=" + len + ";\n endOffset=" + endOffset;
            msg = msg + this.diagnoseTextInconsistency(new String(buffer, 0, Math.min(len, endOffset)));
            throw new AssertionError((Object)msg);
        }
        if (buffer == null) {
            CompositeElement.$$$reportNull$$$0(14);
        }
        return buffer;
    }

    private String diagnoseTextInconsistency(String text2) {
        PsiElement psi;
        String msg = "";
        msg = msg + ";\n nonPhysicalOrInjected=" + CompositeElement.isNonPhysicalOrInjected(SharedImplUtil.getContainingFile(this));
        msg = msg + ";\n buffer=" + text2;
        try {
            msg = msg + ";\n this=" + this;
        }
        catch (StackOverflowError e) {
            msg = msg + ";\n this.toString produces SOE";
        }
        int shitStart = this.textMatches(text2, 0);
        msg = msg + ";\n matches until " + shitStart;
        LeafElement leaf = this.findLeafElementAt(Math.abs(shitStart));
        msg = msg + ";\n element there=" + leaf;
        if (leaf != null) {
            psi = leaf.getPsi();
            msg = msg + ";\n leaf.text=" + leaf.getText();
            msg = msg + ";\n leaf.psi=" + psi;
            msg = msg + ";\n leaf.lang=" + (psi == null ? null : psi.getLanguage());
            msg = msg + ";\n leaf.type=" + leaf.getElementType();
        }
        if ((psi = this.getPsi()) != null) {
            PsiFile file2;
            boolean valid = psi.isValid();
            msg = msg + ";\n psi.valid=" + valid;
            if (valid && (file2 = psi.getContainingFile()) != null) {
                msg = msg + ";\n psi.file=" + file2;
                msg = msg + ";\n psi.file.tl=" + file2.getTextLength();
                msg = msg + ";\n psi.file.lang=" + file2.getLanguage();
                msg = msg + ";\n psi.file.vp=" + file2.getViewProvider();
                msg = msg + ";\n psi.file.vp.lang=" + file2.getViewProvider().getLanguages();
                msg = msg + ";\n psi.file.vp.lang=" + file2.getViewProvider().getLanguages();
                PsiElement fileLeaf = file2.findElementAt(this.getTextRange().getStartOffset());
                LeafElement myLeaf = this.findLeafElementAt(0);
                msg = msg + ";\n leaves at start=" + fileLeaf + " and " + myLeaf;
            }
        }
        return msg;
    }

    @Override
    public boolean textContains(char c) {
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!child.textContains(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int textMatches(final @NotNull CharSequence buffer, int start) {
        if (buffer == null) {
            CompositeElement.$$$reportNull$$$0(15);
        }
        final int[] curOffset = new int[]{start};
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitLeaf(LeafElement leaf) {
                this.matchText(leaf);
            }

            private void matchText(TreeElement leaf) {
                curOffset[0] = leaf.textMatches(buffer, curOffset[0]);
                if (curOffset[0] < 0) {
                    this.stopWalking();
                }
            }

            @Override
            public void visitComposite(CompositeElement composite) {
                if (composite instanceof LazyParseableElement && !((LazyParseableElement)composite).isParsed()) {
                    this.matchText(composite);
                } else {
                    super.visitComposite(composite);
                }
            }
        });
        return curOffset[0];
    }

    @Nullable
    public final PsiElement findChildByRoleAsPsiElement(int role) {
        ASTNode element = this.findChildByRole(role);
        if (element == null) {
            return null;
        }
        return SourceTreeToPsiMap.treeElementToPsi(element);
    }

    @Nullable
    public ASTNode findChildByRole(int role) {
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (this.getChildRole(child) != role) continue;
            return child;
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(16);
        }
        LOG.assertTrue(child.getTreeParent() == this, child);
        return 0;
    }

    protected final int getChildRole(@NotNull ASTNode child, int roleCandidate) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(17);
        }
        if (this.findChildByRole(roleCandidate) == child) {
            return roleCandidate;
        }
        return 0;
    }

    @Override
    public ASTNode @NotNull [] getChildren(@Nullable TokenSet filter2) {
        int count2 = this.countChildren(filter2);
        if (count2 == 0) {
            if (EMPTY_ARRAY == null) {
                CompositeElement.$$$reportNull$$$0(18);
            }
            return EMPTY_ARRAY;
        }
        ASTNode[] result2 = new ASTNode[count2];
        count2 = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (filter2 != null && !filter2.contains(child.getElementType())) continue;
            result2[count2++] = child;
        }
        if (result2 == null) {
            CompositeElement.$$$reportNull$$$0(19);
        }
        return result2;
    }

    public <T extends PsiElement> T @NotNull [] getChildrenAsPsiElements(@Nullable TokenSet filter2, @NotNull ArrayFactory<? extends T> constructor2) {
        if (constructor2 == null) {
            CompositeElement.$$$reportNull$$$0(20);
        }
        this.assertReadAccessAllowed();
        int count2 = this.countChildren(filter2);
        PsiElement[] result2 = (PsiElement[])constructor2.create(count2);
        if (count2 == 0) {
            if (result2 == null) {
                CompositeElement.$$$reportNull$$$0(21);
            }
            return result2;
        }
        int idx = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null && idx < count2; child = child.getTreeNext()) {
            if (filter2 != null && !filter2.contains(child.getElementType())) continue;
            PsiElement element = child.getPsi();
            LOG.assertTrue(element != null, child);
            result2[idx++] = element;
        }
        if (result2 == null) {
            CompositeElement.$$$reportNull$$$0(22);
        }
        return result2;
    }

    public <T extends PsiElement> T @NotNull [] getChildrenAsPsiElements(@NotNull IElementType type2, @NotNull ArrayFactory<? extends T> constructor2) {
        if (type2 == null) {
            CompositeElement.$$$reportNull$$$0(23);
        }
        if (constructor2 == null) {
            CompositeElement.$$$reportNull$$$0(24);
        }
        this.assertReadAccessAllowed();
        int count2 = this.countChildren(type2);
        PsiElement[] result2 = (PsiElement[])constructor2.create(count2);
        if (count2 == 0) {
            if (result2 == null) {
                CompositeElement.$$$reportNull$$$0(25);
            }
            return result2;
        }
        int idx = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null && idx < count2; child = child.getTreeNext()) {
            if (type2 != child.getElementType()) continue;
            PsiElement element = child.getPsi();
            LOG.assertTrue(element != null, child);
            result2[idx++] = element;
        }
        if (result2 == null) {
            CompositeElement.$$$reportNull$$$0(26);
        }
        return result2;
    }

    public int countChildren(@Nullable TokenSet filter2) {
        int count2 = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (filter2 != null && !filter2.contains(child.getElementType())) continue;
            ++count2;
        }
        return count2;
    }

    private int countChildren(@NotNull IElementType type2) {
        if (type2 == null) {
            CompositeElement.$$$reportNull$$$0(27);
        }
        int count2 = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (type2 != child.getElementType()) continue;
            ++count2;
        }
        return count2;
    }

    public TreeElement addInternal(TreeElement first2, ASTNode last2, @Nullable ASTNode anchor2, @Nullable Boolean before) {
        ASTNode anchorBefore = anchor2 == null ? (before == null || before != false ? null : this.getFirstChildNode()) : (before != false ? anchor2 : anchor2.getTreeNext());
        return (TreeElement)CodeEditUtil.addChildren(this, first2, last2, anchorBefore);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(28);
        }
        CodeEditUtil.removeChild(this, child);
    }

    public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(29);
        }
        if (newElement == null) {
            CompositeElement.$$$reportNull$$$0(30);
        }
        CodeEditUtil.replaceChild(this, child, newElement);
    }

    @Override
    public int getTextLength() {
        int cachedLength = this.myCachedLength;
        if (cachedLength >= 0) {
            return cachedLength;
        }
        this.assertReadAccessAllowed();
        try {
            return this.walkCachingLength();
        }
        catch (AssertionError e) {
            this.myCachedLength = -1;
            String assertion = StringUtil.getThrowableText((Throwable)((Object)e));
            throw new AssertionError((Object)("Walking failure: ===\n" + assertion + "\n=== Thread dump:\n" + ThreadDumper.dumpThreadsToString() + "\n===\n"));
        }
    }

    @Override
    public int hc() {
        int hc = this.myHC;
        if (hc == -1) {
            hc = 0;
            for (TreeElement child = this.firstChild; child != null; child = child.getTreeNext()) {
                hc += child.hc();
            }
            this.myHC = hc;
        }
        return hc;
    }

    @Override
    public int getCachedLength() {
        return this.myCachedLength;
    }

    @NotNull
    private static TreeElement drillDown(@NotNull TreeElement start) {
        TreeElement child;
        if (start == null) {
            CompositeElement.$$$reportNull$$$0(31);
        }
        TreeElement cur = start;
        while (cur.getCachedLength() < 0 && (child = cur.getFirstChildNode()) != null) {
            cur = child;
        }
        TreeElement treeElement = cur;
        if (treeElement == null) {
            CompositeElement.$$$reportNull$$$0(32);
        }
        return treeElement;
    }

    private int walkCachingLength() {
        TreeElement cur = CompositeElement.drillDown(this);
        while (true) {
            int length;
            if ((length = cur.getCachedLength()) < 0) {
                length = 0;
                for (TreeElement child = cur.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                    length += child.getTextLength();
                }
                ((CompositeElement)cur).setCachedLength(length);
            }
            if (cur == this) {
                return length;
            }
            TreeElement next = cur.getTreeNext();
            cur = next != null ? CompositeElement.drillDown(next) : CompositeElement.getNotNullParent(cur);
        }
    }

    private static TreeElement getNotNullParent(TreeElement cur) {
        CompositeElement parent2 = cur.getTreeParent();
        if (parent2 == null) {
            CompositeElement.diagnoseNullParent(cur);
        }
        return parent2;
    }

    private static void diagnoseNullParent(TreeElement cur) {
        PsiElement psi = cur.getPsi();
        if (psi != null) {
            PsiUtilCore.ensureValid(psi);
        }
        throw new IllegalStateException("Null parent of " + cur + " " + cur.getClass());
    }

    void setCachedLength(int cachedLength) {
        this.myCachedLength = cachedLength;
    }

    @Override
    public TreeElement getFirstChildNode() {
        return this.firstChild;
    }

    @Override
    public TreeElement getLastChildNode() {
        return this.lastChild;
    }

    void setFirstChildNode(TreeElement firstChild) {
        this.firstChild = firstChild;
        CompositeElement.clearRelativeOffsets(firstChild);
    }

    void setLastChildNode(TreeElement lastChild) {
        this.lastChild = lastChild;
    }

    @Override
    public void addChild(@NotNull ASTNode child, @Nullable ASTNode anchorBefore) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(33);
        }
        LOG.assertTrue(anchorBefore == null || ((TreeElement)anchorBefore).getTreeParent() == this, "anchorBefore == null || anchorBefore.getTreeParent() == parent");
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(child);
        TreeElement last2 = ((TreeElement)child).getTreeNext();
        TreeElement first2 = (TreeElement)child;
        CompositeElement.removeChildrenInner(first2, last2);
        ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
            if (anchorBefore != null) {
                CompositeElement.insertBefore((TreeChangeEventImpl)destinationTreeChange, (TreeElement)anchorBefore, first2);
            } else {
                CompositeElement.add((TreeChangeEventImpl)destinationTreeChange, this, first2);
            }
        }, this);
    }

    public void addLeaf(@NotNull IElementType leafType, @NotNull CharSequence leafText, ASTNode anchorBefore) {
        if (leafType == null) {
            CompositeElement.$$$reportNull$$$0(34);
        }
        if (leafText == null) {
            CompositeElement.$$$reportNull$$$0(35);
        }
        FileElement holder2 = new DummyHolder(this.getManager(), null).getTreeElement();
        LeafElement leaf = ASTFactory.leaf(leafType, holder2.getCharTable().intern(leafText));
        CodeEditUtil.setNodeGenerated(leaf, true);
        holder2.rawAddChildren(leaf);
        this.addChild(leaf, anchorBefore);
    }

    public void addChild(@NotNull ASTNode child) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(36);
        }
        this.addChild(child, null);
    }

    @Override
    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(37);
        }
        CompositeElement.removeChildInner((TreeElement)child);
    }

    @Override
    public void removeRange(@NotNull ASTNode first2, ASTNode firstWhichStayInTree) {
        if (first2 == null) {
            CompositeElement.$$$reportNull$$$0(38);
        }
        CompositeElement.removeChildrenInner((TreeElement)first2, (TreeElement)firstWhichStayInTree);
    }

    @Override
    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            CompositeElement.$$$reportNull$$$0(39);
        }
        if (newChild == null) {
            CompositeElement.$$$reportNull$$$0(40);
        }
        LOG.assertTrue(((TreeElement)oldChild).getTreeParent() == this);
        TreeElement oldChild1 = (TreeElement)oldChild;
        TreeElement newChildNext = ((TreeElement)newChild).getTreeNext();
        TreeElement newChild1 = (TreeElement)newChild;
        if (oldChild1 == newChild1) {
            return;
        }
        CompositeElement.removeChildrenInner(newChild1, newChildNext);
        ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
            CompositeElement.replace((TreeChangeEventImpl)destinationTreeChange, oldChild1, newChild1);
            CompositeElement.repairRemovedElement(this, oldChild1);
        }, this);
    }

    @Override
    public void replaceAllChildrenToChildrenOf(@NotNull ASTNode anotherParent) {
        if (anotherParent == null) {
            CompositeElement.$$$reportNull$$$0(41);
        }
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(anotherParent.getFirstChildNode());
        ASTNode firstChild = anotherParent.getFirstChildNode();
        ChangeUtil.prepareAndRunChangeAction(event -> CompositeElement.remove((TreeChangeEventImpl)event, (TreeElement)anotherParent.getFirstChildNode(), null), (TreeElement)anotherParent);
        if (firstChild != null) {
            ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
                TreeElement first2 = this.getFirstChildNode();
                TreeChangeEventImpl event = (TreeChangeEventImpl)destinationTreeChange;
                CompositeElement parent2 = this.getTreeParent();
                if (parent2 != null) {
                    event.addElementaryChange(parent2);
                }
                CompositeElement.remove(event, first2, null);
                CompositeElement.add(event, this, (TreeElement)firstChild);
                if (parent2 != null) {
                    CompositeElement.repairRemovedElement(this, first2);
                }
            }, this);
        } else {
            this.removeAllChildren();
        }
    }

    public void removeAllChildren() {
        TreeElement child = this.getFirstChildNode();
        if (child != null) {
            this.removeRange(child, null);
        }
    }

    @Override
    public void addChildren(@NotNull ASTNode firstChild, ASTNode lastChild, ASTNode anchorBefore) {
        if (firstChild == null) {
            CompositeElement.$$$reportNull$$$0(42);
        }
        ASTNode f = firstChild;
        while (f != lastChild) {
            ASTNode next = f.getTreeNext();
            this.addChild(f, anchorBefore);
            f = next;
        }
    }

    @Nullable
    final PsiElement getCachedPsi() {
        return this.myWrapper;
    }

    @Override
    public final PsiElement getPsi() {
        ProgressIndicatorProvider.checkCanceled();
        PsiElement wrapper = this.myWrapper;
        if (wrapper != null) {
            return wrapper;
        }
        wrapper = this.createPsiNoLock();
        return ourPsiUpdater.compareAndSet(this, null, wrapper) ? wrapper : Objects.requireNonNull(this.myWrapper);
    }

    @Override
    public <T extends PsiElement> T getPsi(@NotNull Class<T> clazz) {
        if (clazz == null) {
            CompositeElement.$$$reportNull$$$0(43);
        }
        return LeafElement.getPsi(clazz, this.getPsi(), LOG);
    }

    protected PsiElement createPsiNoLock() {
        Language lang = this.getElementType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null) {
            return parserDefinition.createElement(this);
        }
        return null;
    }

    public void setPsi(@NotNull PsiElement psi) {
        PsiElement prev;
        if (psi == null) {
            CompositeElement.$$$reportNull$$$0(44);
        }
        if ((prev = this.myWrapper) != null && prev != psi) {
            DebugUtil.onInvalidated(prev);
        }
        this.myWrapper = psi;
    }

    void clearPsi() {
        this.myWrapper = null;
    }

    public final void rawAddChildren(@NotNull TreeElement first2) {
        if (first2 == null) {
            CompositeElement.$$$reportNull$$$0(45);
        }
        this.rawAddChildrenWithoutNotifications(first2);
        this.subtreeChanged();
    }

    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first2) {
        TreeElement last2;
        if (first2 == null) {
            CompositeElement.$$$reportNull$$$0(46);
        }
        if ((last2 = this.getLastChildNode()) == null) {
            TreeElement chainLast = CompositeElement.rawSetParents(first2, this);
            this.setFirstChildNode(first2);
            this.setLastChildNode(chainLast);
        } else {
            last2.rawInsertAfterMeWithoutNotifications(first2);
        }
        DebugUtil.checkTreeStructure(this);
    }

    @NotNull
    static TreeElement rawSetParents(@NotNull TreeElement child, @NotNull CompositeElement parent2) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(47);
        }
        if (parent2 == null) {
            CompositeElement.$$$reportNull$$$0(48);
        }
        child.rawRemoveUpToWithoutNotifications(null, false);
        while (true) {
            child.setTreeParent(parent2);
            TreeElement treeNext = child.getTreeNext();
            if (treeNext == null) {
                TreeElement treeElement = child;
                if (treeElement == null) {
                    CompositeElement.$$$reportNull$$$0(49);
                }
                return treeElement;
            }
            child = treeNext;
        }
    }

    public void rawRemoveAllChildren() {
        TreeElement first2 = this.getFirstChildNode();
        if (first2 != null) {
            first2.rawRemoveUpToLast();
        }
    }

    private static void repairRemovedElement(@NotNull CompositeElement oldParent, TreeElement oldChild) {
        if (oldParent == null) {
            CompositeElement.$$$reportNull$$$0(50);
        }
        if (oldChild == null) {
            return;
        }
        FileElement treeElement = DummyHolderFactory.createHolder((PsiManager)oldParent.getManager(), null, false).getTreeElement();
        treeElement.rawAddChildren(oldChild);
    }

    private static void add(@NotNull TreeChangeEventImpl destinationTreeChange, @NotNull CompositeElement parent2, @NotNull TreeElement first2) {
        if (destinationTreeChange == null) {
            CompositeElement.$$$reportNull$$$0(51);
        }
        if (parent2 == null) {
            CompositeElement.$$$reportNull$$$0(52);
        }
        if (first2 == null) {
            CompositeElement.$$$reportNull$$$0(53);
        }
        destinationTreeChange.addElementaryChange(parent2);
        parent2.rawAddChildren(first2);
    }

    private static void remove(@NotNull TreeChangeEventImpl destinationTreeChange, TreeElement first2, TreeElement last2) {
        if (destinationTreeChange == null) {
            CompositeElement.$$$reportNull$$$0(54);
        }
        if (first2 != null) {
            destinationTreeChange.addElementaryChange(first2.getTreeParent());
            first2.rawRemoveUpTo(last2);
        }
    }

    private static void insertBefore(@NotNull TreeChangeEventImpl destinationTreeChange, @NotNull TreeElement anchorBefore, @NotNull TreeElement first2) {
        if (destinationTreeChange == null) {
            CompositeElement.$$$reportNull$$$0(55);
        }
        if (anchorBefore == null) {
            CompositeElement.$$$reportNull$$$0(56);
        }
        if (first2 == null) {
            CompositeElement.$$$reportNull$$$0(57);
        }
        destinationTreeChange.addElementaryChange(anchorBefore.getTreeParent());
        anchorBefore.rawInsertBeforeMe(first2);
    }

    private static void replace(@NotNull TreeChangeEventImpl sourceTreeChange, @NotNull TreeElement oldChild, @NotNull TreeElement newChild) {
        if (sourceTreeChange == null) {
            CompositeElement.$$$reportNull$$$0(58);
        }
        if (oldChild == null) {
            CompositeElement.$$$reportNull$$$0(59);
        }
        if (newChild == null) {
            CompositeElement.$$$reportNull$$$0(60);
        }
        sourceTreeChange.addElementaryChange(oldChild.getTreeParent());
        oldChild.rawReplaceWithList(newChild);
    }

    private static void removeChildInner(@NotNull TreeElement child) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(61);
        }
        CompositeElement.removeChildrenInner(child, child.getTreeNext());
    }

    private static void removeChildrenInner(@NotNull TreeElement first2, TreeElement last2) {
        FileElement fileElement;
        if (first2 == null) {
            CompositeElement.$$$reportNull$$$0(62);
        }
        if ((fileElement = TreeUtil.getFileElement(first2)) != null) {
            ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
                CompositeElement.remove((TreeChangeEventImpl)destinationTreeChange, first2, last2);
                CompositeElement.repairRemovedElement(fileElement, first2);
            }, first2.getTreeParent());
        } else {
            first2.rawRemoveUpTo(last2);
        }
    }

    public TreeElement rawFirstChild() {
        return this.firstChild;
    }

    public TreeElement rawLastChild() {
        return this.lastChild;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 32: 
            case 49: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 32: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 32: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/CompositeElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesSet";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 16: 
            case 17: 
            case 28: 
            case 29: 
            case 33: 
            case 36: 
            case 37: 
            case 47: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafText";
                break;
            }
            case 38: 
            case 45: 
            case 46: 
            case 53: 
            case 57: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 39: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldChild";
                break;
            }
            case 40: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anotherParent";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstChild";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldParent";
                break;
            }
            case 51: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationTreeChange";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorBefore";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTreeChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/CompositeElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 21: 
            case 22: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenAsPsiElements";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "drillDown";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "rawSetParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 32: 
            case 49: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assertThreading";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getThreadingDiagnostics";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isNonPhysicalOrInjected";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptTree";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findPsiChildByType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findChildByType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 20: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenAsPsiElements";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "countChildren";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "replaceChildInternal";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "drillDown";
                break;
            }
            case 33: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addLeaf";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "removeRange";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "replaceChild";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "replaceAllChildrenToChildrenOf";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addChildren";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getPsi";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setPsi";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "rawAddChildren";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "rawAddChildrenWithoutNotifications";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "rawSetParents";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "repairRemovedElement";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "insertBefore";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "removeChildInner";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "removeChildrenInner";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 32: 
            case 49: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

