/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfoRt;
import org.jetbrains.kotlin.com.intellij.util.text.CaseInsensitiveStringHashingStrategy;

public final class EnvironmentUtil {
    private static final Logger LOG = Logger.getInstance(EnvironmentUtil.class);
    private static final AtomicReference<CompletableFuture<Map<String, String>>> ourEnvGetter = new AtomicReference();

    @NotNull
    private static Map<String, String> getSystemEnv() {
        if (SystemInfoRt.isWindows) {
            Map<String, String> map2 = Collections.unmodifiableMap(new THashMap<String, String>(System.getenv(), CaseInsensitiveStringHashingStrategy.INSTANCE));
            if (map2 == null) {
                EnvironmentUtil.$$$reportNull$$$0(0);
            }
            return map2;
        }
        Map<String, String> map3 = System.getenv();
        if (map3 == null) {
            EnvironmentUtil.$$$reportNull$$$0(1);
        }
        return map3;
    }

    private EnvironmentUtil() {
    }

    @NotNull
    public static Map<String, String> getEnvironmentMap() {
        Map<String, String> map2;
        CompletableFuture<Map<String, String>> getter2 = ourEnvGetter.get();
        if (getter2 == null && !ourEnvGetter.compareAndSet(null, getter2 = CompletableFuture.completedFuture(EnvironmentUtil.getSystemEnv()))) {
            getter2 = ourEnvGetter.get();
        }
        try {
            map2 = getter2.join();
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
        if (map2 == null) {
            EnvironmentUtil.$$$reportNull$$$0(3);
        }
        return map2;
    }

    @Nullable
    public static String getValue(@NonNls @NotNull String name2) {
        if (name2 == null) {
            EnvironmentUtil.$$$reportNull$$$0(4);
        }
        return EnvironmentUtil.getEnvironmentMap().get(name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellScript";
                break;
            }
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemEnv";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenEnvironment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellEnv";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildShellProcessCommand";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseEnv";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "setLocaleEnv";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadEnvironment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "flattenEnvironment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildShellProcessCommand";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseEnv";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "waitAndTerminateAfter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "waitFor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setCharsetVar";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setLocaleEnv";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isCharsetVarDefined";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "inlineParentOccurrences";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "testParser";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

