/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.rendering.AbstractDiagnosticWithParametersRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRendererUtilKt;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\b\b\u0002\u0010\u0004*\u00020\u00022\u001e\u0012\u001a\u0012\u0018\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u00060\u0005B=\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\n\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0002\u0018\u00010\n\u00a2\u0006\u0002\u0010\rJ3\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000f2\u001c\u0010\u0010\u001a\u0018\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0002\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticWithParameters3Renderer;", "A", "", "B", "C", "Lorg/jetbrains/kotlin/diagnostics/rendering/AbstractDiagnosticWithParametersRenderer;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticWithParameters3;", "message", "", "rendererForA", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;", "rendererForB", "rendererForC", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;)V", "renderParameters", "", "diagnostic", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticWithParameters3;)[Ljava/lang/Object;", "frontend"})
public final class DiagnosticWithParameters3Renderer<A, B, C>
extends AbstractDiagnosticWithParametersRenderer<DiagnosticWithParameters3<?, A, B, C>> {
    @Nullable
    private final DiagnosticParameterRenderer<A> rendererForA;
    @Nullable
    private final DiagnosticParameterRenderer<B> rendererForB;
    @Nullable
    private final DiagnosticParameterRenderer<C> rendererForC;

    public DiagnosticWithParameters3Renderer(@NotNull String message2, @Nullable DiagnosticParameterRenderer<? super A> rendererForA, @Nullable DiagnosticParameterRenderer<? super B> rendererForB, @Nullable DiagnosticParameterRenderer<? super C> rendererForC) {
        Intrinsics.checkNotNullParameter(message2, "message");
        super(message2);
        this.rendererForA = rendererForA;
        this.rendererForB = rendererForB;
        this.rendererForC = rendererForC;
    }

    @Override
    @NotNull
    public Object[] renderParameters(@NotNull DiagnosticWithParameters3<?, A, B, C> diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        Object[] objectArray = new Object[]{diagnostic.getA(), diagnostic.getB(), diagnostic.getC()};
        RenderingContext context2 = RenderingContext.Companion.of(objectArray);
        objectArray = new Object[3];
        Object object = diagnostic.getA();
        Intrinsics.checkNotNullExpressionValue(object, "diagnostic.a");
        objectArray[0] = DiagnosticRendererUtilKt.renderParameter(object, this.rendererForA, context2);
        object = diagnostic.getB();
        Intrinsics.checkNotNullExpressionValue(object, "diagnostic.b");
        objectArray[1] = DiagnosticRendererUtilKt.renderParameter(object, this.rendererForB, context2);
        object = diagnostic.getC();
        Intrinsics.checkNotNullExpressionValue(object, "diagnostic.c");
        objectArray[2] = DiagnosticRendererUtilKt.renderParameter(object, this.rendererForC, context2);
        return objectArray;
    }
}

