/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategy;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategyKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategies;", "", "()V", "DECLARATION_NAME", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "getDECLARATION_NAME", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "DECLARATION_SIGNATURE", "getDECLARATION_SIGNATURE", "DEFAULT", "getDEFAULT", "SECONDARY_CONSTRUCTOR_DELEGATION_CALL", "getSECONDARY_CONSTRUCTOR_DELEGATION_CALL", "VAL_OR_VAR_NODE", "getVAL_OR_VAR_NODE", "checkers"})
public final class LightTreePositioningStrategies {
    @NotNull
    public static final LightTreePositioningStrategies INSTANCE = new LightTreePositioningStrategies();
    @NotNull
    private static final LightTreePositioningStrategy DEFAULT = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            IElementType iElementType = node.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.OBJECT_DECLARATION)) {
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$objectKeyword(tree, node);
                Intrinsics.checkNotNull(lighterASTNode2);
                LighterASTNode objectKeyword = lighterASTNode2;
                lighterASTNode2 = LightTreePositioningStrategiesKt.access$nameIdentifier(tree, node);
                return LightTreePositioningStrategyKt.markRange(objectKeyword, lighterASTNode2 == null ? objectKeyword : lighterASTNode2, tree);
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL)) {
                return LightTreePositioningStrategies.INSTANCE.getSECONDARY_CONSTRUCTOR_DELEGATION_CALL().mark(node, tree);
            }
            return super.mark(node, tree);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy VAL_OR_VAR_NODE = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$valOrVarKeyword(tree, node);
            LighterASTNode target = lighterASTNode2 == null ? node : lighterASTNode2;
            return LightTreePositioningStrategyKt.markElement(target, tree);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy SECONDARY_CONSTRUCTOR_DELEGATION_CALL = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            IElementType iElementType = node.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.SECONDARY_CONSTRUCTOR)) {
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node);
                if (lighterASTNode2 == null) {
                    return LightTreePositioningStrategyKt.markElement(node, tree);
                }
                LighterASTNode valueParameterList = lighterASTNode2;
                lighterASTNode2 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, node);
                Intrinsics.checkNotNull(lighterASTNode2);
                LighterASTNode lighterASTNode3 = lighterASTNode2;
                lighterASTNode2 = LightTreePositioningStrategiesKt.access$lastChild(tree, valueParameterList);
                Intrinsics.checkNotNull(lighterASTNode2);
                return LightTreePositioningStrategyKt.markRange(lighterASTNode3, lighterASTNode2, tree);
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL)) {
                Object object = KtNodeTypes.CONSTRUCTOR_DELEGATION_REFERENCE;
                Intrinsics.checkNotNullExpressionValue(object, "CONSTRUCTOR_DELEGATION_REFERENCE");
                LighterASTNode delegationReference = LightTreePositioningStrategiesKt.findChildByType(tree, node, (IElementType)object);
                if (delegationReference != null && LightTreePositioningStrategiesKt.access$firstChild(tree, delegationReference) == null) {
                    Object object2 = KtNodeTypes.SECONDARY_CONSTRUCTOR;
                    Intrinsics.checkNotNullExpressionValue(object2, "SECONDARY_CONSTRUCTOR");
                    LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.access$findParentOfType(tree, node, (IElementType)object2);
                    Intrinsics.checkNotNull(lighterASTNode4);
                    LighterASTNode constructor2 = lighterASTNode4;
                    object2 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, constructor2);
                    if (object2 == null) {
                        return LightTreePositioningStrategyKt.markElement(constructor2, tree);
                    }
                    Object valueParameterList = object2;
                    object2 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, constructor2);
                    Intrinsics.checkNotNull(object2);
                    Object object3 = object2;
                    object2 = LightTreePositioningStrategiesKt.access$lastChild(tree, (LighterASTNode)valueParameterList);
                    Intrinsics.checkNotNull(object2);
                    return LightTreePositioningStrategyKt.markRange((LighterASTNode)object3, (LighterASTNode)object2, tree);
                }
                object = delegationReference;
                return LightTreePositioningStrategyKt.markElement((LighterASTNode)(object == null ? node : object), tree);
            }
            String string2 = Intrinsics.stringPlus("unexpected element ", node);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy DECLARATION_NAME = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            LighterASTNode nameIdentifier = LightTreePositioningStrategiesKt.access$nameIdentifier(tree, node);
            if (nameIdentifier != null) {
                if (Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.CLASS) || Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.OBJECT_DECLARATION)) {
                    LighterASTNode lighterASTNode2;
                    Object object;
                    LighterASTNode lighterASTNode3;
                    LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.access$modifierList(tree, node);
                    if (lighterASTNode4 == null) {
                        lighterASTNode3 = null;
                    } else {
                        object = lighterASTNode4;
                        boolean bl = false;
                        boolean bl2 = false;
                        LighterASTNode modifierList2 = object;
                        boolean bl3 = false;
                        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ENUM_KEYWORD;
                        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "ENUM_KEYWORD");
                        lighterASTNode3 = LightTreePositioningStrategiesKt.findChildByType(tree, modifierList2, ktModifierKeywordToken);
                    }
                    LighterASTNode lighterASTNode5 = lighterASTNode3;
                    if (lighterASTNode5 == null) {
                        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD};
                        object = TokenSet.create(iElementTypeArray);
                        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD)");
                        lighterASTNode4 = LightTreePositioningStrategiesKt.access$findChildByType(tree, node, (TokenSet)object);
                        lighterASTNode2 = lighterASTNode4 == null ? node : lighterASTNode4;
                    } else {
                        lighterASTNode2 = lighterASTNode5;
                    }
                    LighterASTNode startElement = lighterASTNode2;
                    return LightTreePositioningStrategyKt.markRange(startElement, nameIdentifier, tree);
                }
                return LightTreePositioningStrategyKt.markElement(nameIdentifier, tree);
            }
            if (Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.FUN)) {
                return LightTreePositioningStrategies.INSTANCE.getDECLARATION_SIGNATURE().mark(node, tree);
            }
            return LightTreePositioningStrategies.INSTANCE.getDEFAULT().mark(node, tree);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy DECLARATION_SIGNATURE = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            IElementType iElementType = node.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.PRIMARY_CONSTRUCTOR) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.SECONDARY_CONSTRUCTOR)) {
                LighterASTNode lighterASTNode2;
                LighterASTNode lighterASTNode3;
                LighterASTNode lighterASTNode4;
                LighterASTNode lighterASTNode5 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, node);
                if (lighterASTNode5 == null) {
                    lighterASTNode4 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node);
                    if (lighterASTNode4 == null) {
                        return LightTreePositioningStrategyKt.markElement(node, tree);
                    }
                    lighterASTNode3 = lighterASTNode4;
                } else {
                    lighterASTNode3 = lighterASTNode5;
                }
                LighterASTNode begin = lighterASTNode3;
                lighterASTNode4 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node);
                if (lighterASTNode4 == null) {
                    LighterASTNode lighterASTNode6 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, node);
                    if (lighterASTNode6 == null) {
                        return LightTreePositioningStrategyKt.markElement(node, tree);
                    }
                    lighterASTNode2 = lighterASTNode6;
                } else {
                    lighterASTNode2 = lighterASTNode4;
                }
                LighterASTNode end = lighterASTNode2;
                return LightTreePositioningStrategyKt.markRange(begin, end, tree);
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.FUN) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.FUNCTION_LITERAL)) {
                LighterASTNode lighterASTNode7;
                LighterASTNode endOfSignatureElement;
                LighterASTNode end;
                LighterASTNode lighterASTNode8 = LightTreePositioningStrategiesKt.access$typeReference(tree, node);
                LighterASTNode lighterASTNode9 = end = lighterASTNode8 == null ? LightTreePositioningStrategiesKt.access$valueParameterList(tree, node) : lighterASTNode8;
                LighterASTNode lighterASTNode10 = end == null ? ((lighterASTNode8 = LightTreePositioningStrategiesKt.access$nameIdentifier(tree, node)) == null ? node : lighterASTNode8) : (endOfSignatureElement = end);
                LighterASTNode lighterASTNode11 = Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.FUNCTION_LITERAL) ? ((lighterASTNode8 = LightTreePositioningStrategiesKt.access$receiverTypeReference(tree, node)) == null ? ((lighterASTNode7 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node)) == null ? node : lighterASTNode7) : lighterASTNode8) : node;
                LighterASTNode startElement = lighterASTNode11;
                return LightTreePositioningStrategyKt.markRange(startElement, endOfSignatureElement, tree);
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.PROPERTY)) {
                LighterASTNode lighterASTNode12;
                LighterASTNode startElement = LightTreePositioningStrategiesKt.access$typeReference(tree, node);
                LighterASTNode endOfSignatureElement = startElement == null ? ((lighterASTNode12 = LightTreePositioningStrategiesKt.access$nameIdentifier(tree, node)) == null ? node : lighterASTNode12) : startElement;
                return LightTreePositioningStrategyKt.markRange(node, endOfSignatureElement, tree);
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.PROPERTY_ACCESSOR)) {
                LighterASTNode lighterASTNode13;
                LighterASTNode startElement = LightTreePositioningStrategiesKt.access$typeReference(tree, node);
                LighterASTNode endOfSignatureElement = startElement == null ? ((lighterASTNode13 = LightTreePositioningStrategiesKt.access$rightParenthesis(tree, node)) == null ? LightTreePositioningStrategiesKt.access$accessorNamePlaceholder(tree, node) : lighterASTNode13) : startElement;
                return LightTreePositioningStrategyKt.markRange(node, endOfSignatureElement, tree);
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.CLASS)) {
                LighterASTNode lighterASTNode14;
                LighterASTNode startElement = LightTreePositioningStrategiesKt.access$nameIdentifier(tree, node);
                if (startElement == null) {
                    return LightTreePositioningStrategyKt.markElement(node, tree);
                }
                LighterASTNode nameAsDeclaration = startElement;
                LighterASTNode lighterASTNode15 = LightTreePositioningStrategiesKt.access$primaryConstructor(tree, node);
                if (lighterASTNode15 == null) {
                    lighterASTNode14 = null;
                } else {
                    LighterASTNode lighterASTNode16 = lighterASTNode15;
                    boolean bl = false;
                    boolean bl2 = false;
                    LighterASTNode constructor2 = lighterASTNode16;
                    boolean bl3 = false;
                    lighterASTNode14 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, constructor2);
                }
                LighterASTNode lighterASTNode17 = lighterASTNode14;
                if (lighterASTNode17 == null) {
                    return LightTreePositioningStrategyKt.markElement(nameAsDeclaration, tree);
                }
                LighterASTNode primaryConstructorParameterList = lighterASTNode17;
                return LightTreePositioningStrategyKt.markRange(nameAsDeclaration, primaryConstructorParameterList, tree);
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.OBJECT_DECLARATION)) {
                return LightTreePositioningStrategies.INSTANCE.getDECLARATION_NAME().mark(node, tree);
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.CLASS_INITIALIZER)) {
                LighterASTNode lighterASTNode18 = LightTreePositioningStrategiesKt.access$initKeyword(tree, node);
                Intrinsics.checkNotNull(lighterASTNode18);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode18, tree);
            }
            return super.mark(node, tree);
        }
    };

    private LightTreePositioningStrategies() {
    }

    @NotNull
    public final LightTreePositioningStrategy getDEFAULT() {
        return DEFAULT;
    }

    @NotNull
    public final LightTreePositioningStrategy getVAL_OR_VAR_NODE() {
        return VAL_OR_VAR_NODE;
    }

    @NotNull
    public final LightTreePositioningStrategy getSECONDARY_CONSTRUCTOR_DELEGATION_CALL() {
        return SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    }

    @NotNull
    public final LightTreePositioningStrategy getDECLARATION_NAME() {
        return DECLARATION_NAME;
    }

    @NotNull
    public final LightTreePositioningStrategy getDECLARATION_SIGNATURE() {
        return DECLARATION_SIGNATURE;
    }
}

