/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.multiproject;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalModuleEntry;
import org.jetbrains.kotlin.incremental.IncrementalModuleInfo;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistory;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryKt;
import org.jetbrains.kotlin.incremental.util.Either;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u00112\u0006\u0010\u0012\u001a\u00020\u0007H$J\u001c\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u00112\u0006\u0010\u0014\u001a\u00020\u0007H\u0014J\"\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\bH\u0016R6\u0010\u0005\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryBase;", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistory;", "modulesInfo", "Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;", "(Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;)V", "dirToHistoryFileCache", "Ljava/util/HashMap;", "Ljava/io/File;", "", "Lkotlin/collections/HashMap;", "getModulesInfo", "()Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;", "projectRootPath", "Ljava/nio/file/Path;", "getProjectRootPath", "()Ljava/nio/file/Path;", "getBuildHistoryFilesForJar", "Lorg/jetbrains/kotlin/incremental/util/Either;", "jar", "getBuildHistoryForDir", "file", "historyFilesForChangedFiles", "changedFiles", "incremental-compilation-impl"})
public abstract class ModulesApiHistoryBase
implements ModulesApiHistory {
    @NotNull
    private final IncrementalModuleInfo modulesInfo;
    @NotNull
    private final Path projectRootPath;
    @NotNull
    private final HashMap<File, Set<File>> dirToHistoryFileCache;

    public ModulesApiHistoryBase(@NotNull IncrementalModuleInfo modulesInfo) {
        Intrinsics.checkNotNullParameter(modulesInfo, "modulesInfo");
        this.modulesInfo = modulesInfo;
        Path path2 = Paths.get(this.modulesInfo.getProjectRoot().getAbsolutePath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue(path2, "get(modulesInfo.projectRoot.absolutePath)");
        this.projectRootPath = path2;
        this.dirToHistoryFileCache = new HashMap();
    }

    @NotNull
    protected final IncrementalModuleInfo getModulesInfo() {
        return this.modulesInfo;
    }

    @NotNull
    protected final Path getProjectRootPath() {
        return this.projectRootPath;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Either<Set<File>> historyFilesForChangedFiles(@NotNull Set<? extends File> changedFiles) {
        void $this$groupByTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter(changedFiles, "changedFiles");
        HashSet result2 = new HashSet();
        ArrayList<File> jarFiles = new ArrayList<File>();
        ArrayList<File> classFiles = new ArrayList<File>();
        for (File file2 : changedFiles) {
            String extension = FilesKt.getExtension(file2);
            if (StringsKt.equals(extension, "class", true)) {
                classFiles.add(file2);
                continue;
            }
            if (!StringsKt.equals(extension, "jar", true)) continue;
            jarFiles.add(file2);
        }
        for (File file3 : jarFiles) {
            Intrinsics.checkNotNullExpressionValue(file3, "jar");
            Either<Set<File>> historyEither = this.getBuildHistoryFilesForJar(file3);
            object = historyEither;
            if (object instanceof Either.Success) {
                result2.addAll((Collection)((Either.Success)historyEither).getValue());
                continue;
            }
            if (!(object instanceof Either.Error)) continue;
            return historyEither;
        }
        Iterable iterable = classFiles;
        boolean $i$f$groupBy = false;
        object = iterable;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            File it = (File)element$iv$iv;
            boolean bl = false;
            File key$iv$iv = it.getParentFile();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map classFileDirs = destination$iv$iv;
        for (File dir : classFileDirs.keySet()) {
            Intrinsics.checkNotNullExpressionValue(dir, "dir");
            Either<Set<File>> historyEither = this.getBuildHistoryForDir(dir);
            if (historyEither instanceof Either.Success) {
                result2.addAll((Collection)((Either.Success)historyEither).getValue());
                continue;
            }
            if (!(historyEither instanceof Either.Error)) continue;
            return historyEither;
        }
        return new Either.Success(result2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected Either<Set<File>> getBuildHistoryForDir(@NotNull File file2) {
        Object object;
        Intrinsics.checkNotNullParameter(file2, "file");
        Map $this$getOrPut$iv = this.dirToHistoryFileCache;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(file2);
        if (value$iv == null) {
            Set set;
            boolean bl = false;
            IncrementalModuleEntry module2 = this.getModulesInfo().getDirToModule().get(file2);
            File parent2 = file2.getParentFile();
            if (module2 != null) {
                set = SetsKt.setOf(module2.getBuildHistoryFile());
            } else {
                if (parent2 == null || !ModulesApiHistoryKt.access$isParentOf(this.getProjectRootPath(), parent2)) return new Either.Error(Intrinsics.stringPlus("Unable to get build history for ", file2));
                Either<Set<File>> parentHistory = this.getBuildHistoryForDir(parent2);
                Either<Set<File>> either = parentHistory;
                if (either instanceof Either.Success) {
                    set = (Set)((Either.Success)parentHistory).getValue();
                } else {
                    if (!(either instanceof Either.Error)) throw new NoWhenBranchMatchedException();
                    return parentHistory;
                }
            }
            Set answer$iv = set;
            $this$getOrPut$iv.put(file2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Set history = (Set)object;
        return new Either.Success<Set>(history);
    }

    @NotNull
    protected abstract Either<Set<File>> getBuildHistoryFilesForJar(@NotNull File var1);
}

