/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.PropertyLazyInitLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/RemoveInitializersForLazyProperties;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "fileToInitializerPureness", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "", "getFileToInitializerPureness", "()Ljava/util/Map;", "calculateFileFieldsPureness", "file", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "backend.js"})
public final class RemoveInitializersForLazyProperties
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public RemoveInitializersForLazyProperties(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    private final Map<IrFile, Boolean> getFileToInitializerPureness() {
        return this.context.getFileToInitializerPureness();
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration2) {
        IrProperty it;
        boolean bl;
        boolean bl2;
        IrProperty irProperty2;
        Object object;
        boolean allFieldsInFilePure;
        IrFile irFile;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        if (!this.context.getPropertyLazyInitialization()) {
            return null;
        }
        if (!(declaration2 instanceof IrField)) {
            return null;
        }
        if (!PropertyLazyInitLoweringKt.access$isCompatibleDeclaration(declaration2)) {
            return null;
        }
        Object object2 = declaration2.getParent();
        IrFile irFile2 = irFile = object2 instanceof IrFile ? (IrFile)object2 : null;
        if (irFile == null) {
            return null;
        }
        IrFile file2 = irFile;
        if (Intrinsics.areEqual(this.getFileToInitializerPureness().get(file2), true)) {
            return null;
        }
        object2 = this.getFileToInitializerPureness().get(file2);
        boolean bl3 = allFieldsInFilePure = object2 == null ? this.calculateFileFieldsPureness(file2) : ((Boolean)object2).booleanValue();
        if (allFieldsInFilePure) {
            return null;
        }
        IrDeclarationBase irDeclarationBase = PropertyLazyInitLoweringKt.access$getCorrespondingProperty(declaration2);
        if (irDeclarationBase == null) {
            object = null;
        } else {
            irProperty2 = irDeclarationBase;
            bl2 = false;
            bl = false;
            it = irProperty2;
            boolean bl4 = false;
            object = object2 = PropertyLazyInitLoweringKt.access$isForLazyInit(it) ? irProperty2 : null;
        }
        if (object2 != null && (irDeclarationBase = ((IrProperty)object2).getBackingField()) != null) {
            irProperty2 = irDeclarationBase;
            bl2 = false;
            bl = false;
            it = irProperty2;
            boolean bl5 = false;
            PropertyLazyInitLoweringKt.access$assertCompatibleDeclaration(it);
            ((IrField)((Object)it)).setInitializer(null);
        }
        return null;
    }

    private final boolean calculateFileFieldsPureness(IrFile file2) {
        List declarations2 = CollectionsKt.toList((Iterable)file2.getDeclarations());
        Collection expressions = PropertyLazyInitLoweringKt.access$calculateFieldToExpression(declarations2).values();
        boolean allFieldsInFilePure = PropertyLazyInitLoweringKt.access$allFieldsInFilePure(expressions);
        Map<IrFile, Boolean> map2 = this.getFileToInitializerPureness();
        Boolean bl = allFieldsInFilePure;
        boolean bl2 = false;
        map2.put(file2, bl);
        return allFieldsInFilePure;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        DeclarationTransformer.DefaultImpls.lower(this, irFile);
    }

    @Override
    public boolean getWithLocalDeclarations() {
        return DeclarationTransformer.DefaultImpls.getWithLocalDeclarations(this);
    }
}

