/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsModuleCheckUtilKt;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\u00042\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsModuleCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkReifieidTypeParameters", "call", "extractModuleCallee", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "js.frontend"})
public final class JsModuleCallChecker
implements CallChecker {
    @NotNull
    public static final JsModuleCallChecker INSTANCE = new JsModuleCallChecker();

    private JsModuleCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        this.checkReifieidTypeParameters(resolvedCall2, reportOn, context2);
        DeclarationDescriptor declarationDescriptor = this.extractModuleCallee(resolvedCall2);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor callee = declarationDescriptor;
        BindingContext bindingContext = context2.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "context.trace.bindingContext");
        BindingContext bindingContext2 = bindingContext;
        DeclarationDescriptor containingDescriptor = context2.getScope().getOwnerDescriptor();
        JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext2, context2.getTrace(), containingDescriptor, callee, reportOn);
    }

    private final DeclarationDescriptor extractModuleCallee(ResolvedCall<?> call2) {
        Object callee = call2.getResultingDescriptor();
        if (DescriptorUtils.isTopLevelDeclaration((DeclarationDescriptor)callee)) {
            return (DeclarationDescriptor)callee;
        }
        ReceiverValue receiverValue = call2.getDispatchReceiver();
        if (receiverValue == null) {
            return (DeclarationDescriptor)callee;
        }
        ReceiverValue receiverValue2 = receiverValue;
        ReceiverValue receiver = receiverValue2;
        if (receiver instanceof ClassValueReceiver) {
            return ((ClassValueReceiver)receiver).getClassQualifier().getDescriptor();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReifieidTypeParameters(ResolvedCall<?> call2, PsiElement reportOn, CallCheckerContext context2) {
        KtTypeReference $this$mapTo$iv$iv;
        Map map2;
        KtTypeArgumentList $this$filterTo$iv$iv232;
        TypeParameterDescriptor typeParameterDescriptor;
        boolean bl;
        Collection collection;
        Object object;
        Iterable $this$mapTo$iv$iv2;
        DeclarationDescriptor containingDescriptor = context2.getScope().getOwnerDescriptor();
        List<TypeParameterDescriptor> list2 = call2.getCandidateDescriptor().getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "call.candidateDescriptor.typeParameters");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv2) {
            void it;
            object = (TypeParameterDescriptor)t;
            collection = destination$iv$iv;
            bl = false;
            typeParameterDescriptor = it.getOriginal();
            collection.add(typeParameterDescriptor);
        }
        Iterable $this$filter$iv = CollectionsKt.withIndex((List)destination$iv$iv);
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv22 = new ArrayList();
        boolean $i$f$filterTo232 = false;
        Iterator iterator2 = $this$filterTo$iv$iv232.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            IndexedValue $dstr$_u24__u24$param = (IndexedValue)t;
            bl = false;
            TypeParameterDescriptor param = (TypeParameterDescriptor)$dstr$_u24__u24$param.component2();
            if (!param.isReified()) continue;
            destination$iv$iv22.add(t);
        }
        List typeParams = (List)destination$iv$iv22;
        Object object2 = call2.getCall().getTypeArgumentList();
        if (object2 == null) {
            map2 = null;
        } else {
            void $this$associateTo$iv$iv;
            $this$filterTo$iv$iv232 = object2;
            boolean destination$iv$iv22 = false;
            $i$f$filterTo232 = false;
            KtTypeArgumentList args2 = $this$filterTo$iv$iv232;
            boolean object4 = false;
            Iterable $this$associate$iv = typeParams;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            Iterable iterable2 = $this$associate$iv;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv3;
                IndexedValue $dstr$index$param = (IndexedValue)element$iv$iv;
                boolean bl2 = false;
                int index2 = $dstr$index$param.component1();
                TypeParameterDescriptor param = (TypeParameterDescriptor)$dstr$index$param.component2();
                TypeParameterDescriptor typeParameterDescriptor2 = param.getOriginal();
                List<KtTypeProjection> list3 = args2.getArguments();
                Intrinsics.checkNotNullExpressionValue(list3, "args.arguments");
                KtTypeProjection ktTypeProjection = CollectionsKt.getOrNull(list3, index2);
                Pair<TypeParameterDescriptor, KtTypeReference> pair = TuplesKt.to(typeParameterDescriptor2, ktTypeProjection == null ? null : ktTypeProjection.getTypeReference());
                boolean bl3 = false;
                map3.put(pair.getFirst(), pair.getSecond());
            }
            map2 = destination$iv$iv3;
        }
        object2 = map2;
        boolean $this$filterTo$iv$iv232 = false;
        Object object3 = object2;
        if (object3 == null) {
            object3 = MapsKt.emptyMap();
        }
        KtTypeArgumentList typeArguments2 = object3;
        Iterable $this$map$iv2 = typeParams;
        boolean $i$f$map2 = false;
        Iterable $i$f$filterTo232 = $this$map$iv2;
        Object destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean bl4 = false;
        object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            void $dstr$_u24__u24$param;
            Object item$iv$iv = object.next();
            IndexedValue capacity$iv = (IndexedValue)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl5 = false;
            TypeParameterDescriptor param = (TypeParameterDescriptor)$dstr$_u24__u24$param.component2();
            typeParameterDescriptor = param.getOriginal();
            collection.add(typeParameterDescriptor);
        }
        for (TypeParameterDescriptor typeParam : (List)destination$iv$iv4) {
            ClassDescriptor classDescriptor2;
            PsiElement argPsi;
            $this$mapTo$iv$iv = (KtTypeReference)typeArguments2.get(typeParam);
            PsiElement psiElement = argPsi = $this$mapTo$iv$iv == null ? reportOn : (PsiElement)$this$mapTo$iv$iv;
            destination$iv$iv4 = call2.getTypeArguments().get(typeParam);
            if (destination$iv$iv4 == null) continue;
            Object typeArgument = destination$iv$iv4;
            object = ((KotlinType)typeArgument).getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor3 = classDescriptor2 = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
            if (classDescriptor2 == null) continue;
            ClassDescriptor typeArgumentClass = classDescriptor2;
            BindingContext bindingContext = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "context.trace.bindingContext");
            JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext, context2.getTrace(), containingDescriptor, typeArgumentClass, argPsi);
        }
    }
}

