/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.repl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.ReplEvalResult;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.ReplInterpreter;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.configuration.ConsoleReplConfiguration;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.configuration.IdeReplConfiguration;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.configuration.ReplConfiguration;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.writer.ReplWriter;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001aH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplFromTerminal;", "", "disposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "replConfiguration", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/configuration/ReplConfiguration;", "(Lcom/intellij/openapi/Disposable;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/configuration/ReplConfiguration;)V", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "replInitializer", "Ljava/util/concurrent/Future;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplInterpreter;", "replInterpreter", "getReplInterpreter", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplInterpreter;", "writer", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/writer/ReplWriter;", "getWriter", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/writer/ReplWriter;", "doRun", "", "eval", "Lorg/jetbrains/kotlin/cli/common/repl/ReplEvalResult;", "line", "", "one", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplFromTerminal$WhatNextAfterOneLine;", "next", "oneCommand", "", "command", "Companion", "WhatNextAfterOneLine", "kotlin-scripting-compiler"})
public final class ReplFromTerminal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReplConfiguration replConfiguration;
    @NotNull
    private final Future<ReplInterpreter> replInitializer;
    @NotNull
    private final MessageCollector messageCollector;

    public ReplFromTerminal(@NotNull Disposable disposable, @NotNull CompilerConfiguration compilerConfiguration, @NotNull ReplConfiguration replConfiguration) {
        Intrinsics.checkParameterIsNotNull(disposable, "disposable");
        Intrinsics.checkParameterIsNotNull(compilerConfiguration, "compilerConfiguration");
        Intrinsics.checkParameterIsNotNull(replConfiguration, "replConfiguration");
        this.replConfiguration = replConfiguration;
        Object object = Executors.newSingleThreadExecutor().submit((Callable)new Callable<ReplInterpreter>(disposable, compilerConfiguration, this){
            final /* synthetic */ Disposable $disposable;
            final /* synthetic */ CompilerConfiguration $compilerConfiguration;
            final /* synthetic */ ReplFromTerminal this$0;
            {
                this.$disposable = $disposable;
                this.$compilerConfiguration = $compilerConfiguration;
                this.this$0 = $receiver;
            }

            @NotNull
            public final ReplInterpreter call() {
                return new ReplInterpreter(this.$disposable, this.$compilerConfiguration, ReplFromTerminal.access$getReplConfiguration$p(this.this$0));
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(object, "newSingleThreadExecutor().submit(Callable {\n        ReplInterpreter(disposable, compilerConfiguration, replConfiguration)\n    })");
        this.replInitializer = object;
        object = compilerConfiguration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkExpressionValueIsNotNull(object, "compilerConfiguration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY)");
        this.messageCollector = (MessageCollector)object;
    }

    private final ReplInterpreter getReplInterpreter() {
        ReplInterpreter replInterpreter = this.replInitializer.get();
        Intrinsics.checkExpressionValueIsNotNull(replInterpreter, "replInitializer.get()");
        return replInterpreter;
    }

    private final ReplWriter getWriter() {
        return this.replConfiguration.getWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doRun() {
        try {
            GroupingMessageCollector groupingMessageCollector;
            ReplWriter replWriter = this.getWriter();
            boolean bl = false;
            boolean bl2 = false;
            ReplWriter $this$doRun_u24lambda_u2d0 = replWriter;
            boolean bl3 = false;
            $this$doRun_u24lambda_u2d0.printlnWelcomeMessage("Welcome to Kotlin version " + KotlinCompilerVersion.VERSION + " (JRE " + System.getProperty("java.runtime.version") + ')');
            $this$doRun_u24lambda_u2d0.printlnWelcomeMessage("Type :help for help, :quit for quit");
            boolean hasErrors = this.messageCollector.hasErrors();
            MessageCollector messageCollector2 = this.messageCollector;
            GroupingMessageCollector groupingMessageCollector2 = groupingMessageCollector = messageCollector2 instanceof GroupingMessageCollector ? (GroupingMessageCollector)messageCollector2 : null;
            if (groupingMessageCollector != null) {
                groupingMessageCollector.flush();
            }
            if (hasErrors) {
                return;
            }
            WhatNextAfterOneLine next = WhatNextAfterOneLine.READ_LINE;
            while ((next = this.one(next)) != WhatNextAfterOneLine.QUIT) {
            }
        }
        catch (Exception e) {
            this.replConfiguration.getExceptionReporter().report(e);
            throw e;
        }
        finally {
            try {
                this.replConfiguration.getCommandReader().flushHistory();
            }
            catch (Exception e) {
                this.replConfiguration.getExceptionReporter().report(e);
                throw e;
            }
        }
    }

    private final WhatNextAfterOneLine one(WhatNextAfterOneLine next) {
        String string2 = this.replConfiguration.getCommandReader().readLine(next);
        if (string2 == null) {
            return WhatNextAfterOneLine.QUIT;
        }
        String line = string2;
        if (StringsKt.startsWith$default(line = ReplUtilKt.replUnescapeLineBreaks(line), ":", false, 2, null) && (line.length() == 1 || line.charAt(1) != ':')) {
            String string3 = line;
            int n = 1;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).substring(startIndex)");
            boolean notQuit = this.oneCommand(string5);
            return notQuit ? WhatNextAfterOneLine.READ_LINE : WhatNextAfterOneLine.QUIT;
        }
        ReplEvalResult lineResult = this.eval(line);
        return lineResult instanceof ReplEvalResult.Incomplete ? WhatNextAfterOneLine.INCOMPLETE : WhatNextAfterOneLine.READ_LINE;
    }

    private final ReplEvalResult eval(String line) {
        ReplEvalResult evalResult = this.getReplInterpreter().eval(line);
        ReplEvalResult replEvalResult = evalResult;
        if (replEvalResult instanceof ReplEvalResult.ValueResult ? true : replEvalResult instanceof ReplEvalResult.UnitResult) {
            this.getWriter().notifyCommandSuccess();
            if (evalResult instanceof ReplEvalResult.ValueResult) {
                this.getWriter().outputCommandResult(evalResult.toString());
            }
        } else if (replEvalResult instanceof ReplEvalResult.Error.Runtime) {
            this.getWriter().outputRuntimeError(((ReplEvalResult.Error.Runtime)evalResult).getMessage());
        } else if (replEvalResult instanceof ReplEvalResult.Error.CompileTime) {
            this.getWriter().outputRuntimeError(((ReplEvalResult.Error.CompileTime)evalResult).getMessage());
        } else if (replEvalResult instanceof ReplEvalResult.Incomplete) {
            this.getWriter().notifyIncomplete();
        }
        return evalResult;
    }

    private final boolean oneCommand(String command) throws Exception {
        List split = ReplFromTerminal.Companion.splitCommand(command);
        Collection collection = split;
        boolean bl = false;
        if (!collection.isEmpty() && Intrinsics.areEqual(command, "help")) {
            this.getWriter().printlnHelpMessage("Available commands:\n:help                   show this help\n:quit                   exit the interpreter\n:dump bytecode          dump classes to terminal\n:load <file>            load script from specified file");
            return true;
        }
        if (split.size() >= 2 && Intrinsics.areEqual(split.get(0), "dump") && Intrinsics.areEqual(split.get(1), "bytecode")) {
            this.getReplInterpreter().dumpClasses(new PrintWriter(System.out));
            return true;
        }
        collection = split;
        bl = false;
        if (!collection.isEmpty() && Intrinsics.areEqual(split.get(0), "quit")) {
            return false;
        }
        if (split.size() >= 2 && Intrinsics.areEqual(split.get(0), "load")) {
            String fileName = (String)split.get(1);
            try {
                String string2 = FileUtil.loadFile(new File(fileName));
                Intrinsics.checkExpressionValueIsNotNull(string2, "loadFile(File(fileName))");
                String scriptText = string2;
                this.eval(scriptText);
            }
            catch (IOException e) {
                this.getWriter().outputCompileError(Intrinsics.stringPlus("Can not load script: ", e.getMessage()));
            }
            return true;
        }
        this.getWriter().printlnHelpMessage("Unknown command\nType :help for help");
        return true;
    }

    public static final /* synthetic */ ReplConfiguration access$getReplConfiguration$p(ReplFromTerminal $this) {
        return $this.replConfiguration;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplFromTerminal$WhatNextAfterOneLine;", "", "(Ljava/lang/String;I)V", "READ_LINE", "INCOMPLETE", "QUIT", "kotlin-scripting-compiler"})
    public static final class WhatNextAfterOneLine
    extends Enum<WhatNextAfterOneLine> {
        public static final /* enum */ WhatNextAfterOneLine READ_LINE = new WhatNextAfterOneLine();
        public static final /* enum */ WhatNextAfterOneLine INCOMPLETE = new WhatNextAfterOneLine();
        public static final /* enum */ WhatNextAfterOneLine QUIT = new WhatNextAfterOneLine();
        private static final /* synthetic */ WhatNextAfterOneLine[] $VALUES;

        public static WhatNextAfterOneLine[] values() {
            WhatNextAfterOneLine[] whatNextAfterOneLineArray = $VALUES;
            WhatNextAfterOneLine[] whatNextAfterOneLineArray2 = new WhatNextAfterOneLine[whatNextAfterOneLineArray.length];
            System.arraycopy(whatNextAfterOneLineArray, 0, whatNextAfterOneLineArray2, 0, whatNextAfterOneLineArray.length);
            return whatNextAfterOneLineArray2;
        }

        public static WhatNextAfterOneLine valueOf(String value2) {
            Intrinsics.checkParameterIsNotNull(value2, "value");
            return Enum.valueOf(WhatNextAfterOneLine.class, value2);
        }

        static {
            WhatNextAfterOneLine[] whatNextAfterOneLineArray = new WhatNextAfterOneLine[]{READ_LINE, INCOMPLETE, QUIT};
            $VALUES = whatNextAfterOneLineArray;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplFromTerminal$Companion;", "", "()V", "run", "", "disposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "splitCommand", "", "", "command", "kotlin-scripting-compiler"})
    public static final class Companion {
        private Companion() {
        }

        private final List<String> splitCommand(String command) {
            List list2;
            String[] stringArray = (String[])command;
            Object object = " ";
            int n = 0;
            object = new Regex((String)object);
            n = 0;
            boolean bl = false;
            List<String> $this$dropLastWhile$iv = ((Regex)object).split((CharSequence)stringArray, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator<String> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    CharSequence p0 = iterator$iv.previous();
                    boolean bl2 = false;
                    CharSequence charSequence = p0;
                    boolean bl3 = false;
                    if (charSequence.length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray3 = stringArray2;
            stringArray = new String[stringArray3.length];
            System.arraycopy(stringArray3, 0, stringArray, 0, stringArray3.length);
            return CollectionsKt.listOf(stringArray);
        }

        public final void run(@NotNull Disposable disposable, @NotNull CompilerConfiguration configuration2) {
            Intrinsics.checkParameterIsNotNull(disposable, "disposable");
            Intrinsics.checkParameterIsNotNull(configuration2, "configuration");
            boolean replIdeMode = Intrinsics.areEqual(System.getProperty("kotlin.repl.ideMode"), "true");
            ReplConfiguration replConfiguration = replIdeMode ? (ReplConfiguration)new IdeReplConfiguration() : (ReplConfiguration)new ConsoleReplConfiguration();
            try {
                new ReplFromTerminal(disposable, configuration2, replConfiguration).doRun();
            }
            catch (Exception e) {
                replConfiguration.getExceptionReporter().report(e);
                throw e;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

