/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequenceScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0002\u001a\u00020\u0001\u001a&\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u000b\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0002\u001a\u00020\u0001\u001a)\u0010\u000e\u001a\u00020\u000f\"\b\b\u0000\u0010\u0010*\u00020\u0011*\b\u0012\u0004\u0012\u0002H\u00100\u00122\b\u0010\u0013\u001a\u0004\u0018\u0001H\u0010\u00a2\u0006\u0002\u0010\u0014\u001a\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0016\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\u0017\u001aC\u0010\u0018\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006*\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u00192\u0006\u0010\u001a\u001a\u0002H\u00052\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001cH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001d\u001a9\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u0010\"\u000e\b\u0001\u0010\u001f*\b\u0012\u0004\u0012\u0002H\u00100 *\u0002H\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u001cH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"\u001aE\u0010\u001e\u001a\u0002H#\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006\"\u0014\b\u0002\u0010#*\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060$*\u0002H#2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H#0\u001cH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%\u001aA\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00100&\"\u0004\b\u0000\u0010\u0010*\n\u0012\u0006\b\u0001\u0012\u0002H\u00100&2\u0014\u0010!\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00100&0\u001cH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'\u001a2\u0010(\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\u00162\u0006\u0010)\u001a\u00020\u00012\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020,0+\u001a<\u0010-\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060$\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00050.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060+\u001aB\u00100\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060$\"\u0004\b\u0000\u0010\u0005\"\b\b\u0001\u0010\u0006*\u00020\u0011*\b\u0012\u0004\u0012\u0002H\u00050.2\u0014\u0010/\u001a\u0010\u0012\u0004\u0012\u0002H\u0005\u0012\u0006\u0012\u0004\u0018\u0001H\u00060+\u001a\"\u00101\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00010$\"\u0004\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050.\u001a/\u00102\u001a\u00020\u000f\"\b\b\u0000\u0010\u0010*\u00020\u0011*\b\u0012\u0004\u0012\u0002H\u0010032\b\u0010\u0013\u001a\u0004\u0018\u0001H\u0010H\u0086@\u00f8\u0001\u0001\u00a2\u0006\u0002\u00104\u0082\u0002\u000b\n\u0005\b\u009920\u0001\n\u0002\b\u0019\u00a8\u00065"}, d2={"capacity", "", "expectedSize", "newHashMapWithExpectedSize", "Ljava/util/HashMap;", "K", "V", "newHashSetWithExpectedSize", "Ljava/util/HashSet;", "E", "newLinkedHashMapWithExpectedSize", "Ljava/util/LinkedHashMap;", "newLinkedHashSetWithExpectedSize", "Ljava/util/LinkedHashSet;", "addIfNotNull", "", "T", "", "", "t", "(Ljava/util/Collection;Ljava/lang/Object;)V", "compact", "", "Ljava/util/ArrayList;", "getOrPutNullable", "", "key", "defaultValue", "Lkotlin/Function0;", "(Ljava/util/Map;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "ifEmpty", "C", "", "body", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function0;)Ljava/util/Collection;", "M", "", "(Ljava/util/Map;Lkotlin/jvm/functions/Function0;)Ljava/util/Map;", "", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)[Ljava/lang/Object;", "indexOfFirst", "startFrom", "predicate", "Lkotlin/Function1;", "", "keysToMap", "", "value", "keysToMapExceptNulls", "mapToIndex", "yieldIfNotNull", "Lkotlin/sequences/SequenceScope;", "(Lkotlin/sequences/SequenceScope;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "util.runtime"})
public final class CollectionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> keysToMap(@NotNull Iterable<? extends K> $this$keysToMap, @NotNull Function1<? super K, ? extends V> value2) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$keysToMap, "<this>");
        Intrinsics.checkNotNullParameter(value2, "value");
        Iterable<? extends K> $this$associateBy$iv = $this$keysToMap;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable<? extends K> iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator iterator2 = $this$associateByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator2.next();
            Map map2 = destination$iv$iv;
            boolean bl = false;
            void var13_13 = it;
            map2.put(var13_13, value2.invoke(element$iv$iv));
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final <K, V> Map<K, V> keysToMapExceptNulls(@NotNull Iterable<? extends K> $this$keysToMapExceptNulls, @NotNull Function1<? super K, ? extends V> value2) {
        Intrinsics.checkNotNullParameter($this$keysToMapExceptNulls, "<this>");
        Intrinsics.checkNotNullParameter(value2, "value");
        LinkedHashMap map2 = new LinkedHashMap();
        for (K k : $this$keysToMapExceptNulls) {
            V v = value2.invoke(k);
            if (v == null) continue;
            Map map3 = map2;
            boolean bl = false;
            map3.put(k, v);
        }
        return map2;
    }

    @NotNull
    public static final <K> Map<K, Integer> mapToIndex(@NotNull Iterable<? extends K> $this$mapToIndex) {
        Intrinsics.checkNotNullParameter($this$mapToIndex, "<this>");
        LinkedHashMap map2 = new LinkedHashMap();
        Iterator<K> iterator2 = $this$mapToIndex.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            K k = iterator2.next();
            Map map3 = map2;
            Integer n2 = index2;
            boolean bl = false;
            map3.put(k, n2);
        }
        return map2;
    }

    public static final <K, V> V getOrPutNullable(@NotNull Map<K, V> $this$getOrPutNullable, K key, @NotNull Function0<? extends V> defaultValue2) {
        V v;
        Intrinsics.checkNotNullParameter($this$getOrPutNullable, "<this>");
        Intrinsics.checkNotNullParameter(defaultValue2, "defaultValue");
        boolean $i$f$getOrPutNullable = false;
        if (!$this$getOrPutNullable.containsKey(key)) {
            V answer = defaultValue2.invoke();
            $this$getOrPutNullable.put(key, answer);
            v = answer;
        } else {
            v = $this$getOrPutNullable.get(key);
        }
        return v;
    }

    @NotNull
    public static final <T, C extends Collection<? extends T>> C ifEmpty(@NotNull C $this$ifEmpty, @NotNull Function0<? extends C> body2) {
        Intrinsics.checkNotNullParameter($this$ifEmpty, "<this>");
        Intrinsics.checkNotNullParameter(body2, "body");
        boolean $i$f$ifEmpty = false;
        return (C)($this$ifEmpty.isEmpty() ? (Collection)body2.invoke() : $this$ifEmpty);
    }

    @NotNull
    public static final <K, V, M extends Map<K, ? extends V>> M ifEmpty(@NotNull M $this$ifEmpty, @NotNull Function0<? extends M> body2) {
        Intrinsics.checkNotNullParameter($this$ifEmpty, "<this>");
        Intrinsics.checkNotNullParameter(body2, "body");
        boolean $i$f$ifEmpty = false;
        return (M)($this$ifEmpty.isEmpty() ? (Map)body2.invoke() : $this$ifEmpty);
    }

    @NotNull
    public static final <T> T[] ifEmpty(@NotNull T[] $this$ifEmpty, @NotNull Function0<? extends T[]> body2) {
        Intrinsics.checkNotNullParameter($this$ifEmpty, "<this>");
        Intrinsics.checkNotNullParameter(body2, "body");
        boolean $i$f$ifEmpty = false;
        T[] TArray = $this$ifEmpty;
        boolean bl = false;
        return TArray.length == 0 ? body2.invoke() : $this$ifEmpty;
    }

    public static final <T> void addIfNotNull(@NotNull Collection<T> $this$addIfNotNull, @Nullable T t) {
        Intrinsics.checkNotNullParameter($this$addIfNotNull, "<this>");
        if (t != null) {
            $this$addIfNotNull.add(t);
        }
    }

    @Nullable
    public static final <T> Object yieldIfNotNull(@NotNull SequenceScope<? super T> $this$yieldIfNotNull, @Nullable T t, @NotNull Continuation<? super Unit> $completion) {
        if (t != null) {
            Object object = $this$yieldIfNotNull.yield(t, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public static final <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(CollectionsKt.capacity(expectedSize));
    }

    @NotNull
    public static final <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(CollectionsKt.capacity(expectedSize));
    }

    @NotNull
    public static final <K, V> LinkedHashMap<K, V> newLinkedHashMapWithExpectedSize(int expectedSize) {
        return new LinkedHashMap(CollectionsKt.capacity(expectedSize));
    }

    @NotNull
    public static final <E> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int expectedSize) {
        return new LinkedHashSet(CollectionsKt.capacity(expectedSize));
    }

    private static final int capacity(int expectedSize) {
        return expectedSize < 3 ? 3 : expectedSize + expectedSize / 3 + 1;
    }

    @NotNull
    public static final <T> List<T> compact(@NotNull ArrayList<T> $this$compact) {
        List list2;
        Intrinsics.checkNotNullParameter($this$compact, "<this>");
        int n = $this$compact.size();
        switch (n) {
            case 0: {
                list2 = kotlin.collections.CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list2 = kotlin.collections.CollectionsKt.listOf(kotlin.collections.CollectionsKt.first((List)$this$compact));
                break;
            }
            default: {
                ArrayList<T> arrayList = $this$compact;
                boolean bl = false;
                boolean bl2 = false;
                ArrayList<T> $this$compact_u24lambda_u2d1 = arrayList;
                boolean bl3 = false;
                $this$compact_u24lambda_u2d1.trimToSize();
                list2 = arrayList;
            }
        }
        return list2;
    }

    public static final <T> int indexOfFirst(@NotNull List<? extends T> $this$indexOfFirst, int startFrom, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$indexOfFirst, "<this>");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        int n = startFrom;
        int n2 = kotlin.collections.CollectionsKt.getLastIndex($this$indexOfFirst);
        if (n <= n2) {
            int index2;
            do {
                if (!predicate.invoke($this$indexOfFirst.get(index2 = n++)).booleanValue()) continue;
                return index2;
            } while (index2 != n2);
        }
        return -1;
    }
}

