/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.ki.shell;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.ki.shell.UtilKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002\u001a\u000e\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002\u001a\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\f\u001a\u00020\u0002\u001a\u0012\u0010\u0013\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015\u001a\n\u0010\u0016\u001a\u00020\u0002*\u00020\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0002X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"builtinPackages", "", "", "builtinsNamesRE", "Lkotlin/text/Regex;", "typeDelimiters", "calcHumanReadableSize", "bytes", "", "si", "", "globToRegex", "line", "renderKotlinType", "typeName", "replJars", "Ljava/io/File;", "jars", "smartSplit", "bound", "maxLength", "", "unquote", "ki-shell"})
public final class UtilKt {
    private static final List<String> builtinPackages = CollectionsKt.listOf("kotlin", "kotlin.collections", "java.lang");
    private static final String typeDelimiters = "<>, ";
    private static final Regex builtinsNamesRE = new Regex("(?<=^|[" + typeDelimiters + "])(?:(?:" + CollectionsKt.joinToString$default(builtinPackages, "|", null, null, 0, null, builtinsNamesRE.1.INSTANCE, 30, null) + ")\\.){1}([^\\." + typeDelimiters + "]+)(?=[" + typeDelimiters + "]|$)");

    @NotNull
    public static final String calcHumanReadableSize(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char c = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1);
        String string2 = si ? "" : "i";
        boolean bl = false;
        String pre = String.valueOf(c) + string2;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        string2 = "%.1f %sB";
        Object[] objectArray = new Object[]{(double)bytes / Math.pow(unit, exp), pre};
        boolean bl2 = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "java.lang.String.format(format, *args)");
        return string3;
    }

    public static /* synthetic */ String calcHumanReadableSize$default(long l, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UtilKt.calcHumanReadableSize(l, bl);
    }

    @NotNull
    public static final String bound(@NotNull String $this$bound, int maxLength) {
        String string2;
        Intrinsics.checkNotNullParameter($this$bound, "$this$bound");
        if ($this$bound.length() > maxLength) {
            StringBuilder stringBuilder2 = new StringBuilder();
            String string3 = $this$bound;
            int n = 0;
            int n2 = maxLength - 1;
            boolean bl = false;
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string2 = stringBuilder2.append(string4).append(" ...").toString();
        } else {
            string2 = $this$bound;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> replJars(@NotNull List<String> jars) {
        int n;
        Object object;
        String it;
        Iterable $this$filterTo$iv$iv;
        File file2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        String jvmClasspath;
        Intrinsics.checkNotNullParameter(jars, "jars");
        String string2 = jvmClasspath = System.getProperty("java.class.path");
        Intrinsics.checkNotNullExpressionValue(string2, "jvmClasspath");
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)string2, new char[]{File.pathSeparatorChar}, false, 0, 6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            String string3 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            file2 = new File((String)p1);
            collection.add(file2);
        }
        List systemJars = (List)destination$iv$iv;
        Iterable $this$filter$iv = jars;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            object = new Regex("/kotlin-(runtime|stdlib|compiler|reflect)(-.*)?\\.jar");
            n = 0;
            if (!(!((Regex)object).containsMatchIn(charSequence))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            int p = StringsKt.indexOf$default((CharSequence)it, ':', 0, false, 6, null);
            object = it;
            n = p + 1;
            boolean bl2 = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = ((String)object2).substring(n);
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).substring(startIndex)");
            file2 = new File(string4);
            collection.add(file2);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)systemJars);
    }

    public static /* synthetic */ List replJars$default(List list2, int n, Object object) {
        if ((n & 1) != 0) {
            boolean bl = false;
            list2 = CollectionsKt.emptyList();
        }
        return UtilKt.replJars(list2);
    }

    @NotNull
    public static final String globToRegex(@NotNull String line) {
        Intrinsics.checkNotNullParameter(line, "line");
        StringBuilder sb = new StringBuilder();
        CharSequence $this$forEach$iv = line;
        boolean $i$f$forEach = false;
        CharSequence charSequence = $this$forEach$iv;
        block5: for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv;
            char it = element$iv = charSequence.charAt(i);
            boolean bl = false;
            switch (it) {
                case '*': {
                    sb.append("[a-zA-Z_0-9.]*");
                    continue block5;
                }
                case '?': {
                    sb.append("[a-zA-Z_0-9.]");
                    continue block5;
                }
                case '.': {
                    sb.append("\\.");
                    continue block5;
                }
                default: {
                    sb.append(it);
                }
            }
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "sb.toString()");
        return string2;
    }

    @NotNull
    public static final List<String> smartSplit(@NotNull String line) {
        Intrinsics.checkNotNullParameter(line, "line");
        ArrayList<String> list2 = new ArrayList<String>();
        Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(line);
        while (m.find()) {
            String string2 = m.group(1);
            Intrinsics.checkNotNullExpressionValue(string2, "m.group(1)");
            list2.add(UtilKt.unquote(string2));
        }
        return list2;
    }

    @NotNull
    public static final String unquote(@NotNull String $this$unquote) {
        String string2;
        Intrinsics.checkNotNullParameter($this$unquote, "$this$unquote");
        if (StringsKt.startsWith$default($this$unquote, "\"", false, 2, null) && StringsKt.endsWith$default($this$unquote, "\"", false, 2, null)) {
            String string3 = $this$unquote;
            int n = 1;
            int n2 = $this$unquote.length() - 1;
            boolean bl = false;
            String string4 = string3.substring(n, n2);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string2 = $this$unquote;
        }
        return string2;
    }

    @NotNull
    public static final String renderKotlinType(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter(typeName, "typeName");
        CharSequence charSequence = typeName;
        Regex regex = builtinsNamesRE;
        String string2 = "$1";
        boolean bl = false;
        return regex.replace(charSequence, string2);
    }
}

