/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt$configureStandardLibs$2;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt$configureStandardLibs$3;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMAssertionsMode;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JVMConstructorCallNormalizationMode;
import org.jetbrains.kotlin.config.JvmAbiStability;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmClosureGenerationScheme;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmStringConcat;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a\u0012\u0010\r\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0011\u001a\u00020\b*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0012\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001c\u0010\u0013\u001a\u00020\u0006*\u00020\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u000f\u001a4\u0010\u0016\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0002\u001a\u0012\u0010\u001e\u001a\u00020\b*\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010 \u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006!"}, d2={"messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getMessageCollector", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "addModularRootIfNotNull", "", "isModularJava", "", "moduleName", "", "file", "Ljava/io/File;", "configureAdvancedJvmOptions", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "configureExplicitContentRoots", "configureJdkHome", "configureKlibPaths", "configureStandardLibs", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "handleClosureGenerationSchemeArgument", "flag", "value", "key", "Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "Lorg/jetbrains/kotlin/config/JvmClosureGenerationScheme;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "registerJavacIfNeeded", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "setupJvmSpecificArguments", "cli"})
public final class JvmArgumentsKt {
    public static final void setupJvmSpecificArguments(@NotNull CompilerConfiguration $this$setupJvmSpecificArguments, @NotNull K2JVMCompilerArguments arguments2) {
        String stringConcat;
        JvmDefaultMode jvmDefaultMode2;
        JvmTarget jvmTarget;
        JvmTarget jvmTarget2;
        Intrinsics.checkNotNullParameter($this$setupJvmSpecificArguments, "$this$setupJvmSpecificArguments");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.INCLUDE_RUNTIME, arguments2.getIncludeRuntime());
        $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.NO_REFLECT, arguments2.getNoReflect());
        String[] stringArray = arguments2.getFriendPaths();
        $this$setupJvmSpecificArguments.putIfNotNull(JVMConfigurationKeys.FRIEND_PATHS, stringArray != null ? ArraysKt.asList(stringArray) : null);
        if (arguments2.getJvmTarget() != null) {
            String string2 = arguments2.getJvmTarget();
            Intrinsics.checkNotNull(string2);
            jvmTarget2 = JvmTarget.Companion.fromString(string2);
            if (jvmTarget2 != null) {
                $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.JVM_TARGET, jvmTarget2);
                if (jvmTarget2 == JvmTarget.JVM_1_6 && !arguments2.getSuppressDeprecatedJvmTargetWarning()) {
                    MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.STRONG_WARNING, "JVM target 1.6 is deprecated and will be removed in a future release. Please migrate to JVM target 1.8 or above", null, 4, null);
                }
            } else {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "Unknown JVM target version: " + arguments2.getJvmTarget() + '\n' + "Supported versions: " + ArraysKt.joinToString$default(JvmTarget.values(), null, null, null, 0, null, (Function1)setupJvmSpecificArguments.1.INSTANCE, 31, null), null, 4, null);
            }
        }
        if ((jvmTarget = $this$setupJvmSpecificArguments.get(JVMConfigurationKeys.JVM_TARGET)) == null) {
            jvmTarget = JvmTarget.DEFAULT;
        }
        Intrinsics.checkNotNullExpressionValue(jvmTarget, "get(JVMConfigurationKeys\u2026GET) ?: JvmTarget.DEFAULT");
        jvmTarget2 = jvmTarget;
        if (jvmTarget2.getMajorVersion() < JvmTarget.JVM_1_8.getMajorVersion() && (jvmDefaultMode2 = CommonConfigurationKeysKt.getLanguageVersionSettings($this$setupJvmSpecificArguments).getFlag(JvmAnalysisFlags.getJvmDefaultMode())).getForAllMethodsWithBody()) {
            MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "'-Xjvm-default=" + jvmDefaultMode2.getDescription() + "' is only supported since JVM target 1.8. Recompile with '-jvm-target 1.8'", null, 4, null);
        }
        if ((stringConcat = arguments2.getStringConcat()) != null) {
            JvmStringConcat runtimeStringConcat = JvmStringConcat.Companion.fromString(stringConcat);
            if (runtimeStringConcat != null) {
                $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.STRING_CONCAT, runtimeStringConcat);
                if (jvmTarget2.getMajorVersion() < JvmTarget.JVM_9.getMajorVersion() && runtimeStringConcat != JvmStringConcat.INLINE) {
                    MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.WARNING, "`-Xstring-concat=" + stringConcat + "` does nothing with JVM target `" + jvmTarget2.getDescription() + "`.", null, 4, null);
                }
            } else {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "Unknown `-Xstring-concat` mode: " + stringConcat + '\n' + "Supported modes: " + ArraysKt.joinToString$default((Object[])JvmStringConcat.values(), null, null, null, 0, null, (Function1)setupJvmSpecificArguments.2.INSTANCE, 31, null), null, 4, null);
            }
        }
        String string3 = arguments2.getSamConversions();
        CompilerConfigurationKey<JvmClosureGenerationScheme> compilerConfigurationKey = JVMConfigurationKeys.SAM_CONVERSIONS;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, "JVMConfigurationKeys.SAM_CONVERSIONS");
        JvmArgumentsKt.handleClosureGenerationSchemeArgument($this$setupJvmSpecificArguments, "-Xsam-conversions", string3, compilerConfigurationKey, jvmTarget2);
        String string4 = arguments2.getLambdas();
        CompilerConfigurationKey<JvmClosureGenerationScheme> compilerConfigurationKey2 = JVMConfigurationKeys.LAMBDAS;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey2, "JVMConfigurationKeys.LAMBDAS");
        JvmArgumentsKt.handleClosureGenerationSchemeArgument($this$setupJvmSpecificArguments, "-Xlambdas", string4, compilerConfigurationKey2, jvmTarget2);
        String[] stringArray2 = arguments2.getAdditionalJavaModules();
        $this$setupJvmSpecificArguments.addAll(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, (Collection)(stringArray2 != null ? ArraysKt.asList(stringArray2) : null));
    }

    private static final void handleClosureGenerationSchemeArgument(CompilerConfiguration $this$handleClosureGenerationSchemeArgument, String flag, String value2, CompilerConfigurationKey<JvmClosureGenerationScheme> key, JvmTarget jvmTarget) {
        if (value2 != null) {
            JvmClosureGenerationScheme parsedValue = JvmClosureGenerationScheme.Companion.fromString(value2);
            if (parsedValue != null) {
                $this$handleClosureGenerationSchemeArgument.put(key, parsedValue);
                if (jvmTarget.compareTo((Enum)parsedValue.getMinJvmTarget()) < 0) {
                    MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$handleClosureGenerationSchemeArgument), CompilerMessageSeverity.WARNING, '`' + flag + '=' + value2 + "` requires JVM target at least " + parsedValue.getMinJvmTarget().getDescription() + " and is ignored.", null, 4, null);
                }
            } else {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$handleClosureGenerationSchemeArgument), CompilerMessageSeverity.ERROR, "Unknown `" + flag + "` argument: " + value2 + "\n." + "Supported arguments: " + ArraysKt.joinToString$default((Object[])JvmClosureGenerationScheme.values(), null, null, null, 0, null, (Function1)handleClosureGenerationSchemeArgument.1.INSTANCE, 31, null), null, 4, null);
            }
        }
    }

    public static final boolean configureJdkHome(@NotNull CompilerConfiguration $this$configureJdkHome, @NotNull K2JVMCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter($this$configureJdkHome, "$this$configureJdkHome");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        if (arguments2.getNoJdk()) {
            $this$configureJdkHome.put(JVMConfigurationKeys.NO_JDK, true);
            if (arguments2.getJdkHome() != null) {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureJdkHome), CompilerMessageSeverity.STRONG_WARNING, "The '-jdk-home' option is ignored because '-no-jdk' is specified", null, 4, null);
            }
            return true;
        }
        if (arguments2.getJdkHome() != null) {
            String string2 = arguments2.getJdkHome();
            Intrinsics.checkNotNull(string2);
            File jdkHome2 = new File(string2);
            if (!jdkHome2.exists()) {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureJdkHome), CompilerMessageSeverity.ERROR, "JDK home directory does not exist: " + jdkHome2, null, 4, null);
                return false;
            }
            MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureJdkHome), CompilerMessageSeverity.LOGGING, "Using JDK home directory " + jdkHome2, null, 4, null);
            $this$configureJdkHome.put(JVMConfigurationKeys.JDK_HOME, jdkHome2);
        }
        return true;
    }

    public static final void configureExplicitContentRoots(@NotNull CompilerConfiguration $this$configureExplicitContentRoots, @NotNull K2JVMCompilerArguments arguments2) {
        List list2;
        Intrinsics.checkNotNullParameter($this$configureExplicitContentRoots, "$this$configureExplicitContentRoots");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        String string2 = arguments2.getJavaModulePath();
        List list3 = list2 = string2 != null ? StringsKt.split$default((CharSequence)string2, new char[]{File.pathSeparatorChar}, false, 0, 6, null) : null;
        for (String string3 : list3 == null ? CollectionsKt.emptyList() : list3) {
            $this$configureExplicitContentRoots.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(new File(string3)));
        }
        if (arguments2.getBuildFile() != null) {
            return;
        }
        String string4 = arguments2.getClasspath();
        list3 = list2 = string4 != null ? StringsKt.split$default((CharSequence)string4, new char[]{File.pathSeparatorChar}, false, 0, 6, null) : null;
        for (String string5 : list3 == null ? CollectionsKt.emptyList() : list3) {
            $this$configureExplicitContentRoots.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(new File(string5)));
        }
    }

    public static final void configureStandardLibs(@NotNull CompilerConfiguration $this$configureStandardLibs, @Nullable KotlinPaths paths, @NotNull K2JVMCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter($this$configureStandardLibs, "$this$configureStandardLibs");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        boolean isModularJava = JvmArgumentsKt.isModularJava($this$configureStandardLibs);
        Function4<String, String, Function1<? super KotlinPaths, ? extends File>, String, Unit> $fun$addRoot$1 = new Function4<String, String, Function1<? super KotlinPaths, ? extends File>, String, Unit>($this$configureStandardLibs, isModularJava, paths){
            final /* synthetic */ CompilerConfiguration $this_configureStandardLibs;
            final /* synthetic */ boolean $isModularJava;
            final /* synthetic */ KotlinPaths $paths;

            public final void invoke(@NotNull String moduleName, @NotNull String libraryName2, @NotNull Function1<? super KotlinPaths, ? extends File> getLibrary, @NotNull String noLibraryArgument) {
                Intrinsics.checkNotNullParameter(moduleName, "moduleName");
                Intrinsics.checkNotNullParameter(libraryName2, "libraryName");
                Intrinsics.checkNotNullParameter(getLibrary, "getLibrary");
                Intrinsics.checkNotNullParameter(noLibraryArgument, "noLibraryArgument");
                JvmArgumentsKt.addModularRootIfNotNull(this.$this_configureStandardLibs, this.$isModularJava, moduleName, UtilsKt.getLibraryFromHome(this.$paths, getLibrary, libraryName2, JvmArgumentsKt.access$getMessageCollector$p(this.$this_configureStandardLibs), noLibraryArgument));
            }
            {
                this.$this_configureStandardLibs = compilerConfiguration;
                this.$isModularJava = bl;
                this.$paths = kotlinPaths;
                super(4);
            }
        };
        if (!arguments2.getNoStdlib()) {
            $fun$addRoot$1.invoke("kotlin.stdlib", "kotlin-stdlib.jar", (Function1<KotlinPaths, File>)((Function1<? super KotlinPaths, ? extends File>)JvmArgumentsKt$configureStandardLibs$2.INSTANCE), "'-no-stdlib'");
            $fun$addRoot$1.invoke("kotlin.script.runtime", "kotlin-script-runtime.jar", (Function1<KotlinPaths, File>)((Function1<? super KotlinPaths, ? extends File>)JvmArgumentsKt$configureStandardLibs$3.INSTANCE), "'-no-stdlib'");
        }
        if (!arguments2.getNoReflect() && !arguments2.getNoStdlib()) {
            $fun$addRoot$1.invoke("kotlin.reflect", "kotlin-reflect.jar", (Function1<KotlinPaths, File>)((Function1<? super KotlinPaths, ? extends File>)configureStandardLibs.4.INSTANCE), "'-no-reflect' or '-no-stdlib'");
        }
    }

    public static final boolean isModularJava(@NotNull CompilerConfiguration $this$isModularJava) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isModularJava, "$this$isModularJava");
        File file2 = $this$isModularJava.get(JVMConfigurationKeys.JDK_HOME);
        if (file2 != null) {
            File file3;
            File it = file3 = file2;
            boolean bl2 = false;
            File file4 = it;
            Intrinsics.checkNotNullExpressionValue(file4, "it");
            bl = CoreJrtFileSystem.Companion.isModularJdk(file4);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final void addModularRootIfNotNull(@NotNull CompilerConfiguration $this$addModularRootIfNotNull, boolean isModularJava, @NotNull String moduleName, @Nullable File file2) {
        Intrinsics.checkNotNullParameter($this$addModularRootIfNotNull, "$this$addModularRootIfNotNull");
        Intrinsics.checkNotNullParameter(moduleName, "moduleName");
        if (file2 != null) {
            if (isModularJava) {
                $this$addModularRootIfNotNull.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(file2));
                $this$addModularRootIfNotNull.add(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, moduleName);
            } else {
                $this$addModularRootIfNotNull.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(file2));
            }
        }
    }

    public static final boolean registerJavacIfNeeded(@NotNull KotlinCoreEnvironment $this$registerJavacIfNeeded, @NotNull K2JVMCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter($this$registerJavacIfNeeded, "$this$registerJavacIfNeeded");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        if (arguments2.getUseJavac()) {
            $this$registerJavacIfNeeded.getConfiguration().put(JVMConfigurationKeys.USE_JAVAC, true);
            if (arguments2.getCompileJava()) {
                $this$registerJavacIfNeeded.getConfiguration().put(JVMConfigurationKeys.COMPILE_JAVA, true);
            }
            return KotlinCoreEnvironment.registerJavac$default($this$registerJavacIfNeeded, null, null, arguments2.getJavacArguments(), null, null, 27, null);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static final void configureAdvancedJvmOptions(@NotNull CompilerConfiguration $this$configureAdvancedJvmOptions, @NotNull K2JVMCompilerArguments arguments) {
        Intrinsics.checkNotNullParameter($this$configureAdvancedJvmOptions, "$this$configureAdvancedJvmOptions");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.PARAMETERS_METADATA, arguments.getJavaParameters());
        v0 = useOldBackend = arguments.getUseOldBackend() != false || arguments.getUseIR() == false && Intrinsics.areEqual($this$configureAdvancedJvmOptions.get(JVMConfigurationKeys.IR), false) != false;
        if (arguments.getUseFir()) ** GOTO lbl-1000
        v1 = CommonConfigurationKeysKt.getLanguageVersionSettings($this$configureAdvancedJvmOptions).supportsFeature(LanguageFeature.JvmIrEnabledByDefault) ? !useOldBackend : arguments.getUseIR() != false && useOldBackend == false;
        if (v1) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = useIR = false;
        }
        if (arguments.getUseOldBackend()) {
            MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.STRONG_WARNING, "-Xuse-old-backend is deprecated and will be removed in a future release", null, 4, null);
            if (arguments.getUseIR()) {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.STRONG_WARNING, "Both -Xuse-ir and -Xuse-old-backend are passed. This is an inconsistent configuration. " + "The compiler will use the " + (useIR != false ? "JVM IR" : "old JVM") + " backend", null, 4, null);
            }
        }
        MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.LOGGING, "Using " + (useIR != false ? "JVM IR" : "old JVM") + " backend", null, 4, null);
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.IR, useIR);
        abiStability = JvmAbiStability.Companion.fromStringOrNull(arguments.getAbiStability());
        if (arguments.getAbiStability() != null) {
            if (abiStability == null) {
                var5_5 = JvmAbiStability.values();
                var20_6 = new StringBuilder().append("Unknown ABI stability mode: ").append(arguments.getAbiStability()).append(", supported modes: ");
                var19_7 = CompilerMessageSeverity.ERROR;
                var18_8 = JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions);
                $i$f$map = false;
                var7_11 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                $i$f$mapTo = false;
                for (Enum item$iv$iv : $this$mapTo$iv$iv) {
                    var14_26 = item$iv$iv;
                    var21_30 = destination$iv$iv;
                    $i$a$-map-JvmArgumentsKt$configureAdvancedJvmOptions$1 = false;
                    var22_31 = it.getDescription();
                    var21_30.add(var22_31);
                }
                var21_30 = (List)destination$iv$iv;
                MessageCollector.DefaultImpls.report$default(var18_8, var19_7, var20_6.append(var21_30).toString(), null, 4, null);
            } else if (!useIR && abiStability == JvmAbiStability.UNSTABLE) {
                MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.ERROR, "-Xabi-stability=unstable is not supported in the old JVM backend", null, 4, null);
            } else {
                $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ABI_STABILITY, abiStability);
            }
        }
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DO_NOT_CLEAR_BINDING_CONTEXT, arguments.getDoNotClearBindingContext());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, arguments.getNoCallAssertions());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_RECEIVER_ASSERTIONS, arguments.getNoReceiverAssertions());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, arguments.getNoParamAssertions());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_EXCEPTION_ON_EXPLICIT_EQUALS_FOR_BOXED_NULL, arguments.getNoExceptionOnExplicitEqualsForBoxedNull());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, arguments.getNoOptimize());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.EMIT_JVM_TYPE_ANNOTATIONS, arguments.getEmitJvmTypeAnnotations());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_OPTIMIZED_CALLABLE_REFERENCES, arguments.getNoOptimizedCallableReferences());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_KOTLIN_NOTHING_VALUE_EXCEPTION, arguments.getNoKotlinNothingValueException());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_RESET_JAR_TIMESTAMPS, arguments.getNoResetJarTimestamps());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_UNIFIED_NULL_CHECKS, arguments.getNoUnifiedNullChecks());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.SERIALIZE_IR, arguments.getSerializeIr());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.VALIDATE_IR, arguments.getValidateIr());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.VALIDATE_BYTECODE, arguments.getValidateBytecode());
        if (!JVMConstructorCallNormalizationMode.Companion.isSupportedValue(arguments.getConstructorCallNormalizationMode())) {
            $this$map$iv = JVMConstructorCallNormalizationMode.values();
            var20_6 = new StringBuilder().append("Unknown constructor call normalization mode: ").append(arguments.getConstructorCallNormalizationMode()).append(", ").append("supported modes: ");
            var19_7 = CompilerMessageSeverity.ERROR;
            var18_8 = JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions);
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>($this$map$iv.length);
            $i$f$mapTo = false;
            for (Enum item$iv$iv : $this$mapTo$iv$iv) {
                it = item$iv$iv;
                var21_30 = destination$iv$iv;
                $i$a$-map-JvmArgumentsKt$configureAdvancedJvmOptions$2 = false;
                var22_31 = it.getDescription();
                var21_30.add(var22_31);
            }
            var21_30 = (List)destination$iv$iv;
            MessageCollector.DefaultImpls.report$default(var18_8, var19_7, var20_6.append(var21_30).toString(), null, 4, null);
        }
        if ((constructorCallNormalizationMode = JVMConstructorCallNormalizationMode.Companion.fromStringOrNull(arguments.getConstructorCallNormalizationMode())) != null) {
            $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.CONSTRUCTOR_CALL_NORMALIZATION_MODE, constructorCallNormalizationMode);
        }
        if ((assertionsMode = JVMAssertionsMode.Companion.fromStringOrNull(arguments.getAssertionsMode())) == null) {
            $this$mapTo$iv$iv = JVMAssertionsMode.values();
            var20_6 = new StringBuilder().append("Unknown assertions mode: ").append(arguments.getAssertionsMode()).append(", supported modes: ");
            var19_7 = CompilerMessageSeverity.ERROR;
            var18_8 = JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions);
            $i$f$map = false;
            $i$f$mapTo = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
            $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                var16_32 = item$iv$iv;
                var21_30 = destination$iv$iv;
                $i$a$-map-JvmArgumentsKt$configureAdvancedJvmOptions$3 = false;
                var22_31 = it.getDescription();
                var21_30.add(var22_31);
            }
            var21_30 = (List)destination$iv$iv;
            MessageCollector.DefaultImpls.report$default(var18_8, var19_7, var20_6.append(var21_30).toString(), null, 4, null);
        }
        if ((v3 = assertionsMode) == null) {
            v3 = JVMAssertionsMode.DEFAULT;
        }
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ASSERTIONS_MODE, v3);
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_TYPE_TABLE, arguments.getUseTypeTable());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.SKIP_RUNTIME_VERSION_CHECK, arguments.getSkipRuntimeVersionCheck());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_PSI_CLASS_FILES_READING, arguments.getUseOldClassFilesReading());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_FAST_JAR_FILE_SYSTEM, arguments.getUseFastJarFileSystem());
        if (arguments.getUseOldClassFilesReading()) {
            MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.INFO, "Using the old java class files reading implementation", null, 4, null);
        }
        if (arguments.getUseFastJarFileSystem()) {
            MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.INFO, "Using fast Jar FS implementation", null, 4, null);
        }
        $this$configureAdvancedJvmOptions.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments.getAllowKotlinPackage());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_SINGLE_MODULE, arguments.getSingleModule());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_OLD_SPILLED_VAR_TYPE_ANALYSIS, arguments.getUseOldSpilledVarTypeAnalysis());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_OLD_INLINE_CLASSES_MANGLING_SCHEME, arguments.getUseOldInlineClassesManglingScheme());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ENABLE_JVM_PREVIEW, arguments.getEnableJvmPreview());
        if (arguments.getEnableJvmPreview()) {
            MessageCollector.DefaultImpls.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.INFO, "Using preview Java language features", null, 4, null);
        }
        v4 = arguments.getDeclarationsOutputPath();
        if (v4 != null) {
            it = $this$map$iv = v4;
            $i$a$-let-JvmArgumentsKt$configureAdvancedJvmOptions$4 = false;
            $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DECLARATIONS_JSON_PATH, it);
        }
        v5 = StringsKt.toIntOrNull(arguments.getParallelBackendThreads());
        nThreadsRaw = v5 != null ? v5 : 1;
        nThreads = nThreadsRaw == 0 ? Runtime.getRuntime().availableProcessors() : nThreadsRaw;
        $this$configureAdvancedJvmOptions.put(CommonConfigurationKeys.PARALLEL_BACKEND_THREADS, nThreads);
    }

    /*
     * WARNING - void declaration
     */
    public static final void configureKlibPaths(@NotNull CompilerConfiguration $this$configureKlibPaths, @NotNull K2JVMCompilerArguments arguments2) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter($this$configureKlibPaths, "$this$configureKlibPaths");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        String string2 = arguments2.getKlibLibraries();
        if (string2 == null) {
            return;
        }
        String libraries = string2;
        boolean bl2 = bl = arguments2.getUseIR() && !arguments2.getUseOldBackend();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JvmArgumentsKt$configureKlibPaths$22 = false;
            String $i$a$-assert-JvmArgumentsKt$configureKlibPaths$22 = "Klib libraries can only be used with IR backend";
            throw new AssertionError((Object)$i$a$-assert-JvmArgumentsKt$configureKlibPaths$22);
        }
        Object object = libraries;
        String string3 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue(string3, "File.pathSeparator");
        Object $i$a$-assert-JvmArgumentsKt$configureKlibPaths$22 = string3;
        $i$a$-assert-JvmArgumentsKt$configureKlibPaths$22 = new Regex((String)$i$a$-assert-JvmArgumentsKt$configureKlibPaths$22);
        int n = 0;
        object = ((Regex)$i$a$-assert-JvmArgumentsKt$configureKlibPaths$22).split((CharSequence)object, n);
        CompilerConfigurationKey<List<String>> compilerConfigurationKey = JVMConfigurationKeys.KLIB_PATHS;
        CompilerConfiguration compilerConfiguration = $this$configureKlibPaths;
        boolean $i$f$filterNot = false;
        void var5_10 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String p1 = (String)element$iv$iv;
            boolean bl3 = false;
            CharSequence charSequence2 = p1;
            if (charSequence2.length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        compilerConfiguration.put(compilerConfigurationKey, list2);
    }

    private static final MessageCollector getMessageCollector(CompilerConfiguration $this$messageCollector) {
        MessageCollector messageCollector2 = $this$messageCollector.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue(messageCollector2, "getNotNull(CLIConfigurat\u2026ys.MESSAGE_COLLECTOR_KEY)");
        return messageCollector2;
    }

    public static final /* synthetic */ MessageCollector access$getMessageCollector$p(CompilerConfiguration $this$access_u24messageCollector_u24p) {
        return JvmArgumentsKt.getMessageCollector($this$access_u24messageCollector_u24p);
    }
}

