/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.components;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtilRt;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;
import org.jetbrains.kotlin.com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;

public interface ComponentManager
extends Disposable,
AreaInstance,
UserDataHolder {
    public <T> T getComponent(@NotNull Class<T> var1);

    @NotNull
    public PicoContainer getPicoContainer();

    @NotNull
    public MessageBus getMessageBus();

    public boolean isDisposed();

    @NotNull
    public Condition<?> getDisposed();

    default public <T> T getService(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            ComponentManager.$$$reportNull$$$0(8);
        }
        return (T)this.getPicoContainer().getComponentInstance(serviceClass.getName());
    }

    @Nullable
    default public <T> T getServiceIfCreated(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            ComponentManager.$$$reportNull$$$0(9);
        }
        return this.getService(serviceClass);
    }

    @Override
    @NotNull
    default public ExtensionsArea getExtensionArea() {
        throw new AbstractMethodError();
    }

    @ApiStatus.Internal
    default public <T> T instantiateClass(@NotNull Class<T> aClass, @Nullable PluginId pluginId) {
        if (aClass == null) {
            ComponentManager.$$$reportNull$$$0(10);
        }
        return ReflectionUtil.newInstance(aClass, false);
    }

    @ApiStatus.Internal
    default public <T> T instantiateClassWithConstructorInjection(@NotNull Class<T> aClass, @NotNull Object key, @NotNull PluginId pluginId) {
        if (aClass == null) {
            ComponentManager.$$$reportNull$$$0(11);
        }
        if (key == null) {
            ComponentManager.$$$reportNull$$$0(12);
        }
        if (pluginId == null) {
            ComponentManager.$$$reportNull$$$0(13);
        }
        return (T)new CachingConstructorInjectionComponentAdapter(key, aClass).getComponentInstance(this.getPicoContainer());
    }

    @ApiStatus.Internal
    default public void logError(@NotNull Throwable error, @NotNull PluginId pluginId) {
        if (error == null) {
            ComponentManager.$$$reportNull$$$0(14);
        }
        if (pluginId == null) {
            ComponentManager.$$$reportNull$$$0(15);
        }
        throw this.createError(error, pluginId);
    }

    @ApiStatus.Internal
    @NotNull
    default public RuntimeException createError(@NotNull Throwable error, @NotNull PluginId pluginId) {
        if (error == null) {
            ComponentManager.$$$reportNull$$$0(16);
        }
        if (pluginId == null) {
            ComponentManager.$$$reportNull$$$0(17);
        }
        ExceptionUtilRt.rethrowUnchecked(error);
        return new RuntimeException(error);
    }

    @ApiStatus.Internal
    @NotNull
    default public RuntimeException createError(@NotNull @NonNls String message2, @NotNull PluginId pluginId) {
        if (message2 == null) {
            ComponentManager.$$$reportNull$$$0(18);
        }
        if (pluginId == null) {
            ComponentManager.$$$reportNull$$$0(19);
        }
        return new RuntimeException(message2);
    }

    @ApiStatus.Internal
    @NotNull
    default public <T> T instantiateExtensionWithPicoContainerOnlyIfNeeded(@Nullable String name2, @Nullable PluginDescriptor pluginDescriptor) {
        Object obj;
        try {
            obj = ReflectionUtil.newInstance(Class.forName(name2));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (obj == null) {
            ComponentManager.$$$reportNull$$$0(20);
        }
        return (T)obj;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 20: 
            case 22: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 3: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 4: 
            case 6: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/components/ComponentManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/components/ComponentManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateExtensionWithPicoContainerOnlyIfNeeded";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentInstancesOfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getComponents";
                break;
            }
            case 4: 
            case 6: 
            case 20: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getServiceIfCreated";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "instantiateClass";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "instantiateClassWithConstructorInjection";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "logError";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createError";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getComponentInstancesOfType";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

