/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstructorAllowedChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstructorChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirConstructorAllowedChecker
extends FirDeclarationChecker<FirConstructor> {
    @NotNull
    public static final FirConstructorAllowedChecker INSTANCE = new FirConstructorAllowedChecker();

    private FirConstructorAllowedChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirConstructor declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        IElementType elementType;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter2, "reporter");
        FirDeclaration firDeclaration = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        if (!(firDeclaration instanceof FirClass)) return;
        FirClass firClass = (FirClass)firDeclaration;
        FirClass firClass2 = firClass;
        if (firClass2 == null) {
            return;
        }
        FirClass containingClass = firClass2;
        FirSourceElement source = declaration2.getSource();
        Object object = source;
        IElementType iElementType = elementType = object == null ? null : ((FirSourceElement)object).getElementType();
        if (!Intrinsics.areEqual(elementType, KtNodeTypes.PRIMARY_CONSTRUCTOR) && !Intrinsics.areEqual(elementType, KtNodeTypes.SECONDARY_CONSTRUCTOR)) {
            return;
        }
        object = containingClass.getClassKind();
        int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getCONSTRUCTOR_IN_OBJECT(), context2, null, 8, null);
                return;
            }
            case 2: {
                DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getCONSTRUCTOR_IN_INTERFACE(), context2, null, 8, null);
                return;
            }
            case 3: {
                DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getCONSTRUCTOR_IN_OBJECT(), context2, null, 8, null);
                return;
            }
            case 4: {
                FirMemberDeclaration $this$visibility$iv = declaration2;
                boolean $i$f$getVisibility = false;
                if (Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Private.INSTANCE)) return;
                DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getNON_PRIVATE_CONSTRUCTOR_IN_ENUM(), context2, null, 8, null);
                return;
            }
            case 5: {
                FirModifier it;
                if (!(containingClass instanceof FirRegularClass)) return;
                FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)((Object)containingClass);
                boolean $i$f$getModality22 = false;
                if ($this$modality$iv.getStatus().getModality() != Modality.SEALED) return;
                FirModifierList $i$f$getModality22 = FirKeywordUtilsKt.getModifierList(source);
                if ($i$f$getModality22 == null) {
                    return;
                }
                FirModifierList modifierList2 = $i$f$getModality22;
                Iterable $this$any$iv = modifierList2.getModifiers();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return;
                }
                Iterator iterator2 = $this$any$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return;
                    Object element$iv = iterator2.next();
                    it = (FirModifier)element$iv;
                    boolean bl = false;
                } while (!(!Intrinsics.areEqual(it.getToken(), KtTokens.PROTECTED_KEYWORD) && !Intrinsics.areEqual(it.getToken(), KtTokens.PRIVATE_KEYWORD)));
                boolean bl = true;
                boolean hasIllegalModifier = bl;
                if (!hasIllegalModifier) return;
                DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getNON_PRIVATE_OR_PROTECTED_CONSTRUCTOR_IN_SEALED(), context2, null, 8, null);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            nArray[ClassKind.OBJECT.ordinal()] = 1;
            nArray[ClassKind.INTERFACE.ordinal()] = 2;
            nArray[ClassKind.ENUM_ENTRY.ordinal()] = 3;
            nArray[ClassKind.ENUM_CLASS.ordinal()] = 4;
            nArray[ClassKind.CLASS.ordinal()] = 5;
            nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

