/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model.building;

import org.jetbrains.kotlin.org.apache.maven.model.DependencyManagement;
import org.jetbrains.kotlin.org.apache.maven.model.Model;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelData;

interface ModelCacheTag<T> {
    public static final ModelCacheTag<ModelData> RAW = new ModelCacheTag<ModelData>(){

        @Override
        public String getName() {
            return "raw";
        }

        @Override
        public Class<ModelData> getType() {
            return ModelData.class;
        }

        @Override
        public ModelData intoCache(ModelData data2) {
            Model model = data2.getModel() != null ? data2.getModel().clone() : null;
            return new ModelData(data2.getSource(), model, data2.getGroupId(), data2.getArtifactId(), data2.getVersion());
        }

        @Override
        public ModelData fromCache(ModelData data2) {
            return this.intoCache(data2);
        }
    };
    public static final ModelCacheTag<DependencyManagement> IMPORT = new ModelCacheTag<DependencyManagement>(){

        @Override
        public String getName() {
            return "import";
        }

        @Override
        public Class<DependencyManagement> getType() {
            return DependencyManagement.class;
        }

        @Override
        public DependencyManagement intoCache(DependencyManagement data2) {
            return data2 != null ? data2.clone() : null;
        }

        @Override
        public DependencyManagement fromCache(DependencyManagement data2) {
            return this.intoCache(data2);
        }
    };

    public String getName();

    public Class<T> getType();

    public T intoCache(T var1);

    public T fromCache(T var1);
}

