/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.interpolation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.util.ValueSourceUtils;

public class PrefixAwareRecursionInterceptor
implements RecursionInterceptor {
    private Stack<String> nakedExpressions = new Stack();
    private final String[] possiblePrefixes;
    private boolean watchUnprefixedExpressions = true;

    public PrefixAwareRecursionInterceptor(Collection<String> possiblePrefixes) {
        this.possiblePrefixes = possiblePrefixes.toArray(new String[possiblePrefixes.size()]);
    }

    @Override
    public boolean hasRecursiveExpression(String expression2) {
        String realExpr = ValueSourceUtils.trimPrefix(expression2, this.possiblePrefixes, this.watchUnprefixedExpressions);
        return realExpr != null && this.nakedExpressions.contains(realExpr);
    }

    @Override
    public void expressionResolutionFinished(String expression2) {
        this.nakedExpressions.pop();
    }

    @Override
    public void expressionResolutionStarted(String expression2) {
        String realExpr = ValueSourceUtils.trimPrefix(expression2, this.possiblePrefixes, this.watchUnprefixedExpressions);
        this.nakedExpressions.push(realExpr);
    }

    @Override
    public List getExpressionCycle(String expression2) {
        String expr = ValueSourceUtils.trimPrefix(expression2, this.possiblePrefixes, this.watchUnprefixedExpressions);
        if (expr == null) {
            return Collections.EMPTY_LIST;
        }
        int idx = this.nakedExpressions.indexOf(expr);
        if (idx < 0) {
            return Collections.EMPTY_LIST;
        }
        return this.nakedExpressions.subList(idx, this.nakedExpressions.size());
    }
}

