/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.checksum.ChecksumPolicy;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.ChecksumFailureException;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.TransferResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractChecksumPolicy
implements ChecksumPolicy {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final TransferResource resource;

    protected AbstractChecksumPolicy(TransferResource resource) {
        this.resource = resource;
    }

    @Override
    public boolean onChecksumMatch(String algorithm, int kind) {
        return true;
    }

    @Override
    public void onChecksumMismatch(String algorithm, int kind, ChecksumFailureException exception) throws ChecksumFailureException {
        if ((kind & 1) == 0) {
            throw exception;
        }
    }

    @Override
    public void onChecksumError(String algorithm, int kind, ChecksumFailureException exception) throws ChecksumFailureException {
        this.logger.debug("Could not validate {} checksum for {}", new Object[]{algorithm, this.resource.getResourceName(), exception});
    }

    @Override
    public void onNoMoreChecksums() throws ChecksumFailureException {
        throw new ChecksumFailureException("Checksum validation failed, no checksums available");
    }

    @Override
    public void onTransferRetry() {
    }
}

