/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.org.eclipse.aether.repository.ArtifactRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.Authentication;
import org.jetbrains.kotlin.org.eclipse.aether.repository.Proxy;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RepositoryPolicy;

public final class RemoteRepository
implements ArtifactRepository {
    private static final Pattern URL_PATTERN = Pattern.compile("([^:/]+(:[^:/]{2,}+(?=://))?):(//([^@/]*@)?([^/:]+))?.*");
    private final String id;
    private final String type;
    private final String url;
    private final String host;
    private final String protocol;
    private final RepositoryPolicy releasePolicy;
    private final RepositoryPolicy snapshotPolicy;
    private final Proxy proxy;
    private final Authentication authentication;
    private final List<RemoteRepository> mirroredRepositories;
    private final boolean repositoryManager;
    private final boolean blocked;

    RemoteRepository(Builder builder2) {
        if (builder2.prototype != null) {
            this.id = (builder2.delta & 1) != 0 ? builder2.id : builder2.prototype.id;
            this.type = (builder2.delta & 2) != 0 ? builder2.type : builder2.prototype.type;
            this.url = (builder2.delta & 4) != 0 ? builder2.url : builder2.prototype.url;
            this.releasePolicy = (builder2.delta & 8) != 0 ? builder2.releasePolicy : builder2.prototype.releasePolicy;
            this.snapshotPolicy = (builder2.delta & 0x10) != 0 ? builder2.snapshotPolicy : builder2.prototype.snapshotPolicy;
            this.proxy = (builder2.delta & 0x20) != 0 ? builder2.proxy : builder2.prototype.proxy;
            this.authentication = (builder2.delta & 0x40) != 0 ? builder2.authentication : builder2.prototype.authentication;
            this.repositoryManager = (builder2.delta & 0x100) != 0 ? builder2.repositoryManager : builder2.prototype.repositoryManager;
            this.blocked = (builder2.delta & 0x200) != 0 ? builder2.blocked : builder2.prototype.blocked;
            this.mirroredRepositories = (builder2.delta & 0x80) != 0 ? RemoteRepository.copy(builder2.mirroredRepositories) : builder2.prototype.mirroredRepositories;
        } else {
            this.id = builder2.id;
            this.type = builder2.type;
            this.url = builder2.url;
            this.releasePolicy = builder2.releasePolicy;
            this.snapshotPolicy = builder2.snapshotPolicy;
            this.proxy = builder2.proxy;
            this.authentication = builder2.authentication;
            this.repositoryManager = builder2.repositoryManager;
            this.blocked = builder2.blocked;
            this.mirroredRepositories = RemoteRepository.copy(builder2.mirroredRepositories);
        }
        Matcher m = URL_PATTERN.matcher(this.url);
        if (m.matches()) {
            this.protocol = m.group(1);
            String host = m.group(5);
            this.host = host != null ? host : "";
        } else {
            this.protocol = "";
            this.host = "";
        }
    }

    private static List<RemoteRepository> copy(List<RemoteRepository> repos) {
        if (repos == null || repos.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(repos.toArray(new RemoteRepository[repos.size()])));
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getContentType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public RepositoryPolicy getPolicy(boolean snapshot) {
        return snapshot ? this.snapshotPolicy : this.releasePolicy;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public List<RemoteRepository> getMirroredRepositories() {
        return this.mirroredRepositories;
    }

    public boolean isRepositoryManager() {
        return this.repositoryManager;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(this.getId());
        buffer.append(" (").append(this.getUrl());
        buffer.append(", ").append(this.getContentType());
        boolean r = this.getPolicy(false).isEnabled();
        boolean s = this.getPolicy(true).isEnabled();
        if (r && s) {
            buffer.append(", releases+snapshots");
        } else if (r) {
            buffer.append(", releases");
        } else if (s) {
            buffer.append(", snapshots");
        } else {
            buffer.append(", disabled");
        }
        if (this.isRepositoryManager()) {
            buffer.append(", managed");
        }
        if (this.isBlocked()) {
            buffer.append(", blocked");
        }
        buffer.append(")");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        RemoteRepository that = (RemoteRepository)obj;
        return Objects.equals(this.url, that.url) && Objects.equals(this.type, that.type) && Objects.equals(this.id, that.id) && Objects.equals(this.releasePolicy, that.releasePolicy) && Objects.equals(this.snapshotPolicy, that.snapshotPolicy) && Objects.equals(this.proxy, that.proxy) && Objects.equals(this.authentication, that.authentication) && Objects.equals(this.mirroredRepositories, that.mirroredRepositories) && this.repositoryManager == that.repositoryManager;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + RemoteRepository.hash(this.url);
        hash = hash * 31 + RemoteRepository.hash(this.type);
        hash = hash * 31 + RemoteRepository.hash(this.id);
        hash = hash * 31 + RemoteRepository.hash(this.releasePolicy);
        hash = hash * 31 + RemoteRepository.hash(this.snapshotPolicy);
        hash = hash * 31 + RemoteRepository.hash(this.proxy);
        hash = hash * 31 + RemoteRepository.hash(this.authentication);
        hash = hash * 31 + RemoteRepository.hash(this.mirroredRepositories);
        hash = hash * 31 + (this.repositoryManager ? 1 : 0);
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }

    public static final class Builder {
        private static final RepositoryPolicy DEFAULT_POLICY = new RepositoryPolicy();
        int delta;
        RemoteRepository prototype;
        String id;
        String type;
        String url;
        RepositoryPolicy releasePolicy = DEFAULT_POLICY;
        RepositoryPolicy snapshotPolicy = DEFAULT_POLICY;
        Proxy proxy;
        Authentication authentication;
        List<RemoteRepository> mirroredRepositories;
        boolean repositoryManager;
        boolean blocked;

        public Builder(String id, String type2, String url) {
            this.id = id != null ? id : "";
            this.type = type2 != null ? type2 : "";
            this.url = url != null ? url : "";
        }

        public Builder(RemoteRepository prototype) {
            this.prototype = Objects.requireNonNull(prototype, "remote repository prototype cannot be null");
        }

        public RemoteRepository build() {
            if (this.prototype != null && this.delta == 0) {
                return this.prototype;
            }
            return new RemoteRepository(this);
        }

        private <T> void delta(int flag, T builder2, T prototype) {
            boolean equal = Objects.equals(builder2, prototype);
            this.delta = equal ? (this.delta &= ~flag) : (this.delta |= flag);
        }

        public Builder setContentType(String type2) {
            String string2 = this.type = type2 != null ? type2 : "";
            if (this.prototype != null) {
                this.delta(2, this.type, this.prototype.getContentType());
            }
            return this;
        }

        public Builder setReleasePolicy(RepositoryPolicy releasePolicy) {
            RepositoryPolicy repositoryPolicy = this.releasePolicy = releasePolicy != null ? releasePolicy : DEFAULT_POLICY;
            if (this.prototype != null) {
                this.delta(8, this.releasePolicy, this.prototype.getPolicy(false));
            }
            return this;
        }

        public Builder setSnapshotPolicy(RepositoryPolicy snapshotPolicy) {
            RepositoryPolicy repositoryPolicy = this.snapshotPolicy = snapshotPolicy != null ? snapshotPolicy : DEFAULT_POLICY;
            if (this.prototype != null) {
                this.delta(16, this.snapshotPolicy, this.prototype.getPolicy(true));
            }
            return this;
        }

        public Builder setProxy(Proxy proxy) {
            this.proxy = proxy;
            if (this.prototype != null) {
                this.delta(32, this.proxy, this.prototype.getProxy());
            }
            return this;
        }

        public Builder setAuthentication(Authentication authentication) {
            this.authentication = authentication;
            if (this.prototype != null) {
                this.delta(64, this.authentication, this.prototype.getAuthentication());
            }
            return this;
        }

        public Builder setMirroredRepositories(List<RemoteRepository> mirroredRepositories) {
            if (this.mirroredRepositories == null) {
                this.mirroredRepositories = new ArrayList<RemoteRepository>();
            } else {
                this.mirroredRepositories.clear();
            }
            if (mirroredRepositories != null) {
                this.mirroredRepositories.addAll(mirroredRepositories);
            }
            if (this.prototype != null) {
                this.delta(128, this.mirroredRepositories, this.prototype.getMirroredRepositories());
            }
            return this;
        }

        public Builder addMirroredRepository(RemoteRepository mirroredRepository) {
            if (mirroredRepository != null) {
                if (this.mirroredRepositories == null) {
                    this.mirroredRepositories = new ArrayList<RemoteRepository>();
                    if (this.prototype != null) {
                        this.mirroredRepositories.addAll(this.prototype.getMirroredRepositories());
                    }
                }
                this.mirroredRepositories.add(mirroredRepository);
                if (this.prototype != null) {
                    this.delta |= 0x80;
                }
            }
            return this;
        }

        public Builder setRepositoryManager(boolean repositoryManager) {
            this.repositoryManager = repositoryManager;
            if (this.prototype != null) {
                this.delta(256, this.repositoryManager, this.prototype.isRepositoryManager());
            }
            return this;
        }

        public Builder setBlocked(boolean blocked) {
            this.blocked = blocked;
            if (this.prototype != null) {
                this.delta(512, this.blocked, this.prototype.isBlocked());
            }
            return this;
        }
    }
}

