/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.plexus;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Component;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Configuration;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Requirement;
import org.jetbrains.kotlin.org.codehaus.plexus.util.IOUtil;
import org.jetbrains.kotlin.org.codehaus.plexus.util.InterpolationFilterReader;
import org.jetbrains.kotlin.org.codehaus.plexus.util.ReaderFactory;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.XmlStreamReader;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.MXParser;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.DeferredClass;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.Logs;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.ConfigurationImpl;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.Hints;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanMetadata;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusTypeRegistry;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusXmlMetadata;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.RequirementImpl;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.Roles;
import org.jetbrains.kotlin.org.eclipse.sisu.space.ClassSpace;
import org.jetbrains.kotlin.org.eclipse.sisu.space.Streams;

final class PlexusXmlScanner {
    private final Map<?, ?> variables;
    private final URL plexusXml;
    private final Map<String, PlexusBeanMetadata> metadata;

    PlexusXmlScanner(Map<?, ?> variables, URL plexusXml, Map<String, PlexusBeanMetadata> metadata2) {
        this.variables = variables;
        this.plexusXml = plexusXml;
        this.metadata = metadata2;
    }

    Map<Component, DeferredClass<?>> scan(ClassSpace space, boolean root2) {
        PlexusTypeRegistry registry = new PlexusTypeRegistry(space);
        if (this.plexusXml != null) {
            this.parsePlexusXml(this.plexusXml, registry);
        }
        Enumeration<URL> e = root2 ? space.getResources("META-INF/plexus/components.xml") : space.findEntries("META-INF/plexus", "components.xml", false);
        while (e.hasMoreElements()) {
            this.parseComponentsXml(e.nextElement(), registry);
        }
        return registry.getComponents();
    }

    private static Reader filteredXmlReader(InputStream in, Map variables) throws IOException {
        XmlStreamReader reader = ReaderFactory.newXmlReader(in);
        if (variables != null) {
            return new InterpolationFilterReader(reader, variables);
        }
        return reader;
    }

    private void parsePlexusXml(URL url, PlexusTypeRegistry registry) {
        try {
            InputStream in = Streams.open(url);
            try {
                MXParser parser = new MXParser();
                parser.setInput(PlexusXmlScanner.filteredXmlReader(in, this.variables));
                parser.nextTag();
                parser.require(2, null, null);
                while (parser.nextTag() == 2) {
                    String name2 = parser.getName();
                    if ("load-on-start".equals(name2)) {
                        while (parser.nextTag() == 2) {
                            PlexusXmlScanner.parseLoadOnStart(parser, registry);
                        }
                        continue;
                    }
                    if ("components".equals(name2)) {
                        while (parser.nextTag() == 2) {
                            this.parseComponent(parser, registry);
                        }
                        continue;
                    }
                    parser.skipSubTree();
                }
            }
            finally {
                IOUtil.close(in);
            }
        }
        catch (Exception e) {
            Logs.trace("Problem parsing: {}", url, e);
        }
    }

    private void parseComponentsXml(URL url, PlexusTypeRegistry registry) {
        try {
            InputStream in = Streams.open(url);
            try {
                MXParser parser = new MXParser();
                parser.setInput(PlexusXmlScanner.filteredXmlReader(in, this.variables));
                parser.nextTag();
                parser.require(2, null, null);
                parser.nextTag();
                parser.require(2, null, "components");
                while (parser.nextTag() == 2) {
                    this.parseComponent(parser, registry);
                }
            }
            finally {
                IOUtil.close(in);
            }
        }
        catch (Exception e) {
            Logs.trace("Problem parsing: {}", url, e);
        }
    }

    private static void parseLoadOnStart(MXParser parser, PlexusTypeRegistry registry) throws XmlPullParserException, IOException {
        if ("component".equals(parser.getName())) {
            String role = null;
            String hint = "";
            while (parser.nextTag() == 2) {
                if ("role".equals(parser.getName())) {
                    role = PlexusXmlScanner.TEXT(parser);
                    continue;
                }
                if ("role-hint".equals(parser.getName())) {
                    hint = PlexusXmlScanner.TEXT(parser);
                    continue;
                }
                parser.skipSubTree();
            }
            if (role == null) {
                throw new XmlPullParserException("Missing <role> element.", parser, null);
            }
            registry.loadOnStart(role, hint);
        } else {
            parser.skipSubTree();
        }
    }

    private void parseComponent(MXParser parser, PlexusTypeRegistry registry) throws XmlPullParserException, IOException {
        String role = null;
        String hint = "";
        String instantiationStrategy = "singleton";
        String description2 = "";
        String implementation2 = null;
        HashMap<String, Requirement> requirementMap = new HashMap<String, Requirement>();
        HashMap<String, Configuration> configurationMap = new HashMap<String, Configuration>();
        ClassSpace space = registry.getSpace();
        parser.require(2, null, "component");
        while (parser.nextTag() == 2) {
            String name2 = parser.getName();
            if ("requirements".equals(name2)) {
                while (parser.nextTag() == 2) {
                    PlexusXmlScanner.parseRequirement(parser, space, requirementMap);
                }
                continue;
            }
            if ("configuration".equals(name2)) {
                while (parser.nextTag() == 2) {
                    PlexusXmlScanner.parseConfiguration(parser, configurationMap);
                }
                continue;
            }
            if ("role".equals(name2)) {
                role = PlexusXmlScanner.TEXT(parser).intern();
                continue;
            }
            if ("role-hint".equals(name2)) {
                hint = PlexusXmlScanner.TEXT(parser);
                continue;
            }
            if ("instantiation-strategy".equals(name2)) {
                instantiationStrategy = PlexusXmlScanner.TEXT(parser).intern();
                continue;
            }
            if ("description".equals(name2)) {
                description2 = PlexusXmlScanner.TEXT(parser);
                continue;
            }
            if ("implementation".equals(name2)) {
                implementation2 = PlexusXmlScanner.TEXT(parser).intern();
                continue;
            }
            parser.skipSubTree();
        }
        if (implementation2 == null) {
            throw new XmlPullParserException("Missing <implementation> element.", parser, null);
        }
        if (role == null) {
            role = implementation2;
        }
        if ((implementation2 = registry.addComponent(role, hint, instantiationStrategy, description2, implementation2)) != null) {
            this.updatePlexusBeanMetadata(implementation2, configurationMap, requirementMap);
        }
    }

    private void updatePlexusBeanMetadata(String implementation2, Map<String, Configuration> configurationMap, Map<String, Requirement> requirementMap) {
        if (!(this.metadata == null || configurationMap.isEmpty() && requirementMap.isEmpty())) {
            PlexusXmlMetadata beanMetadata = (PlexusXmlMetadata)this.metadata.get(implementation2);
            if (beanMetadata != null) {
                beanMetadata.merge(configurationMap, requirementMap);
            } else {
                this.metadata.put(implementation2, new PlexusXmlMetadata(configurationMap, requirementMap));
            }
        }
    }

    private static void parseRequirement(MXParser parser, ClassSpace space, Map<String, Requirement> requirementMap) throws XmlPullParserException, IOException {
        String role = null;
        ArrayList<String> hintList = new ArrayList<String>();
        String fieldName = null;
        boolean optional = false;
        parser.require(2, null, "requirement");
        while (parser.nextTag() == 2) {
            String name2 = parser.getName();
            if ("role".equals(name2)) {
                role = PlexusXmlScanner.TEXT(parser).intern();
                continue;
            }
            if ("role-hint".equals(name2)) {
                hintList.add(PlexusXmlScanner.TEXT(parser));
                continue;
            }
            if ("role-hints".equals(name2)) {
                while (parser.nextTag() == 2) {
                    hintList.add(PlexusXmlScanner.TEXT(parser));
                }
                continue;
            }
            if ("field-name".equals(name2)) {
                fieldName = PlexusXmlScanner.TEXT(parser);
                continue;
            }
            if ("optional".equals(name2)) {
                optional = Boolean.parseBoolean(PlexusXmlScanner.TEXT(parser));
                continue;
            }
            parser.skipSubTree();
        }
        if (role == null) {
            throw new XmlPullParserException("Missing <role> element.", parser, null);
        }
        if (fieldName == null) {
            fieldName = role;
        }
        requirementMap.put(fieldName, new RequirementImpl(space.deferLoadClass(role), optional, Hints.canonicalHints(hintList)));
    }

    private static void parseConfiguration(MXParser parser, Map<String, Configuration> configurationMap) throws XmlPullParserException, IOException {
        String name2 = parser.getName();
        String fieldName = Roles.camelizeName(name2);
        StringBuilder buf = new StringBuilder();
        String header = parser.getText().trim();
        int depth = parser.getDepth();
        while (parser.next() != 3 || parser.getDepth() > depth) {
            buf.append(parser.getText().trim());
        }
        if (buf.indexOf("<") == 0 || header.indexOf(61) > 0) {
            buf.insert(0, header);
            if (!header.endsWith("/>")) {
                buf.append("</" + name2 + '>');
            }
        }
        configurationMap.put(fieldName, new ConfigurationImpl(fieldName, buf.toString()));
    }

    private static String TEXT(XmlPullParser parser) throws XmlPullParserException, IOException {
        return parser.nextText().trim();
    }
}

