/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.RequireKotlinConstants;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002J.\u0010\u0010\u001a\u00020\u0004*\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DeprecatedSinceKotlinAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "lessOrNull", "", "a", "Lorg/jetbrains/kotlin/config/ApiVersion;", "b", "checkVersion", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "parsedVersion", "name", "", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "frontend"})
public final class DeprecatedSinceKotlinAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final DeprecatedSinceKotlinAnnotationChecker INSTANCE = new DeprecatedSinceKotlinAnnotationChecker();

    private DeprecatedSinceKotlinAnnotationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(StandardNames.FqNames.deprecatedSinceKotlin);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor deprecatedSinceAnnotation = annotationDescriptor;
        PsiElement psiElement = PsiSourceElementKt.getPsi(deprecatedSinceAnnotation.getSource());
        KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry = psiElement instanceof KtAnnotationEntry ? (KtAnnotationEntry)psiElement : null;
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry deprecatedSinceAnnotationPsi = ktAnnotationEntry;
        AnnotationDescriptor deprecatedAnnotation = descriptor2.getAnnotations().findAnnotation(StandardNames.FqNames.deprecated);
        KtTypeReference ktTypeReference = deprecatedSinceAnnotationPsi.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        Object object = ktTypeReference;
        KtTypeReference deprecatedSinceAnnotationName = object;
        object = DescriptorUtilsKt.fqNameOrNull(descriptor2);
        if (object == null ? false : !FqNamesUtilKt.isSubpackageOf((FqName)object, StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) {
            context2.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_OUTSIDE_KOTLIN_SUBPACKAGE.on(deprecatedSinceAnnotationName));
            return;
        }
        if (deprecatedAnnotation == null) {
            context2.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_WITHOUT_DEPRECATED.on(deprecatedSinceAnnotationName));
            return;
        }
        if (AnnotationUtilKt.argumentValue(deprecatedAnnotation, "level") != null) {
            context2.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_WITH_DEPRECATED_LEVEL.on(deprecatedSinceAnnotationName));
            return;
        }
        if (deprecatedSinceAnnotation.getAllValueArguments().isEmpty()) {
            context2.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_WITHOUT_ARGUMENTS.on(deprecatedSinceAnnotationName));
            return;
        }
        ApiVersion warningSince = DeprecatedSinceKotlinAnnotationChecker.check$getCheckedSinceVersion(deprecatedSinceAnnotation, context2, deprecatedSinceAnnotationName, "warningSince");
        ApiVersion errorSince = DeprecatedSinceKotlinAnnotationChecker.check$getCheckedSinceVersion(deprecatedSinceAnnotation, context2, deprecatedSinceAnnotationName, "errorSince");
        ApiVersion hiddenSince = DeprecatedSinceKotlinAnnotationChecker.check$getCheckedSinceVersion(deprecatedSinceAnnotation, context2, deprecatedSinceAnnotationName, "hiddenSince");
        if (!(this.lessOrNull(warningSince, errorSince) && this.lessOrNull(errorSince, hiddenSince) && this.lessOrNull(warningSince, hiddenSince))) {
            context2.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_WITH_UNORDERED_VERSIONS.on(deprecatedSinceAnnotationName));
            return;
        }
    }

    private final void checkVersion(AnnotationDescriptor $this$checkVersion, ApiVersion parsedVersion, String name2, DeclarationCheckerContext context2, PsiElement reportOn) {
        block5: {
            Object object;
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic;
            block6: {
                String argumentValue;
                ConstantValue<?> $this$safeAs$iv = AnnotationUtilKt.argumentValue($this$checkVersion, name2);
                boolean $i$f$safeAs = false;
                ConstantValue<?> constantValue = $this$safeAs$iv;
                if (!(constantValue instanceof StringValue)) {
                    constantValue = null;
                }
                String string2 = argumentValue = (parametrizedDiagnostic = (StringValue)constantValue) == null ? null : (String)((ConstantValue)((Object)parametrizedDiagnostic)).getValue();
                if (argumentValue == null) break block5;
                if (parsedVersion == null) break block6;
                parametrizedDiagnostic = argumentValue;
                object = RequireKotlinConstants.INSTANCE.getVERSION_REGEX();
                if (((Regex)object).matches((CharSequence)((Object)parametrizedDiagnostic))) break block5;
            }
            BindingTrace bindingTrace = context2.getTrace();
            object = $this$checkVersion.getFqName();
            if (object == null) {
                return;
            }
            parametrizedDiagnostic = Errors.ILLEGAL_KOTLIN_VERSION_STRING_VALUE.on(reportOn, (FqName)object);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "ILLEGAL_KOTLIN_VERSION_S\u2026 return\n                )");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
        }
    }

    private final boolean lessOrNull(ApiVersion a, ApiVersion b) {
        return a == null || b == null ? true : a.compareTo(b) <= 0;
    }

    private static final ApiVersion check$getCheckedSinceVersion(AnnotationDescriptor $this$check_u24getCheckedSinceVersion, DeclarationCheckerContext $context, KtTypeReference deprecatedSinceAnnotationName, String name2) {
        ApiVersion apiVersion;
        ApiVersion it = apiVersion = DeprecationUtilKt.getSinceVersion($this$check_u24getCheckedSinceVersion, name2);
        boolean bl = false;
        INSTANCE.checkVersion($this$check_u24getCheckedSinceVersion, it, name2, $context, deprecatedSinceAnnotationName);
        return apiVersion;
    }
}

