/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.collection.AbstractIterator;
import javaslang.collection.HashArrayMappedTrie;
import javaslang.collection.Iterator;
import javaslang.control.Option;

interface HashArrayMappedTrieModule {

    public static final class ArrayNode<K, V>
    extends AbstractNode<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Object[] subNodes;
        private final int count;
        private final int size;

        ArrayNode(int count2, int size, Object[] subNodes) {
            this.subNodes = subNodes;
            this.count = count2;
            this.size = size;
        }

        @Override
        Option<V> lookup(int shift, int keyHashCode, K key) {
            int frag = ArrayNode.hashFragment(shift, keyHashCode);
            AbstractNode child = (AbstractNode)this.subNodes[frag];
            return child.lookup(shift + 5, keyHashCode, key);
        }

        @Override
        AbstractNode<K, V> modify(int shift, int keyHashCode, K key, V value2, Action action) {
            int frag = ArrayNode.hashFragment(shift, keyHashCode);
            AbstractNode child = (AbstractNode)this.subNodes[frag];
            AbstractNode<K, V> newChild = child.modify(shift + 5, keyHashCode, key, value2, action);
            if (child.isEmpty() && !newChild.isEmpty()) {
                return new ArrayNode<K, V>(this.count + 1, this.size + newChild.size(), ArrayNode.update(this.subNodes, frag, newChild));
            }
            if (!child.isEmpty() && newChild.isEmpty()) {
                if (this.count - 1 <= 8) {
                    return this.pack(frag, this.subNodes);
                }
                return new ArrayNode<K, V>(this.count - 1, this.size - child.size(), ArrayNode.update(this.subNodes, frag, EmptyNode.instance()));
            }
            return new ArrayNode<K, V>(this.count, this.size - child.size() + newChild.size(), ArrayNode.update(this.subNodes, frag, newChild));
        }

        private IndexedNode<K, V> pack(int idx, Object[] elements) {
            Object[] arr = new Object[this.count - 1];
            int bitmap = 0;
            int size = 0;
            int ptr = 0;
            for (int i = 0; i < 32; ++i) {
                AbstractNode elem = (AbstractNode)elements[i];
                if (i == idx || elem.isEmpty()) continue;
                size += elem.size();
                arr[ptr++] = elem;
                bitmap |= 1 << i;
            }
            return new IndexedNode(bitmap, size, arr);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return this.size;
        }

        public int hashCode() {
            return Objects.hash(this.subNodes);
        }
    }

    public static final class IndexedNode<K, V>
    extends AbstractNode<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int bitmap;
        private final int size;
        private final Object[] subNodes;

        IndexedNode(int bitmap, int size, Object[] subNodes) {
            this.bitmap = bitmap;
            this.size = size;
            this.subNodes = subNodes;
        }

        @Override
        Option<V> lookup(int shift, int keyHashCode, K key) {
            int frag = IndexedNode.hashFragment(shift, keyHashCode);
            int bit = IndexedNode.toBitmap(frag);
            if ((this.bitmap & bit) != 0) {
                AbstractNode n = (AbstractNode)this.subNodes[IndexedNode.fromBitmap(this.bitmap, bit)];
                return n.lookup(shift + 5, keyHashCode, key);
            }
            return Option.none();
        }

        @Override
        AbstractNode<K, V> modify(int shift, int keyHashCode, K key, V value2, Action action) {
            int newBitmap;
            boolean added;
            int frag = IndexedNode.hashFragment(shift, keyHashCode);
            int bit = IndexedNode.toBitmap(frag);
            int index2 = IndexedNode.fromBitmap(this.bitmap, bit);
            int mask = this.bitmap;
            boolean exists = (mask & bit) != 0;
            AbstractNode atIndx = exists ? (AbstractNode)this.subNodes[index2] : null;
            AbstractNode<K, V> child = exists ? atIndx.modify(shift + 5, keyHashCode, key, value2, action) : EmptyNode.instance().modify(shift + 5, keyHashCode, key, value2, action);
            boolean removed2 = exists && child.isEmpty();
            boolean bl = added = !exists && !child.isEmpty();
            int n = removed2 ? mask & ~bit : (newBitmap = added ? mask | bit : mask);
            if (newBitmap == 0) {
                return EmptyNode.instance();
            }
            if (removed2) {
                if (this.subNodes.length <= 2 && this.subNodes[index2 ^ 1] instanceof LeafNode) {
                    return (AbstractNode)this.subNodes[index2 ^ 1];
                }
                return new IndexedNode<K, V>(newBitmap, this.size - atIndx.size(), IndexedNode.remove(this.subNodes, index2));
            }
            if (added) {
                if (this.subNodes.length >= 16) {
                    return this.expand(frag, child, mask, this.subNodes);
                }
                return new IndexedNode<K, V>(newBitmap, this.size + child.size(), IndexedNode.insert(this.subNodes, index2, child));
            }
            if (!exists) {
                return this;
            }
            return new IndexedNode<K, V>(newBitmap, this.size - atIndx.size() + child.size(), IndexedNode.update(this.subNodes, index2, child));
        }

        private ArrayNode<K, V> expand(int frag, AbstractNode<K, V> child, int mask, Object[] subNodes) {
            int bit = mask;
            int count2 = 0;
            int ptr = 0;
            Object[] arr = new Object[32];
            for (int i = 0; i < 32; ++i) {
                if ((bit & 1) != 0) {
                    arr[i] = subNodes[ptr++];
                    ++count2;
                } else if (i == frag) {
                    arr[i] = child;
                    ++count2;
                } else {
                    arr[i] = EmptyNode.instance();
                }
                bit >>>= 1;
            }
            return new ArrayNode(count2, this.size + child.size(), arr);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return this.size;
        }

        public int hashCode() {
            return Objects.hash(this.subNodes);
        }
    }

    public static final class LeafList<K, V>
    extends LeafNode<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int hash;
        private final K key;
        private final V value;
        private final int size;
        private final LeafNode<K, V> tail;

        LeafList(int hash, K key, V value2, LeafNode<K, V> tail) {
            this.hash = hash;
            this.key = key;
            this.value = value2;
            this.size = 1 + tail.size();
            this.tail = tail;
        }

        @Override
        Option<V> lookup(int shift, int keyHashCode, K key) {
            if (this.hash != keyHashCode) {
                return Option.none();
            }
            return this.iterator().find(t -> Objects.equals(t._1, key)).map(t -> t._2);
        }

        @Override
        AbstractNode<K, V> modify(int shift, int keyHashCode, K key, V value2, Action action) {
            if (keyHashCode == this.hash) {
                AbstractNode<K, V> filtered = this.removeElement(key);
                if (action == Action.REMOVE) {
                    return filtered;
                }
                return new LeafList<K, V>(this.hash, key, value2, (LeafNode)filtered);
            }
            return action == Action.REMOVE ? this : LeafList.mergeLeaves(shift, this, new LeafSingleton<K, V>(keyHashCode, key, value2));
        }

        private static <K, V> AbstractNode<K, V> mergeNodes(LeafNode<K, V> leaf1, LeafNode<K, V> leaf2) {
            if (leaf2 == null) {
                return leaf1;
            }
            if (leaf1 instanceof LeafSingleton) {
                return new LeafList<K, V>(leaf1.hash(), leaf1.key(), leaf1.value(), leaf2);
            }
            if (leaf2 instanceof LeafSingleton) {
                return new LeafList<K, V>(leaf2.hash(), leaf2.key(), leaf2.value(), leaf1);
            }
            LeafNode<K, V> result2 = leaf1;
            LeafNode<K, V> tail = leaf2;
            while (tail instanceof LeafList) {
                LeafList list2 = (LeafList)tail;
                result2 = new LeafList<K, V>(list2.hash, list2.key, list2.value, result2);
                tail = list2.tail;
            }
            return new LeafList<K, V>(tail.hash(), tail.key(), tail.value(), result2);
        }

        private AbstractNode<K, V> removeElement(K k) {
            if (Objects.equals(k, this.key)) {
                return this.tail;
            }
            LeafNode leaf1 = new LeafSingleton<K, V>(this.hash, this.key, this.value);
            LeafNode<K, V> leaf2 = this.tail;
            boolean found = false;
            while (!found && leaf2 != null) {
                if (Objects.equals(k, leaf2.key())) {
                    found = true;
                } else {
                    leaf1 = new LeafList<K, V>(leaf2.hash(), leaf2.key(), leaf2.value(), leaf1);
                }
                leaf2 = leaf2 instanceof LeafList ? ((LeafList)leaf2).tail : null;
            }
            return LeafList.mergeNodes(leaf1, leaf2);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<LeafNode<K, V>> nodes() {
            return new AbstractIterator<LeafNode<K, V>>(){
                LeafNode<K, V> node;
                {
                    this.node = this;
                }

                @Override
                public boolean hasNext() {
                    return this.node != null;
                }

                @Override
                public LeafNode<K, V> getNext() {
                    LeafNode result2 = this.node;
                    this.node = this.node instanceof LeafSingleton ? null : ((LeafList)this.node).tail;
                    return result2;
                }
            };
        }

        public int hashCode() {
            Iterator<LeafNode<K, V>> it = this.nodes();
            int hashCode2 = 0;
            while (it.hasNext()) {
                LeafNode node = (LeafNode)it.next();
                hashCode2 += Objects.hash(node.key(), node.value());
            }
            return hashCode2;
        }

        @Override
        int hash() {
            return this.hash;
        }

        @Override
        K key() {
            return this.key;
        }

        @Override
        V value() {
            return this.value;
        }
    }

    public static final class LeafSingleton<K, V>
    extends LeafNode<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int hash;
        private final K key;
        private final V value;

        LeafSingleton(int hash, K key, V value2) {
            this.hash = hash;
            this.key = key;
            this.value = value2;
        }

        @Override
        Option<V> lookup(int shift, int keyHashCode, K key) {
            if (keyHashCode == this.hash && Objects.equals(key, this.key)) {
                return Option.some(this.value);
            }
            return Option.none();
        }

        @Override
        AbstractNode<K, V> modify(int shift, int keyHashCode, K key, V value2, Action action) {
            if (keyHashCode == this.hash && Objects.equals(key, this.key)) {
                return action == Action.REMOVE ? EmptyNode.instance() : new LeafSingleton<K, V>(this.hash, key, value2);
            }
            return action == Action.REMOVE ? this : LeafSingleton.mergeLeaves(shift, this, new LeafSingleton<K, V>(keyHashCode, key, value2));
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Iterator<LeafNode<K, V>> nodes() {
            return Iterator.of(this);
        }

        public int hashCode() {
            return Objects.hash(this.hash, this.value);
        }

        @Override
        int hash() {
            return this.hash;
        }

        @Override
        K key() {
            return this.key;
        }

        @Override
        V value() {
            return this.value;
        }
    }

    public static abstract class LeafNode<K, V>
    extends AbstractNode<K, V> {
        abstract K key();

        abstract V value();

        abstract int hash();

        static <K, V> AbstractNode<K, V> mergeLeaves(int shift, LeafNode<K, V> leaf1, LeafSingleton<K, V> leaf2) {
            Object[] objectArray;
            int h2;
            int h1 = leaf1.hash();
            if (h1 == (h2 = leaf2.hash())) {
                return new LeafList<K, V>(h1, leaf2.key(), leaf2.value(), leaf1);
            }
            int subH1 = LeafNode.hashFragment(shift, h1);
            int subH2 = LeafNode.hashFragment(shift, h2);
            int newBitmap = LeafNode.toBitmap(subH1) | LeafNode.toBitmap(subH2);
            if (subH1 == subH2) {
                AbstractNode<K, V> newLeaves = LeafNode.mergeLeaves(shift + 5, leaf1, leaf2);
                return new IndexedNode(newBitmap, newLeaves.size(), new Object[]{newLeaves});
            }
            int n = leaf1.size() + leaf2.size();
            if (subH1 < subH2) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = leaf1;
                objectArray = objectArray2;
                objectArray2[1] = leaf2;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = leaf2;
                objectArray = objectArray3;
                objectArray3[1] = leaf1;
            }
            return new IndexedNode(newBitmap, n, objectArray);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    public static final class EmptyNode<K, V>
    extends AbstractNode<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final EmptyNode<?, ?> INSTANCE = new EmptyNode();

        private EmptyNode() {
        }

        static <K, V> EmptyNode<K, V> instance() {
            return INSTANCE;
        }

        @Override
        Option<V> lookup(int shift, int keyHashCode, K key) {
            return Option.none();
        }

        @Override
        AbstractNode<K, V> modify(int shift, int keyHashCode, K key, V value2, Action action) {
            return action == Action.REMOVE ? this : new LeafSingleton<K, V>(keyHashCode, key, value2);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<LeafNode<K, V>> nodes() {
            return Iterator.empty();
        }

        public int hashCode() {
            return 1;
        }
    }

    public static abstract class AbstractNode<K, V>
    implements HashArrayMappedTrie<K, V> {
        static int bitCount(int x) {
            x -= x >> 1 & 0x55555555;
            x = (x & 0x33333333) + (x >> 2 & 0x33333333);
            x = x + (x >> 4) & 0xF0F0F0F;
            x += x >> 8;
            x += x >> 16;
            return x & 0x7F;
        }

        static int hashFragment(int shift, int hash) {
            return hash >>> shift & 0x1F;
        }

        static int toBitmap(int hash) {
            return 1 << hash;
        }

        static int fromBitmap(int bitmap, int bit) {
            return AbstractNode.bitCount(bitmap & bit - 1);
        }

        static Object[] update(Object[] arr, int index2, Object newElement) {
            Object[] newArr = Arrays.copyOf(arr, arr.length);
            newArr[index2] = newElement;
            return newArr;
        }

        static Object[] remove(Object[] arr, int index2) {
            Object[] newArr = new Object[arr.length - 1];
            System.arraycopy(arr, 0, newArr, 0, index2);
            System.arraycopy(arr, index2 + 1, newArr, index2, arr.length - index2 - 1);
            return newArr;
        }

        static Object[] insert(Object[] arr, int index2, Object newElem) {
            Object[] newArr = new Object[arr.length + 1];
            System.arraycopy(arr, 0, newArr, 0, index2);
            newArr[index2] = newElem;
            System.arraycopy(arr, index2, newArr, index2 + 1, arr.length - index2);
            return newArr;
        }

        abstract Option<V> lookup(int var1, int var2, K var3);

        abstract AbstractNode<K, V> modify(int var1, int var2, K var3, V var4, Action var5);

        Iterator<LeafNode<K, V>> nodes() {
            return new LeafNodeIterator(this);
        }

        @Override
        public Iterator<Tuple2<K, V>> iterator() {
            return this.nodes().map(node -> Tuple.of(node.key(), node.value()));
        }

        @Override
        public Iterator<K> keysIterator() {
            return this.nodes().map(LeafNode::key);
        }

        @Override
        public Option<V> get(K key) {
            return this.lookup(0, Objects.hashCode(key), key);
        }

        @Override
        public boolean containsKey(K key) {
            return this.get(key).isDefined();
        }

        @Override
        public HashArrayMappedTrie<K, V> put(K key, V value2) {
            return this.modify(0, Objects.hashCode(key), key, value2, Action.PUT);
        }

        @Override
        public HashArrayMappedTrie<K, V> remove(K key) {
            return this.modify(0, Objects.hashCode(key), key, null, Action.REMOVE);
        }

        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof HashArrayMappedTrie) {
                HashArrayMappedTrie that = (HashArrayMappedTrie)o;
                if (this.size() == that.size()) {
                    for (Tuple2 thisEntry : this) {
                        Option thatValue = that.get(thisEntry._1);
                        if (thatValue.isDefined() && thatValue.get().equals(thisEntry._2)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        public final String toString() {
            return this.iterator().map(t -> t._1 + " -> " + t._2).mkString("HashArrayMappedTrie(", ", ", ")");
        }
    }

    public static class LeafNodeIterator<K, V>
    extends AbstractIterator<LeafNode<K, V>> {
        private final int total;
        private final Object[] nodes = new Object[8];
        private final int[] indexes = new int[8];
        private int level;
        private int ptr = 0;

        LeafNodeIterator(AbstractNode<K, V> root2) {
            this.total = root2.size();
            this.level = LeafNodeIterator.downstairs(this.nodes, this.indexes, root2, 0);
        }

        @Override
        public boolean hasNext() {
            return this.ptr < this.total;
        }

        @Override
        protected LeafNode<K, V> getNext() {
            Object node = this.nodes[this.level];
            while (!(node instanceof LeafNode)) {
                node = this.findNextLeaf();
            }
            ++this.ptr;
            if (node instanceof LeafList) {
                LeafList leaf = (LeafList)node;
                this.nodes[this.level] = leaf.tail;
                return leaf;
            }
            this.nodes[this.level] = EmptyNode.instance();
            return (LeafSingleton)node;
        }

        private Object findNextLeaf() {
            AbstractNode<K, V> node = null;
            while (this.level > 0) {
                int n = --this.level;
                this.indexes[n] = this.indexes[n] + 1;
                node = LeafNodeIterator.getChild((AbstractNode)this.nodes[this.level], this.indexes[this.level]);
                if (node == null) continue;
            }
            this.level = LeafNodeIterator.downstairs(this.nodes, this.indexes, node, this.level + 1);
            return this.nodes[this.level];
        }

        private static <K, V> int downstairs(Object[] nodes, int[] indexes2, AbstractNode<K, V> root2, int level) {
            while (true) {
                nodes[level] = root2;
                indexes2[level] = 0;
                if ((root2 = LeafNodeIterator.getChild(root2, 0)) == null) break;
                ++level;
            }
            return level;
        }

        private static <K, V> AbstractNode<K, V> getChild(AbstractNode<K, V> node, int index2) {
            if (node instanceof IndexedNode) {
                Object[] subNodes = ((IndexedNode)node).subNodes;
                return index2 < subNodes.length ? (AbstractNode)subNodes[index2] : null;
            }
            if (node instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)node;
                return index2 < 32 ? (AbstractNode)arrayNode.subNodes[index2] : null;
            }
            return null;
        }
    }

    public static enum Action {
        PUT,
        REMOVE;

    }
}

