/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.spi;

import java.util.List;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableList;
import org.jetbrains.kotlin.com.google.inject.internal.util.StackTraceElements;

final class ModuleSource {
    private final String moduleClassName;
    private final ModuleSource parent;
    private final StackTraceElements.InMemoryStackTraceElement[] partialCallStack;

    ModuleSource(Object module2, StackTraceElement[] partialCallStack) {
        this(null, module2, partialCallStack);
    }

    private ModuleSource(ModuleSource parent2, Object module2, StackTraceElement[] partialCallStack) {
        Preconditions.checkNotNull(module2, "module cannot be null.");
        Preconditions.checkNotNull(partialCallStack, "partialCallStack cannot be null.");
        this.parent = parent2;
        this.moduleClassName = module2.getClass().getName();
        this.partialCallStack = StackTraceElements.convertToInMemoryStackTraceElement(partialCallStack);
    }

    String getModuleClassName() {
        return this.moduleClassName;
    }

    StackTraceElement[] getPartialCallStack() {
        return StackTraceElements.convertToStackTraceElement(this.partialCallStack);
    }

    int getPartialCallStackSize() {
        return this.partialCallStack.length;
    }

    ModuleSource createChild(Object module2, StackTraceElement[] partialCallStack) {
        return new ModuleSource(this, module2, partialCallStack);
    }

    ModuleSource getParent() {
        return this.parent;
    }

    List<String> getModuleClassNames() {
        ImmutableList.Builder classNames2 = ImmutableList.builder();
        ModuleSource current = this;
        while (current != null) {
            String className2 = current.moduleClassName;
            classNames2.add(className2);
            current = current.parent;
        }
        return classNames2.build();
    }

    int size() {
        if (this.parent == null) {
            return 1;
        }
        return this.parent.size() + 1;
    }

    int getStackTraceSize() {
        if (this.parent == null) {
            return this.partialCallStack.length;
        }
        return this.parent.getStackTraceSize() + this.partialCallStack.length;
    }

    StackTraceElement[] getStackTrace() {
        int stackTraceSize = this.getStackTraceSize();
        StackTraceElement[] callStack = new StackTraceElement[stackTraceSize];
        int cursor = 0;
        ModuleSource current = this;
        while (current != null) {
            StackTraceElement[] chunk = StackTraceElements.convertToStackTraceElement(current.partialCallStack);
            int chunkSize = chunk.length;
            System.arraycopy(chunk, 0, callStack, cursor, chunkSize);
            current = current.parent;
            cursor += chunkSize;
        }
        return callStack;
    }
}

