/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.core.CoreBundle;
import org.jetbrains.kotlin.com.intellij.model.ModelBranch;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.CompactVirtualFileSet;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.search.DelegatingGlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.ProjectAwareFileFilter;
import org.jetbrains.kotlin.com.intellij.psi.search.ProjectScope;
import org.jetbrains.kotlin.com.intellij.psi.search.PsiSearchScopeUtil;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public abstract class GlobalSearchScope
extends SearchScope
implements ProjectAwareFileFilter {
    public static final GlobalSearchScope[] EMPTY_ARRAY = new GlobalSearchScope[0];
    @Nullable
    private final Project myProject;
    public static final GlobalSearchScope EMPTY_SCOPE = new EmptyScope();

    protected GlobalSearchScope(@Nullable Project project) {
        this.myProject = project;
    }

    protected GlobalSearchScope() {
        this(null);
    }

    @Override
    @ApiStatus.NonExtendable
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            GlobalSearchScope.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(1);
        }
        return 0;
    }

    public abstract boolean isSearchInModuleContent(@NotNull Module var1);

    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            GlobalSearchScope.$$$reportNull$$$0(2);
        }
        return this.isSearchInModuleContent(aModule);
    }

    @Override
    public final boolean accept(@NotNull VirtualFile file2) {
        if (file2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(3);
        }
        return this.contains(file2);
    }

    public abstract boolean isSearchInLibraries();

    public boolean isForceSearchingInLibrarySources() {
        return false;
    }

    @NotNull
    public Collection<Object> getUnloadedModulesBelongingToScope() {
        Set<Object> set = Collections.emptySet();
        if (set == null) {
            GlobalSearchScope.$$$reportNull$$$0(4);
        }
        return set;
    }

    @ApiStatus.Experimental
    @NotNull
    public Collection<ModelBranch> getModelBranchesAffectingScope() {
        Set<ModelBranch> set = Collections.emptySet();
        if (set == null) {
            GlobalSearchScope.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(6);
        }
        if (scope2 == this) {
            GlobalSearchScope globalSearchScope = this;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(7);
            }
            return globalSearchScope;
        }
        if (scope2 instanceof IntersectionScope && ((IntersectionScope)scope2).containsScope(this)) {
            GlobalSearchScope globalSearchScope = scope2;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(8);
            }
            return globalSearchScope;
        }
        return new IntersectionScope(this, scope2);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        if (scope2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(9);
        }
        if (scope2 instanceof LocalSearchScope) {
            LocalSearchScope localScope2 = (LocalSearchScope)scope2;
            SearchScope searchScope = this.intersectWith(localScope2);
            if (searchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(10);
            }
            return searchScope;
        }
        GlobalSearchScope globalSearchScope = this.intersectWith((GlobalSearchScope)scope2);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(11);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public SearchScope intersectWith(@NotNull LocalSearchScope localScope2) {
        if (localScope2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(12);
        }
        PsiElement[] elements2 = localScope2.getScope();
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(elements2.length);
        for (PsiElement element2 : elements2) {
            if (!PsiSearchScopeUtil.isInScope(this, element2)) continue;
            result2.add(element2);
        }
        return result2.isEmpty() ? EMPTY_SCOPE : new LocalSearchScope(result2.toArray(PsiElement.EMPTY_ARRAY), null, localScope2.isIgnoreInjectedPsi());
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope union(@NotNull SearchScope scope2) {
        if (scope2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(13);
        }
        if (scope2 instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = this.uniteWith((GlobalSearchScope)scope2);
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(14);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.union((LocalSearchScope)scope2);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(15);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope union(final @NotNull LocalSearchScope scope2) {
        PsiElement[] localScopeElements;
        if (scope2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(16);
        }
        if ((localScopeElements = scope2.getScope()).length == 0) {
            GlobalSearchScope globalSearchScope = this;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(17);
            }
            return globalSearchScope;
        }
        return new GlobalSearchScope(localScopeElements[0].getProject()){

            @Override
            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return GlobalSearchScope.this.contains(file2) || scope2.isInScope(file2);
            }

            @Override
            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return GlobalSearchScope.this.contains(file1) && GlobalSearchScope.this.contains(file2) ? GlobalSearchScope.this.compare(file1, file2) : 0;
            }

            @Override
            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    1.$$$reportNull$$$0(3);
                }
                return GlobalSearchScope.this.isSearchInModuleContent(aModule);
            }

            @Override
            public boolean isSearchInLibraries() {
                return GlobalSearchScope.this.isSearchInLibraries();
            }

            @Override
            @NotNull
            public Collection<Object> getUnloadedModulesBelongingToScope() {
                Collection<Object> collection = GlobalSearchScope.this.getUnloadedModulesBelongingToScope();
                if (collection == null) {
                    1.$$$reportNull$$$0(4);
                }
                return collection;
            }

            @Override
            @NotNull
            public Collection<ModelBranch> getModelBranchesAffectingScope() {
                Collection<ModelBranch> collection = GlobalSearchScope.this.getModelBranchesAffectingScope();
                if (collection == null) {
                    1.$$$reportNull$$$0(5);
                }
                return collection;
            }

            @NonNls
            public String toString() {
                return "UnionToLocal: (" + GlobalSearchScope.this + ", " + scope2 + ")";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: 
                    case 5: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnloadedModulesBelongingToScope";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getModelBranchesAffectingScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "contains";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "compare";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isSearchInModuleContent";
                        break;
                    }
                    case 4: 
                    case 5: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(18);
        }
        GlobalSearchScope globalSearchScope = UnionScope.create(new GlobalSearchScope[]{this, scope2});
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(19);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope union(@NotNull Collection<? extends GlobalSearchScope> scopes) {
        if (scopes == null) {
            GlobalSearchScope.$$$reportNull$$$0(20);
        }
        if (scopes.isEmpty()) {
            throw new IllegalArgumentException("Empty scope collection");
        }
        if (scopes.size() == 1) {
            GlobalSearchScope globalSearchScope = scopes.iterator().next();
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(21);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = UnionScope.create(scopes.toArray(EMPTY_ARRAY));
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(22);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope union(GlobalSearchScope @NotNull [] scopes) {
        if (scopes == null) {
            GlobalSearchScope.$$$reportNull$$$0(23);
        }
        if (scopes.length == 0) {
            throw new IllegalArgumentException("Empty scope array");
        }
        if (scopes.length == 1) {
            GlobalSearchScope globalSearchScope = scopes[0];
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(24);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = UnionScope.create(scopes);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(25);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope allScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(26);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getAllScope(project);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(27);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope projectScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(28);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope(project);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(29);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope everythingScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(30);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getEverythingScope(project);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(31);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope notScope(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(32);
        }
        return new NotScope(scope2);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(33);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(34);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithLibrariesScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(35);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleWithLibrariesScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(36);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithDependenciesScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(37);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleWithDependenciesScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(38);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleRuntimeScope(@NotNull Module module2, boolean includeTests) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(39);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleRuntimeScope(includeTests);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(40);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(41);
        }
        return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module2, true);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module2, boolean includeTests) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(42);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleWithDependenciesAndLibrariesScope(includeTests);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(43);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithDependentsScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(44);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleWithDependentsScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(45);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleTestsWithDependentsScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(46);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleTestsWithDependentsScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(47);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope fileScope(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GlobalSearchScope.$$$reportNull$$$0(48);
        }
        return new FileScope(psiFile.getProject(), psiFile.getVirtualFile(), null);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope fileScope(@NotNull Project project, VirtualFile virtualFile2) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(49);
        }
        return GlobalSearchScope.fileScope(project, virtualFile2, null);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope fileScope(@NotNull Project project, @Nullable VirtualFile virtualFile2, @Nullable @Nls String displayName) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(50);
        }
        return new FileScope(project, virtualFile2, displayName);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files2) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(51);
        }
        if (files2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(52);
        }
        return GlobalSearchScope.filesScope(project, files2, null);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope filesWithoutLibrariesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files2) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(53);
        }
        if (files2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(54);
        }
        if (files2.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(55);
            }
            return globalSearchScope;
        }
        return new FilesScope(project, files2, false);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope filesWithLibrariesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files2) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(56);
        }
        if (files2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(57);
        }
        if (files2.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(58);
            }
            return globalSearchScope;
        }
        return new FilesScope(project, files2, true);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files2, final @Nullable @Nls String displayName) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(59);
        }
        if (files2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(60);
        }
        if (files2.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(61);
            }
            return globalSearchScope;
        }
        return files2.size() == 1 ? GlobalSearchScope.fileScope(project, files2.iterator().next(), displayName) : new FilesScope(project, files2){

            @Override
            @NotNull
            public String getDisplayName() {
                String string2 = displayName == null ? super.getDisplayName() : displayName;
                if (string2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope$2", "getDisplayName"));
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope getScopeRestrictedByFileTypes(@NotNull GlobalSearchScope scope2, FileType ... fileTypes) {
        if (scope2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(62);
        }
        if (fileTypes == null) {
            GlobalSearchScope.$$$reportNull$$$0(63);
        }
        if (scope2 == EMPTY_SCOPE) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(64);
            }
            return globalSearchScope;
        }
        if (fileTypes.length == 0) {
            throw new IllegalArgumentException("empty fileTypes");
        }
        return new FileTypeRestrictionScope(scope2, fileTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: 
            case 47: 
            case 55: 
            case 58: 
            case 61: 
            case 64: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: 
            case 47: 
            case 55: 
            case 58: 
            case 61: 
            case 64: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: 
            case 47: 
            case 55: 
            case 58: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope";
                break;
            }
            case 6: 
            case 13: 
            case 16: 
            case 18: 
            case 32: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localScope2";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 52: 
            case 54: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelBranchesAffectingScope";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWith";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteWith";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "allScope";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "projectScope";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "everythingScope";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleScope";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithLibrariesScope";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithDependenciesScope";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleRuntimeScope";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithDependenciesAndLibrariesScope";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithDependentsScope";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleTestsWithDependentsScope";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "filesWithoutLibrariesScope";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "filesWithLibrariesScope";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "filesScope";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeRestrictedByFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: 
            case 47: 
            case 55: 
            case 58: 
            case 61: 
            case 64: {
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "intersectWith";
                break;
            }
            case 13: 
            case 16: 
            case 20: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "uniteWith";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "allScope";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "projectScope";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "everythingScope";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "notScope";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "moduleScope";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithLibrariesScope";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDependenciesScope";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "moduleRuntimeScope";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDependenciesAndLibrariesScope";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDependentsScope";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "moduleTestsWithDependentsScope";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "fileScope";
                break;
            }
            case 51: 
            case 52: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "filesScope";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "filesWithoutLibrariesScope";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "filesWithLibrariesScope";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getScopeRestrictedByFileTypes";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: 
            case 47: 
            case 55: 
            case 58: 
            case 61: 
            case 64: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FilesScope
    extends GlobalSearchScope
    implements Iterable<VirtualFile> {
        private final Set<? extends VirtualFile> myFiles;
        private volatile Boolean myHasFilesOutOfProjectRoots;

        private FilesScope(@Nullable Project project, @NotNull Collection<? extends VirtualFile> files2) {
            if (files2 == null) {
                FilesScope.$$$reportNull$$$0(0);
            }
            this(project, files2, null);
        }

        private FilesScope(@Nullable Project project, @NotNull Collection<? extends VirtualFile> files2, @Nullable Boolean hasFilesOutOfProjectRoots) {
            if (files2 == null) {
                FilesScope.$$$reportNull$$$0(1);
            }
            super(project);
            this.myFiles = new CompactVirtualFileSet(files2);
            ((CompactVirtualFileSet)this.myFiles).freeze();
            this.myHasFilesOutOfProjectRoots = hasFilesOutOfProjectRoots;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FilesScope.$$$reportNull$$$0(2);
            }
            return this.myFiles.contains(file2);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                FilesScope.$$$reportNull$$$0(3);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.hasFilesOutOfProjectRoots();
        }

        public boolean equals(Object o) {
            return this == o || o instanceof FilesScope && this.myFiles.equals(((FilesScope)o).myFiles);
        }

        @Override
        public int calcHashCode() {
            return this.myFiles.hashCode();
        }

        private boolean hasFilesOutOfProjectRoots() {
            Boolean result2 = this.myHasFilesOutOfProjectRoots;
            if (result2 == null) {
                Project project = this.getProject();
                this.myHasFilesOutOfProjectRoots = result2 = Boolean.valueOf(project != null && !project.isDefault() && ContainerUtil.find(this.myFiles, file2 -> FileIndexFacade.getInstance(project).getModuleForFile((VirtualFile)file2) != null) == null);
            }
            return result2;
        }

        public String toString() {
            List<? extends VirtualFile> files2 = ContainerUtil.getFirstItems(new ArrayList<VirtualFile>(this.myFiles), 20);
            return "Files: (" + files2 + "); search in libraries: " + (this.myHasFilesOutOfProjectRoots != null ? this.myHasFilesOutOfProjectRoots : "unknown");
        }

        @Override
        @NotNull
        public Iterator<VirtualFile> iterator() {
            Iterator<VirtualFile> iterator2 = this.myFiles.iterator();
            if (iterator2 == null) {
                FilesScope.$$$reportNull$$$0(4);
            }
            return iterator2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope$FilesScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope$FilesScope";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class FileScope
    extends GlobalSearchScope
    implements Iterable<VirtualFile> {
        private final VirtualFile myVirtualFile;
        @Nullable
        @Nls
        private final String myDisplayName;
        private final Module myModule;

        private FileScope(@NotNull Project project, @Nullable VirtualFile virtualFile2, @Nullable @Nls String displayName) {
            if (project == null) {
                FileScope.$$$reportNull$$$0(0);
            }
            super(project);
            this.myVirtualFile = virtualFile2;
            this.myDisplayName = displayName;
            FileIndexFacade facade = project.isDefault() ? null : FileIndexFacade.getInstance(project);
            this.myModule = virtualFile2 == null || facade == null ? null : facade.getModuleForFile(virtualFile2);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FileScope.$$$reportNull$$$0(1);
            }
            return Comparing.equal(this.myVirtualFile, file2);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                FileScope.$$$reportNull$$$0(2);
            }
            return aModule == this.myModule;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myModule == null;
        }

        public String toString() {
            return "File :" + this.myVirtualFile;
        }

        @Override
        @NotNull
        public Iterator<VirtualFile> iterator() {
            Iterator<VirtualFile> iterator2 = Collections.singletonList(this.myVirtualFile).iterator();
            if (iterator2 == null) {
                FileScope.$$$reportNull$$$0(3);
            }
            return iterator2;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string2 = this.myDisplayName != null ? this.myDisplayName : super.getDisplayName();
            if (string2 == null) {
                FileScope.$$$reportNull$$$0(4);
            }
            return string2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            FileScope files2 = (FileScope)o;
            return Objects.equals(this.myVirtualFile, files2.myVirtualFile) && Objects.equals(this.myDisplayName, files2.myDisplayName) && Objects.equals(this.myModule, files2.myModule);
        }

        @Override
        protected int calcHashCode() {
            return Objects.hash(this.myVirtualFile, this.myModule, this.myDisplayName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope$FileScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope$FileScope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EmptyScope
    extends GlobalSearchScope {
        private EmptyScope() {
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                EmptyScope.$$$reportNull$$$0(0);
            }
            return false;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                EmptyScope.$$$reportNull$$$0(1);
            }
            return false;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope2) {
            if (scope2 == null) {
                EmptyScope.$$$reportNull$$$0(2);
            }
            EmptyScope emptyScope2 = this;
            if (emptyScope2 == null) {
                EmptyScope.$$$reportNull$$$0(3);
            }
            return emptyScope2;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope2) {
            if (scope2 == null) {
                EmptyScope.$$$reportNull$$$0(4);
            }
            GlobalSearchScope globalSearchScope = scope2;
            if (globalSearchScope == null) {
                EmptyScope.$$$reportNull$$$0(5);
            }
            return globalSearchScope;
        }

        public String toString() {
            return "EMPTY";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope$EmptyScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope$EmptyScope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intersectWith";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectWith";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class FileTypeRestrictionScope
    extends DelegatingGlobalSearchScope {
        private final FileType[] myFileTypes;

        private FileTypeRestrictionScope(@NotNull GlobalSearchScope scope2, FileType @NotNull [] fileTypes) {
            if (scope2 == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(0);
            }
            if (fileTypes == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(1);
            }
            super(scope2);
            this.myFileTypes = fileTypes;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(2);
            }
            if (!super.contains(file2)) {
                return false;
            }
            for (FileType otherFileType : this.myFileTypes) {
                if (!FileTypeRegistry.getInstance().isFileOfType(file2, otherFileType)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope2) {
            if (scope2 == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(3);
            }
            if (scope2 instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope2;
                if (restrict.myBaseScope == this.myBaseScope) {
                    ArrayList<FileType> intersection = new ArrayList<FileType>(Arrays.asList(restrict.myFileTypes));
                    intersection.retainAll(Arrays.asList(this.myFileTypes));
                    return new FileTypeRestrictionScope(this.myBaseScope, intersection.toArray(FileType.EMPTY_ARRAY));
                }
            }
            GlobalSearchScope globalSearchScope = super.intersectWith(scope2);
            if (globalSearchScope == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(4);
            }
            return globalSearchScope;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope2) {
            if (scope2 == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(5);
            }
            if (scope2 instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope2;
                if (restrict.myBaseScope == this.myBaseScope) {
                    return new FileTypeRestrictionScope(this.myBaseScope, ArrayUtil.mergeArrays(this.myFileTypes, restrict.myFileTypes));
                }
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope2);
            if (globalSearchScope == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(6);
            }
            return globalSearchScope;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileTypeRestrictionScope)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FileTypeRestrictionScope that = (FileTypeRestrictionScope)o;
            return Arrays.equals(this.myFileTypes, that.myFileTypes);
        }

        @Override
        public int calcHashCode() {
            int result2 = super.calcHashCode();
            result2 = 31 * result2 + Arrays.hashCode(this.myFileTypes);
            return result2;
        }

        @Override
        public String toString() {
            return "(restricted by file types: " + Arrays.asList(this.myFileTypes) + " in " + this.myBaseScope + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileTypes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intersectWith";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectWith";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class UnionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope[] myScopes;

        @NotNull
        static GlobalSearchScope create(GlobalSearchScope @NotNull [] scopes) {
            GlobalSearchScope unionScope;
            if (scopes == null) {
                UnionScope.$$$reportNull$$$0(0);
            }
            if (scopes.length == 2 && (unionScope = UnionScope.tryCreateUnionFor2Scopes(scopes)) != null) {
                GlobalSearchScope globalSearchScope = unionScope;
                if (globalSearchScope == null) {
                    UnionScope.$$$reportNull$$$0(1);
                }
                return globalSearchScope;
            }
            THashSet<GlobalSearchScope> result2 = new THashSet<GlobalSearchScope>(scopes.length);
            Project project = null;
            for (GlobalSearchScope scope2 : scopes) {
                if (scope2 == EMPTY_SCOPE) continue;
                Project scopeProject = scope2.getProject();
                if (scopeProject != null) {
                    project = scopeProject;
                }
                if (scope2 instanceof UnionScope) {
                    ContainerUtil.addAll(result2, ((UnionScope)scope2).myScopes);
                    continue;
                }
                result2.add(scope2);
            }
            if (result2.isEmpty()) {
                GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
                if (globalSearchScope == null) {
                    UnionScope.$$$reportNull$$$0(2);
                }
                return globalSearchScope;
            }
            if (result2.size() == 1) {
                GlobalSearchScope globalSearchScope = (GlobalSearchScope)result2.iterator().next();
                if (globalSearchScope == null) {
                    UnionScope.$$$reportNull$$$0(3);
                }
                return globalSearchScope;
            }
            return new UnionScope(project, result2.toArray(EMPTY_ARRAY));
        }

        @Nullable
        private static GlobalSearchScope tryCreateUnionFor2Scopes(GlobalSearchScope @NotNull [] scopes) {
            if (scopes == null) {
                UnionScope.$$$reportNull$$$0(4);
            }
            assert (scopes.length == 2);
            GlobalSearchScope scope0 = scopes[0];
            GlobalSearchScope scope1 = scopes[1];
            if (scope0 == EMPTY_SCOPE) {
                return scope1;
            }
            if (scope1 == EMPTY_SCOPE) {
                return scope0;
            }
            if (scope0 instanceof UnionScope && scope1 instanceof UnionScope) {
                return null;
            }
            Project project = ObjectUtils.chooseNotNull(scope0.getProject(), scope1.getProject());
            if (scope0 instanceof UnionScope) {
                return UnionScope.unionWithUnionScope(scope0, scope1, project);
            }
            if (scope1 instanceof UnionScope) {
                return UnionScope.unionWithUnionScope(scope1, scope0, project);
            }
            return new UnionScope(project, scopes);
        }

        @NotNull
        private static GlobalSearchScope unionWithUnionScope(GlobalSearchScope scope0, GlobalSearchScope scope1, Project project) {
            GlobalSearchScope[] scopes0 = ((UnionScope)scope0).myScopes;
            if (ArrayUtil.contains(scope1, scopes0)) {
                GlobalSearchScope globalSearchScope = scope0;
                if (globalSearchScope == null) {
                    UnionScope.$$$reportNull$$$0(5);
                }
                return globalSearchScope;
            }
            return new UnionScope(project, ArrayUtil.append(scopes0, scope1));
        }

        private UnionScope(Project project, GlobalSearchScope @NotNull [] scopes) {
            if (scopes == null) {
                UnionScope.$$$reportNull$$$0(6);
            }
            super(project);
            this.myScopes = scopes;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string2 = CoreBundle.message("psi.search.scope.union", this.myScopes[0].getDisplayName(), this.myScopes[1].getDisplayName());
            if (string2 == null) {
                UnionScope.$$$reportNull$$$0(7);
            }
            return string2;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                UnionScope.$$$reportNull$$$0(8);
            }
            return ContainerUtil.find(this.myScopes, scope2 -> scope2.contains(file2)) != null;
        }

        @Override
        @NotNull
        public Collection<Object> getUnloadedModulesBelongingToScope() {
            LinkedHashSet<Object> result2 = new LinkedHashSet<Object>();
            for (GlobalSearchScope scope2 : this.myScopes) {
                result2.addAll(scope2.getUnloadedModulesBelongingToScope());
            }
            LinkedHashSet<Object> linkedHashSet = result2;
            if (linkedHashSet == null) {
                UnionScope.$$$reportNull$$$0(9);
            }
            return linkedHashSet;
        }

        @Override
        @NotNull
        public Collection<ModelBranch> getModelBranchesAffectingScope() {
            LinkedHashSet<ModelBranch> result2 = new LinkedHashSet<ModelBranch>();
            for (GlobalSearchScope scope2 : this.myScopes) {
                result2.addAll(scope2.getModelBranchesAffectingScope());
            }
            LinkedHashSet<ModelBranch> linkedHashSet = result2;
            if (linkedHashSet == null) {
                UnionScope.$$$reportNull$$$0(10);
            }
            return linkedHashSet;
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                UnionScope.$$$reportNull$$$0(11);
            }
            if (file2 == null) {
                UnionScope.$$$reportNull$$$0(12);
            }
            int[] result2 = new int[]{0};
            ContainerUtil.process(this.myScopes, scope2 -> {
                if (!scope2.contains(file1) || !scope2.contains(file2)) {
                    return true;
                }
                int cmp = scope2.compare(file1, file2);
                if (result2[0] == 0) {
                    result2[0] = cmp;
                    return true;
                }
                if (cmp == 0) {
                    return true;
                }
                if (result2[0] > 0 == cmp > 0) {
                    return true;
                }
                result2[0] = 0;
                return false;
            });
            return result2[0];
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module module2) {
            if (module2 == null) {
                UnionScope.$$$reportNull$$$0(13);
            }
            return ContainerUtil.find(this.myScopes, scope2 -> scope2.isSearchInModuleContent(module2)) != null;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module module2, boolean testSources) {
            if (module2 == null) {
                UnionScope.$$$reportNull$$$0(14);
            }
            return ContainerUtil.find(this.myScopes, scope2 -> scope2.isSearchInModuleContent(module2, testSources)) != null;
        }

        @Override
        public boolean isSearchInLibraries() {
            return ContainerUtil.find(this.myScopes, GlobalSearchScope::isSearchInLibraries) != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnionScope)) {
                return false;
            }
            UnionScope that = (UnionScope)o;
            return ContainerUtil.set(this.myScopes).equals(ContainerUtil.set(that.myScopes));
        }

        @Override
        public int calcHashCode() {
            return Arrays.hashCode(this.myScopes);
        }

        @NonNls
        public String toString() {
            return "Union: (" + StringUtil.join(Arrays.asList(this.myScopes), ",") + ")";
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope2) {
            if (scope2 == null) {
                UnionScope.$$$reportNull$$$0(15);
            }
            if (scope2 instanceof UnionScope) {
                GlobalSearchScope[] newScopes = ArrayUtil.mergeArrays(this.myScopes, ((UnionScope)scope2).myScopes);
                return UnionScope.create(newScopes);
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope2);
            if (globalSearchScope == null) {
                UnionScope.$$$reportNull$$$0(16);
            }
            return globalSearchScope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 16: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopes";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope$UnionScope";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope$UnionScope";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unionWithUnionScope";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnloadedModulesBelongingToScope";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModelBranchesAffectingScope";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 16: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "tryCreateUnionFor2Scopes";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 16: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class IntersectionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myScope1;
        private final GlobalSearchScope myScope2;

        private IntersectionScope(@NotNull GlobalSearchScope scope1, @NotNull GlobalSearchScope scope2) {
            if (scope1 == null) {
                IntersectionScope.$$$reportNull$$$0(0);
            }
            if (scope2 == null) {
                IntersectionScope.$$$reportNull$$$0(1);
            }
            super(scope1.getProject() == null ? scope2.getProject() : scope1.getProject());
            this.myScope1 = scope1;
            this.myScope2 = scope2;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope2) {
            if (scope2 == null) {
                IntersectionScope.$$$reportNull$$$0(2);
            }
            return this.containsScope(scope2) ? this : new IntersectionScope(this, scope2);
        }

        private boolean containsScope(@NotNull GlobalSearchScope scope2) {
            if (scope2 == null) {
                IntersectionScope.$$$reportNull$$$0(3);
            }
            if (this.myScope1.equals(scope2) || this.myScope2.equals(scope2) || this.equals(scope2)) {
                return true;
            }
            if (this.myScope1 instanceof IntersectionScope && ((IntersectionScope)this.myScope1).containsScope(scope2)) {
                return true;
            }
            return this.myScope2 instanceof IntersectionScope && ((IntersectionScope)this.myScope2).containsScope(scope2);
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string2 = CoreBundle.message("psi.search.scope.intersection", this.myScope1.getDisplayName(), this.myScope2.getDisplayName());
            if (string2 == null) {
                IntersectionScope.$$$reportNull$$$0(4);
            }
            return string2;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                IntersectionScope.$$$reportNull$$$0(5);
            }
            return this.myScope1.contains(file2) && this.myScope2.contains(file2);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                IntersectionScope.$$$reportNull$$$0(6);
            }
            if (file2 == null) {
                IntersectionScope.$$$reportNull$$$0(7);
            }
            int res1 = this.myScope1.compare(file1, file2);
            int res2 = this.myScope2.compare(file1, file2);
            if (res1 == 0) {
                return res2;
            }
            if (res2 == 0) {
                return res1;
            }
            if (res1 > 0 == res2 > 0) {
                return res1;
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                IntersectionScope.$$$reportNull$$$0(8);
            }
            return this.myScope1.isSearchInModuleContent(aModule) && this.myScope2.isSearchInModuleContent(aModule);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                IntersectionScope.$$$reportNull$$$0(9);
            }
            return this.myScope1.isSearchInModuleContent(aModule, testSources) && this.myScope2.isSearchInModuleContent(aModule, testSources);
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myScope1.isSearchInLibraries() && this.myScope2.isSearchInLibraries();
        }

        @Override
        @NotNull
        public Collection<Object> getUnloadedModulesBelongingToScope() {
            Collection<Object> collection = ContainerUtil.intersection(this.myScope1.getUnloadedModulesBelongingToScope(), this.myScope2.getUnloadedModulesBelongingToScope());
            if (collection == null) {
                IntersectionScope.$$$reportNull$$$0(10);
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<ModelBranch> getModelBranchesAffectingScope() {
            Collection<ModelBranch> collection = ContainerUtil.intersection(this.myScope1.getModelBranchesAffectingScope(), this.myScope2.getModelBranchesAffectingScope());
            if (collection == null) {
                IntersectionScope.$$$reportNull$$$0(11);
            }
            return collection;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntersectionScope)) {
                return false;
            }
            IntersectionScope that = (IntersectionScope)o;
            return this.myScope1.equals(that.myScope1) && this.myScope2.equals(that.myScope2);
        }

        @Override
        public int calcHashCode() {
            return 31 * this.myScope1.hashCode() + this.myScope2.hashCode();
        }

        @NonNls
        public String toString() {
            return "Intersection: (" + this.myScope1 + ", " + this.myScope2 + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 10: 
                case 11: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope2";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 4: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope$IntersectionScope";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope$IntersectionScope";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnloadedModulesBelongingToScope";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModelBranchesAffectingScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectWith";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "containsScope";
                    break;
                }
                case 4: 
                case 10: 
                case 11: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class NotScope
    extends DelegatingGlobalSearchScope {
        private NotScope(@NotNull GlobalSearchScope scope2) {
            if (scope2 == null) {
                NotScope.$$$reportNull$$$0(0);
            }
            super(scope2);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                NotScope.$$$reportNull$$$0(1);
            }
            return !this.myBaseScope.contains(file2);
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                NotScope.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                NotScope.$$$reportNull$$$0(3);
            }
            return true;
        }

        @Override
        public String toString() {
            return "NOT: " + this.myBaseScope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope$NotScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

