/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.jvm.JvmBuiltInsSignatures;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.EffectiveVisibilityUtilsKt;
import org.jetbrains.kotlin.fir.EnumClassUtilsKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirVersionRequirementsTableKeyKt;
import org.jetbrains.kotlin.fir.declarations.SealedClassInheritorsKt;
import org.jetbrains.kotlin.fir.declarations.builder.FirEnumEntryBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirOuterClassTypeParameterRefBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirRegularClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.comparators.FirMemberDeclarationComparator;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationBuildingUtilsKt;
import org.jetbrains.kotlin.fir.deserialization.AbstractAnnotationDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirBuiltinAnnotationDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirDeserializationContext;
import org.jetbrains.kotlin.fir.deserialization.FirMemberDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirTypeDeserializer;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirCloneableSymbolProvider;
import org.jetbrains.kotlin.fir.scopes.FirScopeProvider;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoBufUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.GeneratedMessageLite;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoEnumFlags;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0086\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\u001a\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\f0\u001e\u001a\u001e\u0010\u001f\u001a\u00020\u0007*\u00020 2\u0006\u0010\b\u001a\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002\u001a\u0014\u0010#\u001a\u00020\u0007*\u00020 2\u0006\u0010\b\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"ARRAY", "Lorg/jetbrains/kotlin/name/Name;", "ARRAY_CLASSES", "", "JAVA_IO_SERIALIZABLE", "Lorg/jetbrains/kotlin/name/ClassId;", "deserializeClassToSymbol", "", "classId", "classProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "defaultAnnotationDeserializer", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractAnnotationDeserializer;", "scopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirScopeProvider;", "parentContext", "Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;", "containerSource", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "origin", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOrigin;", "deserializeNestedClass", "Lkotlin/Function2;", "addCloneForArrayIfNeeded", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirRegularClassBuilder;", "dispatchReceiver", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "addSerializableIfNeeded", "fir-deserialization"})
public final class ClassDeserializationKt {
    @NotNull
    private static final Name ARRAY;
    @NotNull
    private static final Set<Name> ARRAY_CLASSES;
    @NotNull
    private static final ClassId JAVA_IO_SERIALIZABLE;

    /*
     * WARNING - void declaration
     */
    public static final void deserializeClassToSymbol(@NotNull ClassId classId, @NotNull ProtoBuf.Class classProto, @NotNull FirRegularClassSymbol symbol2, @NotNull NameResolver nameResolver2, @NotNull FirSession session2, @NotNull FirModuleData moduleData2, @Nullable AbstractAnnotationDeserializer defaultAnnotationDeserializer, @NotNull FirScopeProvider scopeProvider, @Nullable FirDeserializationContext parentContext, @Nullable DeserializedContainerSource containerSource, @NotNull FirDeclarationOrigin origin, @NotNull Function2<? super ClassId, ? super FirDeserializationContext, FirRegularClassSymbol> deserializeNestedClass) {
        Unit unit2;
        FirRegularClass firRegularClass;
        Object it$iv$iv;
        Iterable<ProtoBuf.EnumEntry> $this$mapNotNullTo$iv$iv;
        Object $this$mapNotNull$iv;
        Iterable<ProtoBuf.Property> $this$mapTo$iv$iv;
        Iterable<ProtoBuf.Property> $this$map$iv;
        FirPureAbstractElement firPureAbstractElement;
        FirResolvedTypeRef firResolvedTypeRef;
        Iterable<ProtoBuf.Function> $this$mapNotNullTo$iv;
        void $this$mapTo$iv$iv2;
        Object $this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d4_u24lambda_u2d3;
        FirElement firElement;
        Object object;
        Iterable $this$mapTo$iv$iv3;
        FirDeserializationContext $this$map$iv2;
        FirDeserializationContext context2;
        FirDeserializationContext firDeserializationContext;
        Object object2;
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(classProto, "classProto");
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        Intrinsics.checkNotNullParameter(nameResolver2, "nameResolver");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(moduleData2, "moduleData");
        Intrinsics.checkNotNullParameter(scopeProvider, "scopeProvider");
        Intrinsics.checkNotNullParameter(origin, "origin");
        Intrinsics.checkNotNullParameter(deserializeNestedClass, "deserializeNestedClass");
        int flags = classProto.getFlags();
        ProtoBuf.Class.Kind kind = Flags.CLASS_KIND.get(flags);
        Modality modality = ProtoEnumFlags.INSTANCE.modality(Flags.MODALITY.get(flags));
        Visibility visibility2 = ProtoEnumFlags.INSTANCE.visibility(Flags.VISIBILITY.get(flags));
        Object object3 = parentContext;
        Object $this$deserializeClassToSymbol_u24lambda_u2d0 = object3 = new FirResolvedDeclarationStatusImpl(visibility2, modality, EffectiveVisibilityUtilsKt.toEffectiveVisibility$default(visibility2, object3 == null ? null : ((FirDeserializationContext)object3).getOuterClassSymbol(), true, false, 4, null));
        boolean $i$a$-apply-ClassDeserializationKt$deserializeClassToSymbol$status$232 = false;
        Object object4 = Flags.IS_EXPECT_CLASS.get(flags);
        Intrinsics.checkNotNullExpressionValue(object4, "IS_EXPECT_CLASS.get(flags)");
        ((FirDeclarationStatusImpl)$this$deserializeClassToSymbol_u24lambda_u2d0).setExpect((Boolean)object4);
        ((FirDeclarationStatusImpl)$this$deserializeClassToSymbol_u24lambda_u2d0).setActual(false);
        ((FirDeclarationStatusImpl)$this$deserializeClassToSymbol_u24lambda_u2d0).setCompanion(kind == ProtoBuf.Class.Kind.COMPANION_OBJECT);
        object4 = Flags.IS_INNER.get(flags);
        Intrinsics.checkNotNullExpressionValue(object4, "IS_INNER.get(flags)");
        ((FirDeclarationStatusImpl)$this$deserializeClassToSymbol_u24lambda_u2d0).setInner((Boolean)object4);
        object4 = Flags.IS_DATA.get(classProto.getFlags());
        Intrinsics.checkNotNullExpressionValue(object4, "IS_DATA.get(classProto.flags)");
        ((FirDeclarationStatusImpl)$this$deserializeClassToSymbol_u24lambda_u2d0).setData((Boolean)object4);
        object4 = Flags.IS_INLINE_CLASS.get(classProto.getFlags());
        Intrinsics.checkNotNullExpressionValue(object4, "IS_INLINE_CLASS.get(classProto.flags)");
        ((FirDeclarationStatusImpl)$this$deserializeClassToSymbol_u24lambda_u2d0).setInline((Boolean)object4);
        object4 = Flags.IS_EXTERNAL_CLASS.get(classProto.getFlags());
        Intrinsics.checkNotNullExpressionValue(object4, "IS_EXTERNAL_CLASS.get(classProto.flags)");
        ((FirDeclarationStatusImpl)$this$deserializeClassToSymbol_u24lambda_u2d0).setExternal((Boolean)object4);
        object4 = Flags.IS_FUN_INTERFACE.get(classProto.getFlags());
        Intrinsics.checkNotNullExpressionValue(object4, "IS_FUN_INTERFACE.get(classProto.flags)");
        ((FirDeclarationStatusImpl)$this$deserializeClassToSymbol_u24lambda_u2d0).setFun((Boolean)object4);
        Object status2 = object3;
        boolean isSealed = modality == Modality.SEALED;
        AbstractAnnotationDeserializer $i$a$-apply-ClassDeserializationKt$deserializeClassToSymbol$status$232 = defaultAnnotationDeserializer;
        AbstractAnnotationDeserializer annotationDeserializer = $i$a$-apply-ClassDeserializationKt$deserializeClassToSymbol$status$232 == null ? (AbstractAnnotationDeserializer)new FirBuiltinAnnotationDeserializer(session2) : $i$a$-apply-ClassDeserializationKt$deserializeClassToSymbol$status$232;
        object4 = parentContext;
        if (object4 == null) {
            object2 = containerSource instanceof KotlinJvmBinarySourceElement ? (KotlinJvmBinarySourceElement)containerSource : null;
            firDeserializationContext = FirDeserializationContext.Companion.createForClass(classId, classProto, nameResolver2, moduleData2, annotationDeserializer, new FirConstDeserializer(session2, object2 == null ? null : ((KotlinJvmBinarySourceElement)object2).getBinaryClass()), containerSource, symbol2);
        } else {
            object2 = classProto.getTypeParameterList();
            Intrinsics.checkNotNullExpressionValue(object2, "classProto.typeParameterList");
            List<ProtoBuf.TypeParameter> list2 = object2;
            object2 = classProto.getTypeTable();
            Intrinsics.checkNotNullExpressionValue(object2, "classProto.typeTable");
            firDeserializationContext = context2 = FirDeserializationContext.childContext$default((FirDeserializationContext)object4, list2, nameResolver2, new TypeTable((ProtoBuf.TypeTable)object2), classId.getRelativeClassName(), containerSource, symbol2, annotationDeserializer, ((FirDeclarationStatusImpl)status2).isInner(), null, 256, null);
        }
        if (((FirDeclarationStatusImpl)status2).isCompanion()) {
            Unit unit3;
            object4 = parentContext;
            if (object4 == null) {
                unit3 = null;
            } else {
                Object it = object2 = object4;
                boolean bl2 = false;
                context2.getAnnotationDeserializer().inheritAnnotationInfo(((FirDeserializationContext)it).getAnnotationDeserializer());
                unit3 = Unit.INSTANCE;
            }
        }
        boolean $i$f$buildRegularClass = false;
        Object $this$deserializeClassToSymbol_u24lambda_u2d17 = object2 = new FirRegularClassBuilder();
        boolean bl322 = false;
        ((FirRegularClassBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17).setModuleData(moduleData2);
        ((FirRegularClassBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17).setOrigin(origin);
        Object object5 = classId.getShortClassName();
        Intrinsics.checkNotNullExpressionValue(object5, "classId.shortClassName");
        ((FirRegularClassBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17).setName((Name)object5);
        ((FirRegularClassBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17).setStatus((FirDeclarationStatus)status2);
        ((FirRegularClassBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17).setClassKind(ProtoEnumFlags.INSTANCE.classKind(kind));
        ((FirRegularClassBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17).setScopeProvider(scopeProvider);
        ((FirRegularClassBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17).setSymbol(symbol2);
        ((FirRegularClassBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17).setResolvePhase(FirResolvePhase.Companion.getANALYZED_DEPENDENCIES());
        object5 = $this$deserializeClassToSymbol_u24lambda_u2d17;
        Iterable iterable = context2.getTypeDeserializer().getOwnTypeParameters();
        Object object6 = ((FirRegularClassBuilder)object5).getTypeParameters();
        boolean $i$f$map22 = false;
        void var28_41 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            FirTypeParameterSymbol firTypeParameterSymbol = (FirTypeParameterSymbol)item$iv$iv;
            object = destination$iv$iv;
            boolean bl4 = false;
            firElement = (FirTypeParameter)firTypeParameterSymbol.getFir();
            object.add(firElement);
        }
        object = (List)destination$iv$iv;
        CollectionsKt.addAll(object6, (Iterable)object);
        if (((FirDeclarationStatusImpl)status2).isInner()) {
            List<FirTypeParameterSymbol> $i$f$map22;
            Collection<FirTypeParameterSymbol> collection;
            object5 = $this$deserializeClassToSymbol_u24lambda_u2d17;
            Collection collection2 = ((FirRegularClassBuilder)object5).getTypeParameters();
            $this$map$iv2 = parentContext;
            if ($this$map$iv2 == null) {
                collection = null;
            } else {
                void $this$mapTo$iv$iv4;
                void $this$map$iv22;
                $i$f$map22 = $this$map$iv2.getAllTypeParameters();
                $this$mapTo$iv$iv3 = $i$f$map22;
                object6 = collection2;
                boolean $i$f$map3 = false;
                void $i$f$mapTo22 = $this$map$iv22;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv22, 10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                    void it;
                    FirTypeParameterSymbol firTypeParameterSymbol = (FirTypeParameterSymbol)item$iv$iv2;
                    object = destination$iv$iv2;
                    boolean bl5 = false;
                    boolean $i$f$buildOuterClassTypeParameterRef = false;
                    FirOuterClassTypeParameterRefBuilder firOuterClassTypeParameterRefBuilder = new FirOuterClassTypeParameterRefBuilder();
                    $this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d4_u24lambda_u2d3 = firOuterClassTypeParameterRefBuilder;
                    boolean bl6 = false;
                    ((FirOuterClassTypeParameterRefBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d4_u24lambda_u2d3).setSymbol((FirTypeParameterSymbol)it);
                    firElement = firOuterClassTypeParameterRefBuilder.build();
                    object.add(firElement);
                }
                object = (List)destination$iv$iv2;
                collection2 = object6;
                collection = object;
            }
            $i$f$map22 = collection;
            CollectionsKt.addAll(collection2, (Iterable)($i$f$map22 == null ? CollectionsKt.emptyList() : $i$f$map22));
        }
        FirTypeDeserializer typeDeserializer = context2.getTypeDeserializer();
        FirMemberDeserializer classDeserializer = context2.getMemberDeserializer();
        Iterable $this$map$iv3 = ProtoTypeTableUtilKt.supertypes(classProto, context2.getTypeTable());
        boolean $i$f$map4 = false;
        Iterable $i$f$map3 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
        boolean $i$f$mapTo4 = false;
        for (Object t : $this$mapTo$iv$iv2) {
            void supertypeProto;
            ProtoBuf.Type item$iv$iv2 = (ProtoBuf.Type)t;
            object6 = destination$iv$iv3;
            boolean bl7 = false;
            object = typeDeserializer.simpleType((ProtoBuf.Type)supertypeProto, ConeAttributes.Companion.getEmpty());
            object6.add(object);
        }
        Iterable superTypesDeserialized = (List)destination$iv$iv3;
        $this$map$iv3 = superTypesDeserialized;
        Collection destination$iv = ((FirRegularClassBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17).getSuperTypeRefs();
        boolean $i$f$mapNotNullTo232 = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator<Object> $i$f$mapTo3 = $this$forEach$iv$iv.iterator();
        while ($i$f$mapTo3.hasNext()) {
            FirResolvedTypeRef firResolvedTypeRef2;
            Object t;
            Object element$iv = t = $i$f$mapTo3.next();
            boolean bl8 = false;
            ConeSimpleKotlinType it = (ConeSimpleKotlinType)element$iv;
            boolean bl9 = false;
            if (it == null) {
                firResolvedTypeRef2 = null;
            } else {
                boolean $i$f$buildResolvedTypeRef = false;
                Object $this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d7_u24lambda_u2d6 = $this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d4_u24lambda_u2d3 = new FirResolvedTypeRefBuilder();
                boolean bl10 = false;
                ((FirResolvedTypeRefBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d7_u24lambda_u2d6).setType(it);
                firResolvedTypeRef2 = ((FirResolvedTypeRefBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d4_u24lambda_u2d3).build();
            }
            firResolvedTypeRef = firResolvedTypeRef2;
            if (firResolvedTypeRef == null) continue;
            FirResolvedTypeRef it$iv = firPureAbstractElement = firResolvedTypeRef;
            boolean bl11 = false;
            destination$iv.add(it$iv);
        }
        $this$mapNotNullTo$iv = classProto.getFunctionList();
        Intrinsics.checkNotNullExpressionValue($this$mapNotNullTo$iv, "classProto.functionList");
        $this$mapNotNullTo$iv = $this$mapNotNullTo$iv;
        object6 = $this$deserializeClassToSymbol_u24lambda_u2d17;
        boolean $i$f$map = false;
        void $i$f$mapNotNullTo232 = $this$map$iv;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            void it;
            ProtoBuf.Function element$iv = (ProtoBuf.Function)t;
            object = destination$iv$iv2;
            boolean bl12 = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            firElement = classDeserializer.loadFunction((ProtoBuf.Function)it, classProto, symbol2);
            object.add(firElement);
        }
        object = (List)destination$iv$iv2;
        FirDeclarationBuildingUtilsKt.addDeclarations((FirRegularClassBuilder)object6, (Collection)object);
        $this$map$iv = classProto.getPropertyList();
        Intrinsics.checkNotNullExpressionValue($this$map$iv, "classProto.propertyList");
        $this$map$iv = $this$map$iv;
        object6 = $this$deserializeClassToSymbol_u24lambda_u2d17;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object object7 : $this$mapTo$iv$iv) {
            ProtoBuf.Property it = (ProtoBuf.Property)object7;
            object = destination$iv$iv2;
            boolean bl13 = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            firElement = classDeserializer.loadProperty(it, classProto, symbol2);
            object.add(firElement);
        }
        object = (List)destination$iv$iv2;
        FirDeclarationBuildingUtilsKt.addDeclarations((FirRegularClassBuilder)object6, (Collection)object);
        $this$map$iv = classProto.getConstructorList();
        Intrinsics.checkNotNullExpressionValue($this$map$iv, "classProto.constructorList");
        object6 = $this$deserializeClassToSymbol_u24lambda_u2d17;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object object8 : $this$mapTo$iv$iv) {
            ProtoBuf.Constructor it = (ProtoBuf.Constructor)object8;
            object = destination$iv$iv2;
            boolean bl14 = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            firElement = classDeserializer.loadConstructor(it, classProto, (FirRegularClassBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17);
            object.add(firElement);
        }
        object = (List)destination$iv$iv2;
        FirDeclarationBuildingUtilsKt.addDeclarations((FirRegularClassBuilder)object6, (Collection)object);
        $this$map$iv = classProto.getNestedClassNameList();
        Intrinsics.checkNotNullExpressionValue($this$map$iv, "classProto.nestedClassNameList");
        object6 = $this$deserializeClassToSymbol_u24lambda_u2d17;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable<ProtoBuf.EnumEntry> $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean bl = false;
        Iterator<Object> iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            Integer nestedNameId = (Integer)element$iv$iv;
            boolean bl15 = false;
            Intrinsics.checkNotNullExpressionValue(nestedNameId, "nestedNameId");
            Object $this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d7_u24lambda_u2d6 = classId.createNestedClassId(Name.identifier(nameResolver2.getString(nestedNameId)));
            Intrinsics.checkNotNullExpressionValue($this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d7_u24lambda_u2d6, "classId.createNestedClas\u2026getString(nestedNameId)))");
            ClassId nestedClassId = $this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d7_u24lambda_u2d6;
            $this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d7_u24lambda_u2d6 = deserializeNestedClass.invoke(nestedClassId, context2);
            FirPureAbstractElement firPureAbstractElement2 = firResolvedTypeRef = $this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d7_u24lambda_u2d6 == null ? null : (FirRegularClass)((FirBasedSymbol)$this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d7_u24lambda_u2d6).getFir();
            if (firResolvedTypeRef == null) continue;
            firPureAbstractElement = firResolvedTypeRef;
            it$iv$iv = firPureAbstractElement;
            boolean bl16 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        object = (List)destination$iv$iv2;
        FirDeclarationBuildingUtilsKt.addDeclarations((FirRegularClassBuilder)object6, (Collection)object);
        $this$mapNotNull$iv = classProto.getEnumEntryList();
        Intrinsics.checkNotNullExpressionValue($this$mapNotNull$iv, "classProto.enumEntryList");
        $this$mapNotNull$iv = (Iterable)$this$mapNotNull$iv;
        object6 = $this$deserializeClassToSymbol_u24lambda_u2d17;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean bl3 = false;
        iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirPureAbstractElement firPureAbstractElement3;
            FirPureAbstractElement property2;
            void $this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d14_u24lambda_u2d13;
            void $this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d14_u24lambda_u2d12;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl4 = false;
            ProtoBuf.EnumEntry enumEntryProto = (ProtoBuf.EnumEntry)element$iv$iv;
            boolean bl17 = false;
            Name enumEntryName = NameResolverUtilKt.getName(nameResolver2, enumEntryProto.getName());
            boolean $i$f$emptyArray = false;
            ConeClassLikeTypeImpl enumType = new ConeClassLikeTypeImpl(symbol2.toLookupTag(), new ConeTypeProjection[0], false, null, 8, null);
            boolean $i$f$buildEnumEntry = false;
            Object $this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d14 = it$iv$iv = new FirEnumEntryBuilder();
            boolean bl18 = false;
            ((FirEnumEntryBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d14).setModuleData(moduleData2);
            ((FirEnumEntryBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d14).setOrigin(FirDeclarationOrigin.Library.INSTANCE);
            boolean $i$f$buildResolvedTypeRef = false;
            Object object9 = new FirResolvedTypeRefBuilder();
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = object9;
            Object object10 = $this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d14;
            boolean bl19 = false;
            $this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d14_u24lambda_u2d12.setType(enumType);
            Unit unit4 = Unit.INSTANCE;
            ((FirEnumEntryBuilder)object10).setReturnTypeRef(((FirResolvedTypeRefBuilder)object9).build());
            ((FirEnumEntryBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d14).setName(enumEntryName);
            ((FirEnumEntryBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d14).setSymbol(new FirEnumEntrySymbol(new CallableId(classId, enumEntryName)));
            FirResolvedDeclarationStatusImpl firResolvedDeclarationStatusImpl = new FirResolvedDeclarationStatusImpl(Visibilities.Public.INSTANCE, Modality.FINAL, EffectiveVisibility.Public.INSTANCE);
            object9 = firResolvedDeclarationStatusImpl;
            object10 = $this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d14;
            boolean bl20 = false;
            $this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d14_u24lambda_u2d13.setStatic(true);
            unit4 = Unit.INSTANCE;
            ((FirEnumEntryBuilder)object10).setStatus(firResolvedDeclarationStatusImpl);
            ((FirEnumEntryBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d14).setResolvePhase(FirResolvePhase.Companion.getANALYZED_DEPENDENCIES());
            FirPureAbstractElement $this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d15 = firPureAbstractElement = ((FirEnumEntryBuilder)it$iv$iv).build();
            boolean bl21 = false;
            FirCallableDeclaration firCallableDeclaration = (FirCallableDeclaration)$this$deserializeClassToSymbol_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d15;
            ConeClassLikeType coneClassLikeType = context2.getDispatchReceiver();
            Intrinsics.checkNotNull(coneClassLikeType);
            ClassMembersKt.setContainingClassForStaticMemberAttr(firCallableDeclaration, coneClassLikeType.getLookupTag());
            FirPureAbstractElement firPureAbstractElement4 = property2 = firPureAbstractElement;
            if (firPureAbstractElement4 == null) continue;
            FirPureAbstractElement it$iv$iv2 = firPureAbstractElement3 = firPureAbstractElement4;
            boolean bl22 = false;
            destination$iv$iv2.add(it$iv$iv2);
        }
        object = (List)destination$iv$iv2;
        FirDeclarationBuildingUtilsKt.addDeclarations((FirRegularClassBuilder)object6, (Collection)object);
        if (((FirRegularClassBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17).getClassKind() == ClassKind.ENUM_CLASS) {
            $this$mapNotNull$iv = classId.getPackageFqName();
            Intrinsics.checkNotNullExpressionValue($this$mapNotNull$iv, "classId.packageFqName");
            Object object11 = $this$mapNotNull$iv;
            $this$mapNotNull$iv = classId.getRelativeClassName();
            Intrinsics.checkNotNullExpressionValue($this$mapNotNull$iv, "classId.relativeClassName");
            EnumClassUtilsKt.generateValuesFunction$default((FirRegularClassBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17, moduleData2, (FqName)object11, (FqName)$this$mapNotNull$iv, false, 8, null);
            $this$mapNotNull$iv = classId.getPackageFqName();
            Intrinsics.checkNotNullExpressionValue($this$mapNotNull$iv, "classId.packageFqName");
            Object object12 = $this$mapNotNull$iv;
            $this$mapNotNull$iv = classId.getRelativeClassName();
            Intrinsics.checkNotNullExpressionValue($this$mapNotNull$iv, "classId.relativeClassName");
            EnumClassUtilsKt.generateValueOfFunction$default((FirRegularClassBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17, moduleData2, (FqName)object12, (FqName)$this$mapNotNull$iv, false, 8, null);
        }
        ClassDeserializationKt.addCloneForArrayIfNeeded((FirRegularClassBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17, classId, context2.getDispatchReceiver());
        ClassDeserializationKt.addSerializableIfNeeded((FirRegularClassBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17, classId);
        CollectionsKt.sortWith(((FirRegularClassBuilder)$this$deserializeClassToSymbol_u24lambda_u2d17).getDeclarations(), (Comparator)new Comparator<FirDeclaration>(){

            public int compare(@NotNull FirDeclaration a, @NotNull FirDeclaration b) {
                Intrinsics.checkNotNullParameter(a, "a");
                Intrinsics.checkNotNullParameter(b, "b");
                if (a instanceof FirMemberDeclaration && b instanceof FirMemberDeclaration) {
                    return FirMemberDeclarationComparator.TypeAndNameComparator.INSTANCE.compare((FirMemberDeclaration)((Object)a), (FirMemberDeclaration)((Object)b));
                }
                return 0;
            }
        });
        FirRegularClass it = firRegularClass = ((FirRegularClassBuilder)object2).build();
        boolean bl23 = false;
        if (isSealed) {
            void $this$mapTo$iv$iv5;
            List<Integer> bl322 = classProto.getSealedSubclassFqNameList();
            Intrinsics.checkNotNullExpressionValue(bl322, "classProto.sealedSubclassFqNameList");
            Iterable $this$map$iv4 = bl322;
            boolean $i$f$map5 = false;
            superTypesDeserialized = $this$map$iv4;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv4, 10));
            boolean $i$f$mapTo5 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv5) {
                void nameIndex;
                destination$iv$iv2 = (Integer)item$iv$iv;
                Collection collection = destination$iv$iv4;
                boolean bl24 = false;
                Intrinsics.checkNotNullExpressionValue(nameIndex, "nameIndex");
                ClassId classId2 = ClassId.fromString(nameResolver2.getQualifiedClassName(nameIndex.intValue()));
                collection.add(classId2);
            }
            List inheritors = (List)destination$iv$iv4;
            SealedClassInheritorsKt.setSealedClassInheritors(it, inheritors);
        }
        CollectionsKt.addAll((Collection)TypeIntrinsics.asMutableList(it.getAnnotations()), (Iterable)context2.getAnnotationDeserializer().loadClassAnnotations(classProto, context2.getNameResolver()));
        FirVersionRequirementsTableKeyKt.setVersionRequirementsTable(it, context2.getVersionRequirementTable());
        DeclarationAttributesKt.setSourceElement(it, (SourceElement)containerSource);
        it.replaceDeprecation(DeprecationUtilsKt.getDeprecationInfos(it, FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).getApiVersion()));
        GeneratedMessageLite.ExtendableMessage extendableMessage = classProto;
        Object object11 = JvmProtoBuf.classModuleName;
        Intrinsics.checkNotNullExpressionValue(object11, "classModuleName");
        object = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, object11);
        if (object == null) {
            unit2 = null;
        } else {
            object11 = object;
            int idx = ((Number)object11).intValue();
            boolean bl25 = false;
            DeclarationAttributesKt.setModuleName(it, nameResolver2.getString(idx));
            unit2 = Unit.INSTANCE;
        }
    }

    public static /* synthetic */ void deserializeClassToSymbol$default(ClassId classId, ProtoBuf.Class clazz, FirRegularClassSymbol firRegularClassSymbol, NameResolver nameResolver2, FirSession firSession, FirModuleData firModuleData, AbstractAnnotationDeserializer abstractAnnotationDeserializer, FirScopeProvider firScopeProvider, FirDeserializationContext firDeserializationContext, DeserializedContainerSource deserializedContainerSource, FirDeclarationOrigin firDeclarationOrigin, Function2 function2, int n, Object object) {
        if ((n & 0x100) != 0) {
            firDeserializationContext = null;
        }
        if ((n & 0x200) != 0) {
            deserializedContainerSource = null;
        }
        if ((n & 0x400) != 0) {
            firDeclarationOrigin = FirDeclarationOrigin.Library.INSTANCE;
        }
        ClassDeserializationKt.deserializeClassToSymbol(classId, clazz, firRegularClassSymbol, nameResolver2, firSession, firModuleData, abstractAnnotationDeserializer, firScopeProvider, firDeserializationContext, deserializedContainerSource, firDeclarationOrigin, function2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void addSerializableIfNeeded(FirRegularClassBuilder $this$addSerializableIfNeeded, ClassId classId) {
        void $this$addSerializableIfNeeded_u24lambda_u2d21;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
        Object object = classId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue(object, "classId.asSingleFqName().toUnsafe()");
        if (!JvmBuiltInsSignatures.INSTANCE.isSerializableInJava((FqNameUnsafe)object)) {
            return;
        }
        object = $this$addSerializableIfNeeded;
        boolean $i$f$buildResolvedTypeRef = false;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        Collection collection = ((FirRegularClassBuilder)object).getSuperTypeRefs();
        boolean bl = false;
        boolean $i$f$emptyArray = false;
        $this$addSerializableIfNeeded_u24lambda_u2d21.setType(new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(JAVA_IO_SERIALIZABLE), new ConeTypeProjection[0], false, null, 8, null));
        Unit unit2 = Unit.INSTANCE;
        collection.add(firResolvedTypeRefBuilder.build());
    }

    /*
     * WARNING - void declaration
     */
    private static final void addCloneForArrayIfNeeded(FirRegularClassBuilder $this$addCloneForArrayIfNeeded, ClassId classId, ConeClassLikeType dispatchReceiver) {
        void $this$addCloneForArrayIfNeeded_u24lambda_u2d25_u24lambda_u2d24;
        void $this$addCloneForArrayIfNeeded_u24lambda_u2d25_u24lambda_u2d23;
        ConeTypeParameterTypeImpl[] coneTypeParameterTypeImplArray;
        void $this$addCloneForArrayIfNeeded_u24lambda_u2d25;
        FirAnnotationContainerBuilder $this$addCloneForArrayIfNeeded_u24lambda_u2d22;
        if (!Intrinsics.areEqual(classId.getPackageFqName(), StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) {
            return;
        }
        if (!ARRAY_CLASSES.contains(classId.getShortClassName())) {
            return;
        }
        FirRegularClassBuilder firRegularClassBuilder = $this$addCloneForArrayIfNeeded;
        boolean $i$f$buildResolvedTypeRef = false;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder = new FirResolvedTypeRefBuilder();
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = firAnnotationContainerBuilder;
        Collection collection = firRegularClassBuilder.getSuperTypeRefs();
        boolean bl = false;
        boolean $i$f$emptyArray = false;
        ((FirResolvedTypeRefBuilder)$this$addCloneForArrayIfNeeded_u24lambda_u2d22).setType(new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(FirCloneableSymbolProvider.Companion.getCLONEABLE_CLASS_ID()), new ConeTypeProjection[0], false, null, 8, null));
        Unit unit2 = Unit.INSTANCE;
        collection.add(((FirResolvedTypeRefBuilder)firAnnotationContainerBuilder).build());
        firRegularClassBuilder = $this$addCloneForArrayIfNeeded;
        boolean $i$f$buildSimpleFunction = false;
        $this$addCloneForArrayIfNeeded_u24lambda_u2d22 = firAnnotationContainerBuilder = new FirSimpleFunctionBuilder();
        collection = firRegularClassBuilder.getDeclarations();
        boolean bl2 = false;
        $this$addCloneForArrayIfNeeded_u24lambda_u2d25.setModuleData($this$addCloneForArrayIfNeeded.getModuleData());
        $this$addCloneForArrayIfNeeded_u24lambda_u2d25.setOrigin(FirDeclarationOrigin.Library.INSTANCE);
        $this$addCloneForArrayIfNeeded_u24lambda_u2d25.setResolvePhase(FirResolvePhase.Companion.getANALYZED_DEPENDENCIES());
        boolean $i$f$buildResolvedTypeRef2 = false;
        Object object = new FirResolvedTypeRefBuilder();
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = object;
        void var11_15 = $this$addCloneForArrayIfNeeded_u24lambda_u2d25;
        boolean bl3 = false;
        if (Intrinsics.areEqual(classId.getShortClassName(), ARRAY)) {
            ConeTypeParameterTypeImpl[] coneTypeParameterTypeImplArray2 = new ConeTypeParameterTypeImpl[]{new ConeTypeParameterTypeImpl(new ConeTypeParameterLookupTag(CollectionsKt.first($this$addCloneForArrayIfNeeded.getTypeParameters()).getSymbol()), false, null, 4, null)};
            coneTypeParameterTypeImplArray = coneTypeParameterTypeImplArray2;
        } else {
            boolean $i$f$emptyArray2 = false;
            coneTypeParameterTypeImplArray = new ConeTypeParameterTypeImpl[]{};
        }
        ConeTypeParameterTypeImpl[] typeArguments2 = coneTypeParameterTypeImplArray;
        $this$addCloneForArrayIfNeeded_u24lambda_u2d25_u24lambda_u2d23.setType(new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(classId), typeArguments2, false, null, 8, null));
        Unit unit3 = Unit.INSTANCE;
        var11_15.setReturnTypeRef(((FirResolvedTypeRefBuilder)object).build());
        FirResolvedDeclarationStatusImpl firResolvedDeclarationStatusImpl = new FirResolvedDeclarationStatusImpl(Visibilities.Public.INSTANCE, Modality.FINAL, EffectiveVisibility.Public.INSTANCE);
        object = firResolvedDeclarationStatusImpl;
        var11_15 = $this$addCloneForArrayIfNeeded_u24lambda_u2d25;
        boolean bl4 = false;
        $this$addCloneForArrayIfNeeded_u24lambda_u2d25_u24lambda_u2d24.setOverride(true);
        unit3 = Unit.INSTANCE;
        var11_15.setStatus(firResolvedDeclarationStatusImpl);
        $this$addCloneForArrayIfNeeded_u24lambda_u2d25.setName(FirCloneableSymbolProvider.Companion.getCLONE());
        $this$addCloneForArrayIfNeeded_u24lambda_u2d25.setSymbol(new FirNamedFunctionSymbol(new CallableId(classId, FirCloneableSymbolProvider.Companion.getCLONE())));
        ConeClassLikeType coneClassLikeType = dispatchReceiver;
        Intrinsics.checkNotNull(coneClassLikeType);
        $this$addCloneForArrayIfNeeded_u24lambda_u2d25.setDispatchReceiverType(coneClassLikeType);
        unit2 = Unit.INSTANCE;
        collection.add(((FirSimpleFunctionBuilder)firAnnotationContainerBuilder).build());
    }

    static {
        Object object = Name.identifier("Array");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"Array\")");
        ARRAY = object;
        object = new Name[9];
        object[0] = ARRAY;
        Name name2 = Name.identifier("ByteArray");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"ByteArray\")");
        object[1] = name2;
        name2 = Name.identifier("CharArray");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"CharArray\")");
        object[2] = name2;
        name2 = Name.identifier("ShortArray");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"ShortArray\")");
        object[3] = name2;
        name2 = Name.identifier("IntArray");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"IntArray\")");
        object[4] = name2;
        name2 = Name.identifier("LongArray");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"LongArray\")");
        object[5] = name2;
        name2 = Name.identifier("FloatArray");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"FloatArray\")");
        object[6] = name2;
        name2 = Name.identifier("DoubleArray");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"DoubleArray\")");
        object[7] = name2;
        name2 = Name.identifier("BooleanArray");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"BooleanArray\")");
        object[8] = name2;
        ARRAY_CLASSES = SetsKt.setOf(object);
        object = ClassId.topLevel(new FqName("java.io.Serializable"));
        Intrinsics.checkNotNullExpressionValue(object, "topLevel(FqName(\"java.io.Serializable\"))");
        JAVA_IO_SERIALIZABLE = object;
    }
}

