/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.org.eclipse.aether.graph.Dependency;
import org.jetbrains.kotlin.org.eclipse.aether.graph.DependencyCycle;
import org.jetbrains.kotlin.org.eclipse.aether.graph.DependencyNode;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.NodeStack;
import org.jetbrains.kotlin.org.eclipse.aether.util.artifact.ArtifactIdUtils;

final class DefaultDependencyCycle
implements DependencyCycle {
    private final List<Dependency> dependencies;
    private final int cycleEntry;

    DefaultDependencyCycle(NodeStack nodes, int cycleEntry, Dependency dependency) {
        int offset2 = cycleEntry > 0 && nodes.get(0).getDependency() == null ? 1 : 0;
        Dependency[] dependencies2 = new Dependency[nodes.size() - offset2 + 1];
        int n = dependencies2.length - 1;
        for (int i = 0; i < n; ++i) {
            DependencyNode node = nodes.get(i + offset2);
            dependencies2[i] = node.getDependency();
            if (dependencies2[i] != null) continue;
            dependencies2[i] = new Dependency(node.getArtifact(), null);
        }
        dependencies2[dependencies2.length - 1] = dependency;
        this.dependencies = Collections.unmodifiableList(Arrays.asList(dependencies2));
        this.cycleEntry = cycleEntry;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        int n = this.dependencies.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buffer.append(" -> ");
            }
            buffer.append(ArtifactIdUtils.toVersionlessId(this.dependencies.get(i).getArtifact()));
        }
        return buffer.toString();
    }
}

