/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.plexus;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Configuration;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Requirement;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanProperty;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanMetadata;

final class PlexusXmlMetadata
implements PlexusBeanMetadata {
    private Map<String, Configuration> configurationMap = Collections.emptyMap();
    private Map<String, Requirement> requirementMap = Collections.emptyMap();

    PlexusXmlMetadata(Map<String, Configuration> configurationMap, Map<String, Requirement> requirementMap) {
        this.merge(configurationMap, requirementMap);
    }

    @Override
    public boolean isEmpty() {
        return this.configurationMap.isEmpty() && this.requirementMap.isEmpty();
    }

    @Override
    public Configuration getConfiguration(BeanProperty<?> property2) {
        return this.configurationMap.remove(property2.getName());
    }

    @Override
    public Requirement getRequirement(BeanProperty<?> property2) {
        Requirement requirement2 = this.requirementMap.remove(property2.getName());
        if (requirement2 == null) {
            requirement2 = this.requirementMap.remove(property2.getType().getRawType().getName());
        }
        return requirement2;
    }

    void merge(Map<String, Configuration> extraConfiguration, Map<String, Requirement> extraRequirements) {
        this.configurationMap = PlexusXmlMetadata.addIfMissing(this.configurationMap, extraConfiguration);
        this.requirementMap = PlexusXmlMetadata.addIfMissing(this.requirementMap, extraRequirements);
    }

    private static <K, V> Map<K, V> addIfMissing(Map<K, V> primary, Map<K, V> secondary) {
        if (secondary.isEmpty()) {
            return primary;
        }
        if (primary.isEmpty()) {
            return secondary;
        }
        HashMap<K, V> tempMap = new HashMap<K, V>(secondary);
        tempMap.putAll(primary);
        return tempMap;
    }
}

