/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContextKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.TypeClsStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.flags.FlagsKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.flags.FlagsToModifiers;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinModifierListStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeAliasStubImpl;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"createTypeAliasStub", "", "parent", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubElement;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "typeAliasProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeAlias;", "protoContainer", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "outerContext", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderContext;", "decompiler-to-stubs"})
public final class TypeAliasClsStubBuildingKt {
    /*
     * WARNING - void declaration
     */
    public static final void createTypeAliasStub(@NotNull StubElement<? extends PsiElement> parent2, @NotNull ProtoBuf.TypeAlias typeAliasProto, @NotNull ProtoContainer protoContainer, @NotNull ClsStubBuilderContext outerContext) {
        ClassId classId;
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(typeAliasProto, "typeAliasProto");
        Intrinsics.checkNotNullParameter(protoContainer, "protoContainer");
        Intrinsics.checkNotNullParameter(outerContext, "outerContext");
        List<ProtoBuf.TypeParameter> list2 = typeAliasProto.getTypeParameterList();
        Intrinsics.checkNotNullExpressionValue(list2, "typeAliasProto.typeParameterList");
        ClsStubBuilderContext c = ClsStubBuilderContextKt.child$default(outerContext, list2, null, null, null, null, 30, null);
        Name shortName = NameResolverUtilKt.getName(c.getNameResolver(), typeAliasProto.getName());
        ProtoContainer protoContainer2 = protoContainer;
        if (protoContainer2 instanceof ProtoContainer.Class) {
            classId = ((ProtoContainer.Class)protoContainer).getClassId().createNestedClassId(shortName);
        } else if (protoContainer2 instanceof ProtoContainer.Package) {
            classId = ClassId.topLevel(((ProtoContainer.Package)protoContainer).getFqName().child(shortName));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ClassId classId2 = classId;
        Intrinsics.checkNotNullExpressionValue(classId2, "when (protoContainer) {\n\u2026e.child(shortName))\n    }");
        ClassId classId3 = classId2;
        Name name2 = classId3.getShortClassName();
        Intrinsics.checkNotNullExpressionValue(name2, "classId.shortClassName");
        StringRef stringRef = ClsStubBuildingKt.ref(name2);
        FqName fqName2 = classId3.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "classId.asSingleFqName()");
        KotlinTypeAliasStubImpl typeAlias = new KotlinTypeAliasStubImpl(parent2, stringRef, ClsStubBuildingKt.ref(fqName2), classId3, !classId3.isNestedClass());
        FlagsToModifiers[] flagsToModifiersArray = new FlagsToModifiers[]{FlagsKt.getVISIBILITY()};
        KotlinModifierListStubImpl modifierList2 = ClsStubBuildingKt.createModifierListStubForDeclaration(typeAlias, typeAliasProto.getFlags(), (List<? extends FlagsToModifiers>)CollectionsKt.arrayListOf(flagsToModifiersArray), CollectionsKt.emptyList());
        TypeClsStubBuilder typeStubBuilder = new TypeClsStubBuilder(c);
        StubElement stubElement = typeAlias;
        List<ProtoBuf.TypeParameter> list3 = typeAliasProto.getTypeParameterList();
        Intrinsics.checkNotNullExpressionValue(list3, "typeAliasProto.typeParameterList");
        List<Pair<Name, ProtoBuf.Type>> restConstraints = typeStubBuilder.createTypeParameterListStub(stubElement, list3);
        boolean bl = restConstraints.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-TypeAliasClsStubBuildingKt$createTypeAliasStub$22 = false;
            String $i$a$-assert-TypeAliasClsStubBuildingKt$createTypeAliasStub$22 = "'where' constraints are not allowed for type aliases";
            throw new AssertionError((Object)$i$a$-assert-TypeAliasClsStubBuildingKt$createTypeAliasStub$22);
        }
        Boolean bl2 = Flags.HAS_ANNOTATIONS.get(typeAliasProto.getFlags());
        Intrinsics.checkNotNullExpressionValue(bl2, "HAS_ANNOTATIONS.get(typeAliasProto.flags)");
        if (bl2.booleanValue()) {
            void $this$mapTo$iv$iv;
            List<ProtoBuf.Annotation> list4 = typeAliasProto.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list4, "typeAliasProto.annotationList");
            Iterable $this$map$iv = list4;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(NameResolverUtilKt.getClassId(c.getNameResolver(), it.getId()));
            }
            ClsStubBuildingKt.createAnnotationStubs((List)destination$iv$iv, modifierList2);
        }
        ProtoBuf.Type typeAliasUnderlyingType = ProtoTypeTableUtilKt.underlyingType(typeAliasProto, c.getTypeTable());
        TypeClsStubBuilder.createTypeReferenceStub$default(typeStubBuilder, typeAlias, typeAliasUnderlyingType, null, 4, null);
    }
}

