/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.collections.CollectionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.Asm7UtilKt;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BridgeForBuiltinSpecial;
import org.jetbrains.kotlin.codegen.BuiltinSpecialBridgesUtil;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.DefaultParameterValueSubstitutor;
import org.jetbrains.kotlin.codegen.DescriptorAsmUtil;
import org.jetbrains.kotlin.codegen.DescriptorBasedFunctionHandleForJvm;
import org.jetbrains.kotlin.codegen.ExceptionLogger;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FrameMapWithExpectActualSupport;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.GenerateJava8ParameterNamesKt;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmBridgesImplKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.JvmStaticInCompanionObjectGenerator;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.TransformationMethodVisitor;
import org.jetbrains.kotlin.codegen.VariableAsmNameManglingUtils;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.ConstructorContext;
import org.jetbrains.kotlin.codegen.context.DefaultImplsClassContext;
import org.jetbrains.kotlin.codegen.context.InlineLambdaContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassFacadeContext;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.coroutines.SuspendFunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.codegen.state.TypeMapperUtilsKt;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.load.java.SpecialGenericSignatures;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.annotations.ThrowUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.InlineClassManglingRulesKt;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKind;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class FunctionCodegen {
    public final GenerationState state;
    private final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final CodegenContext owner;
    private final ClassBuilder v;
    private final MemberCodegen<?> memberCodegen;

    public FunctionCodegen(@NotNull CodegenContext owner, @NotNull ClassBuilder v, @NotNull GenerationState state, @NotNull MemberCodegen<?> memberCodegen) {
        if (owner == null) {
            FunctionCodegen.$$$reportNull$$$0(0);
        }
        if (v == null) {
            FunctionCodegen.$$$reportNull$$$0(1);
        }
        if (state == null) {
            FunctionCodegen.$$$reportNull$$$0(2);
        }
        if (memberCodegen == null) {
            FunctionCodegen.$$$reportNull$$$0(3);
        }
        this.owner = owner;
        this.v = v;
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.bindingContext = state.getBindingContext();
        this.memberCodegen = memberCodegen;
    }

    public void gen(@NotNull KtNamedFunction function2) {
        SimpleFunctionDescriptor functionDescriptor;
        if (function2 == null) {
            FunctionCodegen.$$$reportNull$$$0(4);
        }
        if (this.bindingContext.get(CodegenBinding.SUSPEND_FUNCTION_TO_JVM_VIEW, functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, function2)) != null) {
            functionDescriptor = (SimpleFunctionDescriptor)this.bindingContext.get(CodegenBinding.SUSPEND_FUNCTION_TO_JVM_VIEW, functionDescriptor);
        }
        if (functionDescriptor == null) {
            throw ExceptionLogger.logDescriptorNotFound("No descriptor for function " + function2.getName(), function2);
        }
        if (this.owner.getContextKind() != OwnerKind.DEFAULT_IMPLS || function2.hasBody()) {
            FunctionGenerationStrategy.CodegenBased strategy = functionDescriptor.isSuspend() ? new SuspendFunctionGenerationStrategy(this.state, CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(functionDescriptor), function2, this.v.getThisName(), this) : new FunctionGenerationStrategy.FunctionDefault(this.state, function2);
            this.generateMethod(JvmDeclarationOriginKt.OtherOrigin(function2, functionDescriptor), functionDescriptor, strategy);
        }
        this.generateDefaultIfNeeded(this.owner.intoFunction(functionDescriptor, true), functionDescriptor, this.owner.getContextKind(), DefaultParameterValueLoader.DEFAULT, function2);
        this.generateOverloadsWithDefaultValues(function2, functionDescriptor, functionDescriptor);
    }

    public void generateOverloadsWithDefaultValues(@Nullable KtNamedFunction function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull FunctionDescriptor delegateFunctionDescriptor) {
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(5);
        }
        if (delegateFunctionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(6);
        }
        new DefaultParameterValueSubstitutor(this.state).generateOverloadsIfNeeded(function2, functionDescriptor, delegateFunctionDescriptor, this.owner.getContextKind(), this.v, this.memberCodegen);
    }

    public void generateMethod(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor descriptor2, @NotNull FunctionGenerationStrategy strategy) {
        if (origin == null) {
            FunctionCodegen.$$$reportNull$$$0(7);
        }
        if (descriptor2 == null) {
            FunctionCodegen.$$$reportNull$$$0(8);
        }
        if (strategy == null) {
            FunctionCodegen.$$$reportNull$$$0(9);
        }
        if (CoroutineCodegenUtilKt.isSuspendFunctionNotSuspensionView(descriptor2)) {
            this.generateMethod(origin, CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(descriptor2, this.state), strategy);
            return;
        }
        this.generateMethod(origin, descriptor2, this.owner.intoFunction(descriptor2), strategy);
    }

    public void generateMethod(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext methodContext2, @NotNull FunctionGenerationStrategy strategy) {
        boolean isOpenSuspendInClass;
        boolean staticInCompanionObject;
        boolean isCompatibilityStubInDefaultImpls;
        if (origin == null) {
            FunctionCodegen.$$$reportNull$$$0(10);
        }
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(11);
        }
        if (methodContext2 == null) {
            FunctionCodegen.$$$reportNull$$$0(12);
        }
        if (strategy == null) {
            FunctionCodegen.$$$reportNull$$$0(13);
        }
        OwnerKind contextKind = TypeMapperUtilsKt.isInlineClassConstructorAccessor(functionDescriptor) ? OwnerKind.ERASED_INLINE_CLASS : methodContext2.getContextKind();
        DeclarationDescriptor containingDeclaration = functionDescriptor.getContainingDeclaration();
        if (DescriptorUtils.isInterface(containingDeclaration) && !FunctionCodegen.processInterfaceMethod(functionDescriptor, contextKind, false, false, this.state.getJvmDefaultMode())) {
            return;
        }
        if (!FunctionCodegen.shouldGenerateMethodInsideInlineClass(origin, functionDescriptor, contextKind, containingDeclaration)) {
            return;
        }
        boolean hasSpecialBridge = this.hasSpecialBridgeMethod(functionDescriptor);
        JvmMethodGenericSignature jvmSignature = strategy.mapMethodSignature(functionDescriptor, this.typeMapper, contextKind, hasSpecialBridge);
        Method asmMethod2 = jvmSignature.getAsmMethod();
        int flags = DescriptorAsmUtil.getMethodAsmFlags(functionDescriptor, contextKind, this.state);
        if (origin.getOriginKind() == JvmDeclarationOriginKind.SAM_DELEGATION) {
            flags |= 0x1000;
        }
        if (isCompatibilityStubInDefaultImpls = FunctionCodegen.isCompatibilityStubInDefaultImpls(functionDescriptor, methodContext2, this.state.getJvmDefaultMode())) {
            flags |= 0x20000;
        }
        if (functionDescriptor.isExternal() && this.owner instanceof MultifileClassFacadeContext) {
            return;
        }
        MethodVisitor mv = strategy.wrapMethodVisitor(this.newMethod(origin, flags, asmMethod2.getName(), asmMethod2.getDescriptor(), strategy.skipGenericSignature() ? null : jvmSignature.getGenericsSignature(), FunctionCodegen.getThrownExceptions(functionDescriptor, this.typeMapper)), flags, asmMethod2.getName(), asmMethod2.getDescriptor());
        this.recordMethodForFunctionIfAppropriate(functionDescriptor, asmMethod2);
        boolean skipNullabilityAnnotations = (flags & 2) != 0 || (flags & 0x1000) != 0 || InlineClassDescriptorResolver.isSpecializedEqualsMethod(functionDescriptor);
        this.generateMethodAnnotationsIfRequired(functionDescriptor, asmMethod2, jvmSignature, mv, isCompatibilityStubInDefaultImpls ? Collections.singletonList(CodegenUtilKt.JAVA_LANG_DEPRECATED) : Collections.emptyList(), skipNullabilityAnnotations);
        GenerateJava8ParameterNamesKt.generateParameterNames(functionDescriptor, mv, jvmSignature, this.state, (flags & 0x1000) != 0);
        if (contextKind != OwnerKind.ERASED_INLINE_CLASS) {
            this.generateBridges(functionDescriptor);
        }
        if (staticInCompanionObject = CodegenUtilKt.isJvmStaticInCompanionObject(functionDescriptor)) {
            ImplementationBodyCodegen parentBodyCodegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
            parentBodyCodegen.addAdditionalTask(new JvmStaticInCompanionObjectGenerator(functionDescriptor, origin, this.state, parentBodyCodegen));
        }
        CodegenUtilKt.generateBridgeForMainFunctionIfNecessary(this.state, this.v, functionDescriptor, jvmSignature, origin, methodContext2.getParentContext());
        boolean bl = isOpenSuspendInClass = functionDescriptor.isSuspend() && functionDescriptor.getModality() != Modality.ABSTRACT && ModalityUtilsKt.isOverridable(functionDescriptor) && !DescriptorUtils.isInterface(containingDeclaration) && !(containingDeclaration instanceof PackageFragmentDescriptor) && origin.getOriginKind() != JvmDeclarationOriginKind.CLASS_MEMBER_DELEGATION_TO_DEFAULT_IMPL;
        if (isOpenSuspendInClass) {
            this.generateOpenMethodInSuspendClass(origin, functionDescriptor, methodContext2, strategy, mv, jvmSignature, asmMethod2, flags, staticInCompanionObject);
        } else if (FunctionCodegen.canDelegateMethodBodyToInlineClass(origin, functionDescriptor, contextKind, containingDeclaration)) {
            FunctionCodegen.generateMethodInsideInlineClassWrapper(origin, functionDescriptor, (ClassDescriptor)containingDeclaration, mv, this.typeMapper);
        } else {
            this.generateMethodBody(origin, functionDescriptor, methodContext2, strategy, mv, jvmSignature, staticInCompanionObject);
        }
    }

    private void recordMethodForFunctionIfAppropriate(@NotNull FunctionDescriptor functionDescriptor, Method asmMethod2) {
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(14);
        }
        if (functionDescriptor instanceof AccessorForConstructorDescriptor) {
            ClassConstructorDescriptor originalConstructor = ((AccessorForConstructorDescriptor)functionDescriptor).getCalleeDescriptor();
            if (InlineClassManglingRulesKt.shouldHideConstructorDueToInlineClassTypeValueParameters(originalConstructor)) {
                functionDescriptor = originalConstructor;
            }
        } else if (InlineClassManglingRulesKt.shouldHideConstructorDueToInlineClassTypeValueParameters(functionDescriptor)) {
            return;
        }
        functionDescriptor = CodegenUtilKt.unwrapFrontendVersion(functionDescriptor);
        if (!CodegenContextUtil.isImplementationOwner(this.owner, functionDescriptor)) {
            return;
        }
        this.v.getSerializationBindings().put(JvmSerializationBindings.METHOD_FOR_FUNCTION, functionDescriptor, asmMethod2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateMethodAnnotationsIfRequired(@NotNull FunctionDescriptor functionDescriptor, @NotNull Method asmMethod2, @NotNull JvmMethodGenericSignature jvmSignature, @NotNull MethodVisitor mv, @NotNull List<String> additionalVisibleAnnotations, boolean skipNullabilityAnnotations) {
        FunctionDescriptor annotationsOwner;
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(15);
        }
        if (asmMethod2 == null) {
            FunctionCodegen.$$$reportNull$$$0(16);
        }
        if (jvmSignature == null) {
            FunctionCodegen.$$$reportNull$$$0(17);
        }
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(18);
        }
        if (additionalVisibleAnnotations == null) {
            FunctionCodegen.$$$reportNull$$$0(19);
        }
        if (InlineClassManglingRulesKt.shouldHideConstructorDueToInlineClassTypeValueParameters(functionDescriptor)) {
            if (!(functionDescriptor instanceof AccessorForConstructorDescriptor)) return;
            annotationsOwner = ((AccessorForConstructorDescriptor)functionDescriptor).getCalleeDescriptor();
        } else {
            annotationsOwner = functionDescriptor;
        }
        AnnotationCodegen.forMethod(mv, this.memberCodegen, this.state, skipNullabilityAnnotations).genAnnotations(annotationsOwner, asmMethod2.getReturnType(), functionDescriptor.getReturnType(), null, additionalVisibleAnnotations);
        FunctionCodegen.generateParameterAnnotations(annotationsOwner, mv, jvmSignature, annotationsOwner.getValueParameters(), this.memberCodegen, this.state, skipNullabilityAnnotations);
    }

    @NotNull
    public MethodVisitor newMethod(@NotNull JvmDeclarationOrigin origin, int access, @NotNull String name2, @NotNull String desc, @Nullable String signature2, @Nullable String[] exceptions) {
        if (origin == null) {
            FunctionCodegen.$$$reportNull$$$0(20);
        }
        if (name2 == null) {
            FunctionCodegen.$$$reportNull$$$0(21);
        }
        if (desc == null) {
            FunctionCodegen.$$$reportNull$$$0(22);
        }
        MethodVisitor methodVisitor = this.v.newMethod(origin, access, name2, desc, signature2, exceptions);
        if (methodVisitor == null) {
            FunctionCodegen.$$$reportNull$$$0(23);
        }
        return methodVisitor;
    }

    private static boolean shouldGenerateMethodInsideInlineClass(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind contextKind, @NotNull DeclarationDescriptor containingDeclaration) {
        if (origin == null) {
            FunctionCodegen.$$$reportNull$$$0(24);
        }
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(25);
        }
        if (contextKind == null) {
            FunctionCodegen.$$$reportNull$$$0(26);
        }
        if (containingDeclaration == null) {
            FunctionCodegen.$$$reportNull$$$0(27);
        }
        return !FunctionCodegen.canDelegateMethodBodyToInlineClass(origin, functionDescriptor, contextKind, containingDeclaration) || !functionDescriptor.getOverriddenDescriptors().isEmpty() || CodegenUtilKt.isJvmStaticInInlineClass(functionDescriptor);
    }

    private static boolean canDelegateMethodBodyToInlineClass(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind contextKind, @NotNull DeclarationDescriptor containingDeclaration) {
        PropertyDescriptor property2;
        if (origin == null) {
            FunctionCodegen.$$$reportNull$$$0(28);
        }
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(29);
        }
        if (contextKind == null) {
            FunctionCodegen.$$$reportNull$$$0(30);
        }
        if (containingDeclaration == null) {
            FunctionCodegen.$$$reportNull$$$0(31);
        }
        if (contextKind == OwnerKind.ERASED_INLINE_CLASS) {
            return false;
        }
        if (origin.getOriginKind() == JvmDeclarationOriginKind.UNBOX_METHOD_OF_INLINE_CLASS) {
            return false;
        }
        if (CodegenUtilKt.isJvmStaticInInlineClass(functionDescriptor)) {
            return false;
        }
        if (functionDescriptor instanceof PropertyAccessorDescriptor && InlineClassesUtilsKt.isUnderlyingPropertyOfInlineClass(property2 = ((PropertyAccessorDescriptor)functionDescriptor).getCorrespondingProperty())) {
            return false;
        }
        boolean isInlineClass = InlineClassesUtilsKt.isInlineClass(containingDeclaration);
        boolean simpleFunctionOrProperty = !(functionDescriptor instanceof ConstructorDescriptor) && !KotlinTypeMapper.isAccessor(functionDescriptor);
        return isInlineClass && simpleFunctionOrProperty;
    }

    public static void generateMethodInsideInlineClassWrapper(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor functionDescriptor, @NotNull ClassDescriptor inlineClass, @NotNull MethodVisitor mv, @NotNull KotlinTypeMapper typeMapper2) {
        if (origin == null) {
            FunctionCodegen.$$$reportNull$$$0(32);
        }
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(33);
        }
        if (inlineClass == null) {
            FunctionCodegen.$$$reportNull$$$0(34);
        }
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(35);
        }
        if (typeMapper2 == null) {
            FunctionCodegen.$$$reportNull$$$0(36);
        }
        mv.visitCode();
        Type fieldOwnerType = typeMapper2.mapClass(inlineClass);
        Method erasedMethodImpl = typeMapper2.mapAsmMethod(functionDescriptor.getOriginal(), OwnerKind.ERASED_INLINE_CLASS);
        InlineClassRepresentation<SimpleType> representation = DescriptorUtilsKt.getInlineClassRepresentation(inlineClass);
        assert (representation != null) : "Not an inline class: " + inlineClass;
        FunctionCodegen.generateDelegateToStaticErasedVersion(mv, erasedMethodImpl, fieldOwnerType, representation.getUnderlyingPropertyName().asString(), typeMapper2.mapType(representation.getUnderlyingType()));
        FunctionCodegen.endVisit(mv, null, origin.getElement());
    }

    private void generateOpenMethodInSuspendClass(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext methodContext2, @NotNull FunctionGenerationStrategy strategy, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature, @NotNull Method asmMethod2, int flags, boolean staticInCompanionObject) {
        if (origin == null) {
            FunctionCodegen.$$$reportNull$$$0(37);
        }
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(38);
        }
        if (methodContext2 == null) {
            FunctionCodegen.$$$reportNull$$$0(39);
        }
        if (strategy == null) {
            FunctionCodegen.$$$reportNull$$$0(40);
        }
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(41);
        }
        if (jvmSignature == null) {
            FunctionCodegen.$$$reportNull$$$0(42);
        }
        if (asmMethod2 == null) {
            FunctionCodegen.$$$reportNull$$$0(43);
        }
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        int index2 = 1;
        for (Type type2 : asmMethod2.getArgumentTypes()) {
            mv.visitVarInsn(type2.getOpcode(21), index2);
            index2 += type2.getSize();
        }
        Method asmMethodForOpenSuspendImpl = CoroutineCodegenUtilKt.getImplForOpenMethod(asmMethod2, this.v.getThisName());
        JvmMethodGenericSignature jvmSignatureForOpenSuspendImpl = new JvmMethodGenericSignature(asmMethodForOpenSuspendImpl, jvmSignature.getValueParameters(), null);
        mv.visitMethodInsn(184, this.v.getThisName(), asmMethodForOpenSuspendImpl.getName(), asmMethodForOpenSuspendImpl.getDescriptor(), false);
        mv.visitInsn(176);
        mv.visitEnd();
        int flagsForOpenSuspendImpl = flags;
        flagsForOpenSuspendImpl |= 0x1008;
        flagsForOpenSuspendImpl &= ~DescriptorAsmUtil.getVisibilityAccessFlag(functionDescriptor);
        MethodVisitor mvForOpenSuspendImpl = strategy.wrapMethodVisitor(this.v.newMethod(origin, flagsForOpenSuspendImpl |= 0, asmMethodForOpenSuspendImpl.getName(), asmMethodForOpenSuspendImpl.getDescriptor(), null, FunctionCodegen.getThrownExceptions(functionDescriptor, this.typeMapper)), flagsForOpenSuspendImpl, asmMethodForOpenSuspendImpl.getName(), asmMethodForOpenSuspendImpl.getDescriptor());
        this.generateMethodBody(origin, functionDescriptor, methodContext2, strategy, mvForOpenSuspendImpl, jvmSignatureForOpenSuspendImpl, staticInCompanionObject);
    }

    private void generateMethodBody(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext methodContext2, @NotNull FunctionGenerationStrategy strategy, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature, boolean staticInCompanionObject) {
        if (origin == null) {
            FunctionCodegen.$$$reportNull$$$0(44);
        }
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(45);
        }
        if (methodContext2 == null) {
            FunctionCodegen.$$$reportNull$$$0(46);
        }
        if (strategy == null) {
            FunctionCodegen.$$$reportNull$$$0(47);
        }
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(48);
        }
        if (jvmSignature == null) {
            FunctionCodegen.$$$reportNull$$$0(49);
        }
        OwnerKind contextKind = methodContext2.getContextKind();
        if (!this.state.getClassBuilderMode().generateBodies || DescriptorAsmUtil.isAbstractMethod(functionDescriptor, contextKind, this.state.getJvmDefaultMode()) || FunctionCodegen.shouldSkipMethodBodyInAbiMode(this.state.getClassBuilderMode(), origin)) {
            FunctionCodegen.generateLocalVariableTable(mv, jvmSignature, functionDescriptor, FunctionCodegen.getThisTypeForFunction(functionDescriptor, methodContext2, this.typeMapper), new Label(), new Label(), contextKind, this.state, 0);
            mv.visitEnd();
            return;
        }
        if (!functionDescriptor.isExternal()) {
            FunctionCodegen.generateMethodBody(mv, functionDescriptor, methodContext2, jvmSignature, strategy, this.memberCodegen, this.state.getJvmDefaultMode());
        } else if (staticInCompanionObject) {
            mv.visitCode();
            FunctionDescriptor staticFunctionDescriptor = JvmStaticInCompanionObjectGenerator.createStaticFunctionDescriptor(functionDescriptor);
            Method accessorMethod = this.typeMapper.mapAsmMethod(this.memberCodegen.getContext().accessibleDescriptor(staticFunctionDescriptor, null));
            Type owningType = this.typeMapper.mapClass((ClassifierDescriptor)staticFunctionDescriptor.getContainingDeclaration());
            FunctionCodegen.generateDelegateToStaticMethodBody(false, mv, accessorMethod, owningType.getInternalName(), false);
        }
        FunctionCodegen.endVisit(mv, null, origin.getElement());
    }

    private static boolean shouldSkipMethodBodyInAbiMode(@NotNull ClassBuilderMode classBuilderMode, @NotNull JvmDeclarationOrigin origin) {
        if (classBuilderMode == null) {
            FunctionCodegen.$$$reportNull$$$0(50);
        }
        if (origin == null) {
            FunctionCodegen.$$$reportNull$$$0(51);
        }
        if (classBuilderMode != ClassBuilderMode.ABI) {
            return false;
        }
        DeclarationDescriptor descriptor2 = origin.getDescriptor();
        return descriptor2 != null && !InlineUtil.isInlineOrContainingInline(descriptor2);
    }

    public static void generateParameterAnnotations(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature, @NotNull List<ValueParameterDescriptor> valueParameters2, @NotNull MemberCodegen<?> memberCodegen, @NotNull GenerationState state, boolean skipNullabilityAnnotations) {
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(52);
        }
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(53);
        }
        if (jvmSignature == null) {
            FunctionCodegen.$$$reportNull$$$0(54);
        }
        if (valueParameters2 == null) {
            FunctionCodegen.$$$reportNull$$$0(55);
        }
        if (memberCodegen == null) {
            FunctionCodegen.$$$reportNull$$$0(56);
        }
        if (state == null) {
            FunctionCodegen.$$$reportNull$$$0(57);
        }
        if (KotlinTypeMapper.isAccessor(functionDescriptor)) {
            return;
        }
        Iterator<ValueParameterDescriptor> iterator2 = valueParameters2.iterator();
        List<JvmMethodParameterSignature> kotlinParameterTypes = jvmSignature.getValueParameters();
        int syntheticParameterCount = CollectionsKt.count(kotlinParameterTypes, signature2 -> signature2.getKind().isSkippedInGenericSignature());
        Asm7UtilKt.visitAnnotableParameterCount(mv, kotlinParameterTypes.size() - syntheticParameterCount);
        boolean isDefaultImpl = OwnerKind.DEFAULT_IMPLS == memberCodegen.context.getContextKind();
        for (int i = 0; i < kotlinParameterTypes.size(); ++i) {
            ParameterDescriptor annotated;
            JvmMethodParameterSignature parameterSignature = kotlinParameterTypes.get(i);
            JvmMethodParameterKind kind = parameterSignature.getKind();
            if (kind.isSkippedInGenericSignature()) continue;
            ParameterDescriptor parameterDescriptor = kind == JvmMethodParameterKind.VALUE ? (ParameterDescriptor)iterator2.next() : (kind == JvmMethodParameterKind.RECEIVER ? JvmCodegenUtil.getDirectMember(functionDescriptor).getExtensionReceiverParameter() : (annotated = kind == JvmMethodParameterKind.THIS && isDefaultImpl ? JvmCodegenUtil.getDirectMember(functionDescriptor).getDispatchReceiverParameter() : null));
            if (annotated == null) continue;
            int parameterIndex = i - syntheticParameterCount;
            AnnotationCodegen.forParameter(parameterIndex, mv, memberCodegen, state, skipNullabilityAnnotations).genAnnotations(annotated, parameterSignature.getAsmType(), annotated.getReturnType(), functionDescriptor, Collections.emptyList());
        }
    }

    @Nullable
    private static Type getThisTypeForFunction(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context, @NotNull KotlinTypeMapper typeMapper2) {
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(58);
        }
        if (context == null) {
            FunctionCodegen.$$$reportNull$$$0(59);
        }
        if (typeMapper2 == null) {
            FunctionCodegen.$$$reportNull$$$0(60);
        }
        ReceiverParameterDescriptor dispatchReceiver = functionDescriptor.getDispatchReceiverParameter();
        if (functionDescriptor instanceof ConstructorDescriptor) {
            return typeMapper2.mapTypeAsDeclaration(functionDescriptor);
        }
        if (dispatchReceiver != null) {
            return typeMapper2.mapTypeAsDeclaration(dispatchReceiver.getType());
        }
        if (ExpressionTypingUtils.isFunctionLiteral(functionDescriptor) || ExpressionTypingUtils.isLocalFunction(functionDescriptor) || ExpressionTypingUtils.isFunctionExpression(functionDescriptor)) {
            return typeMapper2.mapClass(context.getThisDescriptor());
        }
        return null;
    }

    public static void generateMethodBody(@NotNull MethodVisitor mv, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context, @NotNull JvmMethodSignature signature2, @NotNull FunctionGenerationStrategy strategy, @NotNull MemberCodegen<?> parentCodegen, @NotNull JvmDefaultMode jvmDefaultMode2) {
        Label methodEnd;
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(61);
        }
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(62);
        }
        if (context == null) {
            FunctionCodegen.$$$reportNull$$$0(63);
        }
        if (signature2 == null) {
            FunctionCodegen.$$$reportNull$$$0(64);
        }
        if (strategy == null) {
            FunctionCodegen.$$$reportNull$$$0(65);
        }
        if (parentCodegen == null) {
            FunctionCodegen.$$$reportNull$$$0(66);
        }
        if (jvmDefaultMode2 == null) {
            FunctionCodegen.$$$reportNull$$$0(67);
        }
        mv.visitCode();
        Label methodBegin = new Label();
        mv.visitLabel(methodBegin);
        KotlinTypeMapper typeMapper2 = parentCodegen.typeMapper;
        if (BuiltinSpecialBridgesUtil.shouldHaveTypeSafeBarrier(functionDescriptor, typeMapper2::mapAsmMethod)) {
            FunctionCodegen.generateTypeCheckBarrierIfNeeded(new InstructionAdapter(mv), functionDescriptor, signature2.getReturnType(), null, typeMapper2);
        }
        Label methodEntry = null;
        int functionFakeIndex = -1;
        if (context.getParentContext() instanceof MultifileClassFacadeContext) {
            FunctionCodegen.generateFacadeDelegateMethodBody(mv, signature2.getAsmMethod(), (MultifileClassFacadeContext)context.getParentContext());
            methodEnd = new Label();
        } else if (FunctionCodegen.isCompatibilityStubInDefaultImpls(functionDescriptor, context, jvmDefaultMode2)) {
            FunctionDescriptor compatibility = ((DefaultImplsClassContext)context.getParentContext()).getInterfaceContext().getAccessorForJvmDefaultCompatibility(functionDescriptor);
            int flags = DescriptorAsmUtil.getMethodAsmFlags(functionDescriptor, OwnerKind.DEFAULT_IMPLS, context.getState());
            assert ((flags & 0x400) == 0) : "Interface method with body should be non-abstract" + functionDescriptor;
            CallableMethod method = typeMapper2.mapToCallableMethod(compatibility, false);
            FunctionCodegen.generateDelegateToStaticMethodBody(true, mv, method.getAsmMethod(), method.getOwner().getInternalName(), true, signature2.getReturnType());
            methodEnd = new Label();
        } else {
            FrameMap frameMap = FunctionCodegen.createFrameMap(parentCodegen.state, signature2, functionDescriptor.getExtensionReceiverParameter(), functionDescriptor.getValueParameters(), DescriptorAsmUtil.isStaticMethod(context.getContextKind(), functionDescriptor));
            if (functionDescriptor.isSuspend() && CoroutineCodegenUtilKt.isSuspendFunctionNotSuspensionView(functionDescriptor)) {
                FunctionDescriptor view = CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(functionDescriptor, parentCodegen.state);
                ValueParameterDescriptor continuationValueDescriptor = view.getValueParameters().get(view.getValueParameters().size() - 1);
                frameMap.enter(continuationValueDescriptor, typeMapper2.mapType(continuationValueDescriptor));
            }
            if (context.isInlineMethodContext() || context instanceof InlineLambdaContext) {
                functionFakeIndex = FunctionCodegen.newFakeTempIndex(mv, frameMap);
            }
            methodEntry = new Label();
            mv.visitLabel(methodEntry);
            context.setMethodStartLabel(methodEntry);
            if (!strategy.skipNotNullAssertionsForParameters()) {
                DescriptorAsmUtil.genNotNullAssertionsForParameters(new InstructionAdapter(mv), parentCodegen.state, functionDescriptor, frameMap);
            }
            methodEnd = new Label();
            context.setMethodEndLabel(methodEnd);
            strategy.generateBody(mv, frameMap, signature2, context, parentCodegen);
        }
        mv.visitLabel(methodEnd);
        Type thisType = FunctionCodegen.getThisTypeForFunction(functionDescriptor, context, typeMapper2);
        if (functionDescriptor instanceof AnonymousFunctionDescriptor && functionDescriptor.isSuspend()) {
            functionDescriptor = CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(functionDescriptor, parentCodegen.state);
        }
        FunctionCodegen.generateLocalVariableTable(mv, signature2, functionDescriptor, thisType, methodBegin, methodEnd, context.getContextKind(), parentCodegen.state, functionFakeIndex >= 0 ? 1 : 0);
        if (context.isInlineMethodContext() && functionFakeIndex != -1) {
            assert (methodEntry != null) : "methodEntry is not initialized";
            mv.visitLocalVariable("$i$f$" + typeMapper2.mapAsmMethod(functionDescriptor).getName(), Type.INT_TYPE.getDescriptor(), null, methodEntry, methodEnd, functionFakeIndex);
        } else if (context instanceof InlineLambdaContext && thisType != null && functionFakeIndex != -1) {
            ValueParameterDescriptor inlineArgumentDescriptor;
            String internalName2 = thisType.getInternalName();
            String lambdaLocalName = StringsKt.substringAfterLast(internalName2, '/', internalName2);
            Object functionArgument = parentCodegen.element;
            String functionName = "unknown";
            if (functionArgument instanceof KtFunction && (inlineArgumentDescriptor = InlineUtil.getInlineArgumentDescriptor((KtFunction)functionArgument, parentCodegen.bindingContext)) != null) {
                functionName = inlineArgumentDescriptor.getContainingDeclaration().getName().asString();
            }
            assert (methodEntry != null) : "methodEntry is not initialized";
            mv.visitLocalVariable("$i$a$-" + functionName + "-" + lambdaLocalName, Type.INT_TYPE.getDescriptor(), null, methodEntry, methodEnd, functionFakeIndex);
        }
    }

    private static int newFakeTempIndex(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap) {
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(68);
        }
        if (frameMap == null) {
            FunctionCodegen.$$$reportNull$$$0(69);
        }
        int fakeIndex = frameMap.enterTemp(Type.INT_TYPE);
        mv.visitLdcInsn(0);
        mv.visitVarInsn(54, fakeIndex);
        return fakeIndex;
    }

    private static boolean isCompatibilityStubInDefaultImpls(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context, @NotNull JvmDefaultMode jvmDefaultMode2) {
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(70);
        }
        if (context == null) {
            FunctionCodegen.$$$reportNull$$$0(71);
        }
        if (jvmDefaultMode2 == null) {
            FunctionCodegen.$$$reportNull$$$0(72);
        }
        return OwnerKind.DEFAULT_IMPLS == context.getContextKind() && FunctionCodegen.isCompiledInCompatibilityMode(jvmDefaultMode2, functionDescriptor) && JvmAnnotationUtilKt.checkIsImplementationCompiledToJvmDefault(functionDescriptor, jvmDefaultMode2);
    }

    private static boolean isCompiledInCompatibilityMode(JvmDefaultMode mode, CallableMemberDescriptor descriptor2) {
        return mode.isCompatibility() || mode == JvmDefaultMode.ALL_INCOMPATIBLE && JvmAnnotationUtilKt.hasJvmDefaultWithCompatibilityAnnotation(descriptor2.getContainingDeclaration());
    }

    private static void generateLocalVariableTable(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmMethodSignature, @NotNull FunctionDescriptor functionDescriptor, @Nullable Type thisType, @NotNull Label methodBegin, @NotNull Label methodEnd, @NotNull OwnerKind ownerKind, @NotNull GenerationState state, int shiftForDestructuringVariables) {
        FunctionDescriptor unwrapped;
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(73);
        }
        if (jvmMethodSignature == null) {
            FunctionCodegen.$$$reportNull$$$0(74);
        }
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(75);
        }
        if (methodBegin == null) {
            FunctionCodegen.$$$reportNull$$$0(76);
        }
        if (methodEnd == null) {
            FunctionCodegen.$$$reportNull$$$0(77);
        }
        if (ownerKind == null) {
            FunctionCodegen.$$$reportNull$$$0(78);
        }
        if (state == null) {
            FunctionCodegen.$$$reportNull$$$0(79);
        }
        if (functionDescriptor.isSuspend() && !(functionDescriptor instanceof AnonymousFunctionDescriptor) && (unwrapped = CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(functionDescriptor)) != functionDescriptor) {
            FunctionCodegen.generateLocalVariableTable(mv, new JvmMethodSignature(jvmMethodSignature.getAsmMethod(), jvmMethodSignature.getValueParameters().subList(0, jvmMethodSignature.getValueParameters().size() - 1)), unwrapped, thisType, methodBegin, methodEnd, ownerKind, state, shiftForDestructuringVariables);
            return;
        }
        FunctionCodegen.generateLocalVariablesForParameters(mv, jvmMethodSignature, functionDescriptor, thisType, methodBegin, methodEnd, functionDescriptor.getValueParameters(), DescriptorAsmUtil.isStaticMethod(ownerKind, functionDescriptor), state);
    }

    public static void generateLocalVariablesForParameters(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmMethodSignature, @NotNull FunctionDescriptor functionDescriptor, @Nullable Type thisType, @NotNull Label methodBegin, @NotNull Label methodEnd, Collection<ValueParameterDescriptor> valueParameters2, boolean isStatic, @NotNull GenerationState state) {
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(80);
        }
        if (jvmMethodSignature == null) {
            FunctionCodegen.$$$reportNull$$$0(81);
        }
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(82);
        }
        if (methodBegin == null) {
            FunctionCodegen.$$$reportNull$$$0(83);
        }
        if (methodEnd == null) {
            FunctionCodegen.$$$reportNull$$$0(84);
        }
        if (state == null) {
            FunctionCodegen.$$$reportNull$$$0(85);
        }
        Iterator<ValueParameterDescriptor> valueParameterIterator = valueParameters2.iterator();
        List<JvmMethodParameterSignature> params = jvmMethodSignature.getValueParameters();
        int shift = 0;
        if (!isStatic) {
            if (thisType != null) {
                mv.visitLocalVariable("this", thisType.getDescriptor(), null, methodBegin, methodEnd, shift);
            }
            ++shift;
        }
        boolean isEnumName = true;
        KotlinTypeMapper typeMapper2 = state.getTypeMapper();
        for (int i = 0; i < params.size(); ++i) {
            String parameterName;
            JvmMethodParameterSignature param = params.get(i);
            JvmMethodParameterKind kind = param.getKind();
            switch (kind) {
                case VALUE: {
                    ValueParameterDescriptor parameter = valueParameterIterator.next();
                    String nameForDestructuredParameter = VariableAsmNameManglingUtils.getNameForDestructuredParameterOrNull(parameter);
                    parameterName = nameForDestructuredParameter == null ? FunctionCodegen.computeParameterName(i, parameter) : nameForDestructuredParameter;
                    break;
                }
                case RECEIVER: 
                case CONTEXT_RECEIVER: {
                    parameterName = DescriptorAsmUtil.getNameForReceiverParameter(functionDescriptor, typeMapper2.getBindingContext(), state.getLanguageVersionSettings());
                    break;
                }
                case OUTER: {
                    parameterName = "this$0";
                    break;
                }
                case ENUM_NAME_OR_ORDINAL: {
                    parameterName = isEnumName ? "$enum$name" : "$enum$ordinal";
                    isEnumName = !isEnumName;
                    break;
                }
                default: {
                    String lowercaseKind = kind.name().toLowerCase();
                    parameterName = FunctionCodegen.needIndexForVar(kind) ? "$" + lowercaseKind + "$" + i : "$" + lowercaseKind;
                }
            }
            Type type2 = param.getAsmType();
            mv.visitLocalVariable(parameterName, type2.getDescriptor(), null, methodBegin, methodEnd, shift);
            shift += type2.getSize();
        }
    }

    private static String computeParameterName(int i, ValueParameterDescriptor parameter) {
        PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(parameter);
        if (element instanceof KtParameter && UnderscoreUtilKt.isSingleUnderscore((KtParameter)element)) {
            return "$noName_" + i;
        }
        return parameter.getName().asString();
    }

    public static void generateFacadeDelegateMethodBody(@NotNull MethodVisitor mv, @NotNull Method asmMethod2, @NotNull MultifileClassFacadeContext context) {
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(86);
        }
        if (asmMethod2 == null) {
            FunctionCodegen.$$$reportNull$$$0(87);
        }
        if (context == null) {
            FunctionCodegen.$$$reportNull$$$0(88);
        }
        FunctionCodegen.generateDelegateToStaticMethodBody(true, mv, asmMethod2, context.getFilePartType().getInternalName(), false);
    }

    private static void generateDelegateToMethodBody(int firstParamIndex, @NotNull MethodVisitor mv, @NotNull Method asmMethod2, @NotNull String classToDelegateTo, int opcode, boolean isInterface, @NotNull Type returnType2) {
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(89);
        }
        if (asmMethod2 == null) {
            FunctionCodegen.$$$reportNull$$$0(90);
        }
        if (classToDelegateTo == null) {
            FunctionCodegen.$$$reportNull$$$0(91);
        }
        if (returnType2 == null) {
            FunctionCodegen.$$$reportNull$$$0(92);
        }
        InstructionAdapter iv = new InstructionAdapter(mv);
        Type[] argTypes = asmMethod2.getArgumentTypes();
        Label label = new Label();
        iv.visitLabel(label);
        iv.visitLineNumber(1, label);
        int paramIndex = firstParamIndex;
        if (paramIndex == -1) {
            iv.load(0, AsmTypes.OBJECT_TYPE);
            paramIndex = 1;
        }
        for (Type argType : argTypes) {
            iv.load(paramIndex, argType);
            paramIndex += argType.getSize();
        }
        iv.visitMethodInsn(opcode, classToDelegateTo, asmMethod2.getName(), asmMethod2.getDescriptor(), isInterface);
        StackValue.onStack(asmMethod2.getReturnType()).coerceTo(returnType2, null, iv);
        iv.areturn(returnType2);
    }

    private static void generateDelegateToStaticErasedVersion(@NotNull MethodVisitor mv, @NotNull Method erasedStaticAsmMethod, @NotNull Type fieldOwnerType, @NotNull String fieldName, @NotNull Type fieldType) {
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(93);
        }
        if (erasedStaticAsmMethod == null) {
            FunctionCodegen.$$$reportNull$$$0(94);
        }
        if (fieldOwnerType == null) {
            FunctionCodegen.$$$reportNull$$$0(95);
        }
        if (fieldName == null) {
            FunctionCodegen.$$$reportNull$$$0(96);
        }
        if (fieldType == null) {
            FunctionCodegen.$$$reportNull$$$0(97);
        }
        String internalName2 = fieldOwnerType.getInternalName();
        InstructionAdapter iv = new InstructionAdapter(mv);
        Type[] argTypes = erasedStaticAsmMethod.getArgumentTypes();
        Label label = new Label();
        iv.visitLabel(label);
        iv.visitLineNumber(1, label);
        iv.load(0, AsmTypes.OBJECT_TYPE);
        iv.visitFieldInsn(180, internalName2, fieldName, fieldType.getDescriptor());
        int k = 1;
        for (int i = 1; i < argTypes.length; ++i) {
            Type argType = argTypes[i];
            iv.load(k, argType);
            k += argType.getSize();
        }
        iv.invokestatic(internalName2, erasedStaticAsmMethod.getName(), erasedStaticAsmMethod.getDescriptor(), false);
        iv.areturn(erasedStaticAsmMethod.getReturnType());
    }

    private static void generateDelegateToStaticMethodBody(boolean isStatic, @NotNull MethodVisitor mv, @NotNull Method asmMethod2, @NotNull String classToDelegateTo, boolean isInterfaceMethodCall) {
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(98);
        }
        if (asmMethod2 == null) {
            FunctionCodegen.$$$reportNull$$$0(99);
        }
        if (classToDelegateTo == null) {
            FunctionCodegen.$$$reportNull$$$0(100);
        }
        FunctionCodegen.generateDelegateToStaticMethodBody(isStatic, mv, asmMethod2, classToDelegateTo, isInterfaceMethodCall, asmMethod2.getReturnType());
    }

    private static void generateDelegateToStaticMethodBody(boolean isStatic, @NotNull MethodVisitor mv, @NotNull Method asmMethod2, @NotNull String classToDelegateTo, boolean isInterfaceMethodCall, @NotNull Type returnType2) {
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(101);
        }
        if (asmMethod2 == null) {
            FunctionCodegen.$$$reportNull$$$0(102);
        }
        if (classToDelegateTo == null) {
            FunctionCodegen.$$$reportNull$$$0(103);
        }
        if (returnType2 == null) {
            FunctionCodegen.$$$reportNull$$$0(104);
        }
        FunctionCodegen.generateDelegateToMethodBody(isStatic ? 0 : 1, mv, asmMethod2, classToDelegateTo, 184, isInterfaceMethodCall, returnType2);
    }

    private static boolean needIndexForVar(JvmMethodParameterKind kind) {
        return kind == JvmMethodParameterKind.CAPTURED_LOCAL_VARIABLE || kind == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL || kind == JvmMethodParameterKind.SUPER_CALL_PARAM;
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description2) {
        FunctionCodegen.endVisit(mv, description2, (PsiElement)null);
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description2, @Nullable KtPureElement method) {
        FunctionCodegen.endVisit(mv, description2, (PsiElement)(method == null ? null : method.getPsiOrParent()));
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description2, @NotNull KtElement method) {
        if (method == null) {
            FunctionCodegen.$$$reportNull$$$0(105);
        }
        FunctionCodegen.endVisit(mv, description2, (PsiElement)method);
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description2, @Nullable PsiElement method) {
        try {
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            String bytecode = FunctionCodegen.renderByteCodeIfAvailable(mv);
            throw new CompilationException("wrong bytecode generated" + (description2 != null ? " for " + description2 : "") + "\n" + (bytecode != null ? bytecode : "<no bytecode>"), e, method);
        }
    }

    @Nullable
    public static String renderByteCodeIfAvailable(@NotNull MethodVisitor mv) {
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(106);
        }
        String bytecode = null;
        if (mv instanceof TransformationMethodVisitor) {
            mv = ((TransformationMethodVisitor)mv).getTraceMethodVisitorIfPossible();
        }
        if (mv instanceof TraceMethodVisitor) {
            TraceMethodVisitor traceMethodVisitor = (TraceMethodVisitor)mv;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            traceMethodVisitor.p.print(pw);
            pw.close();
            bytecode = sw.toString();
        }
        return bytecode;
    }

    private boolean hasSpecialBridgeMethod(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            FunctionCodegen.$$$reportNull$$$0(107);
        }
        if (SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(descriptor2) == null) {
            return false;
        }
        return !BuiltinSpecialBridgesUtil.generateBridgesForBuiltinSpecial(descriptor2, this.typeMapper::mapAsmMethod, this.state).isEmpty();
    }

    public void generateBridges(@NotNull FunctionDescriptor descriptor2) {
        boolean isSpecial;
        if (descriptor2 == null) {
            FunctionCodegen.$$$reportNull$$$0(108);
        }
        if (descriptor2 instanceof ConstructorDescriptor) {
            return;
        }
        if (this.owner.getContextKind() == OwnerKind.DEFAULT_IMPLS) {
            return;
        }
        if (JvmBridgesImplKt.isAbstractOnJvmIgnoringActualModality(descriptor2, this.state.getJvmDefaultMode())) {
            return;
        }
        if (DescriptorUtils.isMethodOfAny(descriptor2)) {
            return;
        }
        boolean bl = isSpecial = SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(descriptor2) != null;
        if (!isSpecial) {
            Set<Bridge<Method, DescriptorBasedFunctionHandleForJvm>> bridgesToGenerate2 = JvmBridgesImplKt.generateBridgesForFunctionDescriptorForJvm(descriptor2, this.typeMapper::mapAsmMethod, this.state);
            if (!bridgesToGenerate2.isEmpty()) {
                PsiElement origin = descriptor2.getKind() == CallableMemberDescriptor.Kind.DECLARATION ? DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2) : null;
                boolean isSpecialBridge = BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava(descriptor2) != null;
                for (Bridge<Method, DescriptorBasedFunctionHandleForJvm> bridge : bridgesToGenerate2) {
                    this.generateBridge(origin, descriptor2, bridge.getFrom(), bridge.getTo(), this.getBridgeReturnType(bridge), isSpecialBridge, false);
                }
            }
        } else {
            Set<BridgeForBuiltinSpecial<Method>> specials = BuiltinSpecialBridgesUtil.generateBridgesForBuiltinSpecial(descriptor2, this.typeMapper::mapAsmMethod, this.state);
            if (!specials.isEmpty()) {
                PsiElement origin = descriptor2.getKind() == CallableMemberDescriptor.Kind.DECLARATION ? DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2) : null;
                for (BridgeForBuiltinSpecial<Method> bridge : specials) {
                    this.generateBridge(origin, descriptor2, bridge.getFrom(), bridge.getTo(), descriptor2.getReturnType(), bridge.isSpecial(), bridge.isDelegateToSuper());
                }
            }
            if (!descriptor2.getKind().isReal() && DescriptorAsmUtil.isAbstractMethod(descriptor2, OwnerKind.IMPLEMENTATION, this.state.getJvmDefaultMode())) {
                FunctionDescriptor overridden = SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(descriptor2);
                assert (overridden != null);
                if (!FunctionCodegen.isThereOverriddenInKotlinClass(descriptor2)) {
                    Method method = this.typeMapper.mapAsmMethod(descriptor2);
                    int flags = 0x400 | DescriptorAsmUtil.getVisibilityAccessFlag(descriptor2);
                    this.v.newMethod(JvmDeclarationOriginKt.AugmentedBuiltInApi(overridden), flags, method.getName(), method.getDescriptor(), null, null);
                }
            }
        }
    }

    private KotlinType getBridgeReturnType(Bridge<Method, DescriptorBasedFunctionHandleForJvm> bridge) {
        Iterator<DescriptorBasedFunctionHandleForJvm> iterator2 = bridge.getOriginalFunctions().iterator();
        if (iterator2.hasNext()) {
            DescriptorBasedFunctionHandleForJvm handle3 = iterator2.next();
            return handle3.getDescriptor().getReturnType();
        }
        if (this.state.getClassBuilderMode().mightBeIncorrectCode) {
            return this.state.getModule().getBuiltIns().getNullableAnyType();
        }
        if (bridge.getOriginalFunctions().isEmpty()) {
            throw new AssertionError((Object)("No overridden functions for the bridge method '" + bridge.getTo() + "'"));
        }
        throw new AssertionError((Object)("No return type for the bridge method '" + bridge.getTo() + "' found in the following overridden functions:\n" + bridge.getOriginalFunctions().stream().map(handle2 -> handle2.getDescriptor().toString()).collect(Collectors.joining("\n"))));
    }

    public static boolean isThereOverriddenInKotlinClass(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            FunctionCodegen.$$$reportNull$$$0(109);
        }
        return CollectionsKt.any(DescriptorUtils.getAllOverriddenDescriptors(descriptor2), overridden -> !(overridden.getContainingDeclaration() instanceof JavaClassDescriptor) && DescriptorUtils.isClass(overridden.getContainingDeclaration()));
    }

    @NotNull
    public static String[] getThrownExceptions(@NotNull FunctionDescriptor function2, @NotNull KotlinTypeMapper typeMapper2) {
        if (function2 == null) {
            FunctionCodegen.$$$reportNull$$$0(110);
        }
        if (typeMapper2 == null) {
            FunctionCodegen.$$$reportNull$$$0(111);
        }
        String[] stringArray = ArrayUtil.toStringArray(CollectionsKt.map(FunctionCodegen.getThrownExceptions(function2, typeMapper2.getLanguageVersionSettings()), d -> typeMapper2.mapClass((ClassifierDescriptor)d).getInternalName()));
        if (stringArray == null) {
            FunctionCodegen.$$$reportNull$$$0(112);
        }
        return stringArray;
    }

    @NotNull
    public static List<ClassDescriptor> getThrownExceptions(@NotNull FunctionDescriptor function2, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (function2 == null) {
            FunctionCodegen.$$$reportNull$$$0(113);
        }
        if (languageVersionSettings == null) {
            FunctionCodegen.$$$reportNull$$$0(114);
        }
        if (function2.getKind() == CallableMemberDescriptor.Kind.DELEGATION && languageVersionSettings.supportsFeature(LanguageFeature.DoNotGenerateThrowsForDelegatedKotlinMembers)) {
            List<ClassDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                FunctionCodegen.$$$reportNull$$$0(115);
            }
            return list2;
        }
        AnnotationDescriptor annotation2 = function2.getAnnotations().findAnnotation(ThrowUtilKt.JVM_THROWS_ANNOTATION_FQ_NAME);
        if (annotation2 == null) {
            List<ClassDescriptor> list3 = Collections.emptyList();
            if (list3 == null) {
                FunctionCodegen.$$$reportNull$$$0(116);
            }
            return list3;
        }
        Collection<ConstantValue<?>> values2 = annotation2.getAllValueArguments().values();
        if (values2.isEmpty()) {
            List<ClassDescriptor> list4 = Collections.emptyList();
            if (list4 == null) {
                FunctionCodegen.$$$reportNull$$$0(117);
            }
            return list4;
        }
        ConstantValue<?> value2 = values2.iterator().next();
        if (!(value2 instanceof ArrayValue)) {
            List<ClassDescriptor> list5 = Collections.emptyList();
            if (list5 == null) {
                FunctionCodegen.$$$reportNull$$$0(118);
            }
            return list5;
        }
        ArrayValue arrayValue = (ArrayValue)value2;
        List<ClassDescriptor> list6 = CollectionsKt.mapNotNull((Iterable)arrayValue.getValue(), constant -> {
            if (constant instanceof KClassValue) {
                return DescriptorUtils.getClassDescriptorForType(((KClassValue)constant).getArgumentType(DescriptorUtilsKt.getModule(function2)));
            }
            return null;
        });
        if (list6 == null) {
            FunctionCodegen.$$$reportNull$$$0(119);
        }
        return list6;
    }

    void generateDefaultIfNeeded(@NotNull MethodContext owner, @NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind kind, @NotNull DefaultParameterValueLoader loadStrategy, @Nullable KtNamedFunction function2) {
        DeclarationDescriptor contextClass;
        if (owner == null) {
            FunctionCodegen.$$$reportNull$$$0(120);
        }
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(121);
        }
        if (kind == null) {
            FunctionCodegen.$$$reportNull$$$0(122);
        }
        if (loadStrategy == null) {
            FunctionCodegen.$$$reportNull$$$0(123);
        }
        if (DescriptorUtils.isInterface(contextClass = ((CallableMemberDescriptor)owner.getContextDescriptor()).getContainingDeclaration()) && !FunctionCodegen.processInterfaceMethod(functionDescriptor, kind, true, false, this.state.getJvmDefaultMode())) {
            return;
        }
        if (InlineClassesUtilsKt.isInlineClass(contextClass) && kind != OwnerKind.ERASED_INLINE_CLASS) {
            return;
        }
        if (!this.isDefaultNeeded(functionDescriptor, function2)) {
            return;
        }
        int visibilityFlag = !(DescriptorUtils.isInterface(functionDescriptor.getContainingDeclaration()) && kind != OwnerKind.DEFAULT_IMPLS || !DescriptorVisibilities.isPrivate(functionDescriptor.getVisibility()) && !InlineOnlyKt.isInlineOnlyPrivateInBytecode(functionDescriptor)) ? 0 : 1;
        int flags = visibilityFlag | DescriptorAsmUtil.getDeprecatedAccessFlag(functionDescriptor) | 0x1000;
        if (!(functionDescriptor instanceof ConstructorDescriptor) || InlineClassesUtilsKt.isInlineClass(functionDescriptor.getContainingDeclaration())) {
            flags |= 8;
        }
        Method defaultMethod = this.typeMapper.mapDefaultMethod(functionDescriptor, kind);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.Synthetic(function2, functionDescriptor), flags, defaultMethod.getName(), defaultMethod.getDescriptor(), null, FunctionCodegen.getThrownExceptions(functionDescriptor, this.typeMapper));
        if (!this.state.getClassBuilderMode().generateBodies) {
            if (this.owner instanceof MultifileClassFacadeContext) {
                FunctionCodegen.endVisit(mv, "default method delegation", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
            } else {
                FunctionCodegen.endVisit(mv, "default method", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
            }
            return;
        }
        if (this.owner instanceof MultifileClassFacadeContext) {
            mv.visitCode();
            FunctionCodegen.generateFacadeDelegateMethodBody(mv, defaultMethod, (MultifileClassFacadeContext)this.owner);
            FunctionCodegen.endVisit(mv, "default method delegation", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
        } else if (FunctionCodegen.isCompatibilityStubInDefaultImpls(functionDescriptor, owner, this.state.getJvmDefaultMode())) {
            mv.visitCode();
            Method interfaceDefaultMethod = this.typeMapper.mapDefaultMethod(functionDescriptor, OwnerKind.IMPLEMENTATION);
            FunctionCodegen.generateDelegateToStaticMethodBody(true, mv, interfaceDefaultMethod, this.typeMapper.mapOwner(functionDescriptor).getInternalName(), true);
            FunctionCodegen.endVisit(mv, "default method delegation to interface one", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
        } else {
            mv.visitCode();
            FunctionCodegen.generateDefaultImplBody(owner, functionDescriptor, mv, loadStrategy, function2, this.memberCodegen, defaultMethod);
            FunctionCodegen.endVisit(mv, "default method", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
        }
    }

    public static void generateDefaultImplBody(@NotNull MethodContext methodContext2, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodVisitor mv, @NotNull DefaultParameterValueLoader loadStrategy, @Nullable KtNamedFunction function2, @NotNull MemberCodegen<?> parentCodegen, @NotNull Method defaultMethod) {
        int index2;
        int capturedArgumentsCount;
        if (methodContext2 == null) {
            FunctionCodegen.$$$reportNull$$$0(124);
        }
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(125);
        }
        if (mv == null) {
            FunctionCodegen.$$$reportNull$$$0(126);
        }
        if (loadStrategy == null) {
            FunctionCodegen.$$$reportNull$$$0(127);
        }
        if (parentCodegen == null) {
            FunctionCodegen.$$$reportNull$$$0(128);
        }
        if (defaultMethod == null) {
            FunctionCodegen.$$$reportNull$$$0(129);
        }
        if (methodContext2 instanceof ConstructorContext) {
            ((ConstructorContext)methodContext2).setThisInitialized(false);
        }
        GenerationState state = parentCodegen.state;
        JvmMethodGenericSignature signature2 = state.getTypeMapper().mapSignatureWithGeneric(functionDescriptor, methodContext2.getContextKind());
        List<ValueParameterDescriptor> valueParameters2 = functionDescriptor.isSuspend() ? CollectionsKt.plus(CodegenUtil.getFunctionParametersForDefaultValueGeneration(CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(functionDescriptor), null), CollectionsKt.last(functionDescriptor.getValueParameters())) : CodegenUtil.getFunctionParametersForDefaultValueGeneration(functionDescriptor, null);
        boolean isStatic = DescriptorAsmUtil.isStaticMethod(methodContext2.getContextKind(), functionDescriptor);
        FrameMap frameMap = FunctionCodegen.createFrameMap(state, signature2, functionDescriptor.getExtensionReceiverParameter(), valueParameters2, isStatic);
        ExpressionCodegen codegen2 = new ExpressionCodegen(mv, frameMap, signature2.getReturnType(), methodContext2, state, parentCodegen);
        CallGenerator generator2 = codegen2.getOrCreateCallGeneratorForDefaultImplBody(functionDescriptor, function2);
        InstructionAdapter iv = new InstructionAdapter(mv);
        FunctionCodegen.genDefaultSuperCallCheckIfNeeded(iv, functionDescriptor, defaultMethod);
        List<JvmMethodParameterSignature> mappedParameters = signature2.getValueParameters();
        for (capturedArgumentsCount = 0; capturedArgumentsCount < mappedParameters.size() && mappedParameters.get(capturedArgumentsCount).getKind() != JvmMethodParameterKind.VALUE; ++capturedArgumentsCount) {
        }
        assert (valueParameters2.size() > 0) : "Expecting value parameters to generate default function " + functionDescriptor;
        int firstMaskIndex = frameMap.enterTemp(Type.INT_TYPE);
        for (index2 = 1; index2 < valueParameters2.size(); ++index2) {
            if (index2 % 32 != 0) continue;
            frameMap.enterTemp(Type.INT_TYPE);
        }
        frameMap.enterTemp(AsmTypes.OBJECT_TYPE);
        for (index2 = 0; index2 < valueParameters2.size(); ++index2) {
            int maskIndex = firstMaskIndex + index2 / 32;
            ValueParameterDescriptor parameterDescriptor = valueParameters2.get(index2);
            Type type2 = mappedParameters.get(capturedArgumentsCount + index2).getAsmType();
            int parameterIndex = frameMap.getIndex(parameterDescriptor);
            if (!parameterDescriptor.declaresDefaultValue()) continue;
            iv.load(maskIndex, Type.INT_TYPE);
            iv.iconst(1 << index2 % 32);
            iv.and(Type.INT_TYPE);
            Label loadArg = new Label();
            iv.ifeq(loadArg);
            CallableDescriptor containingDeclaration = parameterDescriptor.getContainingDeclaration();
            codegen2.runWithShouldMarkLineNumbers(!(containingDeclaration instanceof MemberDescriptor) || !((MemberDescriptor)((Object)containingDeclaration)).isExpect(), () -> {
                StackValue.local(parameterIndex, type2, parameterDescriptor.getType()).store(loadStrategy.genValue(parameterDescriptor, codegen2), iv);
                return null;
            });
            iv.mark(loadArg);
        }
        FunctionCodegen.loadExplicitArgumentsOnStack(AsmTypes.OBJECT_TYPE, isStatic, signature2, generator2);
        for (index2 = 0; index2 < valueParameters2.size(); ++index2) {
            ValueParameterDescriptor parameterDescriptor = valueParameters2.get(index2);
            Type type3 = mappedParameters.get(capturedArgumentsCount + index2).getAsmType();
            int parameterIndex = frameMap.getIndex(parameterDescriptor);
            generator2.putValueIfNeeded(new JvmKotlinType(type3, null), StackValue.local(parameterIndex, type3));
        }
        CallableMethod method = state.getTypeMapper().mapToCallableMethod(functionDescriptor, false, methodContext2.getContextKind());
        generator2.genCall(method, null, false, codegen2);
        iv.areturn(signature2.getReturnType());
    }

    private static void genDefaultSuperCallCheckIfNeeded(@NotNull InstructionAdapter iv, @NotNull FunctionDescriptor descriptor2, @NotNull Method defaultMethod) {
        if (iv == null) {
            FunctionCodegen.$$$reportNull$$$0(130);
        }
        if (descriptor2 == null) {
            FunctionCodegen.$$$reportNull$$$0(131);
        }
        if (defaultMethod == null) {
            FunctionCodegen.$$$reportNull$$$0(132);
        }
        if (descriptor2 instanceof ConstructorDescriptor) {
            return;
        }
        DeclarationDescriptor container = descriptor2.getContainingDeclaration();
        if (!(container instanceof ClassDescriptor)) {
            return;
        }
        if (((ClassDescriptor)container).getModality() == Modality.FINAL) {
            return;
        }
        Label end = new Label();
        int handleIndex = (Type.getArgumentsAndReturnSizes(defaultMethod.getDescriptor()) >> 2) - 2;
        iv.load(handleIndex, AsmTypes.OBJECT_TYPE);
        iv.ifnull(end);
        AsmUtil.genThrow(iv, "java/lang/UnsupportedOperationException", "Super calls with default arguments not supported in this target, function: " + descriptor2.getName().asString());
        iv.visitLabel(end);
    }

    @NotNull
    private static FrameMap createFrameMap(@NotNull GenerationState state, @NotNull JvmMethodSignature signature2, @Nullable ReceiverParameterDescriptor extensionReceiverParameter2, @NotNull List<ValueParameterDescriptor> valueParameters2, boolean isStatic) {
        if (state == null) {
            FunctionCodegen.$$$reportNull$$$0(133);
        }
        if (signature2 == null) {
            FunctionCodegen.$$$reportNull$$$0(134);
        }
        if (valueParameters2 == null) {
            FunctionCodegen.$$$reportNull$$$0(135);
        }
        FrameMapWithExpectActualSupport frameMap = new FrameMapWithExpectActualSupport(state.getModule());
        if (!isStatic) {
            frameMap.enterTemp(AsmTypes.OBJECT_TYPE);
        }
        for (JvmMethodParameterSignature jvmMethodParameterSignature : signature2.getValueParameters()) {
            if (jvmMethodParameterSignature.getKind() == JvmMethodParameterKind.RECEIVER || jvmMethodParameterSignature.getKind() == JvmMethodParameterKind.CONTEXT_RECEIVER) {
                if (extensionReceiverParameter2 != null) {
                    frameMap.enter(extensionReceiverParameter2, state.getTypeMapper().mapType(extensionReceiverParameter2));
                    continue;
                }
                frameMap.enterTemp(jvmMethodParameterSignature.getAsmType());
                continue;
            }
            if (jvmMethodParameterSignature.getKind() == JvmMethodParameterKind.VALUE) continue;
            frameMap.enterTemp(jvmMethodParameterSignature.getAsmType());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : valueParameters2) {
            frameMap.enter(valueParameterDescriptor, state.getTypeMapper().mapType(valueParameterDescriptor));
        }
        FrameMapWithExpectActualSupport frameMapWithExpectActualSupport = frameMap;
        if (frameMapWithExpectActualSupport == null) {
            FunctionCodegen.$$$reportNull$$$0(136);
        }
        return frameMapWithExpectActualSupport;
    }

    private static void loadExplicitArgumentsOnStack(@NotNull Type ownerType, boolean isStatic, @NotNull JvmMethodSignature signature2, @NotNull CallGenerator callGenerator) {
        if (ownerType == null) {
            FunctionCodegen.$$$reportNull$$$0(137);
        }
        if (signature2 == null) {
            FunctionCodegen.$$$reportNull$$$0(138);
        }
        if (callGenerator == null) {
            FunctionCodegen.$$$reportNull$$$0(139);
        }
        int var = 0;
        if (!isStatic) {
            callGenerator.putValueIfNeeded(new JvmKotlinType(ownerType, null), StackValue.local(var, ownerType));
            var += ownerType.getSize();
        }
        for (JvmMethodParameterSignature parameterSignature : signature2.getValueParameters()) {
            if (parameterSignature.getKind() == JvmMethodParameterKind.VALUE) continue;
            Type type2 = parameterSignature.getAsmType();
            callGenerator.putValueIfNeeded(new JvmKotlinType(type2, null), StackValue.local(var, type2));
            var += type2.getSize();
        }
    }

    private boolean isDefaultNeeded(@NotNull FunctionDescriptor descriptor2, @Nullable KtNamedFunction function2) {
        if (descriptor2 == null) {
            FunctionCodegen.$$$reportNull$$$0(140);
        }
        List<ValueParameterDescriptor> parameters2 = CodegenUtil.getFunctionParametersForDefaultValueGeneration(descriptor2.isSuspend() ? CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(descriptor2) : descriptor2, this.state.getDiagnostics());
        return CollectionsKt.any(parameters2, ValueParameterDescriptor::declaresDefaultValue);
    }

    private void generateBridge(@Nullable PsiElement origin, @NotNull FunctionDescriptor descriptor2, @NotNull Method bridge, @NotNull Method delegateTo, @NotNull KotlinType bridgeReturnType, boolean isSpecialBridge, boolean isStubDeclarationWithDelegationToSuper) {
        if (descriptor2 == null) {
            FunctionCodegen.$$$reportNull$$$0(141);
        }
        if (bridge == null) {
            FunctionCodegen.$$$reportNull$$$0(142);
        }
        if (delegateTo == null) {
            FunctionCodegen.$$$reportNull$$$0(143);
        }
        if (bridgeReturnType == null) {
            FunctionCodegen.$$$reportNull$$$0(144);
        }
        boolean isSpecialOrDelegationToSuper = isSpecialBridge || isStubDeclarationWithDelegationToSuper;
        int flags = 0x41 | (!isSpecialOrDelegationToSuper ? 4096 : 0) | (isSpecialBridge ? 16 : 0);
        String bridgeSignature = isSpecialBridge ? this.typeMapper.mapSignatureWithGeneric(descriptor2, OwnerKind.IMPLEMENTATION).getGenericsSignature() : null;
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.Bridge(descriptor2, origin), flags, bridge.getName(), bridge.getDescriptor(), bridgeSignature, null);
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        mv.visitCode();
        InstructionAdapter iv = new InstructionAdapter(mv);
        Type[] argTypes = bridge.getArgumentTypes();
        Type[] originalArgTypes = delegateTo.getArgumentTypes();
        ArrayList<ParameterDescriptor> allKotlinParameters = new ArrayList<ParameterDescriptor>(originalArgTypes.length);
        if (descriptor2.getExtensionReceiverParameter() != null) {
            allKotlinParameters.add(descriptor2.getExtensionReceiverParameter());
        }
        allKotlinParameters.addAll(descriptor2.getValueParameters());
        boolean safeToUseKotlinTypes = allKotlinParameters.size() == originalArgTypes.length;
        boolean isVarargInvoke = JvmCodegenUtil.isOverrideOfBigArityFunctionInvoke(descriptor2);
        if (isVarargInvoke) {
            assert (argTypes.length == 1 && argTypes[0].equals(AsmUtil.getArrayType(AsmTypes.OBJECT_TYPE))) : "Vararg invoke must have one parameter of type [Ljava/lang/Object;: " + bridge;
            DescriptorAsmUtil.generateVarargInvokeArityAssert(iv, originalArgTypes.length);
        } else assert (argTypes.length == originalArgTypes.length) : "Number of parameters of the bridge and delegate must be the same.\nDescriptor: " + descriptor2 + "\nBridge: " + bridge + "\nDelegate: " + delegateTo;
        MemberCodegen.markLineNumberForDescriptor(this.owner.getThisDescriptor(), iv);
        if (delegateTo.getArgumentTypes().length > 0 && isSpecialBridge) {
            FunctionCodegen.generateTypeCheckBarrierIfNeeded(iv, descriptor2, bridge.getReturnType(), delegateTo.getArgumentTypes(), this.typeMapper);
        }
        iv.load(0, AsmTypes.OBJECT_TYPE);
        int reg = 1;
        for (int i = 0; i < originalArgTypes.length; ++i) {
            StackValue value2;
            KotlinType kotlinType;
            KotlinType kotlinType2 = kotlinType = safeToUseKotlinTypes ? ((ParameterDescriptor)allKotlinParameters.get(i)).getType() : null;
            if (isVarargInvoke) {
                value2 = StackValue.arrayElement(AsmTypes.OBJECT_TYPE, null, StackValue.local(1, argTypes[0]), StackValue.constant(i));
            } else {
                value2 = StackValue.local(reg, argTypes[i], kotlinType);
                reg += argTypes[i].getSize();
            }
            value2.put(originalArgTypes[i], kotlinType, iv);
        }
        if (isStubDeclarationWithDelegationToSuper) {
            ClassDescriptor parentClass = DescriptorUtils.getSuperClassDescriptor((ClassDescriptor)descriptor2.getContainingDeclaration());
            assert (parentClass != null);
            String parentInternalName = this.typeMapper.mapClass(parentClass).getInternalName();
            iv.invokespecial(parentInternalName, delegateTo.getName(), delegateTo.getDescriptor(), false);
        } else if (DescriptorUtils.isInterface(descriptor2.getContainingDeclaration()) && JvmAnnotationUtilKt.isCompiledToJvmDefault(descriptor2, this.state.getJvmDefaultMode())) {
            iv.invokeinterface(this.v.getThisName(), delegateTo.getName(), delegateTo.getDescriptor());
        } else {
            iv.invokevirtual(this.v.getThisName(), delegateTo.getName(), delegateTo.getDescriptor(), false);
        }
        KotlinType returnValueType = descriptor2.getReturnType();
        StackValue.coerce(delegateTo.getReturnType(), returnValueType, bridge.getReturnType(), bridgeReturnType, iv);
        iv.areturn(bridge.getReturnType());
        FunctionCodegen.endVisit(mv, "bridge method", origin);
    }

    private static void generateTypeCheckBarrierIfNeeded(@NotNull InstructionAdapter iv, @NotNull FunctionDescriptor descriptor2, @NotNull Type returnType2, @Nullable Type[] delegateParameterTypes, @NotNull KotlinTypeMapper typeMapper2) {
        SpecialGenericSignatures.TypeSafeBarrierDescription typeSafeBarrierDescription;
        if (iv == null) {
            FunctionCodegen.$$$reportNull$$$0(145);
        }
        if (descriptor2 == null) {
            FunctionCodegen.$$$reportNull$$$0(146);
        }
        if (returnType2 == null) {
            FunctionCodegen.$$$reportNull$$$0(147);
        }
        if (typeMapper2 == null) {
            FunctionCodegen.$$$reportNull$$$0(148);
        }
        if ((typeSafeBarrierDescription = BuiltinMethodsWithSpecialGenericSignature.getDefaultValueForOverriddenBuiltinFunction(descriptor2)) == null) {
            return;
        }
        FunctionDescriptor overriddenBuiltin = BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava(descriptor2);
        assert (overriddenBuiltin != null) : "Overridden built-in method should not be null for " + descriptor2;
        Label defaultBranch = new Label();
        for (int i = 0; i < descriptor2.getValueParameters().size(); ++i) {
            if (!typeSafeBarrierDescription.checkParameter(i)) continue;
            boolean isCheckForAny = delegateParameterTypes == null || AsmTypes.OBJECT_TYPE.equals(delegateParameterTypes[i]);
            KotlinType kotlinType = descriptor2.getValueParameters().get(i).getType();
            if (isCheckForAny && TypeUtils.isNullableType(kotlinType)) continue;
            iv.load(1 + i, AsmTypes.OBJECT_TYPE);
            if (isCheckForAny) {
                assert (!TypeUtils.isNullableType(kotlinType)) : "Only bridges for not-nullable types are necessary";
                iv.ifnull(defaultBranch);
                continue;
            }
            Type targetBoxedType = InlineClassesUtilsKt.isInlineClassType(kotlinType) ? typeMapper2.mapTypeAsDeclaration(kotlinType) : AsmUtil.boxType(delegateParameterTypes[i]);
            CodegenUtilKt.generateIsCheck(iv, kotlinType, targetBoxedType);
            iv.ifeq(defaultBranch);
        }
        Label afterDefaultBranch = new Label();
        iv.goTo(afterDefaultBranch);
        iv.visitLabel(defaultBranch);
        if (typeSafeBarrierDescription.equals((Object)SpecialGenericSignatures.TypeSafeBarrierDescription.MAP_GET_OR_DEFAULT)) {
            iv.load(2, returnType2);
        } else {
            StackValue.constant(typeSafeBarrierDescription.getDefaultValue(), returnType2).put(iv);
        }
        iv.areturn(returnType2);
        iv.visitLabel(afterDefaultBranch);
    }

    public void genSamDelegate(@NotNull FunctionDescriptor functionDescriptor, FunctionDescriptor overriddenDescriptor2, StackValue field2) {
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(149);
        }
        FunctionDescriptor delegatedTo = overriddenDescriptor2.getOriginal();
        JvmDeclarationOrigin declarationOrigin = JvmDeclarationOriginKt.SamDelegation(functionDescriptor);
        this.genDelegate(functionDescriptor, delegatedTo, declarationOrigin, (ClassDescriptor)overriddenDescriptor2.getContainingDeclaration(), field2, true);
    }

    public void genDelegate(@NotNull FunctionDescriptor functionDescriptor, FunctionDescriptor overriddenDescriptor2, StackValue field2) {
        if (functionDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(150);
        }
        this.genDelegate(functionDescriptor, overriddenDescriptor2.getOriginal(), (ClassDescriptor)overriddenDescriptor2.getContainingDeclaration(), field2);
    }

    public void genDelegate(@NotNull FunctionDescriptor delegateFunction, FunctionDescriptor delegatedTo, ClassDescriptor toClass, StackValue field2) {
        if (delegateFunction == null) {
            FunctionCodegen.$$$reportNull$$$0(151);
        }
        JvmDeclarationOrigin declarationOrigin = JvmDeclarationOriginKt.Delegation(DescriptorToSourceUtils.descriptorToDeclaration(delegatedTo), delegateFunction);
        this.genDelegate(delegateFunction, delegatedTo, declarationOrigin, toClass, field2, false);
    }

    private void genDelegate(final @NotNull FunctionDescriptor delegateFunction, final FunctionDescriptor delegatedTo, @NotNull JvmDeclarationOrigin declarationOrigin, final ClassDescriptor toClass, final StackValue field2, final boolean skipGenericSignature) {
        if (delegateFunction == null) {
            FunctionCodegen.$$$reportNull$$$0(152);
        }
        if (declarationOrigin == null) {
            FunctionCodegen.$$$reportNull$$$0(153);
        }
        this.generateMethod(declarationOrigin, delegateFunction, new FunctionGenerationStrategy(){

            @Override
            public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature2, @NotNull MethodContext context, @NotNull MemberCodegen<?> parentCodegen) {
                if (mv == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (frameMap == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (signature2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (parentCodegen == null) {
                    1.$$$reportNull$$$0(4);
                }
                Method delegateMethod = FunctionCodegen.this.typeMapper.mapAsmMethod(delegateFunction);
                Type[] argTypes = delegateMethod.getArgumentTypes();
                List<KotlinType> argKotlinTypes = this.getKotlinTypesForJvmParameters(delegateFunction);
                Method delegateToMethod = FunctionCodegen.this.typeMapper.mapToCallableMethod(delegatedTo, false).getAsmMethod();
                Type[] originalArgTypes = delegateToMethod.getArgumentTypes();
                List<KotlinType> originalArgKotlinTypes = this.getKotlinTypesForJvmParameters(delegatedTo);
                InstructionAdapter iv = new InstructionAdapter(mv);
                iv.load(0, AsmTypes.OBJECT_TYPE);
                field2.put(iv);
                int toArgsShift = InlineClassesUtilsKt.isInlineClass(toClass) ? 1 : 0;
                int reg = 1;
                for (int i = 0; i < argTypes.length; ++i) {
                    Type argType = argTypes[i];
                    KotlinType argKotlinType = argKotlinTypes.get(i);
                    Type toArgType = originalArgTypes[i + toArgsShift];
                    KotlinType toArgKotlinType = originalArgKotlinTypes.get(i);
                    StackValue.local(reg, argType, argKotlinType).put(toArgType, toArgKotlinType, iv);
                    reg += argType.getSize();
                }
                String internalName2 = FunctionCodegen.this.typeMapper.mapClass(toClass).getInternalName();
                if (toClass.getKind() == ClassKind.INTERFACE) {
                    iv.invokeinterface(internalName2, delegateToMethod.getName(), delegateToMethod.getDescriptor());
                } else if (InlineClassesUtilsKt.isInlineClass(toClass)) {
                    iv.invokestatic(internalName2, delegateToMethod.getName(), delegateToMethod.getDescriptor(), false);
                } else {
                    iv.invokevirtual(internalName2, delegateToMethod.getName(), delegateToMethod.getDescriptor(), false);
                }
                StackValue stackValue = DescriptorAsmUtil.genNotNullAssertions(FunctionCodegen.this.state, StackValue.onStack(delegateToMethod.getReturnType(), delegatedTo.getReturnType()), RuntimeAssertionInfo.create(delegateFunction.getReturnType(), delegatedTo.getReturnType(), new RuntimeAssertionInfo.DataFlowExtras.OnlyMessage(delegatedTo.getName() + "(...)")));
                stackValue.put(delegateMethod.getReturnType(), delegateFunction.getReturnType(), iv);
                iv.areturn(delegateMethod.getReturnType());
            }

            @Override
            public boolean skipNotNullAssertionsForParameters() {
                return false;
            }

            @Override
            public boolean skipGenericSignature() {
                return skipGenericSignature;
            }

            private List<KotlinType> getKotlinTypesForJvmParameters(@NotNull FunctionDescriptor functionDescriptor) {
                if (functionDescriptor == null) {
                    1.$$$reportNull$$$0(5);
                }
                ArrayList<KotlinType> kotlinTypes = new ArrayList<KotlinType>();
                ReceiverParameterDescriptor extensionReceiver = functionDescriptor.getExtensionReceiverParameter();
                if (extensionReceiver != null) {
                    kotlinTypes.add(extensionReceiver.getType());
                }
                for (ValueParameterDescriptor parameter : functionDescriptor.getValueParameters()) {
                    kotlinTypes.add(parameter.getType());
                }
                if (functionDescriptor.isSuspend()) {
                    kotlinTypes.add(null);
                }
                return kotlinTypes;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mv";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "frameMap";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "signature";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parentCodegen";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "functionDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/codegen/FunctionCodegen$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "generateBody";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getKotlinTypesForJvmParameters";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean processInterfaceMethod(@NotNull CallableMemberDescriptor memberDescriptor, @NotNull OwnerKind kind, boolean isDefault, boolean isSynthetic, JvmDefaultMode mode) {
        if (memberDescriptor == null) {
            FunctionCodegen.$$$reportNull$$$0(154);
        }
        if (kind == null) {
            FunctionCodegen.$$$reportNull$$$0(155);
        }
        DeclarationDescriptor containingDeclaration = memberDescriptor.getContainingDeclaration();
        assert (DescriptorUtils.isInterface(containingDeclaration)) : "'processInterfaceMethod' method should be called only for interfaces, but: " + containingDeclaration;
        if (JvmAnnotationUtilKt.checkIsImplementationCompiledToJvmDefault(memberDescriptor, mode)) {
            boolean isCompatibilityMode = FunctionCodegen.isCompiledInCompatibilityMode(mode, memberDescriptor);
            boolean isSyntheticInCompatibilityOrJvmDefault = isSynthetic && (isCompatibilityMode || mode == JvmDefaultMode.ENABLE);
            return kind != OwnerKind.DEFAULT_IMPLS && !isSyntheticInCompatibilityOrJvmDefault || kind == OwnerKind.DEFAULT_IMPLS && (isSyntheticInCompatibilityOrJvmDefault || isCompatibilityMode && !JvmAnnotationUtilKt.hasJvmDefaultNoCompatibilityAnnotation(containingDeclaration)) && !DescriptorVisibilities.isPrivate(memberDescriptor.getVisibility());
        }
        switch (kind) {
            case DEFAULT_IMPLS: {
                return true;
            }
            case IMPLEMENTATION: {
                return !DescriptorVisibilities.isPrivate(memberDescriptor.getVisibility()) && !isDefault && !isSynthetic;
            }
        }
        return false;
    }

    @Nullable
    public CalculatedClosure getClosure() {
        return this.owner.closure;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 136: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 136: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 2: 
            case 57: 
            case 79: 
            case 85: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberCodegen";
                break;
            }
            case 4: 
            case 110: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: 
            case 11: 
            case 14: 
            case 15: 
            case 25: 
            case 29: 
            case 33: 
            case 38: 
            case 45: 
            case 52: 
            case 58: 
            case 62: 
            case 70: 
            case 75: 
            case 82: 
            case 121: 
            case 125: 
            case 149: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateFunctionDescriptor";
                break;
            }
            case 7: 
            case 10: 
            case 20: 
            case 24: 
            case 28: 
            case 32: 
            case 37: 
            case 44: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 8: 
            case 107: 
            case 108: 
            case 109: 
            case 131: 
            case 140: 
            case 141: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: 
            case 13: 
            case 40: 
            case 47: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 12: 
            case 39: 
            case 46: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodContext";
                break;
            }
            case 16: 
            case 43: 
            case 87: 
            case 90: 
            case 99: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asmMethod";
                break;
            }
            case 17: 
            case 42: 
            case 49: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmSignature";
                break;
            }
            case 18: 
            case 35: 
            case 41: 
            case 48: 
            case 53: 
            case 61: 
            case 68: 
            case 73: 
            case 80: 
            case 86: 
            case 89: 
            case 93: 
            case 98: 
            case 101: 
            case 106: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mv";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalVisibleAnnotations";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 23: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/FunctionCodegen";
                break;
            }
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextKind";
                break;
            }
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlineClass";
                break;
            }
            case 36: 
            case 60: 
            case 111: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classBuilderMode";
                break;
            }
            case 55: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameters";
                break;
            }
            case 59: 
            case 63: 
            case 71: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 64: 
            case 134: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 66: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentCodegen";
                break;
            }
            case 67: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmDefaultMode";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameMap";
                break;
            }
            case 74: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmMethodSignature";
                break;
            }
            case 76: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodBegin";
                break;
            }
            case 77: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodEnd";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerKind";
                break;
            }
            case 91: 
            case 100: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToDelegateTo";
                break;
            }
            case 92: 
            case 104: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "erasedStaticAsmMethod";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldOwnerType";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 122: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 123: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadStrategy";
                break;
            }
            case 129: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMethod";
                break;
            }
            case 130: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iv";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerType";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callGenerator";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bridge";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateTo";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bridgeReturnType";
                break;
            }
            case 151: 
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateFunction";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationOrigin";
                break;
            }
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/FunctionCodegen";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "newMethod";
                break;
            }
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownExceptions";
                break;
            }
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrameMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "gen";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateOverloadsWithDefaultValues";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateMethod";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "recordMethodForFunctionIfAppropriate";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodAnnotationsIfRequired";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "newMethod";
                break;
            }
            case 23: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 136: {
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "shouldGenerateMethodInsideInlineClass";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "canDelegateMethodBodyToInlineClass";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodInsideInlineClassWrapper";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "generateOpenMethodInSuspendClass";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodBody";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipMethodBodyInAbiMode";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "generateParameterAnnotations";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getThisTypeForFunction";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "newFakeTempIndex";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibilityStubInDefaultImpls";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "generateLocalVariableTable";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "generateLocalVariablesForParameters";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "generateFacadeDelegateMethodBody";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "generateDelegateToMethodBody";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "generateDelegateToStaticErasedVersion";
                break;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "generateDelegateToStaticMethodBody";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "endVisit";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "renderByteCodeIfAvailable";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "hasSpecialBridgeMethod";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "generateBridges";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "isThereOverriddenInKotlinClass";
                break;
            }
            case 110: 
            case 111: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "getThrownExceptions";
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "generateDefaultIfNeeded";
                break;
            }
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "generateDefaultImplBody";
                break;
            }
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "genDefaultSuperCallCheckIfNeeded";
                break;
            }
            case 133: 
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "createFrameMap";
                break;
            }
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "loadExplicitArgumentsOnStack";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultNeeded";
                break;
            }
            case 141: 
            case 142: 
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "generateBridge";
                break;
            }
            case 145: 
            case 146: 
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "generateTypeCheckBarrierIfNeeded";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "genSamDelegate";
                break;
            }
            case 150: 
            case 151: 
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "genDelegate";
                break;
            }
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "processInterfaceMethod";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 23: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 136: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

