/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.jetbrains.kotlin.com.google.inject.internal.ConstructionProxy;
import org.jetbrains.kotlin.com.google.inject.internal.ConstructionProxyFactory;
import org.jetbrains.kotlin.com.google.inject.spi.InjectionPoint;

final class DefaultConstructionProxyFactory<T>
implements ConstructionProxyFactory<T> {
    private final InjectionPoint injectionPoint;

    DefaultConstructionProxyFactory(InjectionPoint injectionPoint) {
        this.injectionPoint = injectionPoint;
    }

    @Override
    public ConstructionProxy<T> create() {
        Constructor constructor2 = (Constructor)this.injectionPoint.getMember();
        return new ReflectiveProxy(this.injectionPoint, constructor2);
    }

    private static final class ReflectiveProxy<T>
    implements ConstructionProxy<T> {
        final Constructor<T> constructor;
        final InjectionPoint injectionPoint;

        ReflectiveProxy(InjectionPoint injectionPoint, Constructor<T> constructor2) {
            if (!Modifier.isPublic(constructor2.getDeclaringClass().getModifiers()) || !Modifier.isPublic(constructor2.getModifiers())) {
                constructor2.setAccessible(true);
            }
            this.injectionPoint = injectionPoint;
            this.constructor = constructor2;
        }

        @Override
        public T newInstance(Object ... arguments2) throws InvocationTargetException {
            try {
                return this.constructor.newInstance(arguments2);
            }
            catch (InstantiationException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public InjectionPoint getInjectionPoint() {
            return this.injectionPoint;
        }

        @Override
        public Constructor<T> getConstructor() {
            return this.constructor;
        }
    }
}

