/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.multibindings;

import java.lang.annotation.Annotation;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.binder.LinkedBindingBuilder;
import org.jetbrains.kotlin.com.google.inject.internal.RealMultibinder;

public class Multibinder<T> {
    private final RealMultibinder<T> delegate;

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> type2) {
        return Multibinder.newSetBinder(binder, Key.get(type2));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> type2) {
        return Multibinder.newSetBinder(binder, Key.get(type2));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> type2, Annotation annotation2) {
        return Multibinder.newSetBinder(binder, Key.get(type2, annotation2));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> type2, Annotation annotation2) {
        return Multibinder.newSetBinder(binder, Key.get(type2, annotation2));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> type2, Class<? extends Annotation> annotationType) {
        return Multibinder.newSetBinder(binder, Key.get(type2, annotationType));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Key<T> key) {
        return new Multibinder<T>(RealMultibinder.newRealSetBinder(binder.skipSources(Multibinder.class), key));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> type2, Class<? extends Annotation> annotationType) {
        return Multibinder.newSetBinder(binder, Key.get(type2, annotationType));
    }

    private Multibinder(RealMultibinder<T> delegate2) {
        this.delegate = delegate2;
    }

    public Multibinder<T> permitDuplicates() {
        this.delegate.permitDuplicates();
        return this;
    }

    public LinkedBindingBuilder<T> addBinding() {
        return this.delegate.addBinding();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Multibinder) {
            return this.delegate.equals(((Multibinder)obj).delegate);
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

