/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java.enhancement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.PrivateForInline;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirAbstractConstructorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirConstructorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPrimaryConstructorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticProperty;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticPropertyBuilderKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.java.FirJavaTypeConversionMode;
import org.jetbrains.kotlin.fir.java.JavaTypeConversionKt;
import org.jetbrains.kotlin.fir.java.JavaTypeParameterStack;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaClass;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaConstructor;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaField;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaFieldBuilder;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaMethod;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaValueParameter;
import org.jetbrains.kotlin.fir.java.enhancement.EnhancementSignatureParts;
import org.jetbrains.kotlin.fir.java.enhancement.FirAnnotationTypeQualifierResolver;
import org.jetbrains.kotlin.fir.java.enhancement.FirAnnotationTypeQualifierResolverKt;
import org.jetbrains.kotlin.fir.java.enhancement.FirEnhancedSymbolsStorage;
import org.jetbrains.kotlin.fir.java.enhancement.JavaTypeUtilsKt;
import org.jetbrains.kotlin.fir.java.enhancement.SignatureEnhancementKt;
import org.jetbrains.kotlin.fir.java.symbols.FirJavaOverriddenSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.scopes.jvm.SignatureUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.jvm.FirJavaTypeRef;
import org.jetbrains.kotlin.load.java.AnnotationQualifierApplicabilityType;
import org.jetbrains.kotlin.load.java.JavaTypeQualifiersByElementType;
import org.jetbrains.kotlin.load.java.typeEnhancement.AbstractSignatureParts;
import org.jetbrains.kotlin.load.java.typeEnhancement.JavaTypeQualifiers;
import org.jetbrains.kotlin.load.java.typeEnhancement.NullabilityQualifier;
import org.jetbrains.kotlin.load.java.typeEnhancement.PredefinedEnhancementInfoKt;
import org.jetbrains.kotlin.load.java.typeEnhancement.PredefinedFunctionEnhancementInfo;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementInfo;
import org.jetbrains.kotlin.load.kotlin.SignatureBuildingComponents;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00f4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001^B4\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001d\u0010\u0006\u001a\u0019\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\fJ'\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0001\u00a2\u0006\u0002\b\u001eJ%\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001f2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\b\u001eJ&\u0010 \u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J(\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010*\u001a\u0004\u0018\u00010\u000eH\u0002J2\u0010+\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\n2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010*\u001a\u0004\u0018\u00010\u000e2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/J \u00101\u001a\u00020&2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020/2\u0006\u00105\u001a\u000206H\u0002J\u0014\u00107\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0\tJJ\u0010;\u001a\u00020&2\u0006\u0010'\u001a\u00020\"2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010<\u001a\u0002062\b\u0010*\u001a\u0004\u0018\u00010\u000e2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J \u0010A\u001a\u0006\u0012\u0002\b\u00030\u001a2\n\u0010B\u001a\u0006\u0012\u0002\b\u00030\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u001e\u0010C\u001a\u0006\u0012\u0002\b\u00030\u001f2\n\u0010D\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010E\u001a\u0004\u0018\u00010\u000e*\u00020FH\u0002JX\u0010\u0019\u001a\u00020&*\u00020\n2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010I\u001a\u0002062\b\u0010J\u001a\u0004\u0018\u00010\u000e2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\b\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010Q\u001a\u000206H\u0002J6\u0010\u0019\u001a\u00020&*\u00020R2\u0006\u0010S\u001a\u00020/2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020/0\t2\u0006\u0010U\u001a\u00020V2\n\b\u0002\u0010O\u001a\u0004\u0018\u00010PH\u0002JH\u0010W\u001a\u00020&*\u00020\"2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010X\u001a\u0004\u0018\u00010H2\b\u0010*\u001a\u0004\u0018\u00010\u000e2\u0006\u0010M\u001a\u00020N2\b\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010Q\u001a\u000206H\u0002J-\u0010Y\u001a\u000208*\b\u0012\u0004\u0012\u00020:0\t2\u0018\u0010Z\u001a\u0014\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020/0[H\u0082\bJ\u0014\u0010\\\u001a\u00020]*\u00020/2\u0006\u0010U\u001a\u00020VH\u0002R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R%\u0010\u0006\u001a\u0019\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement;", "", "owner", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "overridden", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Lorg/jetbrains/kotlin/fir/FirSession;Lkotlin/jvm/functions/Function1;)V", "contextQualifiers", "Lorg/jetbrains/kotlin/load/java/JavaTypeQualifiersByElementType;", "enhancementsCache", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirEnhancedSymbolsStorage$EnhancementSymbolsCache;", "javaTypeParameterStack", "Lorg/jetbrains/kotlin/fir/java/JavaTypeParameterStack;", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "getModuleData", "()Lorg/jetbrains/kotlin/fir/FirModuleData;", "typeQualifierResolver", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirAnnotationTypeQualifierResolver;", "enhance", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "original", "name", "Lorg/jetbrains/kotlin/name/Name;", "enhance$java", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "enhanceMethod", "firMethod", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "methodId", "Lorg/jetbrains/kotlin/name/CallableId;", "enhanceReceiverType", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "ownerFunction", "Lorg/jetbrains/kotlin/fir/java/declarations/FirJavaMethod;", "overriddenMembers", "defaultQualifiers", "enhanceReturnType", "predefinedEnhancementInfo", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/PredefinedFunctionEnhancementInfo;", "enhanceSuperType", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "type", "enhanceTypeParameterBound", "typeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "bound", "forceOnlyHeadTypeConstructor", "", "enhanceTypeParameterBounds", "", "typeParameters", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "enhanceValueParameterType", "hasReceiver", "ownerParameter", "Lorg/jetbrains/kotlin/fir/java/declarations/FirJavaValueParameter;", "index", "", "enhancedFunction", "function", "enhancedProperty", "property", "computeDefaultQualifiers", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "typeContainer", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "isCovariant", "containerQualifiers", "containerApplicabilityType", "Lorg/jetbrains/kotlin/load/java/AnnotationQualifierApplicabilityType;", "typeInSignature", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature;", "predefined", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/TypeEnhancementInfo;", "forAnnotationMember", "Lorg/jetbrains/kotlin/fir/java/enhancement/EnhancementSignatureParts;", "typeRef", "typeRefsFromOverridden", "mode", "Lorg/jetbrains/kotlin/fir/java/FirJavaTypeConversionMode;", "enhanceValueParameter", "parameterContainer", "replaceBounds", "block", "Lkotlin/Function2;", "toConeKotlinType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "TypeInSignature", "java"})
public final class FirSignatureEnhancement {
    @NotNull
    private final FirRegularClass owner;
    @NotNull
    private final FirSession session;
    @NotNull
    private final Function1<FirSimpleFunction, List<FirCallableDeclaration>> overridden;
    @NotNull
    private final JavaTypeParameterStack javaTypeParameterStack;
    @NotNull
    private final FirAnnotationTypeQualifierResolver typeQualifierResolver;
    @Nullable
    private final JavaTypeQualifiersByElementType contextQualifiers;
    @NotNull
    private final FirEnhancedSymbolsStorage.EnhancementSymbolsCache enhancementsCache;

    public FirSignatureEnhancement(@NotNull FirRegularClass owner, @NotNull FirSession session2, @NotNull Function1<? super FirSimpleFunction, ? extends List<? extends FirCallableDeclaration>> overridden) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(overridden, "overridden");
        this.owner = owner;
        this.session = session2;
        this.overridden = overridden;
        this.javaTypeParameterStack = this.owner instanceof FirJavaClass ? ((FirJavaClass)this.owner).getJavaTypeParameterStack$java() : JavaTypeParameterStack.Companion.getEMPTY();
        this.typeQualifierResolver = FirAnnotationTypeQualifierResolverKt.getJavaAnnotationTypeQualifierResolver(this.session);
        this.contextQualifiers = this.typeQualifierResolver.extractDefaultQualifiers(this.owner);
        this.enhancementsCache = (FirEnhancedSymbolsStorage.EnhancementSymbolsCache)SignatureEnhancementKt.access$getEnhancedSymbolStorage(this.session).getCacheByOwner().getValue(this.owner.getSymbol(), null);
    }

    private final FirModuleData getModuleData() {
        return this.owner.getModuleData();
    }

    @NotNull
    public final FirFunctionSymbol<?> enhancedFunction(@NotNull FirFunctionSymbol<?> function2, @Nullable Name name2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return this.enhancementsCache.getEnhancedFunctions().getValue(function2, TuplesKt.to(this, name2));
    }

    @NotNull
    public final FirVariableSymbol<?> enhancedProperty(@NotNull FirVariableSymbol<?> property2, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(property2, "property");
        Intrinsics.checkNotNullParameter(name2, "name");
        return this.enhancementsCache.getEnhancedVariables().getValue(property2, TuplesKt.to(this, name2));
    }

    private final JavaTypeQualifiersByElementType computeDefaultQualifiers(FirDeclaration $this$computeDefaultQualifiers) {
        return this.typeQualifierResolver.extractAndMergeDefaultQualifiers(this.contextQualifiers, (Iterable)$this$computeDefaultQualifiers.getAnnotations());
    }

    @PrivateForInline
    @NotNull
    public final FirVariableSymbol<?> enhance$java(@NotNull FirVariableSymbol<?> original, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(original, "original");
        Intrinsics.checkNotNullParameter(name2, "name");
        FirVariable firElement = (FirVariable)original.getFir();
        if (firElement instanceof FirEnumEntry) {
            FirEnumEntrySymbol firEnumEntrySymbol;
            if (!(firElement.getReturnTypeRef() instanceof FirJavaTypeRef)) {
                return original;
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to(0, new JavaTypeQualifiers(NullabilityQualifier.NOT_NULL, null, false, false, 8, null))};
            PredefinedFunctionEnhancementInfo predefinedInfo = new PredefinedFunctionEnhancementInfo(new TypeEnhancementInfo(pairArray), CollectionsKt.emptyList());
            FirResolvedTypeRef newReturnTypeRef = this.enhanceReturnType(firElement, CollectionsKt.emptyList(), this.computeDefaultQualifiers(firElement), predefinedInfo);
            FirEnumEntrySymbol $this$enhance_u24lambda_u2d0 = firEnumEntrySymbol = ((FirEnumEntry)firElement).getSymbol();
            boolean bl = false;
            ((FirEnumEntry)$this$enhance_u24lambda_u2d0.getFir()).replaceReturnTypeRef(newReturnTypeRef);
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.session);
            if (firLookupTrackerComponent != null) {
                FirLookupTrackerComponentKt.recordTypeResolveAsLookup(firLookupTrackerComponent, newReturnTypeRef, ((FirEnumEntry)$this$enhance_u24lambda_u2d0.getFir()).getSource(), null);
            }
            return firEnumEntrySymbol;
        }
        if (firElement instanceof FirField) {
            if (!(firElement.getReturnTypeRef() instanceof FirJavaTypeRef)) {
                return original;
            }
            FirResolvedTypeRef it = this.enhanceReturnType(firElement, CollectionsKt.emptyList(), this.computeDefaultQualifiers(firElement), null);
            boolean bl = false;
            ConeSimpleKotlinType lowerBound = ConeTypeUtilsKt.lowerBoundIfFlexible(it.getType());
            FirMemberDeclaration $this$isStatic$iv = firElement;
            boolean $i$f$isStatic = false;
            FirResolvedTypeRef newReturnTypeRef = $this$isStatic$iv.getStatus().isStatic() && firElement.getInitializer() != null && (ConeBuiltinTypeUtilsKt.isString(lowerBound) || ConeBuiltinTypeUtilsKt.isInt(lowerBound)) ? TypeUtilsKt.withReplacedConeType$default(it, TypeUtilsKt.withNullability$default(it.getType(), ConeNullability.NOT_NULL, TypeComponentsKt.getTypeContext(this.session), null, 4, null), null, 2, null) : it;
            FirFieldSymbol symbol2 = new FirFieldSymbol(original.getCallableId());
            boolean $i$f$buildJavaField = false;
            FirJavaFieldBuilder $this$enhance_u24lambda_u2d2 = bl = new FirJavaFieldBuilder();
            boolean bl2 = false;
            $this$enhance_u24lambda_u2d2.setSource(firElement.getSource());
            $this$enhance_u24lambda_u2d2.setModuleData(this.getModuleData());
            $this$enhance_u24lambda_u2d2.setSymbol(symbol2);
            $this$enhance_u24lambda_u2d2.setName(name2);
            $this$enhance_u24lambda_u2d2.setReturnTypeRef(newReturnTypeRef);
            FirMemberDeclaration $this$visibility$iv = firElement;
            boolean $i$f$getVisibility = false;
            $this$enhance_u24lambda_u2d2.setVisibility($this$visibility$iv.getStatus().getVisibility());
            FirMemberDeclaration $this$modality$iv = firElement;
            boolean $i$f$getModality = false;
            $this$enhance_u24lambda_u2d2.setModality($this$modality$iv.getStatus().getModality());
            $this$enhance_u24lambda_u2d2.setVar(firElement.isVar());
            FirMemberDeclaration $this$isStatic$iv2 = firElement;
            boolean $i$f$isStatic2 = false;
            $this$enhance_u24lambda_u2d2.setStatic($this$isStatic$iv2.getStatus().isStatic());
            $this$enhance_u24lambda_u2d2.setAnnotationBuilder((Function0<? extends List<? extends FirAnnotation>>)new Function0<List<? extends FirAnnotation>>(firElement){
                final /* synthetic */ FirVariable $firElement;
                {
                    this.$firElement = $firElement;
                    super(0);
                }

                @NotNull
                public final List<FirAnnotation> invoke() {
                    return this.$firElement.getAnnotations();
                }
            });
            $this$enhance_u24lambda_u2d2.setStatus(firElement.getStatus());
            $this$enhance_u24lambda_u2d2.setInitializer(firElement.getInitializer());
            $this$enhance_u24lambda_u2d2.setDispatchReceiverType(firElement.getDispatchReceiverType());
            $this$enhance_u24lambda_u2d2.setAttributes(firElement.getAttributes().copy());
            bl.build();
            return symbol2;
        }
        if (firElement instanceof FirSyntheticProperty) {
            FirFunctionSymbol<?> enhancedSetterSymbol;
            FirFunctionSymbol<?> firFunctionSymbol;
            FirSimpleFunction setterDelegate;
            FirSyntheticPropertySymbol accessorSymbol = ((FirSyntheticProperty)firElement).getSymbol();
            FirSimpleFunction getterDelegate = ((FirSyntheticProperty)firElement).getGetter().getDelegate();
            FirFunctionSymbol<?> enhancedGetterSymbol = getterDelegate instanceof FirJavaMethod ? this.enhanceMethod(getterDelegate, getterDelegate.getSymbol().getCallableId(), getterDelegate.getName()) : (FirFunctionSymbol<?>)getterDelegate.getSymbol();
            FirSyntheticPropertyAccessor firSyntheticPropertyAccessor = ((FirSyntheticProperty)firElement).getSetter();
            FirSimpleFunction firSimpleFunction = setterDelegate = firSyntheticPropertyAccessor != null ? firSyntheticPropertyAccessor.getDelegate() : null;
            if (setterDelegate instanceof FirJavaMethod) {
                firFunctionSymbol = this.enhanceMethod(setterDelegate, ((FirJavaMethod)setterDelegate).getSymbol().getCallableId(), ((FirJavaMethod)setterDelegate).getName());
            } else {
                FirSimpleFunction firSimpleFunction2 = setterDelegate;
                firFunctionSymbol = enhancedSetterSymbol = (FirFunctionSymbol<?>)(firSimpleFunction2 != null ? firSimpleFunction2.getSymbol() : null);
            }
            if (!(getterDelegate instanceof FirJavaMethod) && !(setterDelegate instanceof FirJavaMethod)) {
                return original;
            }
            return FirSyntheticPropertyBuilderKt.buildSyntheticProperty((Function1<? super FirSyntheticPropertyBuilder, Unit>)new Function1<FirSyntheticPropertyBuilder, Unit>(this, name2, accessorSymbol, enhancedGetterSymbol, enhancedSetterSymbol, firElement){
                final /* synthetic */ FirSignatureEnhancement this$0;
                final /* synthetic */ Name $name;
                final /* synthetic */ FirSyntheticPropertySymbol $accessorSymbol;
                final /* synthetic */ FirFunctionSymbol<? extends FirFunction> $enhancedGetterSymbol;
                final /* synthetic */ FirFunctionSymbol<? extends FirFunction> $enhancedSetterSymbol;
                final /* synthetic */ FirVariable $firElement;
                {
                    this.this$0 = $receiver;
                    this.$name = $name;
                    this.$accessorSymbol = $accessorSymbol;
                    this.$enhancedGetterSymbol = $enhancedGetterSymbol;
                    this.$enhancedSetterSymbol = $enhancedSetterSymbol;
                    this.$firElement = $firElement;
                    super(1);
                }

                public final void invoke(@NotNull FirSyntheticPropertyBuilder $this$buildSyntheticProperty) {
                    Intrinsics.checkNotNullParameter($this$buildSyntheticProperty, "$this$buildSyntheticProperty");
                    $this$buildSyntheticProperty.setModuleData(FirSignatureEnhancement.access$getModuleData(this.this$0));
                    $this$buildSyntheticProperty.setName(this.$name);
                    $this$buildSyntheticProperty.setSymbol(new FirJavaOverriddenSyntheticPropertySymbol(this.$accessorSymbol.getCallableId(), this.$accessorSymbol.getGetterId()));
                    E e = this.$enhancedGetterSymbol.getFir();
                    Intrinsics.checkNotNull(e, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirSimpleFunction");
                    $this$buildSyntheticProperty.setDelegateGetter((FirSimpleFunction)e);
                    FirFunctionSymbol<? extends FirFunction> firFunctionSymbol = this.$enhancedSetterSymbol;
                    $this$buildSyntheticProperty.setDelegateSetter((FirSimpleFunction)(firFunctionSymbol != null ? (FirFunction)firFunctionSymbol.getFir() : null));
                    $this$buildSyntheticProperty.setStatus(this.$firElement.getStatus());
                    $this$buildSyntheticProperty.setDeprecation(DeprecationUtilsKt.getDeprecationsFromAccessors($this$buildSyntheticProperty.getDelegateGetter(), $this$buildSyntheticProperty.getDelegateSetter(), FirLanguageSettingsComponentKt.getLanguageVersionSettings(FirSignatureEnhancement.access$getSession$p(this.this$0)).getApiVersion()));
                }
            }).getSymbol();
        }
        if (original instanceof FirPropertySymbol || original instanceof FirSyntheticPropertySymbol) {
            return original;
        }
        throw new IllegalStateException(("Can't make enhancement for " + original + ": `" + FirRendererKt.render$default(firElement, null, 1, null) + '`').toString());
    }

    @PrivateForInline
    @NotNull
    public final FirFunctionSymbol<?> enhance$java(@NotNull FirFunctionSymbol<?> original, @Nullable Name name2) {
        FirFunctionSymbol<?> firFunctionSymbol;
        block1: {
            Intrinsics.checkNotNullParameter(original, "original");
            FirFunction firMethod = (FirFunction)original.getFir();
            if (!(firMethod instanceof FirJavaMethod) && !(firMethod instanceof FirJavaConstructor)) {
                return original;
            }
            this.enhanceTypeParameterBounds(firMethod.getTypeParameters());
            FirFunctionSymbol<?> enhancedVersion = firFunctionSymbol = this.enhanceMethod(firMethod, original.getCallableId(), name2);
            boolean bl = false;
            FirFunction enhancedVersionFir = (FirFunction)enhancedVersion.getFir();
            FirCallableDeclaration firCallableDeclaration = ClassMembersKt.getInitialSignatureAttr(enhancedVersionFir);
            FirSimpleFunction firSimpleFunction = firCallableDeclaration instanceof FirSimpleFunction ? (FirSimpleFunction)firCallableDeclaration : null;
            if (firSimpleFunction == null) break block1;
            FirSimpleFunction it = firSimpleFunction;
            boolean bl2 = false;
            ClassMembersKt.setInitialSignatureAttr(enhancedVersionFir, (FirCallableDeclaration)this.enhancedFunction(it.getSymbol(), it.getName()).getFir());
        }
        return firFunctionSymbol;
    }

    /*
     * WARNING - void declaration
     */
    private final FirFunctionSymbol<?> enhanceMethod(FirFunction firMethod, CallableId methodId, Name name2) {
        FirFunctionBuilder firFunctionBuilder;
        Object symbol2;
        Object object;
        FirPureAbstractElement firPureAbstractElement;
        Object element$iv2;
        boolean bl;
        List<FirCallableDeclaration> overriddenMembers;
        JavaTypeQualifiersByElementType defaultQualifiers;
        PredefinedFunctionEnhancementInfo predefinedEnhancementInfo2;
        block18: {
            String signature2 = SignatureBuildingComponents.INSTANCE.signature(this.owner.getSymbol().getClassId(), SignatureUtilsKt.computeJvmDescriptor$default(firMethod, null, false, new Function1<FirTypeRef, ConeKotlinType>(this){
                final /* synthetic */ FirSignatureEnhancement this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final ConeKotlinType invoke(@NotNull FirTypeRef it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return JavaTypeConversionKt.toConeKotlinTypeProbablyFlexible$default(it, FirSignatureEnhancement.access$getSession$p(this.this$0), FirSignatureEnhancement.access$getJavaTypeParameterStack$p(this.this$0), null, 4, null);
                }
            }, 3, null));
            boolean bl2 = false;
            PredefinedFunctionEnhancementInfo predefinedFunctionEnhancementInfo = predefinedEnhancementInfo2 = PredefinedEnhancementInfoKt.getPREDEFINED_FUNCTION_ENHANCEMENT_INFO_BY_SIGNATURE().get(signature2);
            if (predefinedFunctionEnhancementInfo != null) {
                boolean bl3;
                PredefinedFunctionEnhancementInfo it = predefinedFunctionEnhancementInfo;
                boolean bl4 = false;
                boolean bl5 = bl3 = it.getParametersInfo().size() == firMethod.getValueParameters().size();
                if (_Assertions.ENABLED && !bl3) {
                    boolean $i$a$-assert-FirSignatureEnhancement$enhanceMethod$1$22 = false;
                    String $i$a$-assert-FirSignatureEnhancement$enhanceMethod$1$22 = "Predefined enhancement info for " + this + " has " + it.getParametersInfo().size() + ", but " + firMethod.getValueParameters().size() + " expected";
                    throw new AssertionError((Object)$i$a$-assert-FirSignatureEnhancement$enhanceMethod$1$22);
                }
            }
            defaultQualifiers = this.computeDefaultQualifiers(firMethod);
            FirSimpleFunction bl4 = firMethod instanceof FirSimpleFunction ? (FirSimpleFunction)firMethod : null;
            List<FirCallableDeclaration> list2 = bl4 != null ? this.overridden.invoke(bl4) : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            overriddenMembers = list2;
            Iterable $this$any$iv = overriddenMembers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    FirCallableDeclaration it = (FirCallableDeclaration)element$iv2;
                    boolean bl6 = false;
                    if (!(it.getReceiverTypeRef() != null)) continue;
                    bl = true;
                    break block18;
                }
                bl = false;
            }
        }
        boolean hasReceiver = bl;
        FirResolvedTypeRef newReceiverTypeRef = firMethod instanceof FirJavaMethod && hasReceiver ? this.enhanceReceiverType((FirJavaMethod)firMethod, overriddenMembers, defaultQualifiers) : null;
        FirTypeRef newReturnTypeRef = firMethod instanceof FirJavaMethod ? (FirTypeRef)this.enhanceReturnType(firMethod, overriddenMembers, defaultQualifiers, predefinedEnhancementInfo2) : firMethod.getReturnTypeRef();
        List enhancedValueParameterTypes = new ArrayList();
        element$iv2 = firMethod.getValueParameters().iterator();
        int it = 0;
        while (element$iv2.hasNext()) {
            int index2 = it++;
            FirValueParameter valueParameter2 = (FirValueParameter)element$iv2.next();
            if (hasReceiver && index2 == 0) continue;
            Collection collection = enhancedValueParameterTypes;
            Intrinsics.checkNotNull(valueParameter2, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.java.declarations.FirJavaValueParameter");
            collection.add(this.enhanceValueParameterType(firMethod, overriddenMembers, hasReceiver, defaultQualifiers, predefinedEnhancementInfo2, (FirJavaValueParameter)valueParameter2, hasReceiver ? index2 - 1 : index2));
        }
        Iterable $this$zip$iv = firMethod.getValueParameters();
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Object second$iv = ((Iterable)enhancedValueParameterTypes).iterator();
        ArrayList<FirValueParameter> list$iv = new ArrayList<FirValueParameter>(Math.min(CollectionsKt.collectionSizeOrDefault($this$zip$iv, 10), CollectionsKt.collectionSizeOrDefault(enhancedValueParameterTypes, 10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void enhancedReturnType;
            void valueParameter3;
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)second$iv.next();
            firPureAbstractElement = (FirValueParameter)first$iv.next();
            ArrayList<FirValueParameter> arrayList = list$iv;
            boolean bl7 = false;
            FirExpression firExpression2 = valueParameter3.getDefaultValue();
            if (firExpression2 != null) {
                firExpression2.replaceTypeRef((FirTypeRef)enhancedReturnType);
            }
            boolean $i$f$buildValueParameter = false;
            object = new FirValueParameterBuilder();
            FirValueParameterBuilder $this$enhanceMethod_u24lambda_u2d10_u24lambda_u2d9 = object;
            boolean bl8 = false;
            $this$enhanceMethod_u24lambda_u2d10_u24lambda_u2d9.setSource(valueParameter3.getSource());
            $this$enhanceMethod_u24lambda_u2d10_u24lambda_u2d9.setModuleData(this.getModuleData());
            $this$enhanceMethod_u24lambda_u2d10_u24lambda_u2d9.setOrigin(FirDeclarationOrigin.Enhancement.INSTANCE);
            $this$enhanceMethod_u24lambda_u2d10_u24lambda_u2d9.setReturnTypeRef((FirTypeRef)enhancedReturnType);
            $this$enhanceMethod_u24lambda_u2d10_u24lambda_u2d9.setName(valueParameter3.getName());
            $this$enhanceMethod_u24lambda_u2d10_u24lambda_u2d9.setSymbol(new FirValueParameterSymbol($this$enhanceMethod_u24lambda_u2d10_u24lambda_u2d9.getName()));
            $this$enhanceMethod_u24lambda_u2d10_u24lambda_u2d9.setDefaultValue(valueParameter3.getDefaultValue());
            $this$enhanceMethod_u24lambda_u2d10_u24lambda_u2d9.setCrossinline(valueParameter3.isCrossinline());
            $this$enhanceMethod_u24lambda_u2d10_u24lambda_u2d9.setNoinline(valueParameter3.isNoinline());
            $this$enhanceMethod_u24lambda_u2d10_u24lambda_u2d9.setVararg(valueParameter3.isVararg());
            $this$enhanceMethod_u24lambda_u2d10_u24lambda_u2d9.setResolvePhase(FirResolvePhase.Companion.getANALYZED_DEPENDENCIES());
            CollectionsKt.addAll((Collection)$this$enhanceMethod_u24lambda_u2d10_u24lambda_u2d9.getAnnotations(), (Iterable)valueParameter3.getAnnotations());
            arrayList.add(((FirValueParameterBuilder)object).build());
        }
        List newValueParameters = list$iv;
        Object object2 = firMethod;
        if (object2 instanceof FirJavaConstructor) {
            FirAbstractConstructorBuilder firAbstractConstructorBuilder;
            symbol2 = new FirConstructorSymbol(methodId);
            if (((FirJavaConstructor)firMethod).isPrimary()) {
                void $this$enhanceMethod_u24lambda_u2d12_u24lambda_u2d11;
                FirDeclarationStatusImpl firDeclarationStatusImpl;
                FirResolvedDeclarationStatus resolvedStatus;
                Object $this$enhanceMethod_u24lambda_u2d12 = second$iv = new FirPrimaryConstructorBuilder();
                boolean bl9 = false;
                ((FirPrimaryConstructorBuilder)$this$enhanceMethod_u24lambda_u2d12).setReturnTypeRef(newReturnTypeRef);
                FirDeclarationStatus $this$safeAs$iv = ((FirJavaConstructor)firMethod).getStatus();
                boolean $i$f$safeAs = false;
                FirDeclarationStatus firDeclarationStatus = $this$safeAs$iv;
                if (!(firDeclarationStatus instanceof FirResolvedDeclarationStatus)) {
                    firDeclarationStatus = null;
                }
                if ((resolvedStatus = (FirResolvedDeclarationStatus)firDeclarationStatus) != null) {
                    firDeclarationStatusImpl = new FirResolvedDeclarationStatusImpl(resolvedStatus.getVisibility(), Modality.FINAL, resolvedStatus.getEffectiveVisibility());
                } else {
                    FirMemberDeclaration $this$visibility$iv = firMethod;
                    boolean $i$f$getVisibility = false;
                    FirDeclarationStatusImpl firDeclarationStatusImpl2 = new FirDeclarationStatusImpl($this$visibility$iv.getStatus().getVisibility(), Modality.FINAL);
                    firDeclarationStatusImpl = firDeclarationStatusImpl2;
                }
                FirPureAbstractElement $i$f$getVisibility = firPureAbstractElement = firDeclarationStatusImpl;
                object = $this$enhanceMethod_u24lambda_u2d12;
                boolean bl10 = false;
                $this$enhanceMethod_u24lambda_u2d12_u24lambda_u2d11.setExpect(false);
                $this$enhanceMethod_u24lambda_u2d12_u24lambda_u2d11.setActual(false);
                $this$enhanceMethod_u24lambda_u2d12_u24lambda_u2d11.setOverride(false);
                FirMemberDeclaration $this$isInner$iv = firMethod;
                boolean $i$f$isInner = false;
                $this$enhanceMethod_u24lambda_u2d12_u24lambda_u2d11.setInner($this$isInner$iv.getStatus().isInner());
                ((FirPrimaryConstructorBuilder)object).setStatus((FirDeclarationStatus)((Object)firPureAbstractElement));
                ((FirPrimaryConstructorBuilder)$this$enhanceMethod_u24lambda_u2d12).setSymbol((FirConstructorSymbol)symbol2);
                ((FirPrimaryConstructorBuilder)$this$enhanceMethod_u24lambda_u2d12).setDispatchReceiverType(firMethod.getDispatchReceiverType());
                ((FirPrimaryConstructorBuilder)$this$enhanceMethod_u24lambda_u2d12).setAttributes(firMethod.getAttributes().copy());
                firAbstractConstructorBuilder = (FirAbstractConstructorBuilder)second$iv;
            } else {
                Object $this$enhanceMethod_u24lambda_u2d13 = second$iv = new FirConstructorBuilder();
                boolean bl11 = false;
                ((FirConstructorBuilder)$this$enhanceMethod_u24lambda_u2d13).setReturnTypeRef(newReturnTypeRef);
                ((FirConstructorBuilder)$this$enhanceMethod_u24lambda_u2d13).setStatus(((FirJavaConstructor)firMethod).getStatus());
                ((FirConstructorBuilder)$this$enhanceMethod_u24lambda_u2d13).setSymbol((FirConstructorSymbol)symbol2);
                ((FirConstructorBuilder)$this$enhanceMethod_u24lambda_u2d13).setDispatchReceiverType(firMethod.getDispatchReceiverType());
                ((FirConstructorBuilder)$this$enhanceMethod_u24lambda_u2d13).setAttributes(firMethod.getAttributes().copy());
                firAbstractConstructorBuilder = (FirAbstractConstructorBuilder)second$iv;
            }
            Object $this$enhanceMethod_u24lambda_u2d14 = second$iv = firAbstractConstructorBuilder;
            boolean bl12 = false;
            $this$enhanceMethod_u24lambda_u2d14.setSource(firMethod.getSource());
            $this$enhanceMethod_u24lambda_u2d14.setModuleData(this.getModuleData());
            $this$enhanceMethod_u24lambda_u2d14.setResolvePhase(FirResolvePhase.Companion.getANALYZED_DEPENDENCIES());
            $this$enhanceMethod_u24lambda_u2d14.setOrigin(FirDeclarationOrigin.Enhancement.INSTANCE);
            CollectionsKt.addAll((Collection)$this$enhanceMethod_u24lambda_u2d14.getValueParameters(), newValueParameters);
            CollectionsKt.addAll((Collection)$this$enhanceMethod_u24lambda_u2d14.getTypeParameters(), (Iterable)((FirJavaConstructor)firMethod).getTypeParameters());
            firFunctionBuilder = (FirFunctionBuilder)second$iv;
        } else if (object2 instanceof FirJavaMethod) {
            Object $this$enhanceMethod_u24lambda_u2d15 = symbol2 = new FirSimpleFunctionBuilder();
            boolean bl13 = false;
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d15).setSource(firMethod.getSource());
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d15).setModuleData(this.getModuleData());
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d15).setOrigin(FirDeclarationOrigin.Enhancement.INSTANCE);
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d15).setReturnTypeRef(newReturnTypeRef);
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d15).setReceiverTypeRef(newReceiverTypeRef);
            Name name3 = name2;
            Intrinsics.checkNotNull(name3);
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d15).setName(name3);
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d15).setStatus(((FirJavaMethod)firMethod).getStatus());
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d15).setSymbol(new FirNamedFunctionSymbol(methodId));
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d15).setResolvePhase(FirResolvePhase.Companion.getANALYZED_DEPENDENCIES());
            CollectionsKt.addAll((Collection)((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d15).getValueParameters(), newValueParameters);
            CollectionsKt.addAll((Collection)((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d15).getTypeParameters(), (Iterable)((FirJavaMethod)firMethod).getTypeParameters());
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d15).setDispatchReceiverType(firMethod.getDispatchReceiverType());
            ((FirSimpleFunctionBuilder)$this$enhanceMethod_u24lambda_u2d15).setAttributes(firMethod.getAttributes().copy());
            firFunctionBuilder = (FirFunctionBuilder)symbol2;
        } else {
            throw new AssertionError((Object)("Unknown Java method to enhance: " + FirRendererKt.render$default(firMethod, null, 1, null)));
        }
        Object $this$enhanceMethod_u24lambda_u2d16 = object2 = firFunctionBuilder;
        boolean bl14 = false;
        CollectionsKt.addAll((Collection)$this$enhanceMethod_u24lambda_u2d16.getAnnotations(), (Iterable)firMethod.getAnnotations());
        $this$enhanceMethod_u24lambda_u2d16.setDeprecation(DeprecationUtilsKt.getDeprecationInfosFromAnnotations($this$enhanceMethod_u24lambda_u2d16.getAnnotations(), FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).getApiVersion(), true));
        FirFunction function2 = object2.build();
        return function2.getSymbol();
    }

    public final void enhanceTypeParameterBounds(@NotNull List<? extends FirTypeParameterRef> typeParameters2) {
        FirTypeParameter typeParameter;
        boolean bl;
        FirTypeRef bound;
        FirTypeRef it$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv$iv;
        Iterable $this$map$iv$iv;
        boolean $i$f$map;
        FirTypeParameter firTypeParameter;
        Intrinsics.checkNotNullParameter(typeParameters2, "typeParameters");
        FirSignatureEnhancement firSignatureEnhancement = this;
        List<? extends FirTypeParameterRef> $this$replaceBounds$iv = typeParameters2;
        boolean $i$f$replaceBounds = false;
        for (FirTypeParameterRef firTypeParameterRef : $this$replaceBounds$iv) {
            if (!(firTypeParameterRef instanceof FirTypeParameter)) continue;
            Iterable iterable = ((FirTypeParameter)firTypeParameterRef).getBounds();
            firTypeParameter = (FirTypeParameter)firTypeParameterRef;
            $i$f$map = false;
            void var10_14 = $this$map$iv$iv;
            destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                FirTypeRef firTypeRef = (FirTypeRef)item$iv$iv$iv;
                collection = destination$iv$iv$iv;
                boolean bl2 = false;
                void var18_22 = it$iv;
                FirTypeParameter cfr_ignored_0 = (FirTypeParameter)firTypeParameterRef;
                boolean bl22 = false;
                collection.add(JavaTypeConversionKt.resolveIfJavaType(bound, this.session, this.javaTypeParameterStack, FirJavaTypeConversionMode.TYPE_PARAMETER_BOUND));
            }
            firTypeParameter.replaceBounds((List)destination$iv$iv$iv);
        }
        FirSignatureEnhancement this_$iv = this;
        $this$replaceBounds$iv = typeParameters2;
        $i$f$replaceBounds = false;
        for (FirTypeParameterRef firTypeParameterRef : $this$replaceBounds$iv) {
            if (!(firTypeParameterRef instanceof FirTypeParameter)) continue;
            $this$map$iv$iv = ((FirTypeParameter)firTypeParameterRef).getBounds();
            firTypeParameter = (FirTypeParameter)firTypeParameterRef;
            $i$f$map = false;
            $this$mapTo$iv$iv$iv = $this$map$iv$iv;
            destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                it$iv = (FirTypeRef)item$iv$iv$iv;
                collection = destination$iv$iv$iv;
                bl = false;
                bound = it$iv;
                typeParameter = (FirTypeParameter)firTypeParameterRef;
                boolean bl3 = false;
                collection.add((FirTypeRef)this.enhanceTypeParameterBound(typeParameter, bound, true));
            }
            firTypeParameter.replaceBounds((List)destination$iv$iv$iv);
        }
        this_$iv = this;
        $this$replaceBounds$iv = typeParameters2;
        $i$f$replaceBounds = false;
        for (FirTypeParameterRef firTypeParameterRef : $this$replaceBounds$iv) {
            if (!(firTypeParameterRef instanceof FirTypeParameter)) continue;
            $this$map$iv$iv = ((FirTypeParameter)firTypeParameterRef).getBounds();
            firTypeParameter = (FirTypeParameter)firTypeParameterRef;
            $i$f$map = false;
            $this$mapTo$iv$iv$iv = $this$map$iv$iv;
            destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                it$iv = (FirTypeRef)item$iv$iv$iv;
                collection = destination$iv$iv$iv;
                bl = false;
                bound = it$iv;
                typeParameter = (FirTypeParameter)firTypeParameterRef;
                boolean bl4 = false;
                collection.add((FirTypeRef)this.enhanceTypeParameterBound(typeParameter, bound, false));
            }
            firTypeParameter.replaceBounds((List)destination$iv$iv$iv);
        }
    }

    private final FirResolvedTypeRef enhanceTypeParameterBound(FirTypeParameter typeParameter, FirTypeRef bound, boolean forceOnlyHeadTypeConstructor) {
        return FirSignatureEnhancement.enhance$default(this, new EnhancementSignatureParts(this.session, this.typeQualifierResolver, typeParameter, false, forceOnlyHeadTypeConstructor, AnnotationQualifierApplicabilityType.TYPE_PARAMETER_BOUNDS, this.contextQualifiers), bound, CollectionsKt.emptyList(), FirJavaTypeConversionMode.TYPE_PARAMETER_BOUND, null, 8, null);
    }

    @NotNull
    public final FirTypeRef enhanceSuperType(@NotNull FirTypeRef type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return FirSignatureEnhancement.enhance$default(this, new EnhancementSignatureParts(this.session, this.typeQualifierResolver, null, false, false, AnnotationQualifierApplicabilityType.TYPE_USE, this.contextQualifiers), type2, CollectionsKt.emptyList(), FirJavaTypeConversionMode.SUPERTYPE, null, 8, null);
    }

    private final FirResolvedTypeRef enhanceReceiverType(FirJavaMethod ownerFunction, List<? extends FirCallableDeclaration> overriddenMembers, JavaTypeQualifiersByElementType defaultQualifiers) {
        return this.enhanceValueParameter(ownerFunction, overriddenMembers, ownerFunction, defaultQualifiers, TypeInSignature.Receiver.INSTANCE, null, false);
    }

    private final FirResolvedTypeRef enhanceValueParameterType(FirFunction ownerFunction, List<? extends FirCallableDeclaration> overriddenMembers, boolean hasReceiver, JavaTypeQualifiersByElementType defaultQualifiers, PredefinedFunctionEnhancementInfo predefinedEnhancementInfo2, FirJavaValueParameter ownerParameter, int index2) {
        Object object = predefinedEnhancementInfo2;
        return this.enhanceValueParameter(ownerFunction, overriddenMembers, ownerParameter, defaultQualifiers, new TypeInSignature.ValueParameter(hasReceiver, index2), object != null && (object = ((PredefinedFunctionEnhancementInfo)object).getParametersInfo()) != null ? (TypeEnhancementInfo)CollectionsKt.getOrNull(object, index2) : null, this.owner.getClassKind() == ClassKind.ANNOTATION_CLASS);
    }

    private final FirResolvedTypeRef enhanceReturnType(FirCallableDeclaration owner, List<? extends FirCallableDeclaration> overriddenMembers, JavaTypeQualifiersByElementType defaultQualifiers, PredefinedFunctionEnhancementInfo predefinedEnhancementInfo2) {
        AnnotationQualifierApplicabilityType containerApplicabilityType = owner instanceof FirJavaField ? AnnotationQualifierApplicabilityType.FIELD : AnnotationQualifierApplicabilityType.METHOD_RETURN_TYPE;
        PredefinedFunctionEnhancementInfo predefinedFunctionEnhancementInfo = predefinedEnhancementInfo2;
        return this.enhance(owner, overriddenMembers, owner, true, defaultQualifiers, containerApplicabilityType, TypeInSignature.Return.INSTANCE, predefinedFunctionEnhancementInfo != null ? predefinedFunctionEnhancementInfo.getReturnTypeInfo() : null, this.owner.getClassKind() == ClassKind.ANNOTATION_CLASS);
    }

    /*
     * WARNING - void declaration
     */
    private final FirResolvedTypeRef enhanceValueParameter(FirFunction $this$enhanceValueParameter, List<? extends FirCallableDeclaration> overriddenMembers, FirAnnotationContainer parameterContainer, JavaTypeQualifiersByElementType defaultQualifiers, TypeInSignature typeInSignature, TypeEnhancementInfo predefined, boolean forAnnotationMember) {
        Object object;
        boolean bl;
        FirAnnotationContainer firAnnotationContainer;
        List<? extends FirCallableDeclaration> list2;
        FirCallableDeclaration firCallableDeclaration;
        FirSignatureEnhancement firSignatureEnhancement;
        block5: {
            block4: {
                void it;
                firSignatureEnhancement = this;
                firCallableDeclaration = $this$enhanceValueParameter;
                list2 = overriddenMembers;
                firAnnotationContainer = parameterContainer;
                if (firAnnotationContainer == null) {
                    firAnnotationContainer = $this$enhanceValueParameter;
                }
                bl = false;
                object = parameterContainer;
                if (object == null) break block4;
                FirAnnotationContainer firAnnotationContainer2 = object;
                boolean bl2 = bl;
                FirAnnotationContainer firAnnotationContainer3 = firAnnotationContainer;
                List<? extends FirCallableDeclaration> list3 = list2;
                FirCallableDeclaration firCallableDeclaration2 = firCallableDeclaration;
                FirSignatureEnhancement firSignatureEnhancement2 = firSignatureEnhancement;
                boolean bl3 = false;
                JavaTypeQualifiersByElementType javaTypeQualifiersByElementType = this.typeQualifierResolver.extractAndMergeDefaultQualifiers(defaultQualifiers, (Iterable)it.getAnnotations());
                firSignatureEnhancement = firSignatureEnhancement2;
                firCallableDeclaration = firCallableDeclaration2;
                list2 = list3;
                firAnnotationContainer = firAnnotationContainer3;
                bl = bl2;
                JavaTypeQualifiersByElementType javaTypeQualifiersByElementType2 = javaTypeQualifiersByElementType;
                object = javaTypeQualifiersByElementType2;
                if (javaTypeQualifiersByElementType2 != null) break block5;
            }
            object = defaultQualifiers;
        }
        return firSignatureEnhancement.enhance(firCallableDeclaration, list2, firAnnotationContainer, bl, (JavaTypeQualifiersByElementType)object, AnnotationQualifierApplicabilityType.VALUE_PARAMETER, typeInSignature, predefined, forAnnotationMember);
    }

    /*
     * WARNING - void declaration
     */
    private final FirResolvedTypeRef enhance(FirCallableDeclaration $this$enhance, List<? extends FirCallableDeclaration> overriddenMembers, FirAnnotationContainer typeContainer, boolean isCovariant, JavaTypeQualifiersByElementType containerQualifiers, AnnotationQualifierApplicabilityType containerApplicabilityType, TypeInSignature typeInSignature, TypeEnhancementInfo predefined, boolean forAnnotationMember) {
        void $this$mapTo$iv$iv;
        FirTypeRef typeRef = typeInSignature.getTypeRef($this$enhance);
        Iterable $this$map$iv = overriddenMembers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirCallableDeclaration firCallableDeclaration = (FirCallableDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(typeInSignature.getTypeRef((FirCallableDeclaration)it));
        }
        List typeRefsFromOverridden = (List)destination$iv$iv;
        FirJavaTypeConversionMode mode = forAnnotationMember ? FirJavaTypeConversionMode.ANNOTATION_MEMBER : FirJavaTypeConversionMode.DEFAULT;
        return this.enhance(new EnhancementSignatureParts(this.session, this.typeQualifierResolver, typeContainer, isCovariant, false, containerApplicabilityType, containerQualifiers), typeRef, typeRefsFromOverridden, mode, predefined);
    }

    /*
     * WARNING - void declaration
     */
    private final FirResolvedTypeRef enhance(EnhancementSignatureParts $this$enhance, FirTypeRef typeRef, List<? extends FirTypeRef> typeRefsFromOverridden, FirJavaTypeConversionMode mode, TypeEnhancementInfo predefined) {
        void $this$mapTo$iv$iv;
        ConeKotlinType typeWithoutEnhancement = this.toConeKotlinType(typeRef, mode);
        Iterable $this$map$iv = typeRefsFromOverridden;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeRef firTypeRef = (FirTypeRef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toConeKotlinType((FirTypeRef)it, mode));
        }
        List typesFromOverridden = (List)destination$iv$iv;
        Function1 qualifiers = AbstractSignatureParts.computeIndexedQualifiers$default($this$enhance, typeWithoutEnhancement, typesFromOverridden, predefined, false, 4, null);
        boolean $i$f$buildResolvedTypeRef = false;
        Object $this$enhance_u24lambda_u2d24 = object = new FirResolvedTypeRefBuilder();
        boolean bl = false;
        ConeKotlinType coneKotlinType = JavaTypeUtilsKt.enhance(typeWithoutEnhancement, this.session, qualifiers);
        if (coneKotlinType == null) {
            coneKotlinType = typeWithoutEnhancement;
        }
        ((FirResolvedTypeRefBuilder)$this$enhance_u24lambda_u2d24).setType(coneKotlinType);
        CollectionsKt.addAll((Collection)((FirResolvedTypeRefBuilder)$this$enhance_u24lambda_u2d24).getAnnotations(), (Iterable)typeRef.getAnnotations());
        return ((FirResolvedTypeRefBuilder)object).build();
    }

    static /* synthetic */ FirResolvedTypeRef enhance$default(FirSignatureEnhancement firSignatureEnhancement, EnhancementSignatureParts enhancementSignatureParts, FirTypeRef firTypeRef, List list2, FirJavaTypeConversionMode firJavaTypeConversionMode, TypeEnhancementInfo typeEnhancementInfo, int n, Object object) {
        if ((n & 8) != 0) {
            typeEnhancementInfo = null;
        }
        return firSignatureEnhancement.enhance(enhancementSignatureParts, firTypeRef, list2, firJavaTypeConversionMode, typeEnhancementInfo);
    }

    private final ConeKotlinType toConeKotlinType(FirTypeRef $this$toConeKotlinType, FirJavaTypeConversionMode mode) {
        return JavaTypeConversionKt.toConeKotlinTypeProbablyFlexible($this$toConeKotlinType, this.session, this.javaTypeParameterStack, mode);
    }

    public static final /* synthetic */ FirModuleData access$getModuleData(FirSignatureEnhancement $this) {
        return $this.getModuleData();
    }

    public static final /* synthetic */ FirSession access$getSession$p(FirSignatureEnhancement $this) {
        return $this.session;
    }

    public static final /* synthetic */ JavaTypeParameterStack access$getJavaTypeParameterStack$p(FirSignatureEnhancement $this) {
        return $this.javaTypeParameterStack;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u0082\u0001\u0003\n\u000b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature;", "", "()V", "getTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "member", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Receiver", "Return", "ValueParameter", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$Receiver;", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$Return;", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$ValueParameter;", "java"})
    private static abstract class TypeInSignature {
        private TypeInSignature() {
        }

        @NotNull
        public abstract FirTypeRef getTypeRef(@NotNull FirCallableDeclaration var1);

        public /* synthetic */ TypeInSignature(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$Return;", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature;", "()V", "getTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "member", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "java"})
        public static final class Return
        extends TypeInSignature {
            @NotNull
            public static final Return INSTANCE = new Return();

            private Return() {
                super(null);
            }

            @Override
            @NotNull
            public FirTypeRef getTypeRef(@NotNull FirCallableDeclaration member2) {
                Intrinsics.checkNotNullParameter(member2, "member");
                return member2.getReturnTypeRef();
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$Receiver;", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature;", "()V", "getTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "member", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "java"})
        public static final class Receiver
        extends TypeInSignature {
            @NotNull
            public static final Receiver INSTANCE = new Receiver();

            private Receiver() {
                super(null);
            }

            @Override
            @NotNull
            public FirTypeRef getTypeRef(@NotNull FirCallableDeclaration member2) {
                Intrinsics.checkNotNullParameter(member2, "member");
                if (member2 instanceof FirJavaMethod) {
                    return ((FirJavaMethod)member2).getValueParameters().get(0).getReturnTypeRef();
                }
                FirTypeRef firTypeRef = member2.getReceiverTypeRef();
                Intrinsics.checkNotNull(firTypeRef);
                return firTypeRef;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$ValueParameter;", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature;", "hasReceiver", "", "index", "", "(ZI)V", "getHasReceiver", "()Z", "getIndex", "()I", "getTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "member", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "java"})
        public static final class ValueParameter
        extends TypeInSignature {
            private final boolean hasReceiver;
            private final int index;

            public ValueParameter(boolean hasReceiver, int index2) {
                super(null);
                this.hasReceiver = hasReceiver;
                this.index = index2;
            }

            public final boolean getHasReceiver() {
                return this.hasReceiver;
            }

            public final int getIndex() {
                return this.index;
            }

            @Override
            @NotNull
            public FirTypeRef getTypeRef(@NotNull FirCallableDeclaration member2) {
                Intrinsics.checkNotNullParameter(member2, "member");
                if (this.hasReceiver && member2 instanceof FirJavaMethod) {
                    return ((FirJavaMethod)member2).getValueParameters().get(this.index + 1).getReturnTypeRef();
                }
                return ((FirFunction)member2).getValueParameters().get(this.index).getReturnTypeRef();
            }
        }
    }
}

