/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.client.methods;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.kotlin.org.apache.http.Consts;
import org.jetbrains.kotlin.org.apache.http.HttpEntity;
import org.jetbrains.kotlin.org.apache.http.HttpEntityEnclosingRequest;
import org.jetbrains.kotlin.org.apache.http.HttpRequest;
import org.jetbrains.kotlin.org.apache.http.NameValuePair;
import org.jetbrains.kotlin.org.apache.http.ProtocolVersion;
import org.jetbrains.kotlin.org.apache.http.client.config.RequestConfig;
import org.jetbrains.kotlin.org.apache.http.client.entity.UrlEncodedFormEntity;
import org.jetbrains.kotlin.org.apache.http.client.methods.Configurable;
import org.jetbrains.kotlin.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.jetbrains.kotlin.org.apache.http.client.methods.HttpRequestBase;
import org.jetbrains.kotlin.org.apache.http.client.methods.HttpUriRequest;
import org.jetbrains.kotlin.org.apache.http.client.utils.URIBuilder;
import org.jetbrains.kotlin.org.apache.http.client.utils.URLEncodedUtils;
import org.jetbrains.kotlin.org.apache.http.entity.ContentType;
import org.jetbrains.kotlin.org.apache.http.message.HeaderGroup;
import org.jetbrains.kotlin.org.apache.http.protocol.HTTP;
import org.jetbrains.kotlin.org.apache.http.util.Args;

public class RequestBuilder {
    private String method;
    private Charset charset = Consts.UTF_8;
    private ProtocolVersion version;
    private URI uri;
    private HeaderGroup headerGroup;
    private HttpEntity entity;
    private List<NameValuePair> parameters;
    private RequestConfig config;

    RequestBuilder(String method) {
        this.method = method;
    }

    RequestBuilder() {
        this(null);
    }

    public static RequestBuilder copy(HttpRequest request) {
        Args.notNull(request, "HTTP request");
        return new RequestBuilder().doCopy(request);
    }

    private RequestBuilder doCopy(HttpRequest request) {
        if (request == null) {
            return this;
        }
        this.method = request.getRequestLine().getMethod();
        this.version = request.getRequestLine().getProtocolVersion();
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.clear();
        this.headerGroup.setHeaders(request.getAllHeaders());
        this.parameters = null;
        this.entity = null;
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity originalEntity = ((HttpEntityEnclosingRequest)request).getEntity();
            ContentType contentType = ContentType.get(originalEntity);
            if (contentType != null && contentType.getMimeType().equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                try {
                    List<NameValuePair> formParams = URLEncodedUtils.parse(originalEntity);
                    if (!formParams.isEmpty()) {
                        this.parameters = formParams;
                    }
                }
                catch (IOException iOException) {}
            } else {
                this.entity = originalEntity;
            }
        }
        this.uri = request instanceof HttpUriRequest ? ((HttpUriRequest)request).getURI() : URI.create(request.getRequestLine().getUri());
        this.config = request instanceof Configurable ? ((Configurable)((Object)request)).getConfig() : null;
        return this;
    }

    public RequestBuilder setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    public HttpUriRequest build() {
        HttpRequestBase result2;
        URI uriNotNull = this.uri != null ? this.uri : URI.create("/");
        HttpEntity entityCopy = this.entity;
        if (this.parameters != null && !this.parameters.isEmpty()) {
            if (entityCopy == null && ("POST".equalsIgnoreCase(this.method) || "PUT".equalsIgnoreCase(this.method))) {
                entityCopy = new UrlEncodedFormEntity(this.parameters, this.charset != null ? this.charset : HTTP.DEF_CONTENT_CHARSET);
            } else {
                try {
                    uriNotNull = new URIBuilder(uriNotNull).setCharset(this.charset).addParameters(this.parameters).build();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        if (entityCopy == null) {
            result2 = new InternalRequest(this.method);
        } else {
            InternalEntityEclosingRequest request = new InternalEntityEclosingRequest(this.method);
            request.setEntity(entityCopy);
            result2 = request;
        }
        result2.setProtocolVersion(this.version);
        result2.setURI(uriNotNull);
        if (this.headerGroup != null) {
            result2.setHeaders(this.headerGroup.getAllHeaders());
        }
        result2.setConfig(this.config);
        return result2;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("RequestBuilder [method=");
        builder2.append(this.method);
        builder2.append(", charset=");
        builder2.append(this.charset);
        builder2.append(", version=");
        builder2.append(this.version);
        builder2.append(", uri=");
        builder2.append(this.uri);
        builder2.append(", headerGroup=");
        builder2.append(this.headerGroup);
        builder2.append(", entity=");
        builder2.append(this.entity);
        builder2.append(", parameters=");
        builder2.append(this.parameters);
        builder2.append(", config=");
        builder2.append(this.config);
        builder2.append("]");
        return builder2.toString();
    }

    static class InternalEntityEclosingRequest
    extends HttpEntityEnclosingRequestBase {
        private final String method;

        InternalEntityEclosingRequest(String method) {
            this.method = method;
        }

        @Override
        public String getMethod() {
            return this.method;
        }
    }

    static class InternalRequest
    extends HttpRequestBase {
        private final String method;

        InternalRequest(String method) {
            this.method = method;
        }

        @Override
        public String getMethod() {
            return this.method;
        }
    }
}

