/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.kotlin.org.eclipse.aether.DefaultSessionData;
import org.jetbrains.kotlin.org.eclipse.aether.RepositoryCache;
import org.jetbrains.kotlin.org.eclipse.aether.RepositoryListener;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.SessionData;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.ArtifactType;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyGraphTransformer;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyManager;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencySelector;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyTraverser;
import org.jetbrains.kotlin.org.eclipse.aether.collection.VersionFilter;
import org.jetbrains.kotlin.org.eclipse.aether.repository.Authentication;
import org.jetbrains.kotlin.org.eclipse.aether.repository.AuthenticationSelector;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.repository.MirrorSelector;
import org.jetbrains.kotlin.org.eclipse.aether.repository.Proxy;
import org.jetbrains.kotlin.org.eclipse.aether.repository.ProxySelector;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.WorkspaceReader;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.TransferListener;
import org.jetbrains.kotlin.org.eclipse.aether.transform.FileTransformerManager;

public final class DefaultRepositorySystemSession
implements RepositorySystemSession {
    private boolean readOnly;
    private boolean offline;
    private boolean ignoreArtifactDescriptorRepositories;
    private ResolutionErrorPolicy resolutionErrorPolicy;
    private ArtifactDescriptorPolicy artifactDescriptorPolicy;
    private String checksumPolicy;
    private String updatePolicy;
    private LocalRepositoryManager localRepositoryManager;
    private FileTransformerManager fileTransformerManager;
    private WorkspaceReader workspaceReader;
    private RepositoryListener repositoryListener;
    private TransferListener transferListener;
    private Map<String, String> systemProperties;
    private Map<String, String> systemPropertiesView;
    private Map<String, String> userProperties;
    private Map<String, String> userPropertiesView;
    private Map<String, Object> configProperties;
    private Map<String, Object> configPropertiesView;
    private MirrorSelector mirrorSelector;
    private ProxySelector proxySelector;
    private AuthenticationSelector authenticationSelector;
    private ArtifactTypeRegistry artifactTypeRegistry;
    private DependencyTraverser dependencyTraverser;
    private DependencyManager dependencyManager;
    private DependencySelector dependencySelector;
    private VersionFilter versionFilter;
    private DependencyGraphTransformer dependencyGraphTransformer;
    private SessionData data;
    private RepositoryCache cache;

    public DefaultRepositorySystemSession() {
        this.systemProperties = new HashMap<String, String>();
        this.systemPropertiesView = Collections.unmodifiableMap(this.systemProperties);
        this.userProperties = new HashMap<String, String>();
        this.userPropertiesView = Collections.unmodifiableMap(this.userProperties);
        this.configProperties = new HashMap<String, Object>();
        this.configPropertiesView = Collections.unmodifiableMap(this.configProperties);
        this.mirrorSelector = NullMirrorSelector.INSTANCE;
        this.proxySelector = NullProxySelector.INSTANCE;
        this.authenticationSelector = NullAuthenticationSelector.INSTANCE;
        this.artifactTypeRegistry = NullArtifactTypeRegistry.INSTANCE;
        this.fileTransformerManager = NullFileTransformerManager.INSTANCE;
        this.data = new DefaultSessionData();
    }

    public DefaultRepositorySystemSession(RepositorySystemSession session2) {
        Objects.requireNonNull(session2, "repository system session cannot be null");
        this.setOffline(session2.isOffline());
        this.setIgnoreArtifactDescriptorRepositories(session2.isIgnoreArtifactDescriptorRepositories());
        this.setResolutionErrorPolicy(session2.getResolutionErrorPolicy());
        this.setArtifactDescriptorPolicy(session2.getArtifactDescriptorPolicy());
        this.setChecksumPolicy(session2.getChecksumPolicy());
        this.setUpdatePolicy(session2.getUpdatePolicy());
        this.setLocalRepositoryManager(session2.getLocalRepositoryManager());
        this.setWorkspaceReader(session2.getWorkspaceReader());
        this.setRepositoryListener(session2.getRepositoryListener());
        this.setTransferListener(session2.getTransferListener());
        this.setSystemProperties(session2.getSystemProperties());
        this.setUserProperties(session2.getUserProperties());
        this.setConfigProperties(session2.getConfigProperties());
        this.setMirrorSelector(session2.getMirrorSelector());
        this.setProxySelector(session2.getProxySelector());
        this.setAuthenticationSelector(session2.getAuthenticationSelector());
        this.setArtifactTypeRegistry(session2.getArtifactTypeRegistry());
        this.setDependencyTraverser(session2.getDependencyTraverser());
        this.setDependencyManager(session2.getDependencyManager());
        this.setDependencySelector(session2.getDependencySelector());
        this.setVersionFilter(session2.getVersionFilter());
        this.setDependencyGraphTransformer(session2.getDependencyGraphTransformer());
        this.setFileTransformerManager(session2.getFileTransformerManager());
        this.setData(session2.getData());
        this.setCache(session2.getCache());
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    public DefaultRepositorySystemSession setOffline(boolean offline) {
        this.failIfReadOnly();
        this.offline = offline;
        return this;
    }

    @Override
    public boolean isIgnoreArtifactDescriptorRepositories() {
        return this.ignoreArtifactDescriptorRepositories;
    }

    public DefaultRepositorySystemSession setIgnoreArtifactDescriptorRepositories(boolean ignoreArtifactDescriptorRepositories) {
        this.failIfReadOnly();
        this.ignoreArtifactDescriptorRepositories = ignoreArtifactDescriptorRepositories;
        return this;
    }

    @Override
    public ResolutionErrorPolicy getResolutionErrorPolicy() {
        return this.resolutionErrorPolicy;
    }

    public DefaultRepositorySystemSession setResolutionErrorPolicy(ResolutionErrorPolicy resolutionErrorPolicy) {
        this.failIfReadOnly();
        this.resolutionErrorPolicy = resolutionErrorPolicy;
        return this;
    }

    @Override
    public ArtifactDescriptorPolicy getArtifactDescriptorPolicy() {
        return this.artifactDescriptorPolicy;
    }

    public DefaultRepositorySystemSession setArtifactDescriptorPolicy(ArtifactDescriptorPolicy artifactDescriptorPolicy) {
        this.failIfReadOnly();
        this.artifactDescriptorPolicy = artifactDescriptorPolicy;
        return this;
    }

    @Override
    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public DefaultRepositorySystemSession setChecksumPolicy(String checksumPolicy) {
        this.failIfReadOnly();
        this.checksumPolicy = checksumPolicy;
        return this;
    }

    @Override
    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public DefaultRepositorySystemSession setUpdatePolicy(String updatePolicy) {
        this.failIfReadOnly();
        this.updatePolicy = updatePolicy;
        return this;
    }

    @Override
    public LocalRepository getLocalRepository() {
        LocalRepositoryManager lrm = this.getLocalRepositoryManager();
        return lrm != null ? lrm.getRepository() : null;
    }

    @Override
    public LocalRepositoryManager getLocalRepositoryManager() {
        return this.localRepositoryManager;
    }

    public DefaultRepositorySystemSession setLocalRepositoryManager(LocalRepositoryManager localRepositoryManager) {
        this.failIfReadOnly();
        this.localRepositoryManager = localRepositoryManager;
        return this;
    }

    @Override
    public FileTransformerManager getFileTransformerManager() {
        return this.fileTransformerManager;
    }

    public DefaultRepositorySystemSession setFileTransformerManager(FileTransformerManager fileTransformerManager) {
        this.failIfReadOnly();
        this.fileTransformerManager = fileTransformerManager;
        if (this.fileTransformerManager == null) {
            this.fileTransformerManager = NullFileTransformerManager.INSTANCE;
        }
        return this;
    }

    @Override
    public WorkspaceReader getWorkspaceReader() {
        return this.workspaceReader;
    }

    public DefaultRepositorySystemSession setWorkspaceReader(WorkspaceReader workspaceReader) {
        this.failIfReadOnly();
        this.workspaceReader = workspaceReader;
        return this;
    }

    @Override
    public RepositoryListener getRepositoryListener() {
        return this.repositoryListener;
    }

    public DefaultRepositorySystemSession setRepositoryListener(RepositoryListener repositoryListener) {
        this.failIfReadOnly();
        this.repositoryListener = repositoryListener;
        return this;
    }

    @Override
    public TransferListener getTransferListener() {
        return this.transferListener;
    }

    public DefaultRepositorySystemSession setTransferListener(TransferListener transferListener) {
        this.failIfReadOnly();
        this.transferListener = transferListener;
        return this;
    }

    private <T> Map<String, T> copySafe(Map<?, ?> table, Class<T> valueType) {
        HashMap<String, T> map2;
        if (table == null || table.isEmpty()) {
            map2 = new HashMap<String, T>();
        } else {
            map2 = new HashMap((int)((float)table.size() / 0.75f) + 1);
            for (Map.Entry<?, ?> entry : table.entrySet()) {
                Object value2;
                Object key = entry.getKey();
                if (!(key instanceof String) || !valueType.isInstance(value2 = entry.getValue())) continue;
                map2.put(key.toString(), valueType.cast(value2));
            }
        }
        return map2;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return this.systemPropertiesView;
    }

    public DefaultRepositorySystemSession setSystemProperties(Map<?, ?> systemProperties) {
        this.failIfReadOnly();
        this.systemProperties = this.copySafe(systemProperties, String.class);
        this.systemPropertiesView = Collections.unmodifiableMap(this.systemProperties);
        return this;
    }

    @Override
    public Map<String, String> getUserProperties() {
        return this.userPropertiesView;
    }

    public DefaultRepositorySystemSession setUserProperties(Map<?, ?> userProperties) {
        this.failIfReadOnly();
        this.userProperties = this.copySafe(userProperties, String.class);
        this.userPropertiesView = Collections.unmodifiableMap(this.userProperties);
        return this;
    }

    @Override
    public Map<String, Object> getConfigProperties() {
        return this.configPropertiesView;
    }

    public DefaultRepositorySystemSession setConfigProperties(Map<?, ?> configProperties) {
        this.failIfReadOnly();
        this.configProperties = this.copySafe(configProperties, Object.class);
        this.configPropertiesView = Collections.unmodifiableMap(this.configProperties);
        return this;
    }

    @Override
    public MirrorSelector getMirrorSelector() {
        return this.mirrorSelector;
    }

    public DefaultRepositorySystemSession setMirrorSelector(MirrorSelector mirrorSelector) {
        this.failIfReadOnly();
        this.mirrorSelector = mirrorSelector;
        if (this.mirrorSelector == null) {
            this.mirrorSelector = NullMirrorSelector.INSTANCE;
        }
        return this;
    }

    @Override
    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public DefaultRepositorySystemSession setProxySelector(ProxySelector proxySelector) {
        this.failIfReadOnly();
        this.proxySelector = proxySelector;
        if (this.proxySelector == null) {
            this.proxySelector = NullProxySelector.INSTANCE;
        }
        return this;
    }

    @Override
    public AuthenticationSelector getAuthenticationSelector() {
        return this.authenticationSelector;
    }

    public DefaultRepositorySystemSession setAuthenticationSelector(AuthenticationSelector authenticationSelector) {
        this.failIfReadOnly();
        this.authenticationSelector = authenticationSelector;
        if (this.authenticationSelector == null) {
            this.authenticationSelector = NullAuthenticationSelector.INSTANCE;
        }
        return this;
    }

    @Override
    public ArtifactTypeRegistry getArtifactTypeRegistry() {
        return this.artifactTypeRegistry;
    }

    public DefaultRepositorySystemSession setArtifactTypeRegistry(ArtifactTypeRegistry artifactTypeRegistry) {
        this.failIfReadOnly();
        this.artifactTypeRegistry = artifactTypeRegistry;
        if (this.artifactTypeRegistry == null) {
            this.artifactTypeRegistry = NullArtifactTypeRegistry.INSTANCE;
        }
        return this;
    }

    @Override
    public DependencyTraverser getDependencyTraverser() {
        return this.dependencyTraverser;
    }

    public DefaultRepositorySystemSession setDependencyTraverser(DependencyTraverser dependencyTraverser) {
        this.failIfReadOnly();
        this.dependencyTraverser = dependencyTraverser;
        return this;
    }

    @Override
    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public DefaultRepositorySystemSession setDependencyManager(DependencyManager dependencyManager) {
        this.failIfReadOnly();
        this.dependencyManager = dependencyManager;
        return this;
    }

    @Override
    public DependencySelector getDependencySelector() {
        return this.dependencySelector;
    }

    public DefaultRepositorySystemSession setDependencySelector(DependencySelector dependencySelector) {
        this.failIfReadOnly();
        this.dependencySelector = dependencySelector;
        return this;
    }

    @Override
    public VersionFilter getVersionFilter() {
        return this.versionFilter;
    }

    public DefaultRepositorySystemSession setVersionFilter(VersionFilter versionFilter) {
        this.failIfReadOnly();
        this.versionFilter = versionFilter;
        return this;
    }

    @Override
    public DependencyGraphTransformer getDependencyGraphTransformer() {
        return this.dependencyGraphTransformer;
    }

    public DefaultRepositorySystemSession setDependencyGraphTransformer(DependencyGraphTransformer dependencyGraphTransformer) {
        this.failIfReadOnly();
        this.dependencyGraphTransformer = dependencyGraphTransformer;
        return this;
    }

    @Override
    public SessionData getData() {
        return this.data;
    }

    public DefaultRepositorySystemSession setData(SessionData data2) {
        this.failIfReadOnly();
        this.data = data2;
        if (this.data == null) {
            this.data = new DefaultSessionData();
        }
        return this;
    }

    @Override
    public RepositoryCache getCache() {
        return this.cache;
    }

    public DefaultRepositorySystemSession setCache(RepositoryCache cache2) {
        this.failIfReadOnly();
        this.cache = cache2;
        return this;
    }

    private void failIfReadOnly() {
        if (this.readOnly) {
            throw new IllegalStateException("repository system session is read-only");
        }
    }

    static final class NullFileTransformerManager
    implements FileTransformerManager {
        public static final FileTransformerManager INSTANCE = new NullFileTransformerManager();

        NullFileTransformerManager() {
        }
    }

    static final class NullArtifactTypeRegistry
    implements ArtifactTypeRegistry {
        public static final ArtifactTypeRegistry INSTANCE = new NullArtifactTypeRegistry();

        NullArtifactTypeRegistry() {
        }

        @Override
        public ArtifactType get(String typeId) {
            return null;
        }
    }

    static class NullAuthenticationSelector
    implements AuthenticationSelector {
        public static final AuthenticationSelector INSTANCE = new NullAuthenticationSelector();

        NullAuthenticationSelector() {
        }

        @Override
        public Authentication getAuthentication(RemoteRepository repository) {
            Objects.requireNonNull(repository, "repository cannot be null");
            return repository.getAuthentication();
        }
    }

    static class NullMirrorSelector
    implements MirrorSelector {
        public static final MirrorSelector INSTANCE = new NullMirrorSelector();

        NullMirrorSelector() {
        }

        @Override
        public RemoteRepository getMirror(RemoteRepository repository) {
            Objects.requireNonNull(repository, "repository cannot be null");
            return null;
        }
    }

    static class NullProxySelector
    implements ProxySelector {
        public static final ProxySelector INSTANCE = new NullProxySelector();

        NullProxySelector() {
        }

        @Override
        public Proxy getProxy(RemoteRepository repository) {
            Objects.requireNonNull(repository, "repository cannot be null");
            return repository.getProxy();
        }
    }
}

