/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.checksum;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.checksum.DefaultChecksumAlgorithmFactorySelector$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.checksum.Md5ChecksumAlgorithmFactory;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.checksum.Sha1ChecksumAlgorithmFactory;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.checksum.Sha256ChecksumAlgorithmFactory;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.checksum.Sha512ChecksumAlgorithmFactory;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;

@Singleton
@Named
public class DefaultChecksumAlgorithmFactorySelector
implements ChecksumAlgorithmFactorySelector {
    private final Map<String, ChecksumAlgorithmFactory> factories = new HashMap<String, ChecksumAlgorithmFactory>();

    @Deprecated
    public DefaultChecksumAlgorithmFactorySelector() {
        this.factories.put("SHA-512", new Sha512ChecksumAlgorithmFactory());
        this.factories.put("SHA-256", new Sha256ChecksumAlgorithmFactory());
        this.factories.put("SHA-1", new Sha1ChecksumAlgorithmFactory());
        this.factories.put("MD5", new Md5ChecksumAlgorithmFactory());
    }

    @Override
    public ChecksumAlgorithmFactory select(String algorithmName) {
        Objects.requireNonNull(algorithmName, "algorithmMame must not be null");
        ChecksumAlgorithmFactory factory2 = this.factories.get(algorithmName);
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Unsupported checksum algorithm %s, supported ones are %s", algorithmName, this.getChecksumAlgorithmFactories().stream().map(DefaultChecksumAlgorithmFactorySelector$$Lambda$0.INSTANCE).collect(Collectors.toList())));
        }
        return factory2;
    }

    public List<ChecksumAlgorithmFactory> getChecksumAlgorithmFactories() {
        return new ArrayList<ChecksumAlgorithmFactory>(this.factories.values());
    }
}

