/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.bf;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.DefaultRepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.RepositoryException;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.RequestTrace;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.collection.CollectRequest;
import org.jetbrains.kotlin.org.eclipse.aether.collection.CollectResult;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyCollectionException;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyGraphTransformer;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyManagement;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyManager;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencySelector;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyTraverser;
import org.jetbrains.kotlin.org.eclipse.aether.collection.VersionFilter;
import org.jetbrains.kotlin.org.eclipse.aether.graph.DefaultDependencyNode;
import org.jetbrains.kotlin.org.eclipse.aether.graph.Dependency;
import org.jetbrains.kotlin.org.eclipse.aether.graph.DependencyNode;
import org.jetbrains.kotlin.org.eclipse.aether.graph.Exclusion;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.CachingArtifactTypeRegistry;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.DataPool;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.DefaultDependencyCollectionContext;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.DefaultDependencyCycle;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.DefaultDependencyGraphTransformationContext;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.DefaultVersionFilterContext;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.DependencyCollectorDelegate;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.bf.DependencyProcessingContext;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.bf.DependencyResolutionSkipper;
import org.jetbrains.kotlin.org.eclipse.aether.repository.ArtifactRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.VersionRangeRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.VersionRangeResult;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.Service;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.transformer.TransformationContextKeys;
import org.jetbrains.kotlin.org.eclipse.aether.version.Version;

@Singleton
@Named(value="bf")
public class BfDependencyCollector
extends DependencyCollectorDelegate
implements Service {
    @Override
    public CollectResult collectDependencies(RepositorySystemSession session2, CollectRequest request) throws DependencyCollectionException {
        DefaultDependencyNode node;
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
        session2 = BfDependencyCollector.optimizeSession(session2);
        boolean useSkip = ConfigUtils.getBoolean(session2, true, "aether.dependencyCollector.bf.skipper");
        if (useSkip) {
            this.logger.debug("Collector skip mode enabled");
        }
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        CollectResult result2 = new CollectResult(request);
        DependencySelector depSelector = session2.getDependencySelector();
        DependencyManager depManager = session2.getDependencyManager();
        DependencyTraverser depTraverser = session2.getDependencyTraverser();
        VersionFilter verFilter = session2.getVersionFilter();
        Dependency root2 = request.getRoot();
        List<RemoteRepository> repositories = request.getRepositories();
        List<Dependency> dependencies2 = request.getDependencies();
        List<Dependency> managedDependencies = request.getManagedDependencies();
        LinkedHashMap<String, Long> stats = new LinkedHashMap<String, Long>();
        long time1 = System.nanoTime();
        if (root2 != null) {
            ArtifactDescriptorResult descriptorResult;
            List<? extends Version> versions2;
            VersionRangeResult rangeResult;
            try {
                VersionRangeRequest rangeRequest = new VersionRangeRequest(root2.getArtifact(), request.getRepositories(), request.getRequestContext());
                rangeRequest.setTrace(trace);
                rangeResult = this.versionRangeResolver.resolveVersionRange(session2, rangeRequest);
                versions2 = BfDependencyCollector.filterVersions(root2, rangeResult, verFilter, new DefaultVersionFilterContext(session2));
            }
            catch (VersionRangeResolutionException e) {
                result2.addException(e);
                throw new DependencyCollectionException(result2, e.getMessage());
            }
            Version version = versions2.get(versions2.size() - 1);
            root2 = root2.setArtifact(root2.getArtifact().setVersion(version.toString()));
            try {
                ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
                descriptorRequest.setArtifact(root2.getArtifact());
                descriptorRequest.setRepositories(request.getRepositories());
                descriptorRequest.setRequestContext(request.getRequestContext());
                descriptorRequest.setTrace(trace);
                descriptorResult = BfDependencyCollector.isLackingDescriptor(root2.getArtifact()) ? new ArtifactDescriptorResult(descriptorRequest) : this.descriptorReader.readArtifactDescriptor(session2, descriptorRequest);
            }
            catch (ArtifactDescriptorException e) {
                result2.addException(e);
                throw new DependencyCollectionException(result2, e.getMessage());
            }
            root2 = root2.setArtifact(descriptorResult.getArtifact());
            if (!session2.isIgnoreArtifactDescriptorRepositories()) {
                repositories = this.remoteRepositoryManager.aggregateRepositories(session2, repositories, descriptorResult.getRepositories(), true);
            }
            dependencies2 = this.mergeDeps(dependencies2, descriptorResult.getDependencies());
            managedDependencies = this.mergeDeps(managedDependencies, descriptorResult.getManagedDependencies());
            node = new DefaultDependencyNode(root2);
            node.setRequestContext(request.getRequestContext());
            node.setRelocations(descriptorResult.getRelocations());
            node.setVersionConstraint(rangeResult.getVersionConstraint());
            node.setVersion(version);
            node.setAliases(descriptorResult.getAliases());
            node.setRepositories(request.getRepositories());
        } else {
            node = new DefaultDependencyNode(request.getRootArtifact());
            node.setRequestContext(request.getRequestContext());
            node.setRepositories(request.getRepositories());
        }
        result2.setRoot(node);
        boolean traverse2 = root2 == null || depTraverser == null || depTraverser.traverseDependency(root2);
        String errorPath = null;
        if (traverse2 && !dependencies2.isEmpty()) {
            DataPool pool = new DataPool(session2);
            DefaultDependencyCollectionContext context = new DefaultDependencyCollectionContext(session2, request.getRootArtifact(), root2, managedDependencies);
            DefaultVersionFilterContext versionContext = new DefaultVersionFilterContext(session2);
            Args args2 = new Args(session2, trace, pool, context, versionContext, request, useSkip ? DependencyResolutionSkipper.defaultSkipper() : DependencyResolutionSkipper.neverSkipper());
            Results results = new Results(result2, session2);
            DependencySelector rootDepSelector = depSelector != null ? depSelector.deriveChildSelector(context) : null;
            DependencyManager rootDepManager = depManager != null ? depManager.deriveChildManager(context) : null;
            DependencyTraverser rootDepTraverser = depTraverser != null ? depTraverser.deriveChildTraverser(context) : null;
            VersionFilter rootVerFilter = verFilter != null ? verFilter.deriveChildFilter(context) : null;
            List<DependencyNode> parents2 = Collections.singletonList(node);
            for (Dependency dependency : dependencies2) {
                args2.dependencyProcessingQueue.add(new DependencyProcessingContext(rootDepSelector, rootDepManager, rootDepTraverser, rootVerFilter, repositories, managedDependencies, parents2, dependency));
            }
            while (!args2.dependencyProcessingQueue.isEmpty()) {
                this.processDependency(args2, results, args2.dependencyProcessingQueue.remove(), Collections.<Artifact>emptyList(), false);
            }
            args2.skipper.report();
            errorPath = results.errorPath;
        }
        long time2 = System.nanoTime();
        DependencyGraphTransformer transformer2 = session2.getDependencyGraphTransformer();
        if (transformer2 != null) {
            try {
                DefaultDependencyGraphTransformationContext context = new DefaultDependencyGraphTransformationContext(session2);
                context.put(TransformationContextKeys.STATS, stats);
                result2.setRoot(transformer2.transformGraph(node, context));
            }
            catch (RepositoryException e) {
                result2.addException(e);
            }
        }
        long time3 = System.nanoTime();
        if (this.logger.isDebugEnabled()) {
            stats.put("BfDependencyCollector.collectTime", time2 - time1);
            stats.put("BfDependencyCollector.transformTime", time3 - time2);
            this.logger.debug("Dependency collection stats {}", (Object)stats);
        }
        if (errorPath != null) {
            throw new DependencyCollectionException(result2, "Failed to collect dependencies at " + errorPath);
        }
        if (!result2.getExceptions().isEmpty()) {
            throw new DependencyCollectionException(result2);
        }
        return result2;
    }

    private static RepositorySystemSession optimizeSession(RepositorySystemSession session2) {
        DefaultRepositorySystemSession optimized = new DefaultRepositorySystemSession(session2);
        optimized.setArtifactTypeRegistry(CachingArtifactTypeRegistry.newInstance(session2));
        return optimized;
    }

    private List<Dependency> mergeDeps(List<Dependency> dominant, List<Dependency> recessive) {
        List<Dependency> result2;
        if (dominant == null || dominant.isEmpty()) {
            result2 = recessive;
        } else if (recessive == null || recessive.isEmpty()) {
            result2 = dominant;
        } else {
            int initialCapacity = dominant.size() + recessive.size();
            result2 = new ArrayList<Dependency>(initialCapacity);
            HashSet<String> ids = new HashSet<String>(initialCapacity, 1.0f);
            for (Dependency dependency : dominant) {
                ids.add(BfDependencyCollector.getId(dependency.getArtifact()));
                result2.add(dependency);
            }
            for (Dependency dependency : recessive) {
                if (ids.contains(BfDependencyCollector.getId(dependency.getArtifact()))) continue;
                result2.add(dependency);
            }
        }
        return result2;
    }

    private static String getId(Artifact a) {
        return a.getGroupId() + ':' + a.getArtifactId() + ':' + a.getClassifier() + ':' + a.getExtension();
    }

    /*
     * WARNING - void declaration
     */
    private void processDependency(Args args2, Results results, DependencyProcessingContext context, List<Artifact> relocations, boolean disableVersionManagement) {
        void versions2;
        VersionRangeResult rangeResult;
        if (context.depSelector != null && !context.depSelector.selectDependency(context.dependency)) {
            return;
        }
        PremanagedDependency preManaged = PremanagedDependency.create(context.depManager, context.dependency, disableVersionManagement, args2.premanagedState);
        Dependency dependency = preManaged.managedDependency;
        boolean noDescriptor = BfDependencyCollector.isLackingDescriptor(dependency.getArtifact());
        boolean traverse2 = !noDescriptor && (context.depTraverser == null || context.depTraverser.traverseDependency(dependency));
        try {
            VersionRangeRequest rangeRequest = BfDependencyCollector.createVersionRangeRequest(args2, context.repositories, dependency);
            rangeResult = this.cachedResolveRangeResult(rangeRequest, args2.pool, args2.session);
            List<? extends Version> versions22 = BfDependencyCollector.filterVersions(dependency, rangeResult, context.verFilter, args2.versionContext);
        }
        catch (VersionRangeResolutionException e) {
            results.addException(dependency, e, context.parents);
            return;
        }
        Collections.reverse(versions2);
        for (Version version : versions2) {
            ArtifactDescriptorResult descriptorResult;
            Artifact originalArtifact = dependency.getArtifact().setVersion(version.toString());
            Dependency d = dependency.setArtifact(originalArtifact);
            ArtifactDescriptorRequest descriptorRequest = BfDependencyCollector.createArtifactDescriptorRequest(args2, context.repositories, d);
            ArtifactDescriptorResult artifactDescriptorResult = descriptorResult = noDescriptor ? new ArtifactDescriptorResult(descriptorRequest) : this.resolveCachedArtifactDescriptor(args2.pool, descriptorRequest, args2.session, context.withDependency(d), results);
            if (descriptorResult != null) {
                DefaultDependencyNode child;
                int cycleEntry = DefaultDependencyCycle.find(context.parents, (d = d.setArtifact(descriptorResult.getArtifact())).getArtifact());
                if (cycleEntry >= 0) {
                    results.addCycle(context.parents, cycleEntry, d);
                    DependencyNode cycleNode = context.parents.get(cycleEntry);
                    if (cycleNode.getDependency() != null) {
                        child = BfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult, cycleNode);
                        context.getParent().getChildren().add(child);
                        continue;
                    }
                }
                if (!descriptorResult.getRelocations().isEmpty()) {
                    boolean disableVersionManagementSubsequently = originalArtifact.getGroupId().equals(d.getArtifact().getGroupId()) && originalArtifact.getArtifactId().equals(d.getArtifact().getArtifactId());
                    this.processDependency(args2, results, context.withDependency(d), descriptorResult.getRelocations(), disableVersionManagementSubsequently);
                    return;
                }
                d = args2.pool.intern(d.setArtifact(args2.pool.intern(d.getArtifact())));
                List<RemoteRepository> repos = BfDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), context.repositories);
                child = BfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult.getAliases(), repos, args2.request.getRequestContext());
                context.getParent().getChildren().add(child);
                boolean recurse = traverse2 && !descriptorResult.getDependencies().isEmpty();
                if (!recurse) continue;
                this.doRecurse(args2, context.withDependency(d), descriptorResult, child);
                continue;
            }
            List<RemoteRepository> repos = BfDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), context.repositories);
            DefaultDependencyNode child = BfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, null, repos, args2.request.getRequestContext());
            context.getParent().getChildren().add(child);
        }
    }

    private void doRecurse(Args args2, DependencyProcessingContext parentContext, ArtifactDescriptorResult descriptorResult, DefaultDependencyNode child) {
        DefaultDependencyCollectionContext context = args2.collectionContext;
        context.set(parentContext.dependency, descriptorResult.getManagedDependencies());
        DependencySelector childSelector = parentContext.depSelector != null ? parentContext.depSelector.deriveChildSelector(context) : null;
        DependencyManager childManager = parentContext.depManager != null ? parentContext.depManager.deriveChildManager(context) : null;
        DependencyTraverser childTraverser = parentContext.depTraverser != null ? parentContext.depTraverser.deriveChildTraverser(context) : null;
        VersionFilter childFilter = parentContext.verFilter != null ? parentContext.verFilter.deriveChildFilter(context) : null;
        List<RemoteRepository> childRepos = args2.ignoreRepos ? parentContext.repositories : this.remoteRepositoryManager.aggregateRepositories(args2.session, parentContext.repositories, descriptorResult.getRepositories(), true);
        Object key = args2.pool.toKey(parentContext.dependency.getArtifact(), childRepos, childSelector, childManager, childTraverser, childFilter);
        List<DependencyNode> children2 = args2.pool.getChildren(key);
        if (children2 == null) {
            boolean skipResolution = args2.skipper.skipResolution(child, parentContext.parents);
            if (!skipResolution) {
                ArrayList<DependencyNode> parents2 = new ArrayList<DependencyNode>(parentContext.parents.size() + 1);
                parents2.addAll(parentContext.parents);
                parents2.add(child);
                for (Dependency dependency : descriptorResult.getDependencies()) {
                    args2.dependencyProcessingQueue.add(new DependencyProcessingContext(childSelector, childManager, childTraverser, childFilter, childRepos, descriptorResult.getManagedDependencies(), parents2, dependency));
                }
                args2.pool.putChildren(key, child.getChildren());
                args2.skipper.cache(child, parents2);
            }
        } else {
            child.setChildren(children2);
        }
    }

    private ArtifactDescriptorResult resolveCachedArtifactDescriptor(DataPool pool, ArtifactDescriptorRequest descriptorRequest, RepositorySystemSession session2, DependencyProcessingContext context, Results results) {
        Object key = pool.toKey(descriptorRequest);
        ArtifactDescriptorResult descriptorResult = pool.getDescriptor(key, descriptorRequest);
        if (descriptorResult == null) {
            try {
                descriptorResult = this.descriptorReader.readArtifactDescriptor(session2, descriptorRequest);
                pool.putDescriptor(key, descriptorResult);
            }
            catch (ArtifactDescriptorException e) {
                results.addException(context.dependency, e, context.parents);
                pool.putDescriptor(key, e);
                return null;
            }
        } else if (descriptorResult == DataPool.NO_DESCRIPTOR) {
            return null;
        }
        return descriptorResult;
    }

    private static DefaultDependencyNode createDependencyNode(List<Artifact> relocations, PremanagedDependency preManaged, VersionRangeResult rangeResult, Version version, Dependency d, Collection<Artifact> aliases, List<RemoteRepository> repos, String requestContext) {
        DefaultDependencyNode child = new DefaultDependencyNode(d);
        preManaged.applyTo(child);
        child.setRelocations(relocations);
        child.setVersionConstraint(rangeResult.getVersionConstraint());
        child.setVersion(version);
        child.setAliases(aliases);
        child.setRepositories(repos);
        child.setRequestContext(requestContext);
        return child;
    }

    private static DefaultDependencyNode createDependencyNode(List<Artifact> relocations, PremanagedDependency preManaged, VersionRangeResult rangeResult, Version version, Dependency d, ArtifactDescriptorResult descriptorResult, DependencyNode cycleNode) {
        DefaultDependencyNode child = BfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult.getAliases(), cycleNode.getRepositories(), cycleNode.getRequestContext());
        child.setChildren(cycleNode.getChildren());
        return child;
    }

    private static ArtifactDescriptorRequest createArtifactDescriptorRequest(Args args2, List<RemoteRepository> repositories, Dependency d) {
        ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
        descriptorRequest.setArtifact(d.getArtifact());
        descriptorRequest.setRepositories(repositories);
        descriptorRequest.setRequestContext(args2.request.getRequestContext());
        descriptorRequest.setTrace(args2.trace);
        return descriptorRequest;
    }

    private static VersionRangeRequest createVersionRangeRequest(Args args2, List<RemoteRepository> repositories, Dependency dependency) {
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(dependency.getArtifact());
        rangeRequest.setRepositories(repositories);
        rangeRequest.setRequestContext(args2.request.getRequestContext());
        rangeRequest.setTrace(args2.trace);
        return rangeRequest;
    }

    private VersionRangeResult cachedResolveRangeResult(VersionRangeRequest rangeRequest, DataPool pool, RepositorySystemSession session2) throws VersionRangeResolutionException {
        Object key = pool.toKey(rangeRequest);
        VersionRangeResult rangeResult = pool.getConstraint(key, rangeRequest);
        if (rangeResult == null) {
            rangeResult = this.versionRangeResolver.resolveVersionRange(session2, rangeRequest);
            pool.putConstraint(key, rangeResult);
        }
        return rangeResult;
    }

    private static boolean isLackingDescriptor(Artifact artifact) {
        return artifact.getProperty("localPath", null) != null;
    }

    private static List<RemoteRepository> getRemoteRepositories(ArtifactRepository repository, List<RemoteRepository> repositories) {
        if (repository instanceof RemoteRepository) {
            return Collections.singletonList((RemoteRepository)repository);
        }
        if (repository != null) {
            return Collections.emptyList();
        }
        return repositories;
    }

    private static List<? extends Version> filterVersions(Dependency dependency, VersionRangeResult rangeResult, VersionFilter verFilter, DefaultVersionFilterContext verContext) throws VersionRangeResolutionException {
        List<Version> versions2;
        if (rangeResult.getVersions().isEmpty()) {
            throw new VersionRangeResolutionException(rangeResult, "No versions available for " + dependency.getArtifact() + " within specified range");
        }
        if (verFilter != null && rangeResult.getVersionConstraint().getRange() != null) {
            verContext.set(dependency, rangeResult);
            try {
                verFilter.filterVersions(verContext);
            }
            catch (RepositoryException e) {
                throw new VersionRangeResolutionException(rangeResult, "Failed to filter versions for " + dependency.getArtifact(), e);
            }
            versions2 = verContext.get();
            if (versions2.isEmpty()) {
                throw new VersionRangeResolutionException(rangeResult, "No acceptable versions for " + dependency.getArtifact() + ": " + rangeResult.getVersions());
            }
        } else {
            versions2 = rangeResult.getVersions();
        }
        return versions2;
    }

    static class PremanagedDependency {
        final String premanagedVersion;
        final String premanagedScope;
        final Boolean premanagedOptional;
        final Collection<Exclusion> premanagedExclusions;
        final Map<String, String> premanagedProperties;
        final int managedBits;
        final Dependency managedDependency;
        final boolean premanagedState;

        PremanagedDependency(String premanagedVersion, String premanagedScope, Boolean premanagedOptional, Collection<Exclusion> premanagedExclusions, Map<String, String> premanagedProperties, int managedBits, Dependency managedDependency, boolean premanagedState) {
            this.premanagedVersion = premanagedVersion;
            this.premanagedScope = premanagedScope;
            this.premanagedOptional = premanagedOptional;
            this.premanagedExclusions = premanagedExclusions != null ? Collections.unmodifiableCollection(new ArrayList<Exclusion>(premanagedExclusions)) : null;
            this.premanagedProperties = premanagedProperties != null ? Collections.unmodifiableMap(new HashMap<String, String>(premanagedProperties)) : null;
            this.managedBits = managedBits;
            this.managedDependency = managedDependency;
            this.premanagedState = premanagedState;
        }

        static PremanagedDependency create(DependencyManager depManager, Dependency dependency, boolean disableVersionManagement, boolean premanagedState) {
            DependencyManagement depMngt = depManager != null ? depManager.manageDependency(dependency) : null;
            int managedBits = 0;
            String premanagedVersion = null;
            String premanagedScope = null;
            Boolean premanagedOptional = null;
            Collection<Exclusion> premanagedExclusions = null;
            Map<String, String> premanagedProperties = null;
            if (depMngt != null) {
                Artifact artifact;
                if (depMngt.getVersion() != null && !disableVersionManagement) {
                    artifact = dependency.getArtifact();
                    premanagedVersion = artifact.getVersion();
                    dependency = dependency.setArtifact(artifact.setVersion(depMngt.getVersion()));
                    managedBits |= 1;
                }
                if (depMngt.getProperties() != null) {
                    artifact = dependency.getArtifact();
                    premanagedProperties = artifact.getProperties();
                    dependency = dependency.setArtifact(artifact.setProperties(depMngt.getProperties()));
                    managedBits |= 8;
                }
                if (depMngt.getScope() != null) {
                    premanagedScope = dependency.getScope();
                    dependency = dependency.setScope(depMngt.getScope());
                    managedBits |= 2;
                }
                if (depMngt.getOptional() != null) {
                    premanagedOptional = dependency.isOptional();
                    dependency = dependency.setOptional(depMngt.getOptional());
                    managedBits |= 4;
                }
                if (depMngt.getExclusions() != null) {
                    premanagedExclusions = dependency.getExclusions();
                    dependency = dependency.setExclusions(depMngt.getExclusions());
                    managedBits |= 0x10;
                }
            }
            return new PremanagedDependency(premanagedVersion, premanagedScope, premanagedOptional, premanagedExclusions, premanagedProperties, managedBits, dependency, premanagedState);
        }

        public void applyTo(DefaultDependencyNode child) {
            child.setManagedBits(this.managedBits);
            if (this.premanagedState) {
                child.setData("premanaged.version", this.premanagedVersion);
                child.setData("premanaged.scope", this.premanagedScope);
                child.setData("premanaged.optional", this.premanagedOptional);
                child.setData("premanaged.exclusions", this.premanagedExclusions);
                child.setData("premanaged.properties", this.premanagedProperties);
            }
        }
    }

    static class Results {
        private final CollectResult result;
        final int maxExceptions;
        final int maxCycles;
        String errorPath;

        Results(CollectResult result2, RepositorySystemSession session2) {
            this.result = result2;
            this.maxExceptions = ConfigUtils.getInteger(session2, 50, "aether.dependencyCollector.maxExceptions");
            this.maxCycles = ConfigUtils.getInteger(session2, 10, "aether.dependencyCollector.maxCycles");
        }

        public void addException(Dependency dependency, Exception e, List<DependencyNode> nodes) {
            if (this.maxExceptions < 0 || this.result.getExceptions().size() < this.maxExceptions) {
                this.result.addException(e);
                if (this.errorPath == null) {
                    StringBuilder buffer = new StringBuilder(256);
                    for (DependencyNode node : nodes) {
                        Dependency dep;
                        if (buffer.length() > 0) {
                            buffer.append(" -> ");
                        }
                        if ((dep = node.getDependency()) == null) continue;
                        buffer.append(dep.getArtifact());
                    }
                    if (buffer.length() > 0) {
                        buffer.append(" -> ");
                    }
                    buffer.append(dependency.getArtifact());
                    this.errorPath = buffer.toString();
                }
            }
        }

        public void addCycle(List<DependencyNode> nodes, int cycleEntry, Dependency dependency) {
            if (this.maxCycles < 0 || this.result.getCycles().size() < this.maxCycles) {
                this.result.addCycle(new DefaultDependencyCycle(nodes, cycleEntry, dependency));
            }
        }
    }

    static class Args {
        final RepositorySystemSession session;
        final boolean ignoreRepos;
        final boolean premanagedState;
        final RequestTrace trace;
        final DataPool pool;
        final Queue<DependencyProcessingContext> dependencyProcessingQueue = new ArrayDeque<DependencyProcessingContext>(128);
        final DefaultDependencyCollectionContext collectionContext;
        final DefaultVersionFilterContext versionContext;
        final CollectRequest request;
        final DependencyResolutionSkipper skipper;

        Args(RepositorySystemSession session2, RequestTrace trace, DataPool pool, DefaultDependencyCollectionContext collectionContext, DefaultVersionFilterContext versionContext, CollectRequest request, DependencyResolutionSkipper skipper2) {
            this.session = session2;
            this.request = request;
            this.ignoreRepos = session2.isIgnoreArtifactDescriptorRepositories();
            this.premanagedState = ConfigUtils.getBoolean(session2, false, "aether.dependencyManager.verbose");
            this.trace = trace;
            this.pool = pool;
            this.collectionContext = collectionContext;
            this.versionContext = versionContext;
            this.skipper = skipper2;
        }
    }
}

