/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.ki.shell;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.ReplAnalyzerResult;
import kotlin.script.experimental.api.ResultValue;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.api.ScriptEvaluationConfiguration;
import kotlin.script.experimental.api.ScriptEvaluationKt;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.host.ScriptHostUtilKt;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.BasicJvmReplEvaluator;
import kotlin.script.experimental.jvm.KJvmEvaluatedSnippet;
import kotlin.script.experimental.jvm.impl.KJvmCompiledScript;
import kotlin.script.experimental.util.LinkedSnippet;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.scripting.ide_services.compiler.KJvmReplCompilerWithIdeServices;
import org.jetbrains.kotlinx.ki.shell.BaseCommand;
import org.jetbrains.kotlinx.ki.shell.Command;
import org.jetbrains.kotlinx.ki.shell.CommandKt;
import org.jetbrains.kotlinx.ki.shell.ContextHighlighter;
import org.jetbrains.kotlinx.ki.shell.EventManager;
import org.jetbrains.kotlinx.ki.shell.KotlinCompleter;
import org.jetbrains.kotlinx.ki.shell.KotlinReplSnippetParser;
import org.jetbrains.kotlinx.ki.shell.OnCompile;
import org.jetbrains.kotlinx.ki.shell.OnEval;
import org.jetbrains.kotlinx.ki.shell.Plugin;
import org.jetbrains.kotlinx.ki.shell.ShellKt;
import org.jetbrains.kotlinx.ki.shell.UtilKt;
import org.jetbrains.kotlinx.ki.shell.configuration.BooleanConverter;
import org.jetbrains.kotlinx.ki.shell.configuration.Converter;
import org.jetbrains.kotlinx.ki.shell.configuration.IntConverter;
import org.jetbrains.kotlinx.ki.shell.configuration.ReplConfiguration;
import org.jetbrains.kotlinx.ki.shell.wrappers.ResultWrapper;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009c\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0006\u0096\u0001\u0097\u0001\u0098\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010`\u001a\b\u0012\u0004\u0012\u00020b0a2\u0006\u0010c\u001a\u00020>2\u0006\u0010d\u001a\u00020eJ\u0006\u0010f\u001a\u00020gJ\u0014\u0010h\u001a\u00020g2\n\u0010i\u001a\u00060jj\u0002`kH\u0002J%\u0010l\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020n0m0a2\u0006\u0010c\u001a\u00020>H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010oJ\u001a\u0010l\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020n0m0a2\u0006\u0010c\u001a\u00020pJ\u000e\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020>J\u0006\u0010t\u001a\u00020gJ\u000e\u0010u\u001a\u00020r2\u0006\u0010s\u001a\u00020>J\u001a\u0010v\u001a\u00020g2\n\u0010w\u001a\u0006\u0012\u0002\b\u00030a2\u0006\u0010x\u001a\u00020yJ\u0012\u0010z\u001a\u00020g2\n\u0010w\u001a\u0006\u0012\u0002\b\u00030{J\u0006\u0010|\u001a\u00020gJ\b\u0010}\u001a\u00020gH\u0002J\u0010\u0010~\u001a\u00020y2\u0006\u0010\u007f\u001a\u00020>H\u0002J\u0012\u0010\u0080\u0001\u001a\u00020y2\u0007\u0010\u0081\u0001\u001a\u00020>H\u0002J\u000e\u0010\u0082\u0001\u001a\t\u0012\u0004\u0012\u00020\r0\u0083\u0001J\u0011\u0010\u0084\u0001\u001a\u00020p2\u0006\u0010c\u001a\u00020>H\u0002J\u001d\u0010\u0085\u0001\u001a\u00020g2\n\u0010w\u001a\u0006\u0012\u0002\b\u00030a2\u0006\u0010x\u001a\u00020yH\u0002J\u0010\u0010\u0086\u0001\u001a\u00020g2\u0007\u0010\u0087\u0001\u001a\u00020\rJ\u0011\u0010\u0088\u0001\u001a\u00020>2\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001J\t\u0010\u008b\u0001\u001a\u00020gH\u0002J\u0011\u0010\u008c\u0001\u001a\u00020p2\u0006\u0010c\u001a\u00020>H\u0002J$\u0010\u008d\u0001\u001a\u00020g2\u001b\u0010\u008e\u0001\u001a\u0016\u0012\u0005\u0012\u00030\u0090\u0001\u0012\u0004\u0012\u00020g0\u008f\u0001\u00a2\u0006\u0003\b\u0091\u0001J$\u0010\u0092\u0001\u001a\u00020g2\u001b\u0010\u008e\u0001\u001a\u0016\u0012\u0005\u0012\u00030\u0093\u0001\u0012\u0004\u0012\u00020g0\u008f\u0001\u00a2\u0006\u0003\b\u0091\u0001J$\u0010\u0094\u0001\u001a\u00020g2\u001b\u0010\u008e\u0001\u001a\u0016\u0012\u0005\u0012\u00030\u0095\u0001\u0012\u0004\u0012\u00020g0\u008f\u0001\u00a2\u0006\u0003\b\u0091\u0001R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001e\u0010&\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u00105\u001a\u000206\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u001e\u00109\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R!\u0010<\u001a\u0012\u0012\u0004\u0012\u00020>0=j\b\u0012\u0004\u0012\u00020>`?\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0011\u0010B\u001a\u00020C\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER \u0010F\u001a\b\u0012\u0004\u0012\u00020>0GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u001a\u0010L\u001a\u00020MX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR\u001a\u0010R\u001a\u00020SX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010YR\u001a\u0010Z\u001a\u00020[X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0099\u0001"}, d2={"Lorg/jetbrains/kotlinx/ki/shell/Shell;", "", "replConfiguration", "Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration;", "baseHostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "baseCompilationConfiguration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "baseEvaluationConfiguration", "Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;", "(Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration;Lkotlin/script/experimental/host/ScriptingHostConfiguration;Lkotlin/script/experimental/api/ScriptCompilationConfiguration;Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;)V", "commands", "", "Lorg/jetbrains/kotlinx/ki/shell/Command;", "getCommands", "()Ljava/util/List;", "<set-?>", "compilationConfiguration", "getCompilationConfiguration", "()Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "compiler", "Lorg/jetbrains/kotlin/scripting/ide_services/compiler/KJvmReplCompilerWithIdeServices;", "getCompiler", "()Lorg/jetbrains/kotlin/scripting/ide_services/compiler/KJvmReplCompilerWithIdeServices;", "completer", "Lorg/jetbrains/kotlinx/ki/shell/KotlinCompleter;", "getCompleter", "()Lorg/jetbrains/kotlinx/ki/shell/KotlinCompleter;", "currentSnippetNo", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCurrentSnippetNo", "()Ljava/util/concurrent/atomic/AtomicInteger;", "evalThread", "Lorg/jetbrains/kotlinx/ki/shell/Shell$EvalThread;", "getEvalThread", "()Lorg/jetbrains/kotlinx/ki/shell/Shell$EvalThread;", "setEvalThread", "(Lorg/jetbrains/kotlinx/ki/shell/Shell$EvalThread;)V", "evaluationConfiguration", "getEvaluationConfiguration", "()Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;", "evaluationTimeMillis", "", "getEvaluationTimeMillis", "()J", "setEvaluationTimeMillis", "(J)V", "evaluator", "Lkotlin/script/experimental/jvm/BasicJvmReplEvaluator;", "eventManager", "Lorg/jetbrains/kotlinx/ki/shell/EventManager;", "getEventManager", "()Lorg/jetbrains/kotlinx/ki/shell/EventManager;", "highlighter", "Lorg/jetbrains/kotlinx/ki/shell/ContextHighlighter;", "getHighlighter", "()Lorg/jetbrains/kotlinx/ki/shell/ContextHighlighter;", "hostConfiguration", "getHostConfiguration", "()Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "incompleteLines", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getIncompleteLines", "()Ljava/util/ArrayList;", "parser", "Lorg/jetbrains/kotlinx/ki/shell/KotlinReplSnippetParser;", "getParser", "()Lorg/jetbrains/kotlinx/ki/shell/KotlinReplSnippetParser;", "prompt", "Lkotlin/Function0;", "getPrompt", "()Lkotlin/jvm/functions/Function0;", "setPrompt", "(Lkotlin/jvm/functions/Function0;)V", "reader", "Lorg/jline/reader/LineReader;", "getReader", "()Lorg/jline/reader/LineReader;", "setReader", "(Lorg/jline/reader/LineReader;)V", "readerBuilder", "Lorg/jline/reader/LineReaderBuilder;", "getReaderBuilder", "()Lorg/jline/reader/LineReaderBuilder;", "setReaderBuilder", "(Lorg/jline/reader/LineReaderBuilder;)V", "getReplConfiguration", "()Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration;", "settings", "Lorg/jetbrains/kotlinx/ki/shell/Shell$Settings;", "getSettings", "()Lorg/jetbrains/kotlinx/ki/shell/Shell$Settings;", "setSettings", "(Lorg/jetbrains/kotlinx/ki/shell/Shell$Settings;)V", "analyze", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "Lkotlin/script/experimental/api/ReplAnalyzerResult;", "code", "pos", "Lkotlin/script/experimental/api/SourceCode$Position;", "cleanUp", "", "commandError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "compile", "Lkotlin/script/experimental/util/LinkedSnippet;", "Lkotlin/script/experimental/jvm/impl/KJvmCompiledScript;", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lkotlin/script/experimental/api/SourceCode;", "compileAndEval", "Lorg/jetbrains/kotlinx/ki/shell/wrappers/ResultWrapper;", "source", "doRun", "eval", "handleError", "result", "isCompiled", "", "handleSuccess", "Lkotlin/script/experimental/api/ResultWithDiagnostics$Success;", "initEngine", "interrupt", "isCommandMode", "buffer", "isQuitAction", "line", "listCommands", "", "nextLine", "printDiagnostics", "registerCommand", "command", "renderResultType", "res", "Lkotlin/script/experimental/api/ResultValue$Value;", "sayHello", "tempLine", "updateCompilationConfiguration", "body", "Lkotlin/Function1;", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration$Builder;", "Lkotlin/ExtensionFunctionType;", "updateEvaluationConfiguration", "Lkotlin/script/experimental/api/ScriptEvaluationConfiguration$Builder;", "updateHostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration$Builder;", "EvalThread", "FakeQuit", "Settings", "ki-shell"})
public class Shell {
    @NotNull
    private final ReplConfiguration replConfiguration;
    @NotNull
    private ScriptingHostConfiguration hostConfiguration;
    @NotNull
    private ScriptCompilationConfiguration compilationConfiguration;
    @NotNull
    private ScriptEvaluationConfiguration evaluationConfiguration;
    @NotNull
    private final KJvmReplCompilerWithIdeServices compiler;
    @NotNull
    private final BasicJvmReplEvaluator evaluator;
    @NotNull
    private final AtomicInteger currentSnippetNo;
    @NotNull
    private final ArrayList<String> incompleteLines;
    public LineReaderBuilder readerBuilder;
    public LineReader reader;
    @NotNull
    private final List<Command> commands;
    @NotNull
    private final EventManager eventManager;
    @NotNull
    private final ContextHighlighter highlighter;
    @NotNull
    private final KotlinCompleter completer;
    @NotNull
    private final KotlinReplSnippetParser parser;
    @NotNull
    private Function0<String> prompt;
    private long evaluationTimeMillis;
    @NotNull
    private EvalThread evalThread;
    public Settings settings;

    public Shell(@NotNull ReplConfiguration replConfiguration, @NotNull ScriptingHostConfiguration baseHostConfiguration, @NotNull ScriptCompilationConfiguration baseCompilationConfiguration, @NotNull ScriptEvaluationConfiguration baseEvaluationConfiguration) {
        Intrinsics.checkNotNullParameter(replConfiguration, "replConfiguration");
        Intrinsics.checkNotNullParameter(baseHostConfiguration, "baseHostConfiguration");
        Intrinsics.checkNotNullParameter(baseCompilationConfiguration, "baseCompilationConfiguration");
        Intrinsics.checkNotNullParameter(baseEvaluationConfiguration, "baseEvaluationConfiguration");
        this.replConfiguration = replConfiguration;
        this.hostConfiguration = baseHostConfiguration;
        this.compilationConfiguration = ScriptCompilationKt.with(baseCompilationConfiguration, (Function1<? super ScriptCompilationConfiguration.Builder, Unit>)new Function1<ScriptCompilationConfiguration.Builder, Unit>(this){
            final /* synthetic */ Shell this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ScriptCompilationConfiguration.Builder $this$with) {
                Intrinsics.checkNotNullParameter($this$with, "$this$with");
                $this$with.invoke(ScriptCompilationKt.getHostConfiguration($this$with), this.this$0.getHostConfiguration());
            }
        });
        this.evaluationConfiguration = ScriptEvaluationKt.with(baseEvaluationConfiguration, (Function1<? super ScriptEvaluationConfiguration.Builder, Unit>)new Function1<ScriptEvaluationConfiguration.Builder, Unit>(this){
            final /* synthetic */ Shell this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ScriptEvaluationConfiguration.Builder $this$with) {
                Intrinsics.checkNotNullParameter($this$with, "$this$with");
                $this$with.invoke(ScriptEvaluationKt.getHostConfiguration($this$with), this.this$0.getHostConfiguration());
            }
        });
        this.compiler = new KJvmReplCompilerWithIdeServices(this.hostConfiguration);
        this.evaluator = new BasicJvmReplEvaluator(null, 1, null);
        this.currentSnippetNo = new AtomicInteger();
        this.incompleteLines = new ArrayList();
        Command[] commandArray = new Command[]{new FakeQuit()};
        this.commands = CollectionsKt.mutableListOf(commandArray);
        this.eventManager = new EventManager();
        this.highlighter = new ContextHighlighter((Function1<? super String, Boolean>)new Function1<String, Boolean>(this){
            final /* synthetic */ Shell this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String s) {
                Intrinsics.checkNotNullParameter(s, "s");
                return !Shell.access$isCommandMode(this.this$0, s);
            }
        }, (Function1<? super String, ? extends Command>)new Function1<String, Command>(this){
            final /* synthetic */ Shell this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Command invoke(@NotNull String s) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter(s, "s");
                    Iterable $this$firstOrNull$iv = this.this$0.getCommands();
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        Command it = (Command)element$iv;
                        boolean bl = false;
                        if (!CommandKt.weakMatch(it, s)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }
        });
        this.completer = new KotlinCompleter(this.compiler, (Function0<? extends ScriptCompilationConfiguration>)new Function0<ScriptCompilationConfiguration>(this){
            final /* synthetic */ Shell this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ScriptCompilationConfiguration invoke() {
                return this.this$0.getCompilationConfiguration();
            }
        }, new Function0<Integer>(this){
            final /* synthetic */ Shell this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.this$0.getCurrentSnippetNo().get();
            }
        }, this.incompleteLines);
        this.parser = new KotlinReplSnippetParser();
        this.prompt = new Function0<String>(this){
            final /* synthetic */ Shell this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.this$0.getIncompleteLines().isEmpty() ? "kotlin> " : "... ";
            }
        };
        this.evalThread = new EvalThread();
    }

    @NotNull
    public final ReplConfiguration getReplConfiguration() {
        return this.replConfiguration;
    }

    @NotNull
    public final ScriptingHostConfiguration getHostConfiguration() {
        return this.hostConfiguration;
    }

    @NotNull
    public final ScriptCompilationConfiguration getCompilationConfiguration() {
        return this.compilationConfiguration;
    }

    @NotNull
    public final ScriptEvaluationConfiguration getEvaluationConfiguration() {
        return this.evaluationConfiguration;
    }

    @NotNull
    public final KJvmReplCompilerWithIdeServices getCompiler() {
        return this.compiler;
    }

    @NotNull
    public final AtomicInteger getCurrentSnippetNo() {
        return this.currentSnippetNo;
    }

    @NotNull
    public final ArrayList<String> getIncompleteLines() {
        return this.incompleteLines;
    }

    @NotNull
    public final LineReaderBuilder getReaderBuilder() {
        LineReaderBuilder lineReaderBuilder = this.readerBuilder;
        if (lineReaderBuilder != null) {
            return lineReaderBuilder;
        }
        Intrinsics.throwUninitializedPropertyAccessException("readerBuilder");
        return null;
    }

    public final void setReaderBuilder(@NotNull LineReaderBuilder lineReaderBuilder) {
        Intrinsics.checkNotNullParameter(lineReaderBuilder, "<set-?>");
        this.readerBuilder = lineReaderBuilder;
    }

    @NotNull
    public final LineReader getReader() {
        LineReader lineReader = this.reader;
        if (lineReader != null) {
            return lineReader;
        }
        Intrinsics.throwUninitializedPropertyAccessException("reader");
        return null;
    }

    public final void setReader(@NotNull LineReader lineReader) {
        Intrinsics.checkNotNullParameter(lineReader, "<set-?>");
        this.reader = lineReader;
    }

    @NotNull
    public final List<Command> getCommands() {
        return this.commands;
    }

    @NotNull
    public final EventManager getEventManager() {
        return this.eventManager;
    }

    @NotNull
    public final ContextHighlighter getHighlighter() {
        return this.highlighter;
    }

    @NotNull
    public final KotlinCompleter getCompleter() {
        return this.completer;
    }

    @NotNull
    public final KotlinReplSnippetParser getParser() {
        return this.parser;
    }

    @NotNull
    public final Function0<String> getPrompt() {
        return this.prompt;
    }

    public final void setPrompt(@NotNull Function0<String> function0) {
        Intrinsics.checkNotNullParameter(function0, "<set-?>");
        this.prompt = function0;
    }

    public final long getEvaluationTimeMillis() {
        return this.evaluationTimeMillis;
    }

    public final void setEvaluationTimeMillis(long l) {
        this.evaluationTimeMillis = l;
    }

    @NotNull
    public final EvalThread getEvalThread() {
        return this.evalThread;
    }

    public final void setEvalThread(@NotNull EvalThread evalThread) {
        Intrinsics.checkNotNullParameter(evalThread, "<set-?>");
        this.evalThread = evalThread;
    }

    @NotNull
    public final Settings getSettings() {
        Settings settings2 = this.settings;
        if (settings2 != null) {
            return settings2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("settings");
        return null;
    }

    public final void setSettings(@NotNull Settings settings2) {
        Intrinsics.checkNotNullParameter(settings2, "<set-?>");
        this.settings = settings2;
    }

    public final void updateHostConfiguration(@NotNull Function1<? super ScriptingHostConfiguration.Builder, Unit> body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        this.hostConfiguration = ShellKt.access$with(this.hostConfiguration, body2);
        this.updateCompilationConfiguration((Function1<? super ScriptCompilationConfiguration.Builder, Unit>)new Function1<ScriptCompilationConfiguration.Builder, Unit>(this){
            final /* synthetic */ Shell this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ScriptCompilationConfiguration.Builder $this$updateCompilationConfiguration) {
                Intrinsics.checkNotNullParameter($this$updateCompilationConfiguration, "$this$updateCompilationConfiguration");
                $this$updateCompilationConfiguration.invoke(ScriptCompilationKt.getHostConfiguration($this$updateCompilationConfiguration), this.this$0.getHostConfiguration());
            }
        });
        this.updateEvaluationConfiguration((Function1<? super ScriptEvaluationConfiguration.Builder, Unit>)new Function1<ScriptEvaluationConfiguration.Builder, Unit>(this){
            final /* synthetic */ Shell this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ScriptEvaluationConfiguration.Builder $this$updateEvaluationConfiguration) {
                Intrinsics.checkNotNullParameter($this$updateEvaluationConfiguration, "$this$updateEvaluationConfiguration");
                $this$updateEvaluationConfiguration.invoke(ScriptEvaluationKt.getHostConfiguration($this$updateEvaluationConfiguration), this.this$0.getHostConfiguration());
            }
        });
    }

    public final void updateCompilationConfiguration(@NotNull Function1<? super ScriptCompilationConfiguration.Builder, Unit> body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        this.compilationConfiguration = ScriptCompilationKt.with(this.compilationConfiguration, body2);
    }

    public final void updateEvaluationConfiguration(@NotNull Function1<? super ScriptEvaluationConfiguration.Builder, Unit> body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        this.evaluationConfiguration = ScriptEvaluationKt.with(this.evaluationConfiguration, body2);
    }

    @NotNull
    public final Iterable<Command> listCommands() {
        return this.commands;
    }

    public final void initEngine() {
        this.replConfiguration.load();
        this.setSettings(new Settings(this.replConfiguration));
        Terminal term = this.getSettings().getOverrideSignals() ? TerminalBuilder.builder().nativeSignals(true).signalHandler(arg_0 -> Shell.initEngine$lambda-0(this, arg_0)).build() : TerminalBuilder.builder().build();
        LineReaderBuilder lineReaderBuilder = LineReaderBuilder.builder().terminal(term).highlighter(this.highlighter).parser(this.parser).completer(this.completer);
        Intrinsics.checkNotNullExpressionValue(lineReaderBuilder, "builder()\n              \u2026    .completer(completer)");
        this.setReaderBuilder(lineReaderBuilder);
        LineReader lineReader = this.getReaderBuilder().build();
        Intrinsics.checkNotNullExpressionValue(lineReader, "readerBuilder.build()");
        this.setReader(lineReader);
        Iterator<Plugin> $this$forEach$iv = this.replConfiguration.plugins();
        boolean $i$f$forEach = false;
        Iterator<Plugin> iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Plugin element$iv;
            Plugin it = element$iv = iterator2.next();
            boolean bl = false;
            it.init(this, this.replConfiguration);
        }
        this.getReader().setVariable("history-file", this.replConfiguration.get("history-file", System.getProperty("user.home") + File.separator + ".kshell_history"));
        this.getReader().setVariable("secondary-prompt-pattern", "");
        this.getReader().option(LineReader.Option.DISABLE_EVENT_EXPANSION, true);
    }

    private final void interrupt() {
        if (!this.evalThread.isAlive()) {
            return;
        }
        this.evalThread.interrupt();
        for (int i = 1; i < 6 && this.evalThread.isAlive(); ++i) {
            Thread.sleep(100L);
        }
        if (this.evalThread.isAlive()) {
            this.evalThread.stop();
        }
        this.evalThread = new EvalThread();
    }

    private final boolean isCommandMode(String buffer) {
        return this.incompleteLines.isEmpty() && StringsKt.startsWith$default(buffer, ":", false, 2, null) && !StringsKt.startsWith$default(buffer, "::", false, 2, null);
    }

    public final void doRun() {
        this.initEngine();
        if (this.getSettings().getSayHello()) {
            this.sayHello();
        }
        Ref.IntRef blankLines = new Ref.IntRef();
        block7: while (true) {
            try {
                String line = this.getReader().readLine(this.prompt.invoke());
                if (line == null || this.isQuitAction(line)) break;
                if (this.isCommandMode(line)) {
                    try {
                        Object element$iv2;
                        block15: {
                            Iterable $this$first$iv = this.commands;
                            boolean $i$f$first = false;
                            for (Object element$iv2 : $this$first$iv) {
                                Command it = (Command)element$iv2;
                                boolean bl = false;
                                if (!CommandKt.match(it, line)) continue;
                                break block15;
                            }
                            throw new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        Command action = (Command)element$iv2;
                        Command.Result result2 = action.execute(line);
                        if (result2 instanceof Command.Result.Success) {
                            if (result2.getMessage() != null) {
                                String it;
                                boolean bl = false;
                                System.out.println((Object)it);
                            }
                            this.currentSnippetNo.incrementAndGet();
                            continue;
                        }
                        if (result2 instanceof Command.Result.Failure) {
                            System.out.println((Object)("Error in command " + line + ": " + result2.getMessage()));
                            continue;
                        }
                        if (!(result2 instanceof Command.Result.RunSnippets)) continue;
                        Iterable<String> $this$forEach$iv = ((Command.Result.RunSnippets)result2).getSnippetsToRun();
                        boolean $i$f$forEach = false;
                        Iterator<String> iterator2 = $this$forEach$iv.iterator();
                        while (true) {
                            String element$iv3;
                            if (!iterator2.hasNext()) continue block7;
                            String p0 = element$iv3 = iterator2.next();
                            boolean bl = false;
                            Shell.doRun$evalSnippet(this, blankLines, p0);
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        System.out.println((Object)("Unknown command " + line));
                        continue;
                    }
                    catch (Exception e) {
                        this.commandError(e);
                        continue;
                    }
                }
                Shell.doRun$evalSnippet(this, blankLines, line);
                continue;
            }
            catch (UserInterruptException e) {
                if (!this.getSettings().getOverrideSignals()) break;
                this.currentSnippetNo.incrementAndGet();
                continue;
            }
            catch (EndOfFileException ee) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
        this.cleanUp();
    }

    public final void registerCommand(@NotNull Command command2) {
        Intrinsics.checkNotNullParameter(command2, "command");
        this.commands.add(command2);
    }

    private final boolean isQuitAction(String line) {
        return this.incompleteLines.isEmpty() && (StringsKt.equals(line, ":quit", true) || StringsKt.equals(line, ":q", true));
    }

    private final SourceCode nextLine(String code) {
        return ScriptHostUtilKt.toScriptSource(code, "Line_" + this.currentSnippetNo.incrementAndGet() + "." + this.compilationConfiguration.get(ScriptCompilationKt.getFileExtension(ScriptCompilationConfiguration.Companion)));
    }

    private final SourceCode tempLine(String code) {
        return ScriptHostUtilKt.toScriptSource(code, "$$tempLine_" + UUID.randomUUID() + "." + this.compilationConfiguration.get(ScriptCompilationKt.getFileExtension(ScriptCompilationConfiguration.Companion)));
    }

    @Nullable
    public final Object compile(@NotNull String code, @NotNull Continuation<? super ResultWithDiagnostics<? extends LinkedSnippet<KJvmCompiledScript>>> $completion) {
        return this.compiler.compile(this.nextLine(code), this.compilationConfiguration, $completion);
    }

    @NotNull
    public final ResultWithDiagnostics<LinkedSnippet<KJvmCompiledScript>> compile(@NotNull SourceCode code) {
        Intrinsics.checkNotNullParameter(code, "code");
        return (ResultWithDiagnostics)BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super ResultWithDiagnostics<? extends LinkedSnippet<KJvmCompiledScript>>>, Object>(this, code, null){
            int label;
            final /* synthetic */ Shell this$0;
            final /* synthetic */ SourceCode $code;
            {
                this.this$0 = $receiver;
                this.$code = $code;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.label = 1;
                        Object object3 = this.this$0.getCompiler().compile(this.$code, this.this$0.getCompilationConfiguration(), (Continuation<? super ResultWithDiagnostics<? extends LinkedSnippet<KJvmCompiledScript>>>)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ResultWithDiagnostics<? extends LinkedSnippet<KJvmCompiledScript>>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    @NotNull
    public final ResultWithDiagnostics<ReplAnalyzerResult> analyze(@NotNull String code, @NotNull SourceCode.Position pos) {
        Intrinsics.checkNotNullParameter(code, "code");
        Intrinsics.checkNotNullParameter(pos, "pos");
        return (ResultWithDiagnostics)BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super ResultWithDiagnostics<? extends ReplAnalyzerResult>>, Object>(this, code, pos, null){
            int label;
            final /* synthetic */ Shell this$0;
            final /* synthetic */ String $code;
            final /* synthetic */ SourceCode.Position $pos;
            {
                this.this$0 = $receiver;
                this.$code = $code;
                this.$pos = $pos;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.label = 1;
                        Object object3 = this.this$0.getCompiler().analyze(Shell.access$tempLine(this.this$0, this.$code), this.$pos, this.this$0.getCompilationConfiguration(), this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ResultWithDiagnostics<ReplAnalyzerResult>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    @NotNull
    public final ResultWrapper eval(@NotNull String source) {
        Object object;
        Intrinsics.checkNotNullParameter(source, "source");
        if (this.getSettings().getOverrideSignals()) {
            EvalThread evalThread;
            EvalThread $this$eval_u24lambda_u2d4 = evalThread = this.evalThread;
            boolean bl = false;
            $this$eval_u24lambda_u2d4.setEvalBlock(new Function0<ResultWrapper>(this, source){
                final /* synthetic */ Shell this$0;
                final /* synthetic */ String $source;
                {
                    this.this$0 = $receiver;
                    this.$source = $source;
                    super(0);
                }

                @NotNull
                public final ResultWrapper invoke() {
                    return this.this$0.compileAndEval(this.$source);
                }
            });
            $this$eval_u24lambda_u2d4.start();
            $this$eval_u24lambda_u2d4.join();
            ResultWrapper result2 = this.evalThread.getResult();
            this.evalThread = new EvalThread();
            object = evalThread;
        } else {
            object = this.compileAndEval(source);
        }
        return object;
    }

    @NotNull
    public final ResultWrapper compileAndEval(@NotNull String source) {
        Intrinsics.checkNotNullParameter(source, "source");
        return (ResultWrapper)BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super ResultWrapper>, Object>(this, source, null){
            int label;
            final /* synthetic */ Shell this$0;
            final /* synthetic */ String $source;
            {
                this.this$0 = $receiver;
                this.$source = $source;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block7: {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(var1_1);
                            this.label = 1;
                            v0 = this.this$0.compile(this.$source, this);
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            compileResult = (ResultWithDiagnostics)v0;
                            if (!Thread.currentThread().isInterrupted()) ** GOTO lbl20
                            var4_4 = new ScriptDiagnostic[]{ErrorHandlingKt.asErrorDiagnostics$default("Interrupted", 0, null, null, 7, null)};
                            v1 = new ResultWrapper(new ResultWithDiagnostics.Failure(var4_4), true);
                            v2 = v1;
                            break block7;
lbl20:
                            // 1 sources

                            if (!(compileResult instanceof ResultWithDiagnostics.Success)) break;
                            this.this$0.getEventManager().emitEvent(new OnCompile((LinkedSnippet)((ResultWithDiagnostics.Success)compileResult).getValue()));
                            this.label = 2;
                            v3 = Shell.access$getEvaluator$p(this.this$0).eval((LinkedSnippet)((ResultWithDiagnostics.Success)compileResult).getValue(), this.this$0.getEvaluationConfiguration(), this);
                            if (v3 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl30
                        }
                        case 2: {
                            ResultKt.throwOnFailure($result);
                            v3 = $result;
lbl30:
                            // 2 sources

                            var5_5 = (ResultWithDiagnostics)v3;
                            v2 = new ResultWrapper(var5_5, true);
                            break block7;
                        }
                    }
                    v2 = new ResultWrapper(compileResult, false);
                }
                res = v2;
                return res;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ResultWrapper> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    public final void handleError(@NotNull ResultWithDiagnostics<?> result2, boolean isCompiled) {
        Intrinsics.checkNotNullParameter(result2, "result");
        this.printDiagnostics(result2, isCompiled);
    }

    private final void printDiagnostics(ResultWithDiagnostics<?> result2, boolean isCompiled) {
        Iterable $this$forEach$iv = result2.getReports();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScriptDiagnostic it = (ScriptDiagnostic)element$iv;
            boolean bl = false;
            System.out.println((Object)ScriptDiagnostic.render$default(it, false, false, false, isCompiled, 7, null));
        }
    }

    public final void handleSuccess(@NotNull ResultWithDiagnostics.Success<?> result2) {
        Intrinsics.checkNotNullParameter(result2, "result");
        this.printDiagnostics((ResultWithDiagnostics)result2, true);
        Object obj = result2.getValue();
        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type kotlin.script.experimental.util.LinkedSnippet<kotlin.script.experimental.jvm.KJvmEvaluatedSnippet>");
        LinkedSnippet snippets = (LinkedSnippet)obj;
        this.eventManager.emitEvent(new OnEval(snippets));
        ResultValue evalResultValue = ((KJvmEvaluatedSnippet)snippets.get()).getResult();
        if (evalResultValue instanceof ResultValue.Value) {
            System.out.println((Object)UtilKt.bound(((ResultValue.Value)evalResultValue).getName() + this.renderResultType((ResultValue.Value)evalResultValue) + " = " + ((ResultValue.Value)evalResultValue).getValue(), this.getSettings().getMaxResultLength()));
        } else if (evalResultValue instanceof ResultValue.Error) {
            ResultValue.Error error = (ResultValue.Error)evalResultValue;
            PrintStream printStream = System.err;
            Intrinsics.checkNotNullExpressionValue(printStream, "err");
            ShellKt.access$renderError(error, printStream);
        } else if (Intrinsics.areEqual(evalResultValue, ResultValue.NotEvaluated.INSTANCE) || evalResultValue instanceof ResultValue.Unit) {
            // empty if block
        }
    }

    @NotNull
    public final String renderResultType(@NotNull ResultValue.Value res2) {
        Intrinsics.checkNotNullParameter(res2, "res");
        return ": " + UtilKt.renderKotlinType(res2.getType());
    }

    private final void commandError(Exception e) {
        e.printStackTrace();
    }

    public final void cleanUp() {
        this.getReader().getHistory().save();
    }

    private final void sayHello() {
        UtilKt.printVersion();
        Iterator<Plugin> $this$forEach$iv = this.replConfiguration.plugins();
        boolean $i$f$forEach = false;
        Iterator<Plugin> iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Plugin element$iv;
            Plugin it = element$iv = iterator2.next();
            boolean bl = false;
            it.sayHello();
        }
    }

    private static final void initEngine$lambda-0(Shell this$0, Terminal.Signal it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (it == Terminal.Signal.INT) {
            this$0.interrupt();
        }
    }

    private static final void doRun$evalSnippet(Shell this$0, Ref.IntRef blankLines, String line) {
        if (StringsKt.isBlank(line) && !((Collection)this$0.incompleteLines).isEmpty()) {
            if (blankLines.element == this$0.getSettings().getBlankLinesAllowed() - 1) {
                this$0.incompleteLines.clear();
                System.out.println((Object)("You typed " + this$0.getSettings().getBlankLinesAllowed() + " blank lines. Starting a new command."));
            } else {
                int n = blankLines.element;
                blankLines.element = n + 1;
            }
        } else {
            String source = CollectionsKt.joinToString$default(CollectionsKt.plus((Collection)this$0.incompleteLines, line), "\n", null, null, 0, null, null, 62, null);
            long time = System.nanoTime();
            ResultWrapper result2 = this$0.eval(source);
            this$0.evaluationTimeMillis = (System.nanoTime() - time) / (long)1000000;
            switch (WhenMappings.$EnumSwitchMapping$0[result2.getStatus().ordinal()]) {
                case 1: {
                    this$0.incompleteLines.add(line);
                    break;
                }
                case 2: {
                    this$0.incompleteLines.clear();
                    this$0.handleError(result2.getResult(), result2.isCompiled());
                    break;
                }
                case 3: {
                    this$0.incompleteLines.clear();
                    ResultWithDiagnostics<?> resultWithDiagnostics = result2.getResult();
                    Intrinsics.checkNotNull(resultWithDiagnostics, "null cannot be cast to non-null type kotlin.script.experimental.api.ResultWithDiagnostics.Success<*>");
                    this$0.handleSuccess((ResultWithDiagnostics.Success)resultWithDiagnostics);
                }
            }
        }
    }

    public static final /* synthetic */ SourceCode access$tempLine(Shell $this, String code) {
        return $this.tempLine(code);
    }

    public static final /* synthetic */ BasicJvmReplEvaluator access$getEvaluator$p(Shell $this) {
        return $this.evaluator;
    }

    public static final /* synthetic */ boolean access$isCommandMode(Shell $this, String buffer) {
        return $this.isCommandMode(buffer);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlinx/ki/shell/Shell$EvalThread;", "Ljava/lang/Thread;", "()V", "evalBlock", "Lkotlin/Function0;", "Lorg/jetbrains/kotlinx/ki/shell/wrappers/ResultWrapper;", "getEvalBlock", "()Lkotlin/jvm/functions/Function0;", "setEvalBlock", "(Lkotlin/jvm/functions/Function0;)V", "result", "getResult", "()Lorg/jetbrains/kotlinx/ki/shell/wrappers/ResultWrapper;", "setResult", "(Lorg/jetbrains/kotlinx/ki/shell/wrappers/ResultWrapper;)V", "run", "", "ki-shell"})
    public static final class EvalThread
    extends Thread {
        public Function0<ResultWrapper> evalBlock;
        @NotNull
        private ResultWrapper result;

        public EvalThread() {
            ScriptDiagnostic[] scriptDiagnosticArray = new ScriptDiagnostic[]{ErrorHandlingKt.asErrorDiagnostics$default("Interrupted", 0, null, null, 7, null)};
            this.result = new ResultWrapper(new ResultWithDiagnostics.Failure(scriptDiagnosticArray), true);
        }

        @NotNull
        public final Function0<ResultWrapper> getEvalBlock() {
            Function0<ResultWrapper> function0 = this.evalBlock;
            if (function0 != null) {
                return function0;
            }
            Intrinsics.throwUninitializedPropertyAccessException("evalBlock");
            return null;
        }

        public final void setEvalBlock(@NotNull Function0<ResultWrapper> function0) {
            Intrinsics.checkNotNullParameter(function0, "<set-?>");
            this.evalBlock = function0;
        }

        @NotNull
        public final ResultWrapper getResult() {
            return this.result;
        }

        public final void setResult(@NotNull ResultWrapper resultWrapper) {
            Intrinsics.checkNotNullParameter(resultWrapper, "<set-?>");
            this.result = resultWrapper;
        }

        @Override
        public void run() {
            this.result = this.getEvalBlock().invoke();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR\u001b\u0010\u000e\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\n\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlinx/ki/shell/Shell$Settings;", "", "conf", "Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration;", "(Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration;)V", "blankLinesAllowed", "", "getBlankLinesAllowed", "()I", "blankLinesAllowed$delegate", "Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration$DelegateProvider;", "maxResultLength", "getMaxResultLength", "maxResultLength$delegate", "overrideSignals", "", "getOverrideSignals", "()Z", "overrideSignals$delegate", "sayHello", "getSayHello", "sayHello$delegate", "ki-shell"})
    public static final class Settings {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReplConfiguration.DelegateProvider overrideSignals$delegate;
        @NotNull
        private final ReplConfiguration.DelegateProvider maxResultLength$delegate;
        @NotNull
        private final ReplConfiguration.DelegateProvider blankLinesAllowed$delegate;
        @NotNull
        private final ReplConfiguration.DelegateProvider sayHello$delegate;

        public Settings(@NotNull ReplConfiguration conf) {
            Intrinsics.checkNotNullParameter(conf, "conf");
            this.overrideSignals$delegate = conf.get((Converter)BooleanConverter.INSTANCE, true);
            this.maxResultLength$delegate = conf.get((Converter)IntConverter.INSTANCE, 10000);
            this.blankLinesAllowed$delegate = conf.get((Converter)IntConverter.INSTANCE, 2);
            this.sayHello$delegate = conf.get((Converter)BooleanConverter.INSTANCE, true);
        }

        public final boolean getOverrideSignals() {
            return (Boolean)this.overrideSignals$delegate.getValue(this, $$delegatedProperties[0]);
        }

        public final int getMaxResultLength() {
            return ((Number)this.maxResultLength$delegate.getValue(this, $$delegatedProperties[1])).intValue();
        }

        public final int getBlankLinesAllowed() {
            return ((Number)this.blankLinesAllowed$delegate.getValue(this, $$delegatedProperties[2])).intValue();
        }

        public final boolean getSayHello() {
            return (Boolean)this.sayHello$delegate.getValue(this, $$delegatedProperties[3]);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Settings.class, "overrideSignals", "getOverrideSignals()Z", 0)), Reflection.property1(new PropertyReference1Impl(Settings.class, "maxResultLength", "getMaxResultLength()I", 0)), Reflection.property1(new PropertyReference1Impl(Settings.class, "blankLinesAllowed", "getBlankLinesAllowed()I", 0)), Reflection.property1(new PropertyReference1Impl(Settings.class, "sayHello", "getSayHello()Z", 0))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlinx/ki/shell/Shell$FakeQuit;", "Lorg/jetbrains/kotlinx/ki/shell/BaseCommand;", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "name", "getName", "short", "getShort", "execute", "Lorg/jetbrains/kotlinx/ki/shell/Command$Result;", "line", "ki-shell"})
    private static final class FakeQuit
    extends BaseCommand {
        @NotNull
        private final String name;
        @NotNull
        private final String short;
        @NotNull
        private final String description;

        public FakeQuit() {
            this.name = "quit";
            this.short = "q";
            this.description = "quit the shell";
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public String getShort() {
            return this.short;
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.description;
        }

        @Override
        @NotNull
        public Command.Result execute(@NotNull String line) {
            Intrinsics.checkNotNullParameter(line, "line");
            return new Command.Result.Success(null, 1, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResultWrapper.Status.values().length];
            nArray[ResultWrapper.Status.INCOMPLETE.ordinal()] = 1;
            nArray[ResultWrapper.Status.ERROR.ordinal()] = 2;
            nArray[ResultWrapper.Status.SUCCESS.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

