/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.hash;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jetbrains.kotlin.com.google.common.primitives.Longs;
import sun.misc.Unsafe;

final class LittleEndianByteArray {
    private static final LittleEndianBytes byteArray;

    static long load64(byte[] input, int offset2) {
        assert (input.length >= offset2 + 8);
        return byteArray.getLongLittleEndian(input, offset2);
    }

    static long load64Safely(byte[] input, int offset2, int length) {
        long result2 = 0L;
        int limit = Math.min(length, 8);
        for (int i = 0; i < limit; ++i) {
            result2 |= ((long)input[offset2 + i] & 0xFFL) << i * 8;
        }
        return result2;
    }

    static void store64(byte[] sink, int offset2, long value2) {
        assert (offset2 >= 0 && offset2 + 8 <= sink.length);
        byteArray.putLongLittleEndian(sink, offset2, value2);
    }

    static int load32(byte[] source, int offset2) {
        return source[offset2] & 0xFF | (source[offset2 + 1] & 0xFF) << 8 | (source[offset2 + 2] & 0xFF) << 16 | (source[offset2 + 3] & 0xFF) << 24;
    }

    static boolean usingUnsafe() {
        return byteArray instanceof UnsafeByteArray;
    }

    private LittleEndianByteArray() {
    }

    static {
        Enum theGetter = JavaLittleEndianBytes.INSTANCE;
        try {
            String arch = System.getProperty("os.arch");
            if ("amd64".equals(arch)) {
                theGetter = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? UnsafeByteArray.UNSAFE_LITTLE_ENDIAN : UnsafeByteArray.UNSAFE_BIG_ENDIAN;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        byteArray = theGetter;
    }

    private static enum JavaLittleEndianBytes implements LittleEndianBytes
    {
        INSTANCE{

            @Override
            public long getLongLittleEndian(byte[] source, int offset2) {
                return Longs.fromBytes(source[offset2 + 7], source[offset2 + 6], source[offset2 + 5], source[offset2 + 4], source[offset2 + 3], source[offset2 + 2], source[offset2 + 1], source[offset2]);
            }

            @Override
            public void putLongLittleEndian(byte[] sink, int offset2, long value2) {
                long mask = 255L;
                for (int i = 0; i < 8; ++i) {
                    sink[offset2 + i] = (byte)((value2 & mask) >> i * 8);
                    mask <<= 8;
                }
            }
        };

    }

    private static enum UnsafeByteArray implements LittleEndianBytes
    {
        UNSAFE_LITTLE_ENDIAN{

            @Override
            public long getLongLittleEndian(byte[] array2, int offset2) {
                return theUnsafe.getLong(array2, (long)offset2 + (long)BYTE_ARRAY_BASE_OFFSET);
            }

            @Override
            public void putLongLittleEndian(byte[] array2, int offset2, long value2) {
                theUnsafe.putLong(array2, (long)offset2 + (long)BYTE_ARRAY_BASE_OFFSET, value2);
            }
        }
        ,
        UNSAFE_BIG_ENDIAN{

            @Override
            public long getLongLittleEndian(byte[] array2, int offset2) {
                long bigEndian = theUnsafe.getLong(array2, (long)offset2 + (long)BYTE_ARRAY_BASE_OFFSET);
                return Long.reverseBytes(bigEndian);
            }

            @Override
            public void putLongLittleEndian(byte[] array2, int offset2, long value2) {
                long littleEndianValue = Long.reverseBytes(value2);
                theUnsafe.putLong(array2, (long)offset2 + (long)BYTE_ARRAY_BASE_OFFSET, littleEndianValue);
            }
        };

        private static final Unsafe theUnsafe;
        private static final int BYTE_ARRAY_BASE_OFFSET;

        private static Unsafe getUnsafe() {
            try {
                return Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                        @Override
                        public Unsafe run() throws Exception {
                            Class<Unsafe> k = Unsafe.class;
                            for (Field f : k.getDeclaredFields()) {
                                f.setAccessible(true);
                                Object x = f.get(null);
                                if (!k.isInstance(x)) continue;
                                return (Unsafe)k.cast(x);
                            }
                            throw new NoSuchFieldError("the Unsafe");
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException("Could not initialize intrinsics", e.getCause());
                }
            }
        }

        static {
            theUnsafe = UnsafeByteArray.getUnsafe();
            BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
            if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                throw new AssertionError();
            }
        }
    }

    private static interface LittleEndianBytes {
        public long getLongLittleEndian(byte[] var1, int var2);

        public void putLongLittleEndian(byte[] var1, int var2, long var3);
    }
}

